/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 1460986908574398008L;
    private long n;
    private double value;

    public SumOfSquares() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public SumOfSquares(SumOfSquares original) {
        SumOfSquares.copy(original, this);
    }

    public void increment(double d) {
        this.value = this.n == 0L ? d * d : (this.value += d * d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values, int begin, int length) {
        double sumSq = Double.NaN;
        if (this.test(values, begin, length)) {
            sumSq = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumSq += values[i] * values[i];
            }
        }
        return sumSq;
    }

    public SumOfSquares copy() {
        SumOfSquares result2 = new SumOfSquares();
        SumOfSquares.copy(this, result2);
        return result2;
    }

    public static void copy(SumOfSquares source, SumOfSquares dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

