/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.events;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.events.EventException;
import org.apache.commons.math.ode.events.EventHandler;
import org.apache.commons.math.ode.sampling.StepInterpolator;

public class EventState {
    private final EventHandler handler;
    private final double maxCheckInterval;
    private final double convergence;
    private final int maxIterationCount;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean forward;
    private boolean increasing;
    private int nextAction;

    public EventState(EventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.handler = handler;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = Math.abs(convergence);
        this.maxIterationCount = maxIterationCount;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = 3;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public double getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(double tStart, double[] yStart) throws EventException {
        this.t0 = tStart;
        this.g0 = this.handler.g(tStart, yStart);
        this.g0Positive = this.g0 >= 0.0;
    }

    public boolean evaluateStep(final StepInterpolator interpolator) throws DerivativeException, EventException, ConvergenceException {
        try {
            this.forward = interpolator.isForward();
            double t1 = interpolator.getCurrentTime();
            int n = Math.max(1, (int)Math.ceil(Math.abs(t1 - this.t0) / this.maxCheckInterval));
            double h = (t1 - this.t0) / (double)n;
            double ta = this.t0;
            double ga = this.g0;
            double tb = this.t0 + (interpolator.isForward() ? this.convergence : -this.convergence);
            for (int i = 0; i < n; ++i) {
                interpolator.setInterpolatedTime(tb += h);
                double gb = this.handler.g(tb, interpolator.getInterpolatedState());
                if (this.g0Positive ^ gb >= 0.0) {
                    double root2;
                    if (ga * gb > 0.0) {
                        double epsilon = (this.forward ? 0.25 : -0.25) * this.convergence;
                        for (int k = 0; k < 4 && ga * gb > 0.0; ++k) {
                            interpolator.setInterpolatedTime(ta += epsilon);
                            ga = this.handler.g(ta, interpolator.getInterpolatedState());
                        }
                        if (ga * gb > 0.0) {
                            throw MathRuntimeException.createInternalError(null);
                        }
                    }
                    this.increasing = gb >= ga;
                    UnivariateRealFunction f = new UnivariateRealFunction(){

                        public double value(double t) throws FunctionEvaluationException {
                            try {
                                interpolator.setInterpolatedTime(t);
                                return EventState.this.handler.g(t, interpolator.getInterpolatedState());
                            }
                            catch (DerivativeException e) {
                                throw new FunctionEvaluationException((Throwable)e, t);
                            }
                            catch (EventException e) {
                                throw new FunctionEvaluationException((Throwable)e, t);
                            }
                        }
                    };
                    BrentSolver solver = new BrentSolver();
                    solver.setAbsoluteAccuracy(this.convergence);
                    solver.setMaximalIterationCount(this.maxIterationCount);
                    double d = root2 = ta <= tb ? solver.solve(f, ta, tb) : solver.solve(f, tb, ta);
                    if (Math.abs(root2 - ta) <= this.convergence && Math.abs(root2 - this.previousEventTime) <= this.convergence) {
                        ta = tb;
                        ga = gb;
                        continue;
                    }
                    if (!Double.isNaN(this.previousEventTime) && !(Math.abs(this.previousEventTime - root2) > this.convergence)) continue;
                    this.pendingEventTime = root2;
                    if (this.pendingEvent && Math.abs(t1 - this.pendingEventTime) <= this.convergence) {
                        return false;
                    }
                    this.pendingEvent = true;
                    return true;
                }
                ta = tb;
                ga = gb;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (FunctionEvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof DerivativeException) {
                throw (DerivativeException)cause;
            }
            if (cause != null && cause instanceof EventException) {
                throw (EventException)cause;
            }
            throw new EventException(e);
        }
    }

    public double getEventTime() {
        return this.pendingEventTime;
    }

    public void stepAccepted(double t, double[] y) throws EventException {
        this.t0 = t;
        this.g0 = this.handler.g(t, y);
        if (this.pendingEvent) {
            this.previousEventTime = t;
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(t, y, !(this.increasing ^ this.forward));
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = 3;
        }
    }

    public boolean stop() {
        return this.nextAction == 0;
    }

    public boolean reset(double t, double[] y) throws EventException {
        if (!this.pendingEvent) {
            return false;
        }
        if (this.nextAction == 1) {
            this.handler.resetState(t, y);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == 1 || this.nextAction == 2;
    }
}

