/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.CompositeFormat;

public class RealVectorFormat
extends CompositeFormat {
    private static final long serialVersionUID = -708767813036157690L;
    private static final String DEFAULT_PREFIX = "{";
    private static final String DEFAULT_SUFFIX = "}";
    private static final String DEFAULT_SEPARATOR = "; ";
    private final String prefix;
    private final String suffix;
    private final String separator;
    private final String trimmedPrefix;
    private final String trimmedSuffix;
    private final String trimmedSeparator;
    private NumberFormat format;

    public RealVectorFormat() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, RealVectorFormat.getDefaultNumberFormat());
    }

    public RealVectorFormat(NumberFormat format2) {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, format2);
    }

    public RealVectorFormat(String prefix, String suffix, String separator) {
        this(prefix, suffix, separator, RealVectorFormat.getDefaultNumberFormat());
    }

    public RealVectorFormat(String prefix, String suffix, String separator, NumberFormat format2) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.separator = separator;
        this.trimmedPrefix = prefix.trim();
        this.trimmedSuffix = suffix.trim();
        this.trimmedSeparator = separator.trim();
        this.format = format2;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public static RealVectorFormat getInstance() {
        return RealVectorFormat.getInstance(Locale.getDefault());
    }

    public static RealVectorFormat getInstance(Locale locale) {
        return new RealVectorFormat(RealVectorFormat.getDefaultNumberFormat(locale));
    }

    public static String formatRealVector(RealVector v) {
        return RealVectorFormat.getInstance().format(v);
    }

    public StringBuffer format(RealVector vector, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        toAppendTo.append(this.prefix);
        for (int i = 0; i < vector.getDimension(); ++i) {
            if (i > 0) {
                toAppendTo.append(this.separator);
            }
            this.formatDouble(vector.getEntry(i), this.format, toAppendTo, pos);
        }
        toAppendTo.append(this.suffix);
        return toAppendTo;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof RealVector) {
            return this.format((RealVector)obj, toAppendTo, pos);
        }
        throw MathRuntimeException.createIllegalArgumentException("cannot format a {0} instance as a real vector", obj.getClass().getName());
    }

    public ArrayRealVector parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        ArrayRealVector result2 = this.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw MathRuntimeException.createParseException(parsePosition.getErrorIndex(), "unparseable real vector: \"{0}\"", source);
        }
        return result2;
    }

    public ArrayRealVector parse(String source, ParsePosition pos) {
        int initialIndex = pos.getIndex();
        this.parseAndIgnoreWhitespace(source, pos);
        if (!this.parseFixedstring(source, this.trimmedPrefix, pos)) {
            return null;
        }
        ArrayList<Number> components = new ArrayList<Number>();
        boolean loop2 = true;
        while (loop2) {
            if (!components.isEmpty()) {
                this.parseAndIgnoreWhitespace(source, pos);
                if (!this.parseFixedstring(source, this.trimmedSeparator, pos)) {
                    loop2 = false;
                }
            }
            if (!loop2) continue;
            this.parseAndIgnoreWhitespace(source, pos);
            Number component = this.parseNumber(source, this.format, pos);
            if (component != null) {
                components.add(component);
                continue;
            }
            pos.setIndex(initialIndex);
            return null;
        }
        this.parseAndIgnoreWhitespace(source, pos);
        if (!this.parseFixedstring(source, this.trimmedSuffix, pos)) {
            return null;
        }
        double[] data2 = new double[components.size()];
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = ((Number)components.get(i)).doubleValue();
        }
        return new ArrayRealVector(data2, false);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }
}

