/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.ZipfDistribution;

public class ZipfDistributionImpl
extends AbstractIntegerDistribution
implements ZipfDistribution,
Serializable {
    private static final long serialVersionUID = -140627372283420404L;
    private int numberOfElements;
    private double exponent;

    public ZipfDistributionImpl(int numberOfElements, double exponent2) throws IllegalArgumentException {
        this.setNumberOfElementsInternal(numberOfElements);
        this.setExponentInternal(exponent2);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Deprecated
    public void setNumberOfElements(int n) {
        this.setNumberOfElementsInternal(n);
    }

    private void setNumberOfElementsInternal(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("invalid number of elements {0} (must be positive)", n);
        }
        this.numberOfElements = n;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Deprecated
    public void setExponent(double s2) {
        this.setExponentInternal(s2);
    }

    private void setExponentInternal(double s2) throws IllegalArgumentException {
        if (s2 <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("invalid exponent {0} (must be positive)", s2);
        }
        this.exponent = s2;
    }

    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(x, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(x, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    protected int getDomainLowerBound(double p) {
        return 0;
    }

    protected int getDomainUpperBound(double p) {
        return this.numberOfElements;
    }

    private double generalizedHarmonic(int n, double m) {
        double value2 = 0.0;
        for (int k = n; k > 0; --k) {
            value2 += 1.0 / Math.pow(k, m);
        }
        return value2;
    }
}

