/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.EncodingUtil;

public class URIUtil {
    protected static final BitSet empty = new BitSet(1);

    public static String getName(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        String path = URIUtil.getPath(uri);
        int at = path.lastIndexOf("/");
        int to2 = path.length();
        return at >= 0 ? path.substring(at + 1, to2) : path;
    }

    public static String getQuery(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        int at = uri.indexOf("//");
        int from2 = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to2 = uri.length();
        at = uri.indexOf("?", from2);
        if (at < 0) {
            return null;
        }
        from2 = at + 1;
        if (uri.lastIndexOf("#") > from2) {
            to2 = uri.lastIndexOf("#");
        }
        return from2 < 0 || from2 == to2 ? null : uri.substring(from2, to2);
    }

    public static String getPath(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from2 = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to2 = uri.length();
        if (uri.indexOf(63, from2) != -1) {
            to2 = uri.indexOf(63, from2);
        }
        if (uri.lastIndexOf("#") > from2 && uri.lastIndexOf("#") < to2) {
            to2 = uri.lastIndexOf("#");
        }
        return from2 < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from2, to2);
    }

    public static String getPathQuery(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from2 = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to2 = uri.length();
        if (uri.lastIndexOf("#") > from2) {
            to2 = uri.lastIndexOf("#");
        }
        return from2 < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from2, to2);
    }

    public static String getFromPath(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from2 = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        return from2 < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from2);
    }

    public static String encodeAll(String unescaped) throws URIException {
        return URIUtil.encodeAll(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodeAll(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, empty, charset);
    }

    public static String encodeWithinAuthority(String unescaped) throws URIException {
        return URIUtil.encodeWithinAuthority(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinAuthority(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, URI.allowed_within_authority, charset);
    }

    public static String encodePathQuery(String unescaped) throws URIException {
        return URIUtil.encodePathQuery(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodePathQuery(String unescaped, String charset) throws URIException {
        int at = unescaped.indexOf(63);
        if (at < 0) {
            return URIUtil.encode(unescaped, URI.allowed_abs_path, charset);
        }
        return URIUtil.encode(unescaped.substring(0, at), URI.allowed_abs_path, charset) + '?' + URIUtil.encode(unescaped.substring(at + 1), URI.allowed_query, charset);
    }

    public static String encodeWithinPath(String unescaped) throws URIException {
        return URIUtil.encodeWithinPath(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinPath(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, URI.allowed_within_path, charset);
    }

    public static String encodePath(String unescaped) throws URIException {
        return URIUtil.encodePath(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodePath(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, URI.allowed_abs_path, charset);
    }

    public static String encodeWithinQuery(String unescaped) throws URIException {
        return URIUtil.encodeWithinQuery(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodeWithinQuery(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, URI.allowed_within_query, charset);
    }

    public static String encodeQuery(String unescaped) throws URIException {
        return URIUtil.encodeQuery(unescaped, URI.getDefaultProtocolCharset());
    }

    public static String encodeQuery(String unescaped, String charset) throws URIException {
        return URIUtil.encode(unescaped, URI.allowed_query, charset);
    }

    public static String encode(String unescaped, BitSet allowed) throws URIException {
        return URIUtil.encode(unescaped, allowed, URI.getDefaultProtocolCharset());
    }

    public static String encode(String unescaped, BitSet allowed, String charset) throws URIException {
        byte[] rawdata = URLCodec.encodeUrl(allowed, EncodingUtil.getBytes(unescaped, charset));
        return EncodingUtil.getAsciiString(rawdata);
    }

    public static String decode(String escaped) throws URIException {
        try {
            byte[] rawdata = URLCodec.decodeUrl(EncodingUtil.getAsciiBytes(escaped));
            return EncodingUtil.getString(rawdata, URI.getDefaultProtocolCharset());
        }
        catch (DecoderException e) {
            throw new URIException(e.getMessage());
        }
    }

    public static String decode(String escaped, String charset) throws URIException {
        return Coder.decode(escaped.toCharArray(), charset);
    }

    protected static class Coder
    extends URI {
        protected Coder() {
        }

        public static char[] encode(String unescapedComponent, BitSet allowed, String charset) throws URIException {
            return URI.encode(unescapedComponent, allowed, charset);
        }

        public static String decode(char[] escapedComponent, String charset) throws URIException {
            return URI.decode(escapedComponent, charset);
        }

        public static boolean verifyEscaped(char[] original) {
            for (int i = 0; i < original.length; ++i) {
                char c = original[i];
                if (c > '\u0080') {
                    return false;
                }
                if (c != '%' || Character.digit(original[++i], 16) != -1 && Character.digit(original[++i], 16) != -1) continue;
                return false;
            }
            return true;
        }

        public static String replace(String original, char[] from2, char[] to2) {
            for (int i = from2.length; i > 0; --i) {
                original = Coder.replace(original, from2[i], to2[i]);
            }
            return original;
        }

        public static String replace(String original, char from2, char to2) {
            int at;
            StringBuffer result2 = new StringBuffer(original.length());
            int saved = 0;
            do {
                if ((at = original.indexOf(from2)) >= 0) {
                    result2.append(original.substring(0, at));
                    result2.append(to2);
                } else {
                    result2.append(original.substring(saved));
                }
                saved = at;
            } while (at >= 0);
            return result2.toString();
        }
    }
}

