/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class MultiValueMap
extends AbstractMapDecorator
implements MultiMap {
    private final Factory collectionFactory;
    private transient Collection values;
    static /* synthetic */ Class class$java$util$ArrayList;

    public static MultiValueMap decorate(Map map2) {
        return new MultiValueMap(map2, new ReflectionFactory(class$java$util$ArrayList == null ? (class$java$util$ArrayList = MultiValueMap.class$("java.util.ArrayList")) : class$java$util$ArrayList));
    }

    public static MultiValueMap decorate(Map map2, Class collectionClass) {
        return new MultiValueMap(map2, new ReflectionFactory(collectionClass));
    }

    public static MultiValueMap decorate(Map map2, Factory collectionFactory) {
        return new MultiValueMap(map2, collectionFactory);
    }

    public MultiValueMap() {
        this(new HashMap(), new ReflectionFactory(class$java$util$ArrayList == null ? (class$java$util$ArrayList = MultiValueMap.class$("java.util.ArrayList")) : class$java$util$ArrayList));
    }

    protected MultiValueMap(Map map2, Factory collectionFactory) {
        super(map2);
        if (collectionFactory == null) {
            throw new IllegalArgumentException("The factory must not be null");
        }
        this.collectionFactory = collectionFactory;
    }

    public void clear() {
        this.getMap().clear();
    }

    public Object remove(Object key, Object value2) {
        Collection valuesForKey = this.getCollection(key);
        if (valuesForKey == null) {
            return null;
        }
        boolean removed = valuesForKey.remove(value2);
        if (!removed) {
            return null;
        }
        if (valuesForKey.isEmpty()) {
            this.remove(key);
        }
        return value2;
    }

    public boolean containsValue(Object value2) {
        Set pairs = this.getMap().entrySet();
        if (pairs == null) {
            return false;
        }
        Iterator pairsIterator = pairs.iterator();
        while (pairsIterator.hasNext()) {
            Map.Entry keyValuePair = pairsIterator.next();
            Collection coll = (Collection)keyValuePair.getValue();
            if (!coll.contains(value2)) continue;
            return true;
        }
        return false;
    }

    public Object put(Object key, Object value2) {
        boolean result2 = false;
        Collection coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(1);
            result2 = coll.add(value2);
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result2 = false;
            }
        } else {
            result2 = coll.add(value2);
        }
        return result2 ? value2 : null;
    }

    public void putAll(Map map2) {
        if (map2 instanceof MultiMap) {
            Iterator it = map2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry2 = it.next();
                Collection coll = (Collection)entry2.getValue();
                this.putAll(entry2.getKey(), coll);
            }
        } else {
            Iterator it = map2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry3 = it.next();
                this.put(entry3.getKey(), entry3.getValue());
            }
        }
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public boolean containsValue(Object key, Object value2) {
        Collection coll = this.getCollection(key);
        if (coll == null) {
            return false;
        }
        return coll.contains(value2);
    }

    public Collection getCollection(Object key) {
        return (Collection)this.getMap().get(key);
    }

    public int size(Object key) {
        Collection coll = this.getCollection(key);
        if (coll == null) {
            return 0;
        }
        return coll.size();
    }

    public boolean putAll(Object key, Collection values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        Collection coll = this.getCollection(key);
        if (coll == null) {
            coll = this.createCollection(values.size());
            boolean result2 = coll.addAll(values);
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result2 = false;
            }
            return result2;
        }
        return coll.addAll(values);
    }

    public Iterator iterator(Object key) {
        if (!this.containsKey(key)) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(key);
    }

    public int totalSize() {
        int total = 0;
        Collection values = this.getMap().values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Collection coll = (Collection)it.next();
            total += coll.size();
        }
        return total;
    }

    protected Collection createCollection(int size2) {
        return (Collection)this.collectionFactory.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ReflectionFactory
    implements Factory {
        private final Class clazz;

        public ReflectionFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object create() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception ex) {
                throw new FunctorException("Cannot instantiate class: " + this.clazz, ex);
            }
        }
    }

    private class ValuesIterator
    implements Iterator {
        private final Object key;
        private final Collection values;
        private final Iterator iterator;

        public ValuesIterator(Object key) {
            this.key = key;
            this.values = MultiValueMap.this.getCollection(key);
            this.iterator = this.values.iterator();
        }

        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                MultiValueMap.this.remove(this.key);
            }
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            IteratorChain chain2 = new IteratorChain();
            Iterator it = MultiValueMap.this.keySet().iterator();
            while (it.hasNext()) {
                chain2.addIterator(new ValuesIterator(it.next()));
            }
            return chain2;
        }

        public int size() {
            return MultiValueMap.this.totalSize();
        }

        public void clear() {
            MultiValueMap.this.clear();
        }
    }
}

