/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class StringArrayConverter
extends AbstractArrayConverter {
    private static String[] model = new String[0];
    private static int[] ints = new int[0];

    public StringArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public StringArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value2.getClass()) {
            return value2;
        }
        if (ints.getClass() == value2.getClass()) {
            int[] values = (int[])value2;
            String[] results = new String[values.length];
            int i = 0;
            while (i < values.length) {
                results[i] = Integer.toString(values[i]);
                ++i;
            }
            return results;
        }
        try {
            List list2 = this.parseElements(value2.toString());
            String[] results = new String[list2.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = (String)list2.get(i);
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value2.toString(), e);
        }
    }
}

