/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

public class BinaryData {
    private static final ThreadLocal<Decoders> DECODERS = new ThreadLocal<Decoders>(){

        @Override
        protected Decoders initialValue() {
            return new Decoders();
        }
    };
    private static final ThreadLocal<HashData> HASH_DATA = new ThreadLocal<HashData>(){

        @Override
        protected HashData initialValue() {
            return new HashData();
        }
    };

    private BinaryData() {
    }

    public static int compare(byte[] b1, int s1, byte[] b2, int s2, Schema schema) {
        return BinaryData.compare(b1, s1, b1.length - s1, b2, s2, b2.length - s2, schema);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2, Schema schema) {
        Decoders decoders = DECODERS.get();
        decoders.set(b1, s1, l1, b2, s2, l2);
        try {
            int n = BinaryData.compare(decoders, schema);
            return n;
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
        finally {
            decoders.clear();
        }
    }

    private static int compare(Decoders d, Schema schema) throws IOException {
        BinaryDecoder d1 = d.d1;
        BinaryDecoder d2 = d.d2;
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field2 : schema.getFields()) {
                    if (field2.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field2.schema(), d1);
                        GenericDatumReader.skip(field2.schema(), d2);
                        continue;
                    }
                    int c = BinaryData.compare(d, field2.schema());
                    if (c == 0) continue;
                    return field2.order() != Schema.Field.Order.DESCENDING ? c : -c;
                }
                return 0;
            }
            case ENUM: 
            case INT: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d2).readInt();
                return i1 == i2 ? 0 : (i1 > i2 ? 1 : -1);
            }
            case LONG: {
                long l1 = ((Decoder)d1).readLong();
                long l2 = ((Decoder)d2).readLong();
                return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
            }
            case ARRAY: {
                long i = 0L;
                long r1 = 0L;
                long r2 = 0L;
                long l1 = 0L;
                long l2 = 0L;
                block15: while (true) {
                    if (r1 == 0L) {
                        r1 = ((Decoder)d1).readLong();
                        if (r1 < 0L) {
                            r1 = -r1;
                            ((Decoder)d1).readLong();
                        }
                        l1 += r1;
                    }
                    if (r2 == 0L) {
                        r2 = ((Decoder)d2).readLong();
                        if (r2 < 0L) {
                            r2 = -r2;
                            ((Decoder)d2).readLong();
                        }
                        l2 += r2;
                    }
                    if (r1 == 0L || r2 == 0L) {
                        return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
                    }
                    long l = Math.min(l1, l2);
                    while (true) {
                        if (i >= l) continue block15;
                        int c = BinaryData.compare(d, schema.getElementType());
                        if (c != 0) {
                            return c;
                        }
                        ++i;
                        --r1;
                        --r2;
                    }
                    break;
                }
            }
            case MAP: {
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d2).readInt();
                if (i1 == i2) {
                    return BinaryData.compare(d, schema.getTypes().get(i1));
                }
                return i1 - i2;
            }
            case FIXED: {
                int size2 = schema.getFixedSize();
                int c = BinaryData.compareBytes(d.d1.getBuf(), d.d1.getPos(), size2, d.d2.getBuf(), d.d2.getPos(), size2);
                d.d1.skipFixed(size2);
                d.d2.skipFixed(size2);
                return c;
            }
            case STRING: 
            case BYTES: {
                int l1 = ((Decoder)d1).readInt();
                int l2 = ((Decoder)d2).readInt();
                int c = BinaryData.compareBytes(d.d1.getBuf(), d.d1.getPos(), l1, d.d2.getBuf(), d.d2.getPos(), l2);
                d.d1.skipFixed(l1);
                d.d2.skipFixed(l2);
                return c;
            }
            case FLOAT: {
                float f1 = ((Decoder)d1).readFloat();
                float f2 = ((Decoder)d2).readFloat();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case DOUBLE: {
                double f1 = ((Decoder)d1).readDouble();
                double f2 = ((Decoder)d2).readDouble();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case BOOLEAN: {
                boolean b1 = ((Decoder)d1).readBoolean();
                boolean b2 = ((Decoder)d2).readBoolean();
                return b1 == b2 ? 0 : (b1 ? 1 : -1);
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to compare!");
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int hashCode(byte[] bytes, int start, int length, Schema schema) {
        HashData data2 = HASH_DATA.get();
        data2.set(bytes, start, length);
        try {
            return BinaryData.hashCode(data2, schema);
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private static int hashCode(HashData data2, Schema schema) throws IOException {
        BinaryDecoder decoder2 = data2.decoder;
        switch (schema.getType()) {
            case RECORD: {
                int hashCode = 1;
                for (Schema.Field field2 : schema.getFields()) {
                    if (field2.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field2.schema(), decoder2);
                        continue;
                    }
                    hashCode = hashCode * 31 + BinaryData.hashCode(data2, field2.schema());
                }
                return hashCode;
            }
            case ENUM: 
            case INT: {
                return ((Decoder)decoder2).readInt();
            }
            case FLOAT: {
                return Float.floatToIntBits(((Decoder)decoder2).readFloat());
            }
            case LONG: {
                long l = ((Decoder)decoder2).readLong();
                return (int)(l ^ l >>> 32);
            }
            case DOUBLE: {
                long l = Double.doubleToLongBits(((Decoder)decoder2).readDouble());
                return (int)(l ^ l >>> 32);
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                int hashCode = 1;
                long l = ((Decoder)decoder2).readArrayStart();
                while (l != 0L) {
                    for (long i = 0L; i < l; ++i) {
                        hashCode = hashCode * 31 + BinaryData.hashCode(data2, elementType);
                    }
                    l = ((Decoder)decoder2).arrayNext();
                }
                return hashCode;
            }
            case MAP: {
                throw new AvroRuntimeException("Can't hashCode maps!");
            }
            case UNION: {
                return BinaryData.hashCode(data2, schema.getTypes().get(((Decoder)decoder2).readInt()));
            }
            case FIXED: {
                return BinaryData.hashBytes(1, data2, schema.getFixedSize(), false);
            }
            case STRING: {
                return BinaryData.hashBytes(0, data2, ((Decoder)decoder2).readInt(), false);
            }
            case BYTES: {
                return BinaryData.hashBytes(1, data2, ((Decoder)decoder2).readInt(), true);
            }
            case BOOLEAN: {
                return ((Decoder)decoder2).readBoolean() ? 1231 : 1237;
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to hashCode!");
    }

    private static int hashBytes(int init2, HashData data2, int len, boolean rev) throws IOException {
        int hashCode = init2;
        byte[] bytes = data2.decoder.getBuf();
        int start = data2.decoder.getPos();
        int end = start + len;
        if (rev) {
            for (int i = end - 1; i >= start; --i) {
                hashCode = hashCode * 31 + bytes[i];
            }
        } else {
            for (int i = start; i < end; ++i) {
                hashCode = hashCode * 31 + bytes[i];
            }
        }
        data2.decoder.skipFixed(len);
        return hashCode;
    }

    public static int skipLong(byte[] bytes, int start) {
        int i = start;
        byte b = bytes[i++];
        while ((b & 0x80) != 0) {
            b = bytes[i++];
        }
        return i;
    }

    public static int encodeBoolean(boolean b, byte[] buf, int pos) {
        buf[pos] = b ? (byte)1 : 0;
        return 1;
    }

    public static int encodeInt(int n, byte[] buf, int pos) {
        n = n << 1 ^ n >> 31;
        int start = pos;
        if ((n & 0xFFFFFF80) != 0) {
            buf[pos++] = (byte)((n | 0x80) & 0xFF);
            if ((n >>>= 7) > 127) {
                buf[pos++] = (byte)((n | 0x80) & 0xFF);
                if ((n >>>= 7) > 127) {
                    buf[pos++] = (byte)((n | 0x80) & 0xFF);
                    if ((n >>>= 7) > 127) {
                        buf[pos++] = (byte)((n | 0x80) & 0xFF);
                        n >>>= 7;
                    }
                }
            }
        }
        buf[pos++] = (byte)n;
        return pos - start;
    }

    public static int encodeLong(long n, byte[] buf, int pos) {
        n = n << 1 ^ n >> 63;
        int start = pos;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
            if ((n >>>= 7) > 127L) {
                buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                if ((n >>>= 7) > 127L) {
                    buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                    if ((n >>>= 7) > 127L) {
                        buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                        if ((n >>>= 7) > 127L) {
                            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                            if ((n >>>= 7) > 127L) {
                                buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                if ((n >>>= 7) > 127L) {
                                    buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                    if ((n >>>= 7) > 127L) {
                                        buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                        if ((n >>>= 7) > 127L) {
                                            buf[pos++] = (byte)((n | 0x80L) & 0xFFL);
                                            n >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        buf[pos++] = (byte)n;
        return pos - start;
    }

    public static int encodeFloat(float f, byte[] buf, int pos) {
        int len = 1;
        int bits2 = Float.floatToRawIntBits(f);
        buf[pos] = (byte)(bits2 & 0xFF);
        buf[pos + len++] = (byte)(bits2 >>> 8 & 0xFF);
        buf[pos + len++] = (byte)(bits2 >>> 16 & 0xFF);
        buf[pos + len++] = (byte)(bits2 >>> 24 & 0xFF);
        return 4;
    }

    public static int encodeDouble(double d, byte[] buf, int pos) {
        long bits2 = Double.doubleToRawLongBits(d);
        int first = (int)(bits2 & 0xFFFFFFFFFFFFFFFFL);
        int second = (int)(bits2 >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[pos] = (byte)(first & 0xFF);
        buf[pos + 4] = (byte)(second & 0xFF);
        buf[pos + 5] = (byte)(second >>> 8 & 0xFF);
        buf[pos + 1] = (byte)(first >>> 8 & 0xFF);
        buf[pos + 2] = (byte)(first >>> 16 & 0xFF);
        buf[pos + 6] = (byte)(second >>> 16 & 0xFF);
        buf[pos + 7] = (byte)(second >>> 24 & 0xFF);
        buf[pos + 3] = (byte)(first >>> 24 & 0xFF);
        return 8;
    }

    private static class HashData {
        private final BinaryDecoder decoder = new BinaryDecoder(new byte[0], 0, 0);

        public void set(byte[] bytes, int start, int len) {
            this.decoder.setBuf(bytes, start, len);
        }
    }

    private static class Decoders {
        private final BinaryDecoder d1 = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder d2 = new BinaryDecoder(new byte[0], 0, 0);

        public void set(byte[] data1, int off1, int len1, byte[] data2, int off2, int len2) {
            this.d1.setBuf(data1, off1, len1);
            this.d2.setBuf(data2, off2, len2);
        }

        public void clear() {
            this.d1.clearBuf();
            this.d2.clearBuf();
        }
    }
}

