/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011SE\u0004\u0002\nG%\u0011AEC\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%\u0015!A\u0011\u0006\u0001B\u0001B\u0003%1$\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5rs\u0006\r\t\u0003-\u0001AQa\u0001\u0016A\u0002UAqA\u0007\u0016\u0011\u0002\u0003\u00071\u0004C\u0004*UA\u0005\t\u0019A\u000e\t\u000fI\u0002!\u0019!C\u0001g\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003Q\u0002\"AF\u001b\n\u0005Y\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1\u0001\b\u0001Q\u0001\nQ\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9!\b\u0001b\u0001\n\u0003Y\u0014!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002yA\u0011a#P\u0005\u0003}\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0004A\u0001\u0001\u0006I\u0001P\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!9!\t\u0001b\u0001\n\u0003\u0019\u0015a\u0005:fa2L7-Y*uCR,W*Y2iS:,W#\u0001#\u0011\u0005Y)\u0015B\u0001$\u0003\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002BqA\u0013\u0001C\u0002\u0013\u00051*A\tu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012\u0001\u0014\t\u0004\u001bB\u000bS\"\u0001(\u000b\u0005=k\u0012aB7vi\u0006\u0014G.Z\u0005\u0003A9CaA\u0015\u0001!\u0002\u0013a\u0015A\u0005;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\u0002Bq\u0001\u0016\u0001C\u0002\u0013\u0005Q+A\u000bqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3\u0016\u0003Y\u00032!\u0014)X!\tA6,D\u0001Z\u0015\tQF!\u0001\u0004d_6lwN\\\u0005\u00039f\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u0019q\u0006\u0001)A\u0005-\u00061\u0002/\u0019:uSRLwN\\:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002\u0015\u0011,G.\u001a;f\u0019>\u001c7.F\u0001c!\t\u0019G.D\u0001e\u0015\t)g-A\u0003m_\u000e\\7O\u0003\u0002hQ\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%T\u0017\u0001B;uS2T\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nI\ni!+Z3oiJ\fg\u000e\u001e'pG.Daa\u001c\u0001!\u0002\u0013\u0011\u0017a\u00033fY\u0016$X\rT8dW\u0002Bq!\u001d\u0001C\u0002\u0013\u00051*A\u000eu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u0002'\u00029Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8oA!9Q\u000f\u0001b\u0001\n\u00031\u0018\u0001\u00053fY\u0016$X\rV8qS\u000e\u001c8i\u001c8e+\u00059\bCA2y\u0013\tIHMA\u0005D_:$\u0017\u000e^5p]\"11\u0010\u0001Q\u0001\n]\f\u0011\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3!\u0011\u001di\bA1A\u0005\u0002y\fq\u0003Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b1\u0017AB1u_6L7-\u0003\u0003\u0002\n\u0005\r!!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B@\u00021\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$\u0007\u0005C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0001\u0002\u0014\u0005\u0011B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1e+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0001\u0007\r\u0005m\u0001\u0001AA\u000f\u0005I!U\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193\u0014\t\u0005e\u0011q\u0004\t\u0004\u001f\u0005\u0005\u0012bAA\u0012!\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011\u001dY\u0013\u0011\u0004C\u0001\u0003O!\"!!\u0006\t\u0015\u0005-\u0012\u0011\u0004b\u0001\n\u0003\ti#\u0001\u0005{W\u000ec\u0017.\u001a8u+\t\ty\u0003\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0011i\\7\r\\5f]RTA!!\u000f\u0002<\u00051\u0011\nM%uK\u000eT!!!\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002B\u0005M\"\u0001\u0003.l\u00072LWM\u001c;\t\u0013\u0005\u0015\u0013\u0011\u0004Q\u0001\n\u0005=\u0012!\u0003>l\u00072LWM\u001c;!\u0011!\tI%!\u0007\u0005B\u0005-\u0013A\u00023p/>\u00148\u000e\u0006\u0002\u0002NA\u0019\u0011\"a\u0014\n\u0007\u0005E#B\u0001\u0003V]&$\b\"CA+\u0001\u0001\u0007I\u0011AA,\u0003Y!W\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193`I\u0015\fH\u0003BA'\u00033B!\"a\u0017\u0002T\u0005\u0005\t\u0019AA\u000b\u0003\rAH%\r\u0005\t\u0003?\u0002\u0001\u0015)\u0003\u0002\u0016\u0005\u0019B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1eA!I\u00111\r\u0001C\u0002\u0013\u0005\u0011QM\u0001\u0015SN$U\r\\3uKR{\u0007/[2F]\u0006\u0014G.\u001a3\u0016\u0005\u0005\u001d\u0004cA\u0005\u0002j%\u0019\u00111\u000e\u0006\u0003\u000f\t{w\u000e\\3b]\"A\u0011q\u000e\u0001!\u0002\u0013\t9'A\u000bjg\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\u0011\t\u000f\u0005M\u0004\u0001\"\u0001\u0002L\u0005)1\u000f^1si\"9\u0011q\u000f\u0001\u0005\u0002\u0005-\u0013\u0001C:ikR$wn\u001e8\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u0005ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u00055\u0013q\u0010\u0005\b\u0003\u0003\u000bI\b1\u0001\u001c\u0003\u0019!x\u000e]5dg\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\u0011\ti%!#\t\u0013\u0005\u0005\u00151\u0011I\u0001\u0002\u0004Y\u0002bBAG\u0001\u0011\u0005\u0011qR\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0005\u0003\u001b\n\t\n\u0003\u0005\u0002\u0014\u0006-\u0005\u0019AAK\u0003!\u0011X\r\u001d7jG\u0006\u001c\b\u0003\u0002\u000f \u0003/\u00032AFAM\u0013\r\tYJ\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003?\u0003A\u0011AAQ\u0003yi\u0017M]6U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002N\u0005\r\u0006bBAA\u0003;\u0003\ra\u0007\u0005\b\u0003O\u0003A\u0011AAU\u0003qI7\u000fV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$B!a\u001a\u0002,\"9\u0011QVAS\u0001\u0004\t\u0013!\u0002;pa&\u001c\u0007bBAY\u0001\u0011\u0005\u00111W\u0001\u001aSN$v\u000e]5d\t\u0016dW\r^5p]&s\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002h\u0005U\u0006bBAW\u0003_\u0003\r!\t\u0005\b\u0003s\u0003A\u0011AA^\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\t9'!0\t\u000f\u00055\u0016q\u0017a\u0001C!9\u0011\u0011\u0019\u0001\u0005\n\u0005-\u0013AH1xC&$Hk\u001c9jG\u0012+G.\u001a;j_:tu\u000e^5gS\u000e\fG/[8o\u0011\u001d\t)\r\u0001C\u0005\u0003\u0017\n\u0011D]3tk6,Gk\u001c9jG\u0012+G.\u001a;j_:$\u0006N]3bI\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\u0011\ti%!4\t\u0011\u0005M\u0015q\u0019a\u0001\u0003+Cq!!5\u0001\t\u0013\t\u0019.\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002h\u0005U\u0007bBAW\u0003\u001f\u0004\r!\t\u0005\b\u00033\u0004A\u0011BAn\u0003ei\u0017M]6U_BL7MR8s\t\u0016dW\r^5p]J+GO]=\u0015\t\u00055\u0013Q\u001c\u0005\b\u0003[\u000b9\u000e1\u0001\"\u0011\u001d\t\t\u000f\u0001C\u0005\u0003G\f1cY8na2,G/\u001a#fY\u0016$X\rV8qS\u000e$B!!\u0014\u0002f\"9\u0011QVAp\u0001\u0004\t\u0003bBAu\u0001\u0011%\u00111^\u0001\u0010_:$v\u000e]5d\t\u0016dW\r^5p]R!\u0011QJAw\u0011\u001d\t\t)a:A\u0002mAq!!=\u0001\t\u0013\t\u00190\u0001\u000bti\u0006\u0014HOU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0005\u0003\u001b\n)\u0010\u0003\u0005\u0002x\u0006=\b\u0019AAK\u0003q\u0011X\r\u001d7jG\u0006\u001chi\u001c:U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012Dq!a?\u0001\t\u0013\ti0A\np]B\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000e\u0006\u0003\u0002N\u0005}\bb\u0002+\u0002z\u0002\u0007!\u0011\u0001\t\u00049}9\u0006b\u0002B\u0003\u0001\u0011%!qA\u0001\u001fI\u0016dW\r^3U_BL7m\u0015;paJ+\u0007\u000f\\5dC\u000e\u000bG\u000e\u001c2bG.$b!!\u0014\u0003\n\te\u0001\u0002\u0003B\u0006\u0005\u0007\u0001\rA!\u0004\u0002-M$x\u000e\u001d*fa2L7-\u0019*fgB|gn]3PE*\u0004BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0004\u0005'!\u0011aA1qS&!!q\u0003B\t\u0005E\u0011V-];fgR|%OU3ta>t7/\u001a\u0005\t\u00057\u0011\u0019\u00011\u0001\u0003\u001e\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\t\u0004\u0013\t}\u0011b\u0001B\u0011\u0015\t\u0019\u0011J\u001c;\t\u0013\t\u0015\u0002!%A\u0005\u0002\t\u001d\u0012!\t:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2tI\u0011,g-Y;mi\u0012\nTC\u0001B\u0015U\rY\"1F\u0016\u0003\u0005[\u0001BAa\f\u0003:5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0005v]\u000eDWmY6fI*\u0019!q\u0007\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\tE\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!q\b\u0002\u0002\u0002#\u0005!\u0011I\u0001\u0015)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007Y\u0011\u0019E\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B#'\r\u0011\u0019\u0005\u0003\u0005\bW\t\rC\u0011\u0001B%)\t\u0011\t\u0005\u0003\u0006\u0003N\t\r\u0013\u0013!C\u0001\u0005O\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B)\u0005\u0007\n\n\u0011\"\u0001\u0003(\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final ReentrantLock deleteLock;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final boolean isDeleteTopicEnabled;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void start() {
        if (this.isDeleteTopicEnabled()) {
            this.deleteTopicsThread_$eq(new DeleteTopicsThread());
            this.deleteTopicStateChanged().set(true);
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        if (this.isDeleteTopicEnabled()) {
            this.deleteTopicsThread().shutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq(topics.flatMap(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq(topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }))).size() > 0) {
            Set<String> topics = replicasThatFailedToDelete.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)((Object)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            }));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion(topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq(newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.size() > 0) {
                this.info((Function0<String>)((Object)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                }));
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsIneligibleForDeletion().contains(topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsToBeDeleted().contains(topic) : false;
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        Utils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (!this.$outer.deleteTopicStateChanged().compareAndSet(true, false)) {
                    this.$outer.info((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for signal to start or continue topic deletion";
                        }
                    }));
                    this.$outer.deleteTopicsCond().await();
                }
                return;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        Utils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.deleteTopicsCond().signal();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.debug((Function0<String>)((Object)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        }));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq(topic);
        this.partitionsToBeDeleted().retain((Function1<TopicAndPartition, Object>)((Object)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final boolean apply(TopicAndPartition x$2) {
                String string2 = x$2.topic();
                String string3 = this.topic$1;
                return string2 != null ? !string2.equals(string3) : string3 != null;
            }
            {
                this.topic$1 = topic$1;
            }
        }));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicConfigPath(topic));
        this.controllerContext().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)((Object)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        }));
        Set<TopicAndPartition> partitions = topics.flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest(this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return p._1().topic();
            }
        });
        topics.foreach(new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion(((TraversableOnce)((TraversableLike)this.partitionReplicaAssignmentByTopic$1.apply(topic)).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                        return x$3._1();
                    }
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$4) {
                return x$4.topic();
            }
        }).foreach(new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(Tuple2<String, Set<PartitionAndReplica>> x0$1) {
                Tuple2<String, Set<PartitionAndReplica>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = tuple2._1();
                    Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final boolean apply(PartitionAndReplica p) {
                            return p.topic().equals(this.topic$2);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }));
                    Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus(aliveReplicasForTopic);
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                    this.$outer.replicaStateMachine().handleStateChanges(deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, replicasForDeletionRetry){
                        public static final long serialVersionUID = 0L;
                        private final Set replicasForDeletionRetry$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                        }
                        {
                            this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                        }
                    }));
                    this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<RequestOrResponse, Object, BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                        public final void apply(RequestOrResponse stopReplicaResponseObj, int replicaId) {
                            this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(stopReplicaResponseObj, replicaId);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    })).build());
                    if (deadReplicasForTopic.size() > 0) {
                        this.$outer.markTopicIneligibleForDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)((Object)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        }));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(RequestOrResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)((Object)new Serializable(this, stopReplicaResponse){
            public static final long serialVersionUID = 0L;
            private final StopReplicaResponse stopReplicaResponse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
            }
        }));
        scala.collection.immutable.Set<TopicAndPartition> partitionsInError = stopReplicaResponse.errorCode() != ErrorMapping$.MODULE$.NoError() ? stopReplicaResponse.responseMap().keySet() : ((TraversableOnce)((TraversableLike)stopReplicaResponse.responseMap().filter((Function1<TopicAndPartition, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Object> p) {
                return BoxesRunTime.unboxToShort(p._2()) != ErrorMapping$.MODULE$.NoError();
            }
        }))).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> x$5) {
                return x$5._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set replicasInError = partitionsInError.map(new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final int replicaId$1;

            public final PartitionAndReplica apply(TopicAndPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = replicaId$1;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId, stopReplicaResponse, partitionsInError, replicasInError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            public final int replicaId$1;
            private final StopReplicaResponse stopReplicaResponse$1;
            private final scala.collection.immutable.Set partitionsInError$1;
            private final scala.collection.immutable.Set replicasInError$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion(this.replicasInError$1);
                if (this.replicasInError$1.size() != this.stopReplicaResponse$1.responseMap().size()) {
                    scala.collection.immutable.Set deletedReplicas = (scala.collection.immutable.Set)this.stopReplicaResponse$1.responseMap().keySet().$minus$minus(this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion((Set<PartitionAndReplica>)deletedReplicas.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        public final PartitionAndReplica apply(TopicAndPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom()));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
                this.partitionsInError$1 = partitionsInError$1;
                this.replicasInError$1 = replicasInError$1;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.partitionsToBeDeleted = this.topicsToBeDeleted().flatMap(new $anonfun$1(this), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        this.deleteLock = new ReentrantLock();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkClient zkClient;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        @Override
        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            Utils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicsThread $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    This topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                    if (topicsQueuedForDeletion.size() > 0) {
                        this.$outer.info((Function0<String>)((Object)new Serializable(this, (Set)topicsQueuedForDeletion){
                            public static final long serialVersionUID = 0L;
                            private final Set topicsQueuedForDeletion$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                            }
                            {
                                this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                            }
                        }));
                    }
                    topicsQueuedForDeletion.foreach((Function1<String, BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DeleteTopicsThread$$anonfun$doWork$1 $outer;

                        public final void apply(String topic) {
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$3;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3}));
                                    }
                                    {
                                        this.topic$3 = topic$3;
                                    }
                                }));
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                                Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                                Set<A> replicaIds = replicasInDeletionStartedState.map(new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(PartitionAndReplica x$6) {
                                        return x$6.replica();
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                Set<A> partitions = replicasInDeletionStartedState.map(new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final TopicAndPartition apply(PartitionAndReplica r) {
                                        return new TopicAndPartition(r.topic(), r.partition());
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic, replicaIds, partitions){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$3;
                                    private final Set replicaIds$1;
                                    private final Set partitions$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$3}));
                                    }
                                    {
                                        this.topic$3 = topic$3;
                                        this.replicaIds$1 = replicaIds$1;
                                        this.partitions$1 = partitions$1;
                                    }
                                }));
                            } else {
                                Set<PartitionAndReplica> replicasInTopicDeletionFailedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic, replicasInTopicDeletionFailedState){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$3;
                                    private final Set replicasInTopicDeletionFailedState$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3, this.replicasInTopicDeletionFailedState$1.mkString(",")}));
                                    }
                                    {
                                        this.topic$3 = topic$3;
                                        this.replicasInTopicDeletionFailedState$1 = replicasInTopicDeletionFailedState$1;
                                    }
                                }));
                            }
                            if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$3;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3}));
                                    }
                                    {
                                        this.topic$3 = topic$3;
                                    }
                                }));
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                            } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) {
                                this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final String topic$3;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3}));
                                    }
                                    {
                                        this.topic$3 = topic$3;
                                    }
                                }));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }

                public /* synthetic */ DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw new NullPointerException();
            }
            super("delete-topics-thread", ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
            this.zkClient = TopicDeletionManager.this.controllerContext().zkClient();
        }
    }
}

