/*
 * Decompiled with CFR 0.152.
 */
package kafka.client;

import java.util.Hashtable;
import java.util.Properties;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.cluster.Broker;
import kafka.common.KafkaException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool$;
import kafka.producer.SyncProducer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Random$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ClientUtils$
implements Logging {
    public static final ClientUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ClientUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientUtils$ clientUtils$ = this;
        synchronized (clientUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<Broker> brokers, ProducerConfig producerConfig, int correlationId) {
        boolean fetchMetaDataSucceeded = false;
        IntRef i = new IntRef(0);
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, producerConfig.clientId(), topics.toSeq());
        TopicMetadataResponse topicMetadataResponse = null;
        Throwable t = null;
        Seq shuffledBrokers = Random$.MODULE$.shuffle(brokers, Seq$.MODULE$.canBuildFrom());
        while (i.elem < shuffledBrokers.size() && !fetchMetaDataSucceeded) {
            SyncProducer producer = ProducerPool$.MODULE$.createSyncProducer(producerConfig, (Broker)shuffledBrokers.apply(i.elem));
            this.info((Function0<String>)((Object)new Serializable(topics, correlationId, i, shuffledBrokers){
                public static final long serialVersionUID = 0L;
                private final Set topics$1;
                private final int correlationId$1;
                private final IntRef i$1;
                private final Seq shuffledBrokers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Fetching metadata from broker %s with correlation id %d for %d topic(s) %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.shuffledBrokers$1.apply(this.i$1.elem), BoxesRunTime.boxToInteger(this.correlationId$1), BoxesRunTime.boxToInteger(this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = topics$1;
                    this.correlationId$1 = correlationId$1;
                    this.i$1 = i$1;
                    this.shuffledBrokers$1 = shuffledBrokers$1;
                }
            }));
            {
                topicMetadataResponse = producer.send(topicMetadataRequest);
                fetchMetaDataSucceeded = true;
                ++i.elem;
                producer.close();
            }
        }
        if (fetchMetaDataSucceeded) {
            this.debug((Function0<String>)((Object)new Serializable(topics){
                public static final long serialVersionUID = 0L;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Successfully fetched metadata for %d topic(s) %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = topics$1;
                }
            }));
            return topicMetadataResponse;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("fetching topic metadata for topics [%s] from broker [%s] failed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topics, shuffledBrokers})), t);
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<Broker> brokers, String clientId, int timeoutMs, int correlationId) {
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", ((TraversableOnce)brokers.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Broker x$1) {
                return x$1.getConnectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        ((Hashtable)props).put("client.id", clientId);
        ((Hashtable)props).put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger(timeoutMs)).toString());
        ProducerConfig producerConfig = new ProducerConfig(props);
        return this.fetchTopicMetadata(topics, brokers, producerConfig, correlationId);
    }

    public int fetchTopicMetadata$default$5() {
        return 0;
    }

    public Seq<Broker> parseBrokerList(String brokerListStr) {
        Seq<String> brokersStr = Utils$.MODULE$.parseCsvList(brokerListStr);
        return ((TraversableLike)brokersStr.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Tuple2<String, Object> b) {
                String brokerStr = b._1();
                int brokerId = b._2$mcI$sp();
                String[] brokerInfos = brokerStr.split(":");
                String hostName = brokerInfos[0];
                int port = new StringOps(Predef$.MODULE$.augmentString(brokerInfos[1])).toInt();
                return new Broker(brokerId, hostName, port);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ClientUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

