/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;

public final class DeleteTopicCommand$ {
    public static final DeleteTopicCommand$ MODULE$;

    static {
        new DeleteTopicCommand$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to be deleted.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        OptionSet options = parser.parse(args);
        ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, zkConnectOpt}))).foreach(new Serializable(parser, options){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = parser$1;
                this.options$1 = options$1;
            }
        });
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
            zkClient.deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
            Predef$.MODULE$.println("deletion succeeded!");
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"delection failed because of ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    private DeleteTopicCommand$() {
        MODULE$ = this;
    }
}

