/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka010.KafkaTestUtils$$anonfun$org$apache$spark$streaming$kafka010$KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Q\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u00051!p\u001b%pgR,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019\u0019FO]5oO\"11\u0006\u0001Q\u0001\n\t\nqA_6I_N$\b\u0005C\u0004.\u0001\u0001\u0007I\u0011\u0002\u0018\u0002\ri\\\u0007k\u001c:u+\u0005y\u0003C\u0001\b1\u0013\t\ttBA\u0002J]RDqa\r\u0001A\u0002\u0013%A'\u0001\u0006{WB{'\u000f^0%KF$\"!\u000e\u001d\u0011\u000591\u0014BA\u001c\u0010\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u00030\u0003\u001dQ8\u000eU8si\u0002Bq!\u0010\u0001C\u0002\u0013%a&A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\u0003\u0004@\u0001\u0001\u0006IaL\u0001\u0015u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000f\u0005\u0003!\u0019!C\u0005]\u0005\u0001\"p[*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u0018\u0002#i\\7+Z:tS>tG+[7f_V$\b\u0005C\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\u0006I!p\\8lK\u0016\u0004XM]\u000b\u0002\u000fB\u0011\u0001*S\u0007\u0002\u0001\u0019!!\n\u0001\u0003L\u0005E)UNY3eI\u0016$'l\\8lK\u0016\u0004XM]\n\u0003\u00136A\u0001\"T%\u0003\u0006\u0004%\tAT\u0001\nu.\u001cuN\u001c8fGR,\u0012a\u0014\t\u0003!Ns!AD)\n\u0005I{\u0011A\u0002)sK\u0012,g-\u0003\u0002*)*\u0011!k\u0004\u0005\t-&\u0013\t\u0011)A\u0005\u001f\u0006Q!p[\"p]:,7\r\u001e\u0011\t\u000biIE\u0011\u0001-\u0015\u0005\u001dK\u0006\"B'X\u0001\u0004y\u0005bB.J\u0005\u0004%\t\u0001X\u0001\fg:\f\u0007o\u001d5pi\u0012K'/F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001g%\u0001\u0002j_&\u0011!m\u0018\u0002\u0005\r&dW\r\u0003\u0004e\u0013\u0002\u0006I!X\u0001\rg:\f\u0007o\u001d5pi\u0012K'\u000f\t\u0005\bM&\u0013\r\u0011\"\u0001]\u0003\u0019awn\u001a#je\"1\u0001.\u0013Q\u0001\nu\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004F\u0013\n\u0007I\u0011\u00016\u0016\u0003-\u0004\"\u0001\u001c9\u000e\u00035T!A\\8\u0002\rM,'O^3s\u0015\t)\u0005\"\u0003\u0002r[\ny!l\\8LK\u0016\u0004XM]*feZ,'\u000f\u0003\u0004t\u0013\u0002\u0006Ia[\u0001\u000bu>|7.Z3qKJ\u0004\u0003bB;J\u0003\u0003\u0006IA^\u0001\u0004q\u0012\u001a\u0004\u0003\u0002\bxE=J!\u0001_\b\u0003\rQ+\b\u000f\\33\u0011\u001dQ\u0018J1A\u0005\u0002\u0005\n!!\u001b9\t\rqL\u0005\u0015!\u0003#\u0003\rI\u0007\u000f\t\u0005\b}&\u0013\r\u0011\"\u0001/\u0003\u0011\u0001xN\u001d;\t\u000f\u0005\u0005\u0011\n)A\u0005_\u0005)\u0001o\u001c:uA!I\u0011QA%C\u0002\u0013\u0005\u0011qA\u0001\bM\u0006\u001cGo\u001c:z+\t\tI\u0001E\u0002m\u0003\u0017I1!!\u0004n\u0005Qq\u0015jT*feZ,'o\u00118y]\u001a\u000b7\r^8ss\"A\u0011\u0011C%!\u0002\u0013\tI!\u0001\u0005gC\u000e$xN]=!\u0011!\t)\"\u0013b\u0001\n\u0003q\u0013AC1diV\fG\u000eU8si\"9\u0011\u0011D%!\u0002\u0013y\u0013aC1diV\fG\u000eU8si\u0002Bq!!\bJ\t\u0003\ty\"\u0001\u0005tQV$Hm\\<o)\u0005)\u0004bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\tQB_8pW\u0016,\u0007/\u001a:`I\u0015\fHcA\u001b\u0002(!A\u0011(!\t\u0002\u0002\u0003\u0007q\t\u0003\u0004t\u0001\u0001\u0006Ka\u0012\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty#A\u0004{WV#\u0018\u000e\\:\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0006kRLGn\u001d\u0006\u0003\u0003w\tQa[1gW\u0006LA!a\u0010\u00026\t9!l[+uS2\u001c\bbCA\"\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\n1B_6Vi&d7o\u0018\u0013fcR\u0019Q'a\u0012\t\u0013e\n\t%!AA\u0002\u0005E\u0002\u0002CA&\u0001\u0001\u0006K!!\r\u0002\u0011i\\W\u000b^5mg\u0002B\u0001\"a\u0014\u0001\u0005\u0004%I!I\u0001\u000bEJ|7.\u001a:I_N$\bbBA*\u0001\u0001\u0006IAI\u0001\fEJ|7.\u001a:I_N$\b\u0005\u0003\u0005\u0002X\u0001\u0001\r\u0011\"\u0003/\u0003)\u0011'o\\6feB{'\u000f\u001e\u0005\n\u00037\u0002\u0001\u0019!C\u0005\u0003;\naB\u0019:pW\u0016\u0014\bk\u001c:u?\u0012*\u0017\u000fF\u00026\u0003?B\u0001\"OA-\u0003\u0003\u0005\ra\f\u0005\b\u0003G\u0002\u0001\u0015)\u00030\u0003-\u0011'o\\6feB{'\u000f\u001e\u0011\t\u0017\u0005\u001d\u0004\u00011AA\u0002\u0013%\u0011\u0011N\u0001\u000bEJ|7.\u001a:D_:4WCAA6!\u0011\ti'!\u001d\u000e\u0005\u0005=$b\u00018\u0002:%!\u00111OA8\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0017\u0005]\u0004\u00011AA\u0002\u0013%\u0011\u0011P\u0001\u000fEJ|7.\u001a:D_:4w\fJ3r)\r)\u00141\u0010\u0005\ns\u0005U\u0014\u0011!a\u0001\u0003WB\u0001\"a \u0001A\u0003&\u00111N\u0001\fEJ|7.\u001a:D_:4\u0007\u0005\u0003\u0006o\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007+\"!!\"\u0011\t\u00055\u0014qQ\u0005\u0005\u0003\u0013\u000byGA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbCAG\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001f\u000b!b]3sm\u0016\u0014x\fJ3r)\r)\u0014\u0011\u0013\u0005\ns\u0005-\u0015\u0011!a\u0001\u0003\u000bC\u0001\"!&\u0001A\u0003&\u0011QQ\u0001\bg\u0016\u0014h/\u001a:!\u0011-\tI\n\u0001a\u0001\u0002\u0004%I!a'\u0002\u0011A\u0014x\u000eZ;dKJ,\"!!(\u0011\r\u0005}\u00151U(P\u001b\t\t\tK\u0003\u0003\u0002\u001a\u0006e\u0012\u0002BAS\u0003C\u0013\u0001\u0002\u0015:pIV\u001cWM\u001d\u0005\f\u0003S\u0003\u0001\u0019!a\u0001\n\u0013\tY+\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000fF\u00026\u0003[C\u0011\"OAT\u0003\u0003\u0005\r!!(\t\u0011\u0005E\u0006\u0001)Q\u0005\u0003;\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\t\u0013\u0005U\u0006\u00011A\u0005\n\u0005]\u0016a\u0002>l%\u0016\fG-_\u000b\u0003\u0003s\u00032ADA^\u0013\r\til\u0004\u0002\b\u0005>|G.Z1o\u0011%\t\t\r\u0001a\u0001\n\u0013\t\u0019-A\u0006{WJ+\u0017\rZ=`I\u0015\fHcA\u001b\u0002F\"I\u0011(a0\u0002\u0002\u0003\u0007\u0011\u0011\u0018\u0005\t\u0003\u0013\u0004\u0001\u0015)\u0003\u0002:\u0006A!p\u001b*fC\u0012L\b\u0005C\u0005\u0002N\u0002\u0001\r\u0011\"\u0003\u00028\u0006Y!M]8lKJ\u0014V-\u00193z\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\u0019.A\bce>\\WM\u001d*fC\u0012Lx\fJ3r)\r)\u0014Q\u001b\u0005\ns\u0005=\u0017\u0011!a\u0001\u0003sC\u0001\"!7\u0001A\u0003&\u0011\u0011X\u0001\rEJ|7.\u001a:SK\u0006$\u0017\u0010\t\u0005\u0007\u0003;\u0004A\u0011\u0001(\u0002\u0013i\\\u0017\t\u001a3sKN\u001c\bBBAq\u0001\u0011\u0005a*A\u0007ce>\\WM]!eIJ,7o\u001d\u0005\b\u0003K\u0004A\u0011AA\u0018\u0003=Qxn\\6fKB,'o\u00117jK:$\bbBAu\u0001\u0011%\u0011qD\u0001\u0017g\u0016$X\u000f]#nE\u0016$G-\u001a3[_>\\W-\u001a9fe\"9\u0011Q\u001e\u0001\u0005\n\u0005}\u0011\u0001G:fiV\u0004X)\u001c2fI\u0012,GmS1gW\u0006\u001cVM\u001d<fe\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005}\u0011!B:fiV\u0004\bbBA{\u0001\u0011\u0005\u0011qD\u0001\ti\u0016\f'\u000fZ8x]\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\u0018aC2sK\u0006$X\rV8qS\u000e$R!NA\u007f\u0005\u0003Aq!a@\u0002x\u0002\u0007q*A\u0003u_BL7\rC\u0004\u0003\u0004\u0005]\b\u0019A\u0018\u0002\u0015A\f'\u000f^5uS>t7\u000fC\u0004\u0002z\u0002!\tAa\u0002\u0015\u0007U\u0012I\u0001C\u0004\u0002\u0000\n\u0015\u0001\u0019A(\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010\u0005a1/\u001a8e\u001b\u0016\u001c8/Y4fgR)QG!\u0005\u0003\u0014!9\u0011q B\u0006\u0001\u0004y\u0005\u0002\u0003B\u000b\u0005\u0017\u0001\rAa\u0006\u0002\u001b5,7o]1hKR{gI]3r!\u001d\u0011IBa\bP\u0005Gi!Aa\u0007\u000b\u0007\tua%\u0001\u0003vi&d\u0017\u0002\u0002B\u0011\u00057\u00111!T1q!\r\u0019#QE\u0005\u0004\u0005O!#aB%oi\u0016<WM\u001d\u0005\b\u0005\u001b\u0001A\u0011\u0001B\u0016)\u0015)$Q\u0006B\u0018\u0011\u001d\tyP!\u000bA\u0002=C\u0001B!\u0006\u0003*\u0001\u0007!\u0011\u0007\t\u0006!\nMrjL\u0005\u0004\u0005C!\u0006b\u0002B\u0007\u0001\u0011\u0005!q\u0007\u000b\u0006k\te\"1\b\u0005\b\u0003\u007f\u0014)\u00041\u0001P\u0011!\u0011iD!\u000eA\u0002\t}\u0012\u0001C7fgN\fw-Z:\u0011\t9\u0011\teT\u0005\u0004\u0005\u0007z!!B!se\u0006L\bb\u0002B$\u0001\u0011%!\u0011J\u0001\u0014EJ|7.\u001a:D_:4\u0017nZ;sCRLwN\\\u000b\u0003\u0005\u0017\u0002BA!\u0007\u0003N%!!q\nB\u000e\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005'\u0002A\u0011\u0002B%\u0003U\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:DqAa\u0016\u0001\t\u0003\u0011I&\u0001\u0006fm\u0016tG/^1mYf,BAa\u0017\u0003dQ1!Q\fB@\u0005\u0017#BAa\u0018\u0003vA!!\u0011\rB2\u0019\u0001!\u0001B!\u001a\u0003V\t\u0007!q\r\u0002\u0002)F!!\u0011\u000eB8!\rq!1N\u0005\u0004\u0005[z!a\u0002(pi\"Lgn\u001a\t\u0004\u001d\tE\u0014b\u0001B:\u001f\t\u0019\u0011I\\=\t\u0013\t]$Q\u000bCA\u0002\te\u0014\u0001\u00024v]\u000e\u0004RA\u0004B>\u0005?J1A! \u0010\u0005!a$-\u001f8b[\u0016t\u0004\u0002\u0003BA\u0005+\u0002\rAa!\u0002\u000fQLW.Z8viB!!Q\u0011BD\u001b\u0005!\u0011b\u0001BE\t\t!A+[7f\u0011!\u0011iI!\u0016A\u0002\t\r\u0015\u0001C5oi\u0016\u0014h/\u00197\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\u0006ir/Y5u+:$\u0018\u000e\\'fi\u0006$\u0017\r^1JgB\u0013x\u000e]1hCR,G\rF\u00036\u0005+\u00139\nC\u0004\u0002\u0000\n=\u0005\u0019A(\t\u000f\te%q\u0012a\u0001_\u0005I\u0001/\u0019:uSRLwN\u001c")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkUtils zkUtils;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka010$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka010$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort())}));
    }

    public ZkUtils zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkUtils)Option$.MODULE$.apply((Object)this.zkUtils()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), false));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((Map)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConfiguration(), false));
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3()));
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().startup();
                KafkaServer qual$1 = this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server();
                SecurityProtocol x$4 = qual$1.boundPort$default$1();
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort_$eq(qual$1.boundPort(x$4));
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkUtils() != null) {
            this.zkUtils().close();
            this.zkUtils_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$1;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$3, (Object)x$2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$2;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka010$KafkaTestUtils$$isPropagated$1(this.topic$2, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$streaming$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka010$KafkaTestUtils$$isPropagated$1(String topic$2, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$2, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = this.zkUtils().getLeaderForPartition(topic$2, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$$brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final Tuple2<String, Object> x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

