/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMClientImpl
extends NMClient {
    private static final Log LOG = LogFactory.getLog(NMClientImpl.class);
    protected ConcurrentMap<ContainerId, StartedContainer> startedContainers = new ConcurrentHashMap<ContainerId, StartedContainer>();
    private final AtomicBoolean cleanupRunningContainers = new AtomicBoolean(true);
    private ContainerManagementProtocolProxy cmProxy;

    public NMClientImpl() {
        super(NMClientImpl.class.getName());
    }

    public NMClientImpl(String name) {
        super(name);
    }

    protected void serviceStop() throws Exception {
        if (this.getCleanupRunningContainers().get()) {
            this.cleanupRunningContainers();
        }
        this.cmProxy.stopAllProxies();
        super.serviceStop();
    }

    protected synchronized void cleanupRunningContainers() {
        for (StartedContainer startedContainer : this.startedContainers.values()) {
            try {
                this.stopContainer(startedContainer.getContainerId(), startedContainer.getNodeId());
            }
            catch (YarnException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.cmProxy = new ContainerManagementProtocolProxy(conf);
    }

    @Override
    public void cleanupRunningContainersOnStop(boolean enabled) {
        this.getCleanupRunningContainers().set(enabled);
    }

    private void addStartingContainer(StartedContainer startedContainer) throws YarnException {
        if (this.startedContainers.putIfAbsent(startedContainer.containerId, startedContainer) != null) {
            throw RPCUtil.getRemoteException("Container " + startedContainer.containerId.toString() + " is already started");
        }
        this.startedContainers.put(startedContainer.getContainerId(), startedContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        StartedContainer startingContainer;
        StartedContainer startedContainer = startingContainer = this.createStartedContainer(container);
        synchronized (startedContainer) {
            Map<String, ByteBuffer> allServiceResponse;
            this.addStartingContainer(startingContainer);
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
                StartContainerRequest scRequest = StartContainerRequest.newInstance(containerLaunchContext, container.getContainerToken());
                ArrayList<StartContainerRequest> list2 = new ArrayList<StartContainerRequest>();
                list2.add(scRequest);
                StartContainersRequest allRequests = StartContainersRequest.newInstance(list2);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(allRequests);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                    Throwable t = response.getFailedRequests().get(container.getId()).deSerialize();
                    this.parseAndThrowException(t);
                }
                allServiceResponse = response.getAllServicesMetaData();
                startingContainer.state = ContainerState.RUNNING;
                if (proxy != null) {
                    this.cmProxy.mayBeCloseProxy(proxy);
                }
            }
            catch (YarnException e) {
                try {
                    startingContainer.state = ContainerState.COMPLETE;
                    this.removeStartedContainer(startingContainer);
                    throw e;
                    catch (IOException e2) {
                        startingContainer.state = ContainerState.COMPLETE;
                        this.removeStartedContainer(startingContainer);
                        throw e2;
                    }
                    catch (Throwable t) {
                        startingContainer.state = ContainerState.COMPLETE;
                        this.removeStartedContainer(startingContainer);
                        throw RPCUtil.getRemoteException(t);
                    }
                }
                catch (Throwable throwable) {
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                    throw throwable;
                }
            }
            return allServiceResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        StartedContainer startedContainer = this.getStartedContainer(containerId);
        if (startedContainer != null) {
            StartedContainer startedContainer2 = startedContainer;
            synchronized (startedContainer2) {
                if (startedContainer.state != ContainerState.RUNNING) {
                    return;
                }
                this.stopContainerInternal(containerId, nodeId);
                startedContainer.state = ContainerState.COMPLETE;
                this.removeStartedContainer(startedContainer);
            }
        } else {
            this.stopContainerInternal(containerId, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus getContainerStatus(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            ContainerStatus containerStatus;
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            GetContainerStatusesResponse response = proxy.getContainerManagementProtocol().getContainerStatuses(GetContainerStatusesRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = response.getFailedRequests().get(containerId).deSerialize();
                this.parseAndThrowException(t);
            }
            ContainerStatus containerStatus2 = containerStatus = response.getContainerStatuses().get(0);
            return containerStatus2;
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopContainerInternal(ContainerId containerId, NodeId nodeId) throws IOException, YarnException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            StopContainersResponse response = proxy.getContainerManagementProtocol().stopContainers(StopContainersRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = response.getFailedRequests().get(containerId).deSerialize();
                this.parseAndThrowException(t);
            }
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    protected synchronized StartedContainer createStartedContainer(Container container) throws YarnException, IOException {
        StartedContainer startedContainer = new StartedContainer(container.getId(), container.getNodeId(), container.getContainerToken());
        return startedContainer;
    }

    protected synchronized void removeStartedContainer(StartedContainer container) {
        this.startedContainers.remove(container.containerId);
    }

    protected synchronized StartedContainer getStartedContainer(ContainerId containerId) {
        return (StartedContainer)this.startedContainers.get(containerId);
    }

    public AtomicBoolean getCleanupRunningContainers() {
        return this.cleanupRunningContainers;
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    protected static class StartedContainer {
        private ContainerId containerId;
        private NodeId nodeId;
        private ContainerState state;

        public StartedContainer(ContainerId containerId, NodeId nodeId, Token containerToken) {
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.state = ContainerState.NEW;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }
    }
}

