/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;

public abstract class JsonProperties {
    Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>(1);
    private Set<String> reserved;

    JsonProperties(Set<String> reserved) {
        this.reserved = reserved;
    }

    public String getProp(String name) {
        JsonNode value2 = this.getJsonProp(name);
        return value2 != null && value2.isTextual() ? value2.getTextValue() : null;
    }

    public synchronized JsonNode getJsonProp(String name) {
        return this.props.get(name);
    }

    public void addProp(String name, String value2) {
        this.addProp(name, TextNode.valueOf(value2));
    }

    public synchronized void addProp(String name, JsonNode value2) {
        if (this.reserved.contains(name)) {
            throw new AvroRuntimeException("Can't set reserved property: " + name);
        }
        if (value2 == null) {
            throw new AvroRuntimeException("Can't set a property to null: " + name);
        }
        JsonNode old = this.props.get(name);
        if (old == null) {
            this.props.put(name, value2);
        } else if (!old.equals(value2)) {
            throw new AvroRuntimeException("Can't overwrite property: " + name);
        }
    }

    @Deprecated
    public Map<String, String> getProps() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, JsonNode> e : this.props.entrySet()) {
            if (!e.getValue().isTextual()) continue;
            result.put(e.getKey(), e.getValue().getTextValue());
        }
        return result;
    }

    Map<String, JsonNode> jsonProps(Map<String, String> stringProps) {
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        for (Map.Entry<String, String> e : stringProps.entrySet()) {
            result.put(e.getKey(), TextNode.valueOf(e.getValue()));
        }
        return result;
    }

    public Map<String, JsonNode> getJsonProps() {
        return Collections.unmodifiableMap(this.props);
    }

    void writeProps(JsonGenerator gen) throws IOException {
        for (Map.Entry<String, JsonNode> e : this.props.entrySet()) {
            gen.writeObjectField(e.getKey(), e.getValue());
        }
    }
}

