/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordBatch {
    private static final Logger log = LoggerFactory.getLogger(RecordBatch.class);
    public int recordCount = 0;
    public int maxRecordSize = 0;
    public volatile int attempts = 0;
    public final long createdMs;
    public long drainedMs;
    public long lastAttemptMs;
    public final MemoryRecords records;
    public final TopicPartition topicPartition;
    public final ProduceRequestResult produceFuture;
    public long lastAppendTime;
    private final List<Thunk> thunks;
    private long offsetCounter = 0L;
    private boolean retry;

    public RecordBatch(TopicPartition tp, MemoryRecords records, long now) {
        this.createdMs = now;
        this.lastAttemptMs = now;
        this.records = records;
        this.topicPartition = tp;
        this.produceFuture = new ProduceRequestResult();
        this.thunks = new ArrayList<Thunk>();
        this.lastAppendTime = this.createdMs;
        this.retry = false;
    }

    public FutureRecordMetadata tryAppend(long timestamp2, byte[] key, byte[] value2, Callback callback, long now) {
        if (!this.records.hasRoomFor(key, value2)) {
            return null;
        }
        long checksum = this.records.append(this.offsetCounter++, timestamp2, key, value2);
        this.maxRecordSize = Math.max(this.maxRecordSize, Record.recordSize(key, value2));
        this.lastAppendTime = now;
        FutureRecordMetadata future = new FutureRecordMetadata(this.produceFuture, this.recordCount, timestamp2, checksum, key == null ? -1 : key.length, value2 == null ? -1 : value2.length);
        if (callback != null) {
            this.thunks.add(new Thunk(callback, future));
        }
        ++this.recordCount;
        return future;
    }

    public void done(long baseOffset, long timestamp2, RuntimeException exception) {
        log.trace("Produced messages to topic-partition {} with base offset offset {} and error: {}.", new Object[]{this.topicPartition, baseOffset, exception});
        for (int i = 0; i < this.thunks.size(); ++i) {
            try {
                Thunk thunk = this.thunks.get(i);
                if (exception == null) {
                    RecordMetadata metadata = new RecordMetadata(this.topicPartition, baseOffset, thunk.future.relativeOffset(), timestamp2 == -1L ? thunk.future.timestamp() : timestamp2, thunk.future.checksum(), thunk.future.serializedKeySize(), thunk.future.serializedValueSize());
                    thunk.callback.onCompletion(metadata, null);
                    continue;
                }
                thunk.callback.onCompletion(null, exception);
                continue;
            }
            catch (Exception e) {
                log.error("Error executing user-provided callback on message for topic-partition {}:", (Object)this.topicPartition, (Object)e);
            }
        }
        this.produceFuture.done(this.topicPartition, baseOffset, exception);
    }

    public String toString() {
        return "RecordBatch(topicPartition=" + this.topicPartition + ", recordCount=" + this.recordCount + ")";
    }

    public boolean maybeExpire(int requestTimeoutMs, long retryBackoffMs, long now, long lingerMs, boolean isFull) {
        boolean expire = false;
        if (!this.inRetry() && isFull && (long)requestTimeoutMs < now - this.lastAppendTime) {
            expire = true;
        } else if (!this.inRetry() && (long)requestTimeoutMs < now - (this.createdMs + lingerMs)) {
            expire = true;
        } else if (this.inRetry() && (long)requestTimeoutMs < now - (this.lastAttemptMs + retryBackoffMs)) {
            expire = true;
        }
        if (expire) {
            this.records.close();
            this.done(-1L, -1L, new TimeoutException("Batch containing " + this.recordCount + " record(s) expired due to timeout while requesting metadata from brokers for " + this.topicPartition));
        }
        return expire;
    }

    public boolean inRetry() {
        return this.retry;
    }

    public void setRetry() {
        this.retry = true;
    }

    private static final class Thunk {
        final Callback callback;
        final FutureRecordMetadata future;

        public Thunk(Callback callback, FutureRecordMetadata future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

