/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class NMTokenIdentifier
extends TokenIdentifier {
    private static Log LOG = LogFactory.getLog(NMTokenIdentifier.class);
    public static final Text KIND = new Text("NMToken");
    private ApplicationAttemptId appAttemptId;
    private NodeId nodeId;
    private String appSubmitter;
    private int keyId;

    public NMTokenIdentifier(ApplicationAttemptId appAttemptId, NodeId nodeId, String applicationSubmitter, int masterKeyId) {
        this.appAttemptId = appAttemptId;
        this.nodeId = nodeId;
        this.appSubmitter = applicationSubmitter;
        this.keyId = masterKeyId;
    }

    public NMTokenIdentifier() {
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getApplicationSubmitter() {
        return this.appSubmitter;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug((Object)("Writing NMTokenIdentifier to RPC layer: " + (Object)((Object)this)));
        ApplicationId applicationId = this.appAttemptId.getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(this.appAttemptId.getAttemptId());
        out.writeUTF(this.nodeId.toString());
        out.writeUTF(this.appSubmitter);
        out.writeInt(this.keyId);
    }

    public void readFields(DataInput in) throws IOException {
        this.appAttemptId = ApplicationAttemptId.newInstance(ApplicationId.newInstance(in.readLong(), in.readInt()), in.readInt());
        String[] hostAddr = in.readUTF().split(":");
        this.nodeId = NodeId.newInstance(hostAddr[0], Integer.parseInt(hostAddr[1]));
        this.appSubmitter = in.readUTF();
        this.keyId = in.readInt();
    }

    public Text getKind() {
        return KIND;
    }

    public UserGroupInformation getUser() {
        return UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
    }
}

