/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.admin.AdminUtils$;
import kafka.api.KAFKA_0_9_0$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.GenerateBrokerIdException;
import kafka.common.InconsistentBrokerIdException;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupCoordinator$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.SocketServer;
import kafka.security.auth.Authorizer;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.BrokerShuttingDown$;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats$;
import kafka.server.ClientIdConfigHandler;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaHealthcheck;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.NotRunning$;
import kafka.server.PendingControlledShutdown$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.RunningAsBroker$;
import kafka.server.Starting$;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Mx4jLoader$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r-v!B\u0001\u0003\u0011\u00039\u0011aC&bM.\f7+\u001a:wKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\f\u0017\u000647.Y*feZ,'o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\rYIA\u0011\u0001\u0003\u0018\u0003Q\u0019w\u000e]=LC\u001a\\\u0017mQ8oM&<Gk\u001c'pOR\u0011\u0001$\f\t\u00053y\u0001s%D\u0001\u001b\u0015\tYB$\u0001\u0003vi&d'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u00111!T1q!\t\tCE\u0004\u0002\u000eE%\u00111ED\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$\u001dA\u0011\u0001fK\u0007\u0002S)\u0011!\u0006H\u0001\u0005Y\u0006tw-\u0003\u0002-S\t1qJ\u00196fGRDQAL\u000bA\u0002=\n1b[1gW\u0006\u001cuN\u001c4jOB\u0011\u0001\u0002M\u0005\u0003c\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"91'CI\u0001\n\u0003!\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u00016U\t1D\b\u0005\u00028u5\t\u0001H\u0003\u0002:\t\u0005)Q\u000f^5mg&\u00111\b\u000f\u0002\u0005)&lWmK\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0005v]\u000eDWmY6fI*\u0011!ID\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001#@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b\r&\t\n\u0011\"\u0001H\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t\u0001J\u000b\u0002JyA\u0019QB\u0013\u0011\n\u0005-s!AB(qi&|gN\u0002\u0003\u000b\u0005\u0001i5\u0003\u0002'\r\u001dF\u0003\"aN(\n\u0005AC$a\u0002'pO\u001eLgn\u001a\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0012\tq!\\3ue&\u001c7/\u0003\u0002W'\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011ac%Q1A\u0005\u0002e\u000baaY8oM&<W#A\u0018\t\u0011mc%\u0011!Q\u0001\n=\nqaY8oM&<\u0007\u0005\u0003\u0005^\u0019\n\u0005\t\u0015!\u00037\u0003\u0011!\u0018.\\3\t\u0011}c%\u0011!Q\u0001\n%\u000b\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\t\u000bMaE\u0011A1\u0015\t\t\u001cG-\u001a\t\u0003\u00111CQ\u0001\u00171A\u0002=Bq!\u00181\u0011\u0002\u0003\u0007a\u0007C\u0004`AB\u0005\t\u0019A%\t\u000f\u001dd%\u0019!C\u0005Q\u0006y1\u000f^1siV\u00048i\\7qY\u0016$X-F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003]j\t!bY8oGV\u0014(/\u001a8u\u0013\t\u00018NA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007e2\u0003\u000b\u0011B5\u0002!M$\u0018M\u001d;va\u000e{W\u000e\u001d7fi\u0016\u0004\u0003b\u0002;M\u0005\u0004%I\u0001[\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o\u0011\u00191H\n)A\u0005S\u0006y\u0011n]*ikR$\u0018N\\4E_^t\u0007\u0005C\u0004y\u0019\n\u0007I\u0011\u00025\u0002\u0019%\u001c8\u000b^1si&tw-\u00169\t\rid\u0005\u0015!\u0003j\u00035I7o\u0015;beRLgnZ+qA!9A\u0010\u0014a\u0001\n\u0013i\u0018!D:ikR$wn\u001e8MCR\u001c\u0007.F\u0001\u007f!\ry\u0018\u0011A\u0007\u0002[&\u0019\u00111A7\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"I\u0011q\u0001'A\u0002\u0013%\u0011\u0011B\u0001\u0012g\",H\u000fZ8x]2\u000bGo\u00195`I\u0015\fH\u0003BA\u0006\u0003#\u00012!DA\u0007\u0013\r\tyA\u0004\u0002\u0005+:LG\u000fC\u0005\u0002\u0014\u0005\u0015\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005]A\n)Q\u0005}\u0006q1\u000f[;uI><h\u000eT1uG\"\u0004\u0003\"CA\u000e\u0019\n\u0007I\u0011BA\u000f\u0003%QW\u000e\u001f)sK\u001aL\u00070F\u0001!\u0011\u001d\t\t\u0003\u0014Q\u0001\n\u0001\n!B[7y!J,g-\u001b=!\u0011%\t)\u0003\u0014b\u0001\n\u0013\t9#A\u0005sKB|'\u000f^3sgV\u0011\u0011\u0011\u0006\t\u00063\u0005-\u0012qF\u0005\u0004\u0003[Q\"\u0001\u0002'jgR\u0004B!!\r\u0002D5\u0011\u00111\u0007\u0006\u0004)\u0006U\"\u0002BA\u001c\u0003s\taaY8n[>t'bA\u0003\u0002<)!\u0011QHA \u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011I\u0001\u0004_J<\u0017\u0002BA#\u0003g\u0011q\"T3ue&\u001c7OU3q_J$XM\u001d\u0005\t\u0003\u0013b\u0005\u0015!\u0003\u0002*\u0005Q!/\u001a9peR,'o\u001d\u0011\t\u0013\u00055CJ1A\u0005\f\u0005=\u0013\u0001E6bM.\fW*\u001a;sS\u000e\u001cH+[7f+\t\t\t\u0006\u0005\u0003\u0002T\u0005]SBAA+\u0015\rI\u0014QG\u0005\u0004w\u0005U\u0003\u0002CA.\u0019\u0002\u0006I!!\u0015\u0002#-\fgm[1NKR\u0014\u0018nY:US6,\u0007\u0005\u0003\u0005U\u0019\u0002\u0007I\u0011AA0+\t\t\t\u0007\u0005\u0003\u00022\u0005\r\u0014\u0002BA3\u0003g\u0011q!T3ue&\u001c7\u000fC\u0005\u0002j1\u0003\r\u0011\"\u0001\u0002l\u0005YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\tY!!\u001c\t\u0015\u0005M\u0011qMA\u0001\u0002\u0004\t\t\u0007\u0003\u0005\u0002r1\u0003\u000b\u0015BA1\u0003!iW\r\u001e:jGN\u0004\u0003\"CA;\u0019\n\u0007I\u0011BA<\u00031iW\r\u001e:jG\u000e{gNZ5h+\t\tI\b\u0005\u0003\u00022\u0005m\u0014\u0002BA?\u0003g\u0011A\"T3ue&\u001c7i\u001c8gS\u001eD\u0001\"!!MA\u0003%\u0011\u0011P\u0001\u000e[\u0016$(/[2D_:4\u0017n\u001a\u0011\t\u0013\u0005\u0015EJ1A\u0005\u0002\u0005\u001d\u0015a\u00032s_.,'o\u0015;bi\u0016,\"!!#\u0011\u0007!\tY)C\u0002\u0002\u000e\n\u00111B\u0011:pW\u0016\u00148\u000b^1uK\"A\u0011\u0011\u0013'!\u0002\u0013\tI)\u0001\u0007ce>\\WM]*uCR,\u0007\u0005C\u0005\u0002\u00162\u0003\r\u0011\"\u0001\u0002\u0018\u0006!\u0011\r]5t+\t\tI\nE\u0002\t\u00037K1!!(\u0003\u0005%Y\u0015MZ6b\u0003BL7\u000fC\u0005\u0002\"2\u0003\r\u0011\"\u0001\u0002$\u0006A\u0011\r]5t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\u0015\u0006BCA\n\u0003?\u000b\t\u00111\u0001\u0002\u001a\"A\u0011\u0011\u0016'!B\u0013\tI*A\u0003ba&\u001c\b\u0005C\u0005\u0002.2\u0003\r\u0011\"\u0001\u00020\u0006Q\u0011-\u001e;i_JL'0\u001a:\u0016\u0005\u0005E\u0006\u0003B\u0007K\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,\u0001\u0003bkRD'bAA_\t\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002B\u0006]&AC!vi\"|'/\u001b>fe\"I\u0011Q\u0019'A\u0002\u0013\u0005\u0011qY\u0001\u000fCV$\bn\u001c:ju\u0016\u0014x\fJ3r)\u0011\tY!!3\t\u0015\u0005M\u00111YA\u0001\u0002\u0004\t\t\f\u0003\u0005\u0002N2\u0003\u000b\u0015BAY\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\t\u0013\u0005EG\n1A\u0005\u0002\u0005M\u0017\u0001D:pG.,GoU3sm\u0016\u0014XCAAk!\u0011\t9.!8\u000e\u0005\u0005e'bAAn\t\u00059a.\u001a;x_J\\\u0017\u0002BAp\u00033\u0014AbU8dW\u0016$8+\u001a:wKJD\u0011\"a9M\u0001\u0004%\t!!:\u0002!M|7m[3u'\u0016\u0014h/\u001a:`I\u0015\fH\u0003BA\u0006\u0003OD!\"a\u0005\u0002b\u0006\u0005\t\u0019AAk\u0011!\tY\u000f\u0014Q!\n\u0005U\u0017!D:pG.,GoU3sm\u0016\u0014\b\u0005C\u0005\u0002p2\u0003\r\u0011\"\u0001\u0002r\u0006\u0011\"/Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m+\t\t\u0019\u0010E\u0002\t\u0003kL1!a>\u0003\u0005]Y\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!>|G\u000eC\u0005\u0002|2\u0003\r\u0011\"\u0001\u0002~\u00061\"/Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005}\bBCA\n\u0003s\f\t\u00111\u0001\u0002t\"A!1\u0001'!B\u0013\t\u00190A\nsKF,Xm\u001d;IC:$G.\u001a:Q_>d\u0007\u0005C\u0005\u0003\b1\u0003\r\u0011\"\u0001\u0003\n\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tEA!A\u0002m_\u001eLAA!\u0006\u0003\u0010\tQAj\\4NC:\fw-\u001a:\t\u0013\teA\n1A\u0005\u0002\tm\u0011A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u0017\u0011i\u0002\u0003\u0006\u0002\u0014\t]\u0011\u0011!a\u0001\u0005\u0017A\u0001B!\tMA\u0003&!1B\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0003&1\u0003\r\u0011\"\u0001\u0003(\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XC\u0001B\u0015!\rA!1F\u0005\u0004\u0005[\u0011!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\n\u0005ca\u0005\u0019!C\u0001\u0005g\t!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR!\u00111\u0002B\u001b\u0011)\t\u0019Ba\f\u0002\u0002\u0003\u0007!\u0011\u0006\u0005\t\u0005sa\u0005\u0015)\u0003\u0003*\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0005C\u0005\u0003>1\u0003\r\u0011\"\u0001\u0003@\u0005)B-\u001f8b[&\u001c7i\u001c8gS\u001eD\u0015M\u001c3mKJ\u001cXC\u0001B!!\u0019\t#1\t\u0011\u0003F%\u0011qD\n\t\u0004\u0011\t\u001d\u0013b\u0001B%\u0005\ti1i\u001c8gS\u001eD\u0015M\u001c3mKJD\u0011B!\u0014M\u0001\u0004%\tAa\u0014\u00023\u0011Lh.Y7jG\u000e{gNZ5h\u0011\u0006tG\r\\3sg~#S-\u001d\u000b\u0005\u0003\u0017\u0011\t\u0006\u0003\u0006\u0002\u0014\t-\u0013\u0011!a\u0001\u0005\u0003B\u0001B!\u0016MA\u0003&!\u0011I\u0001\u0017Ift\u0017-\\5d\u0007>tg-[4IC:$G.\u001a:tA!I!\u0011\f'A\u0002\u0013\u0005!1L\u0001\u0015Ift\u0017-\\5d\u0007>tg-[4NC:\fw-\u001a:\u0016\u0005\tu\u0003c\u0001\u0005\u0003`%\u0019!\u0011\r\u0002\u0003)\u0011Kh.Y7jG\u000e{gNZ5h\u001b\u0006t\u0017mZ3s\u0011%\u0011)\u0007\u0014a\u0001\n\u0003\u00119'\u0001\res:\fW.[2D_:4\u0017nZ'b]\u0006<WM]0%KF$B!a\u0003\u0003j!Q\u00111\u0003B2\u0003\u0003\u0005\rA!\u0018\t\u0011\t5D\n)Q\u0005\u0005;\nQ\u0003Z=oC6L7mQ8oM&<W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0003r1\u0003\r\u0011\"\u0001\u0003t\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0005k\u0002BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0004\u0005w\"\u0011aC2p_J$\u0017N\\1u_JLAAa \u0003z\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0005\n\u0005\u0007c\u0005\u0019!C\u0001\u0005\u000b\u000bAc\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:`I\u0015\fH\u0003BA\u0006\u0005\u000fC!\"a\u0005\u0003\u0002\u0006\u0005\t\u0019\u0001B;\u0011!\u0011Y\t\u0014Q!\n\tU\u0014!E4s_V\u00048i\\8sI&t\u0017\r^8sA!I!q\u0012'A\u0002\u0013\u0005!\u0011S\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feV\u0011!1\u0013\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011\u0014\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0003\u001e\n]%aD&bM.\f7i\u001c8ue>dG.\u001a:\t\u0013\t\u0005F\n1A\u0005\u0002\t\r\u0016aE6bM.\f7i\u001c8ue>dG.\u001a:`I\u0015\fH\u0003BA\u0006\u0005KC!\"a\u0005\u0003 \u0006\u0005\t\u0019\u0001BJ\u0011!\u0011I\u000b\u0014Q!\n\tM\u0015\u0001E6bM.\f7i\u001c8ue>dG.\u001a:!\u0011%\u0011i\u000b\u0014b\u0001\n\u0003\u0011y+\u0001\blC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0016\u0005\tE\u0006cA\u001c\u00034&\u0019!Q\u0017\u001d\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\"A!\u0011\u0018'!\u0002\u0013\u0011\t,A\blC\u001a\\\u0017mU2iK\u0012,H.\u001a:!\u0011%\u0011i\f\u0014a\u0001\n\u0003\u0011y,\u0001\tlC\u001a\\\u0017\rS3bYRD7\r[3dWV\u0011!\u0011\u0019\t\u0004\u0011\t\r\u0017b\u0001Bc\u0005\t\u00012*\u00194lC\"+\u0017\r\u001c;iG\",7m\u001b\u0005\n\u0005\u0013d\u0005\u0019!C\u0001\u0005\u0017\fAc[1gW\u0006DU-\u00197uQ\u000eDWmY6`I\u0015\fH\u0003BA\u0006\u0005\u001bD!\"a\u0005\u0003H\u0006\u0005\t\u0019\u0001Ba\u0011!\u0011\t\u000e\u0014Q!\n\t\u0005\u0017!E6bM.\f\u0007*Z1mi\"\u001c\u0007.Z2lA!I!Q\u001b'C\u0002\u0013\u0005!q[\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\te\u0007c\u0001\u0005\u0003\\&\u0019!Q\u001c\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!\u0011\t\u000f\u0014Q\u0001\n\te\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\n\u0005Kd\u0005\u0019!C\u0001\u0005O\fqA_6Vi&d7/\u0006\u0002\u0003jB\u0019qGa;\n\u0007\t5\bHA\u0004[WV#\u0018\u000e\\:\t\u0013\tEH\n1A\u0005\u0002\tM\u0018a\u0003>l+RLGn]0%KF$B!a\u0003\u0003v\"Q\u00111\u0003Bx\u0003\u0003\u0005\rA!;\t\u0011\teH\n)Q\u0005\u0005S\f\u0001B_6Vi&d7\u000f\t\u0005\n\u0005{d%\u0019!C\u0001\u0005\u007f\fQbY8se\u0016d\u0017\r^5p]&#WCAB\u0001!\rQ71A\u0005\u0004\u0007\u000bY'!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005\u0004\n1\u0003\u000b\u0011BB\u0001\u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002B\u0011b!\u0004M\u0005\u0004%\taa\u0004\u0002'\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3\u0016\u0005\rE\u0001c\u0001\u0015\u0004\u0014%\u0011Q%\u000b\u0005\t\u0007/a\u0005\u0015!\u0003\u0004\u0012\u0005!\"M]8lKJlU\r^1Qe>\u00048OR5mK\u0002B\u0011ba\u0007M\u0005\u0004%\ta!\b\u00023\t\u0014xn[3s\u001b\u0016$\u0018\rZ1uC\u000eCWmY6q_&tGo]\u000b\u0003\u0007?\u0001ra!\t\u0004,\u0001\u001ai#\u0004\u0002\u0004$)!1QEB\u0014\u0003%IW.\\;uC\ndWMC\u0002\u0004*9\t!bY8mY\u0016\u001cG/[8o\u0013\ry21\u0005\t\u0004\u0011\r=\u0012bAB\u0019\u0005\tA\"I]8lKJlU\r^1eCR\f7\t[3dWB|\u0017N\u001c;\t\u0011\rUB\n)A\u0005\u0007?\t!D\u0019:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00115fG.\u0004x.\u001b8ug\u0002Bqa!\u000fM\t\u0003\u0019Y$A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005-\u0001bBB \u0019\u0012%1\u0011I\u0001\u0007S:LGOW6\u0015\u0005\t%\bbBB#\u0019\u0012%11H\u0001\u000ee\u0016<\u0017n\u001d;feN#\u0018\r^:\t\u000f\r%C\n\"\u0003\u0004<\u0005\u00112m\u001c8ue>dG.\u001a3TQV$Hm\\<o\u0011\u001d\u0019i\u0005\u0014C\u0001\u0007w\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0007#bE\u0011AB\u001e\u00035\tw/Y5u'\",H\u000fZ8x]\"91Q\u000b'\u0005\u0002\r]\u0013!D4fi2{w-T1oC\u001e,'\u000f\u0006\u0002\u0003\f!911\f'\u0005\u0002\ru\u0013!\u00032pk:$\u0007k\u001c:u)\u0011\u0019yf!\u001a\u0011\u00075\u0019\t'C\u0002\u0004d9\u00111!\u00138u\u0011)\u00199g!\u0017\u0011\u0002\u0003\u00071\u0011N\u0001\taJ|Go\\2pYB!11NB8\u001b\t\u0019iG\u0003\u0003\u0004h\u0005U\u0012\u0002BB9\u0007[\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000f\rUD\n\"\u0003\u0004x\u0005\u00012M]3bi\u0016dunZ'b]\u0006<WM\u001d\u000b\u0007\u0005\u0017\u0019Ih!$\t\u0011\rm41\u000fa\u0001\u0007{\n\u0001B_6DY&,g\u000e\u001e\t\u0005\u0007\u007f\u001aI)\u0004\u0002\u0004\u0002*!11QBC\u0003!Q8n\u00197jK:$(\u0002BBD\u0003\u007f\ta!\u0013\u0019Ji\u0016\u001c\u0017\u0002BBF\u0007\u0003\u0013\u0001BW6DY&,g\u000e\u001e\u0005\t\u0003\u000b\u001b\u0019\b1\u0001\u0002\n\"91\u0011\u0013'\u0005\n\rM\u0015aC4fi\n\u0013xn[3s\u0013\u0012,\"aa\u0018\t\u000f\r]E\n\"\u0003\u0004\u001a\u0006\u00112\r[3dWB|\u0017N\u001c;Ce>\\WM]%e)\u0011\tYaa'\t\u0011\ru5Q\u0013a\u0001\u0007?\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0007CcE\u0011BBJ\u0003A9WM\\3sCR,'I]8lKJLE\rC\u0005\u0004&2\u000b\n\u0011\"\u0001\u0004(\u0006\u0019\"m\\;oIB{'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\u0016\u0016\u0004\u0007Sb\u0004")
public class KafkaServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final AtomicBoolean startupComplete;
    private final AtomicBoolean isShuttingDown;
    private final AtomicBoolean isStartingUp;
    private CountDownLatch shutdownLatch;
    private final String jmxPrefix;
    private final java.util.List<MetricsReporter> reporters;
    private final org.apache.kafka.common.utils.Time kafkaMetricsTime;
    private Metrics metrics;
    private final MetricConfig metricConfig;
    private final BrokerState brokerState;
    private KafkaApis apis;
    private Option<Authorizer> authorizer;
    private SocketServer socketServer;
    private KafkaRequestHandlerPool requestHandlerPool;
    private LogManager logManager;
    private ReplicaManager replicaManager;
    private scala.collection.immutable.Map<String, ConfigHandler> dynamicConfigHandlers;
    private DynamicConfigManager dynamicConfigManager;
    private GroupCoordinator groupCoordinator;
    private KafkaController kafkaController;
    private final KafkaScheduler kafkaScheduler;
    private KafkaHealthcheck kafkaHealthcheck;
    private final MetadataCache metadataCache;
    private ZkUtils zkUtils;
    private final AtomicInteger correlationId;
    private final String brokerMetaPropsFile;
    private final scala.collection.immutable.Map<String, BrokerMetadataCheckpoint> brokerMetadataCheckpoints;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Time $lessinit$greater$default$2() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaServer kafkaServer = this;
        synchronized (kafkaServer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    private AtomicBoolean startupComplete() {
        return this.startupComplete;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    private AtomicBoolean isStartingUp() {
        return this.isStartingUp;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch x$1) {
        this.shutdownLatch = x$1;
    }

    private String jmxPrefix() {
        return this.jmxPrefix;
    }

    private java.util.List<MetricsReporter> reporters() {
        return this.reporters;
    }

    private org.apache.kafka.common.utils.Time kafkaMetricsTime() {
        return this.kafkaMetricsTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private MetricConfig metricConfig() {
        return this.metricConfig;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    public void apis_$eq(KafkaApis x$1) {
        this.apis = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public KafkaRequestHandlerPool requestHandlerPool() {
        return this.requestHandlerPool;
    }

    public void requestHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.requestHandlerPool = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public scala.collection.immutable.Map<String, ConfigHandler> dynamicConfigHandlers() {
        return this.dynamicConfigHandlers;
    }

    public void dynamicConfigHandlers_$eq(scala.collection.immutable.Map<String, ConfigHandler> x$1) {
        this.dynamicConfigHandlers = x$1;
    }

    public DynamicConfigManager dynamicConfigManager() {
        return this.dynamicConfigManager;
    }

    public void dynamicConfigManager_$eq(DynamicConfigManager x$1) {
        this.dynamicConfigManager = x$1;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public KafkaScheduler kafkaScheduler() {
        return this.kafkaScheduler;
    }

    public KafkaHealthcheck kafkaHealthcheck() {
        return this.kafkaHealthcheck;
    }

    public void kafkaHealthcheck_$eq(KafkaHealthcheck x$1) {
        this.kafkaHealthcheck = x$1;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public scala.collection.immutable.Map<String, BrokerMetadataCheckpoint> brokerMetadataCheckpoints() {
        return this.brokerMetadataCheckpoints;
    }

    public void startup() {
        try {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "starting";
                }
            });
            if (this.isShuttingDown().get()) {
                throw new IllegalStateException("Kafka server is still shutting down, cannot re-start!");
            }
            if (this.startupComplete().get()) {
                return;
            }
            boolean canStartup = this.isStartingUp().compareAndSet(false, true);
            if (canStartup) {
                this.metrics_$eq(new Metrics(this.metricConfig(), this.reporters(), this.kafkaMetricsTime(), true));
                this.brokerState().newState(Starting$.MODULE$);
                this.kafkaScheduler().startup();
                this.zkUtils_$eq(this.initZk());
                this.logManager_$eq(this.createLogManager(this.zkUtils().zkClient(), this.brokerState()));
                this.logManager().startup();
                this.config().brokerId_$eq(this.getBrokerId());
                this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Server ").append((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())).append((Object)"], ").toString());
                this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.kafkaMetricsTime()));
                this.socketServer().startup();
                this.replicaManager_$eq(new ReplicaManager(this.config(), this.metrics(), this.time, this.kafkaMetricsTime(), this.zkUtils(), this.kafkaScheduler(), this.logManager(), this.isShuttingDown(), ReplicaManager$.MODULE$.$lessinit$greater$default$9()));
                this.replicaManager().startup();
                this.kafkaController_$eq(new KafkaController(this.config(), this.zkUtils(), this.brokerState(), this.kafkaMetricsTime(), this.metrics(), this.threadNamePrefix));
                this.kafkaController().startup();
                this.groupCoordinator_$eq(GroupCoordinator$.MODULE$.apply(this.config(), this.zkUtils(), this.replicaManager(), this.kafkaMetricsTime()));
                this.groupCoordinator().startup();
                this.authorizer_$eq((Option<Authorizer>)Option$.MODULE$.apply((Object)this.config().authorizerClassName()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public final Authorizer apply(String authorizerClassName) {
                        void var2_2;
                        Authorizer authZ = (Authorizer)CoreUtils$.MODULE$.createObject(authorizerClassName, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]));
                        authZ.configure(this.$outer.config().originals());
                        return var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.apis_$eq(new KafkaApis(this.socketServer().requestChannel(), this.replicaManager(), this.groupCoordinator(), this.kafkaController(), this.zkUtils(), this.config().brokerId(), this.config(), this.metadataCache(), this.metrics(), this.authorizer()));
                this.requestHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().brokerId(), this.socketServer().requestChannel(), this.apis(), Predef$.MODULE$.Integer2int(this.config().numIoThreads())));
                this.brokerState().newState(RunningAsBroker$.MODULE$);
                Mx4jLoader$.MODULE$.maybeLoad();
                this.dynamicConfigHandlers_$eq((scala.collection.immutable.Map<String, ConfigHandler>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)new TopicConfigHandler(this.logManager(), this.config())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ConfigType$.MODULE$.Client()), (Object)new ClientIdConfigHandler(this.apis().quotaManagers()))}))));
                AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply(Tuple2<String, Properties> x0$1) {
                        Tuple2<String, Properties> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String clientId = (String)tuple2._1();
                            Properties properties = (Properties)tuple2._2();
                            ((ConfigHandler)this.$outer.dynamicConfigHandlers().apply((Object)ConfigType$.MODULE$.Client())).processConfigChanges(clientId, properties);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.dynamicConfigManager_$eq(new DynamicConfigManager(this.zkUtils(), (Map<String, ConfigHandler>)this.dynamicConfigHandlers(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4()));
                this.dynamicConfigManager().startup();
                scala.collection.immutable.Map listeners = (scala.collection.immutable.Map)this.config().advertisedListeners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final Tuple2<SecurityProtocol, EndPoint> apply(Tuple2<SecurityProtocol, EndPoint> x0$2) {
                        Tuple2<SecurityProtocol, EndPoint> tuple2 = x0$2;
                        if (tuple2 != null) {
                            SecurityProtocol protocol = (SecurityProtocol)((Object)tuple2._1());
                            EndPoint endpoint = (EndPoint)tuple2._2();
                            Tuple2 tuple22 = endpoint.port() == 0 ? new Tuple2((Object)((Object)protocol), (Object)new EndPoint(endpoint.host(), this.$outer.socketServer().boundPort(protocol), endpoint.protocolType())) : new Tuple2((Object)((Object)protocol), (Object)endpoint);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                this.kafkaHealthcheck_$eq(new KafkaHealthcheck(this.config().brokerId(), (scala.collection.immutable.Map<SecurityProtocol, EndPoint>)listeners, this.zkUtils(), this.config().rack(), this.config().interBrokerProtocolVersion()));
                this.kafkaHealthcheck().startup();
                this.checkpointBrokerId(this.config().brokerId());
                this.registerStats();
                this.shutdownLatch_$eq(new CountDownLatch(1));
                this.startupComplete().set(true);
                this.isStartingUp().set(false);
                AppInfoParser.registerAppInfo(this.jmxPrefix(), ((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())).toString());
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "started";
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fatal error during KafkaServer startup. Prepare to shutdown";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            this.isStartingUp().set(false);
            this.shutdown();
            throw throwable;
        }
    }

    private ZkUtils initZk() {
        boolean secureAclsEnabled;
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Connecting to zookeeper on ").append((Object)this.$outer.config().zkConnect()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String chroot = this.config().zkConnect().indexOf("/") > 0 ? this.config().zkConnect().substring(this.config().zkConnect().indexOf("/")) : "";
        boolean bl = secureAclsEnabled = JaasUtils.isZkSecurityEnabled() && this.config().zkEnableSecureAcls();
        if (this.config().zkEnableSecureAcls() && !secureAclsEnabled) {
            throw new SecurityException("zkEnableSecureAcls is true, but the verification of the JAAS login file failed.");
        }
        if (chroot.length() > 1) {
            String zkConnForChrootCreation = this.config().zkConnect().substring(0, this.config().zkConnect().indexOf("/"));
            ZkUtils zkClientForChrootCreation = ZkUtils$.MODULE$.apply(zkConnForChrootCreation, this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), secureAclsEnabled);
            zkClientForChrootCreation.makeSurePersistentPathExists(chroot, zkClientForChrootCreation.makeSurePersistentPathExists$default$2());
            this.info((Function0<String>)new Serializable(this, chroot){
                public static final long serialVersionUID = 0L;
                private final String chroot$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created zookeeper path ").append((Object)this.chroot$1).toString();
                }
                {
                    this.chroot$1 = chroot$1;
                }
            });
            zkClientForChrootCreation.zkClient().close();
        }
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.config().zkConnect(), this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), secureAclsEnabled);
        zkUtils.setupCommonPaths();
        return zkUtils;
    }

    private void registerStats() {
        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats();
        ControllerStats$.MODULE$.uncleanLeaderElectionRate();
        ControllerStats$.MODULE$.leaderElectionTimer();
    }

    public void kafka$server$KafkaServer$$controlledShutdown() {
        int socketTimeoutMs = this.config().controllerSocketTimeoutMs();
        if (this.startupComplete().get() && Predef$.MODULE$.Boolean2boolean(this.config().controlledShutdownEnable())) {
            boolean shutdownSucceeded;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting controlled shutdown";
                }
            });
            this.brokerState().newState(PendingControlledShutdown$.MODULE$);
            boolean bl = shutdownSucceeded = this.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? this.networkClientControlledShutdown$1(this.config().controlledShutdownMaxRetries(), socketTimeoutMs) : this.blockingChannelControlledShutdown$1(this.config().controlledShutdownMaxRetries());
            if (!shutdownSucceeded) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Proceeding to do an unclean shutdown as all the controlled shutdown attempts failed";
                    }
                });
            }
        }
    }

    public void shutdown() {
        try {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "shutting down";
                }
            });
            if (this.isStartingUp().get()) {
                throw new IllegalStateException("Kafka server is still starting up, cannot shut down!");
            }
            boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
            if (canShutdown && this.shutdownLatch().getCount() > 0L) {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$server$KafkaServer$$controlledShutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.brokerState().newState(BrokerShuttingDown$.MODULE$);
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.socketServer().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.requestHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.requestHandlerPool().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafkaScheduler().shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.apis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.apis().close();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.authorizer().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Authorizer x$2) {
                                x$2.close();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.replicaManager() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            ReplicaManager qual$1 = this.$outer.replicaManager();
                            boolean x$4 = qual$1.shutdown$default$1();
                            qual$1.shutdown(x$4);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.logManager() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.logManager().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.groupCoordinator() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.groupCoordinator().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.kafkaController() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.kafkaController().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.zkUtils() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.zkUtils().close();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                if (this.metrics() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.metrics().close();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                this.brokerState().newState(NotRunning$.MODULE$);
                this.startupComplete().set(false);
                this.isShuttingDown().set(false);
                AppInfoParser.unregisterAppInfo(this.jmxPrefix(), ((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())).toString());
                this.shutdownLatch().countDown();
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "shut down completed";
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fatal error during KafkaServer shutdown.";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            this.isShuttingDown().set(false);
            throw throwable;
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public LogManager getLogManager() {
        return this.logManager();
    }

    public int boundPort(SecurityProtocol protocol) {
        return this.socketServer().boundPort(protocol);
    }

    public SecurityProtocol boundPort$default$1() {
        return SecurityProtocol.PLAINTEXT;
    }

    private LogManager createLogManager(ZkClient zkClient, BrokerState brokerState) {
        java.util.Map<String, Object> defaultProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config());
        LogConfig defaultLogConfig = new LogConfig((java.util.Map<?, ?>)defaultProps);
        Map configs = (Map)AdminUtils$.MODULE$.fetchAllTopicConfigs(this.zkUtils()).map((Function1)new Serializable(this, defaultProps){
            public static final long serialVersionUID = 0L;
            private final java.util.Map defaultProps$1;

            public final Tuple2<String, LogConfig> apply(Tuple2<String, Properties> x0$3) {
                Tuple2<String, Properties> tuple2 = x0$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Properties configs = (Properties)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)LogConfig$.MODULE$.fromProps(this.defaultProps$1, configs));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.defaultProps$1 = defaultProps$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        CleanerConfig cleanerConfig = new CleanerConfig(Predef$.MODULE$.Integer2int(this.config().logCleanerThreads()), Predef$.MODULE$.Long2long(this.config().logCleanerDedupeBufferSize()), Predef$.MODULE$.Double2double(this.config().logCleanerDedupeBufferLoadFactor()), Predef$.MODULE$.Integer2int(this.config().logCleanerIoBufferSize()), Predef$.MODULE$.Integer2int(this.config().messageMaxBytes()), Predef$.MODULE$.Double2double(this.config().logCleanerIoMaxBytesPerSecond()), Predef$.MODULE$.Long2long(this.config().logCleanerBackoffMs()), Predef$.MODULE$.Boolean2boolean(this.config().logCleanerEnable()), CleanerConfig$.MODULE$.apply$default$9());
        return new LogManager((File[])((TraversableOnce)this.config().logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), (Map<String, LogConfig>)configs, defaultLogConfig, cleanerConfig, Predef$.MODULE$.Integer2int(this.config().numRecoveryThreadsPerDataDir()), Predef$.MODULE$.Long2long(this.config().logFlushSchedulerIntervalMs()), this.config().logFlushOffsetCheckpointIntervalMs(), Predef$.MODULE$.Long2long(this.config().logCleanupIntervalMs()), this.kafkaScheduler(), brokerState, this.time);
    }

    /*
     * WARNING - void declaration
     */
    private int getBrokerId() {
        void var1_1;
        int brokerId = this.config().brokerId();
        HashSet brokerIdSet = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.config().logDirs().foreach((Function1)new Serializable(this, brokerIdSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServer $outer;
            public final HashSet brokerIdSet$1;

            public final void apply(String logDir) {
                Option<BrokerMetadata> brokerMetadataOpt = ((BrokerMetadataCheckpoint)this.$outer.brokerMetadataCheckpoints().apply((Object)logDir)).read();
                brokerMetadataOpt.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getBrokerId$1 $outer;

                    public final boolean apply(BrokerMetadata brokerMetadata) {
                        return this.$outer.brokerIdSet$1.add((Object)BoxesRunTime.boxToInteger((int)brokerMetadata.brokerId()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.brokerIdSet$1 = brokerIdSet$1;
            }
        });
        if (brokerIdSet.size() > 1) {
            throw new InconsistentBrokerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to match broker.id across log.dirs. This could happen if multiple brokers shared a log directory (log.dirs) "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or partial data was manually copied from another broker. Found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerIdSet}))).toString());
        }
        if (brokerId >= 0 && brokerIdSet.size() == 1 && BoxesRunTime.unboxToInt((Object)brokerIdSet.last()) != brokerId) {
            throw new InconsistentBrokerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configured broker.id ", " doesn't match stored broker.id ", " in meta.properties. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), brokerIdSet.last()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"If you moved your data, make sure your configured broker.id matches. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"If you intend to create a new broker, you should remove all data in your data directories (log.dirs)."})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (brokerIdSet.size() == 0 && brokerId < 0 && this.config().brokerIdGenerationEnable()) {
            brokerId = this.generateBrokerId();
        } else if (brokerIdSet.size() == 1) {
            brokerId = BoxesRunTime.unboxToInt((Object)brokerIdSet.last());
        }
        return (int)var1_1;
    }

    private void checkpointBrokerId(int brokerId) {
        ObjectRef logDirsWithoutMetaProps = new ObjectRef((Object)Nil$.MODULE$);
        this.config().logDirs().foreach((Function1)new Serializable(this, logDirsWithoutMetaProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServer $outer;
            private final ObjectRef logDirsWithoutMetaProps$1;

            public final void apply(String logDir) {
                Option<BrokerMetadata> brokerMetadataOpt = ((BrokerMetadataCheckpoint)this.$outer.brokerMetadataCheckpoints().apply((Object)logDir)).read();
                if (brokerMetadataOpt.isEmpty()) {
                    this.logDirsWithoutMetaProps$1.elem = (List)((List)this.logDirsWithoutMetaProps$1.elem).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{logDir})), List$.MODULE$.canBuildFrom());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.logDirsWithoutMetaProps$1 = logDirsWithoutMetaProps$1;
            }
        });
        ((List)logDirsWithoutMetaProps.elem).foreach((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServer $outer;
            private final int brokerId$1;

            public final void apply(String logDir) {
                BrokerMetadataCheckpoint checkpoint = (BrokerMetadataCheckpoint)this.$outer.brokerMetadataCheckpoints().apply((Object)logDir);
                checkpoint.write(new BrokerMetadata(this.brokerId$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
            }
        });
    }

    private int generateBrokerId() {
        try {
            return this.zkUtils().getBrokerSequenceId(this.config().maxReservedBrokerId());
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to generate broker.id due to ";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$3;

                public final Exception apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            });
            throw new GenerateBrokerIdException("Failed to generate broker.id", exception);
        }
    }

    private final Node node$1(Broker broker) {
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(this.config().interBrokerSecurityProtocol());
        return new Node(brokerEndPoint.id(), brokerEndPoint.host(), brokerEndPoint.port());
    }

    /*
     * Exception decompiling
     */
    private final boolean networkClientControlledShutdown$1(int retries, int socketTimeoutMs$1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [0 : 439->711)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final boolean blockingChannelControlledShutdown$1(int retries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [0 : 281->419)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KafkaServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.startupComplete = new AtomicBoolean(false);
        this.isShuttingDown = new AtomicBoolean(false);
        this.isStartingUp = new AtomicBoolean(false);
        this.shutdownLatch = new CountDownLatch(1);
        this.jmxPrefix = "kafka.server";
        this.reporters = config.metricReporterClasses();
        this.reporters().add(new JmxReporter(this.jmxPrefix()));
        this.kafkaMetricsTime = new SystemTime();
        this.metrics = null;
        this.metricConfig = new MetricConfig().samples(Predef$.MODULE$.Integer2int(config.metricNumSamples())).timeWindow(Predef$.MODULE$.Long2long(config.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
        this.brokerState = new BrokerState();
        this.apis = null;
        this.authorizer = None$.MODULE$;
        this.socketServer = null;
        this.requestHandlerPool = null;
        this.logManager = null;
        this.replicaManager = null;
        this.dynamicConfigHandlers = null;
        this.dynamicConfigManager = null;
        this.groupCoordinator = null;
        this.kafkaController = null;
        this.kafkaScheduler = new KafkaScheduler(Predef$.MODULE$.Integer2int(config.backgroundThreads()), KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.kafkaHealthcheck = null;
        this.metadataCache = new MetadataCache(config.brokerId());
        this.zkUtils = null;
        this.correlationId = new AtomicInteger(0);
        this.brokerMetaPropsFile = "meta.properties";
        this.brokerMetadataCheckpoints = ((TraversableOnce)config.logDirs().map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.newGauge("BrokerState", new Gauge<Object>(this){
            private final /* synthetic */ KafkaServer $outer;

            public int value() {
                return this.$outer.brokerState().currentState();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("yammer-metrics-count", new Gauge<Object>(this){

            public int value() {
                return com.yammer.metrics.Metrics.defaultRegistry().allMetrics().size();
            }
        }, this.newGauge$default$3());
    }
}

