/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.TestingV2Source;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsPushDownV2Filters;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.junit.jupiter.api.Assertions;
import test.org.apache.spark.sql.connector.JavaRangeInputPartition;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;

public class JavaAdvancedDataSourceV2WithV2Filter
implements TestingV2Source {
    @Override
    public Table getTable(CaseInsensitiveStringMap options) {
        return new JavaSimpleBatchTable(){

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
                return new AdvancedScanBuilderWithV2Filter();
            }
        };
    }

    static class AdvancedReaderFactoryWithV2Filter
    implements PartitionReaderFactory {
        StructType requiredSchema;

        AdvancedReaderFactoryWithV2Filter(StructType requiredSchema) {
            this.requiredSchema = requiredSchema;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            final JavaRangeInputPartition p = (JavaRangeInputPartition)partition;
            return new PartitionReader<InternalRow>(){
                private int current;
                {
                    this.current = p.start - 1;
                }

                public boolean next() throws IOException {
                    ++this.current;
                    return this.current < p.end;
                }

                public InternalRow get() {
                    Object[] values = new Object[requiredSchema.size()];
                    for (int i = 0; i < values.length; ++i) {
                        if ("i".equals(requiredSchema.apply(i).name())) {
                            values[i] = this.current;
                            continue;
                        }
                        if (!"j".equals(requiredSchema.apply(i).name())) continue;
                        values[i] = -this.current;
                    }
                    return new GenericInternalRow(values);
                }

                public void close() throws IOException {
                }
            };
        }
    }

    public static class AdvancedBatchWithV2Filter
    implements Batch {
        public StructType requiredSchema;
        public Predicate[] predicates;

        AdvancedBatchWithV2Filter(StructType requiredSchema, Predicate[] predicates) {
            this.requiredSchema = requiredSchema;
            this.predicates = predicates;
        }

        public InputPartition[] planInputPartitions() {
            ArrayList<JavaRangeInputPartition> res = new ArrayList<JavaRangeInputPartition>();
            Integer lowerBound = null;
            for (Predicate predicate : this.predicates) {
                Integer integer;
                Object object;
                if (!predicate.name().equals(">")) continue;
                Assertions.assertInstanceOf(FieldReference.class, (Object)predicate.children()[0]);
                FieldReference column = (FieldReference)predicate.children()[0];
                Assertions.assertInstanceOf(LiteralValue.class, (Object)predicate.children()[1]);
                Literal value = (Literal)predicate.children()[1];
                if (!"i".equals(column.describe()) || !((object = value.value()) instanceof Integer)) continue;
                lowerBound = integer = (Integer)object;
                break;
            }
            if (lowerBound == null) {
                res.add(new JavaRangeInputPartition(0, 5));
                res.add(new JavaRangeInputPartition(5, 10));
            } else if (lowerBound < 4) {
                res.add(new JavaRangeInputPartition(lowerBound + 1, 5));
                res.add(new JavaRangeInputPartition(5, 10));
            } else if (lowerBound < 9) {
                res.add(new JavaRangeInputPartition(lowerBound + 1, 10));
            }
            return (InputPartition[])res.stream().toArray(InputPartition[]::new);
        }

        public PartitionReaderFactory createReaderFactory() {
            return new AdvancedReaderFactoryWithV2Filter(this.requiredSchema);
        }
    }

    static class AdvancedScanBuilderWithV2Filter
    implements ScanBuilder,
    Scan,
    SupportsPushDownV2Filters,
    SupportsPushDownRequiredColumns {
        private StructType requiredSchema = TestingV2Source.schema();
        private Predicate[] predicates = new Predicate[0];

        AdvancedScanBuilderWithV2Filter() {
        }

        public void pruneColumns(StructType requiredSchema) {
            this.requiredSchema = requiredSchema;
        }

        public StructType readSchema() {
            return this.requiredSchema;
        }

        public Predicate[] pushPredicates(Predicate[] predicates) {
            Predicate[] supported = (Predicate[])Arrays.stream(predicates).filter(f -> {
                if (f.name().equals(">")) {
                    Assertions.assertInstanceOf(FieldReference.class, (Object)f.children()[0]);
                    FieldReference column = (FieldReference)f.children()[0];
                    Assertions.assertInstanceOf(LiteralValue.class, (Object)f.children()[1]);
                    Literal value = (Literal)f.children()[1];
                    return column.describe().equals("i") && value.value() instanceof Integer;
                }
                return false;
            }).toArray(Predicate[]::new);
            Predicate[] unsupported = (Predicate[])Arrays.stream(predicates).filter(f -> {
                if (f.name().equals(">")) {
                    Assertions.assertInstanceOf(FieldReference.class, (Object)f.children()[0]);
                    FieldReference column = (FieldReference)f.children()[0];
                    Assertions.assertInstanceOf(LiteralValue.class, (Object)f.children()[1]);
                    LiteralValue value = (LiteralValue)f.children()[1];
                    return !column.describe().equals("i") || !(value.value() instanceof Integer);
                }
                return true;
            }).toArray(Predicate[]::new);
            this.predicates = supported;
            return unsupported;
        }

        public Predicate[] pushedPredicates() {
            return this.predicates;
        }

        public Scan build() {
            return this;
        }

        public Batch toBatch() {
            return new AdvancedBatchWithV2Filter(this.requiredSchema, this.predicates);
        }
    }
}

