/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.util.ArrayList;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.streaming.ExpiredTimerInfo;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StatefulProcessorWithInitialState;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.TimerValues;
import org.apache.spark.sql.streaming.ValueState;
import org.junit.jupiter.api.Assertions;
import scala.collection.Iterator;
import scala.jdk.javaapi.CollectionConverters;

public class TestStatefulProcessorWithInitialState
extends StatefulProcessorWithInitialState<Integer, String, String, String> {
    private transient ValueState<String> testState;

    public void init(OutputMode outputMode, TimeMode timeMode) {
        this.testState = this.getHandle().getValueState("testState", Encoders.STRING());
    }

    public void handleInitialState(Integer key, String initialState, TimerValues timerValues) {
        this.testState.update((Object)initialState);
    }

    public Iterator<String> handleInputRows(Integer key, Iterator<String> rows, TimerValues timerValues, ExpiredTimerInfo expiredTimerInfo) {
        ArrayList<String> result = new ArrayList<String>();
        if (!expiredTimerInfo.isValid()) {
            String existingValue = "";
            if (this.testState.exists()) {
                existingValue = (String)this.testState.get();
            }
            StringBuilder sb = new StringBuilder(key.toString());
            if (!existingValue.isEmpty()) {
                sb.append(existingValue);
            }
            while (rows.hasNext()) {
                sb.append((String)rows.next());
            }
            this.testState.clear();
            Assertions.assertFalse((boolean)this.testState.exists());
            result.add(sb.toString());
        }
        return CollectionConverters.asScala(result).iterator();
    }
}

