/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.util.ArrayList;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.streaming.ExpiredTimerInfo;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StatefulProcessor;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.TimerValues;
import org.apache.spark.sql.streaming.ValueState;
import org.junit.jupiter.api.Assertions;
import scala.collection.Iterator;
import scala.jdk.javaapi.CollectionConverters;

public class TestStatefulProcessor
extends StatefulProcessor<Integer, String, String> {
    private transient ValueState<Long> countState;
    private transient MapState<String, Long> keyCountMap;
    private transient ListState<String> keysList;

    public void init(OutputMode outputMode, TimeMode timeMode) {
        this.countState = this.getHandle().getValueState("countState", Encoders.LONG());
        this.keyCountMap = this.getHandle().getMapState("keyCountMap", Encoders.STRING(), Encoders.LONG());
        this.keysList = this.getHandle().getListState("keyList", Encoders.STRING());
    }

    public Iterator<String> handleInputRows(Integer key, Iterator<String> rows, TimerValues timerValues, ExpiredTimerInfo expiredTimerInfo) {
        ArrayList<String> result = new ArrayList<String>();
        if (!expiredTimerInfo.isValid()) {
            long count = 0L;
            if (this.countState.exists()) {
                count = (Long)this.countState.get();
            }
            long numRows = 0L;
            StringBuilder sb = new StringBuilder(key.toString());
            while (rows.hasNext()) {
                ++numRows;
                String value = (String)rows.next();
                if (this.keyCountMap.containsKey((Object)value)) {
                    this.keyCountMap.updateValue((Object)value, (Object)((Long)this.keyCountMap.getValue((Object)value) + 1L));
                } else {
                    this.keyCountMap.updateValue((Object)value, (Object)1L);
                }
                Assertions.assertTrue((boolean)this.keyCountMap.containsKey((Object)value));
                this.keysList.appendValue((Object)value);
                sb.append(value);
            }
            Iterator keys = this.keysList.get();
            while (keys.hasNext()) {
                String keyVal = (String)keys.next();
                Assertions.assertTrue((boolean)this.keyCountMap.containsKey((Object)keyVal));
                Assertions.assertTrue(((Long)this.keyCountMap.getValue((Object)keyVal) > 0L ? 1 : 0) != 0);
            }
            this.countState.update((Object)(count += numRows));
            Assertions.assertEquals((long)count, (long)((Long)this.countState.get()));
            result.add(sb.toString());
        }
        return CollectionConverters.asScala(result).iterator();
    }
}

