/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaDataFrameWriterV2Suite {
    private static StructType schema = new StructType().add("s", "string");
    private SparkSession spark = null;

    public Dataset<Row> df() {
        return this.spark.read().schema(schema).text(new String[0]);
    }

    @BeforeEach
    public void createTestTable() {
        this.spark = new TestSparkSession();
        this.spark.conf().set("spark.sql.catalog.testcat", InMemoryTableCatalog.class.getName());
        this.spark.sql("CREATE TABLE testcat.t (s string) USING foo");
    }

    @AfterEach
    public void dropTestTable() {
        this.spark.sql("DROP TABLE testcat.t");
        this.spark.stop();
    }

    @Test
    public void testAppendAPI() throws NoSuchTableException {
        this.df().writeTo("testcat.t").append();
        this.df().writeTo("testcat.t").option("property", "value").append();
    }

    @Test
    public void testOverwritePartitionsAPI() throws NoSuchTableException {
        this.df().writeTo("testcat.t").overwritePartitions();
        this.df().writeTo("testcat.t").option("property", "value").overwritePartitions();
    }

    @Test
    public void testOverwriteAPI() throws NoSuchTableException {
        this.df().writeTo("testcat.t").overwrite(functions.lit((Object)true));
        this.df().writeTo("testcat.t").option("property", "value").overwrite(functions.lit((Object)true));
    }

    @Test
    public void testCreateAPI() throws TableAlreadyExistsException {
        this.df().writeTo("testcat.t2").create();
        this.spark.sql("DROP TABLE testcat.t2");
        this.df().writeTo("testcat.t2").option("property", "value").create();
        this.spark.sql("DROP TABLE testcat.t2");
        this.df().writeTo("testcat.t2").tableProperty("property", "value").create();
        this.spark.sql("DROP TABLE testcat.t2");
        this.df().writeTo("testcat.t2").using("v2format").create();
        this.spark.sql("DROP TABLE testcat.t2");
        this.df().writeTo("testcat.t2").partitionedBy(functions.col((String)"s"), new Column[0]).create();
        this.spark.sql("DROP TABLE testcat.t2");
    }

    @Test
    public void testReplaceAPI() throws CannotReplaceMissingTableException {
        this.df().writeTo("testcat.t").replace();
        this.df().writeTo("testcat.t").option("property", "value").replace();
        this.df().writeTo("testcat.t").tableProperty("property", "value").replace();
        this.df().writeTo("testcat.t").using("v2format").replace();
        this.df().writeTo("testcat.t").partitionedBy(functions.col((String)"s"), new Column[0]).replace();
    }

    @Test
    public void testCreateOrReplaceAPI() {
        this.df().writeTo("testcat.t").createOrReplace();
        this.df().writeTo("testcat.t").option("property", "value").createOrReplace();
        this.df().writeTo("testcat.t").tableProperty("property", "value").createOrReplace();
        this.df().writeTo("testcat.t").using("v2format").createOrReplace();
        this.df().writeTo("testcat.t").partitionedBy(functions.col((String)"s"), new Column[0]).createOrReplace();
    }
}

