/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaApplySchemaSuite
implements Serializable {
    private transient SparkSession spark;
    private transient JavaSparkContext jsc;

    @BeforeEach
    public void setUp() {
        this.spark = SparkSession.builder().master("local[*]").appName("testing").getOrCreate();
        this.jsc = new JavaSparkContext(this.spark.sparkContext());
    }

    @AfterEach
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void applySchema() {
        ArrayList<Person> personList = new ArrayList<Person>(2);
        Person person1 = new Person();
        person1.setName("Michael");
        person1.setAge(29);
        personList.add(person1);
        Person person2 = new Person();
        person2.setName("Yin");
        person2.setAge(28);
        personList.add(person2);
        JavaRDD rowRDD = this.jsc.parallelize(personList).map((Function & Serializable)person -> RowFactory.create((Object[])new Object[]{person.getName(), person.getAge()}));
        ArrayList<StructField> fields = new ArrayList<StructField>(2);
        fields.add(DataTypes.createStructField((String)"name", (DataType)DataTypes.StringType, (boolean)false));
        fields.add(DataTypes.createStructField((String)"age", (DataType)DataTypes.IntegerType, (boolean)false));
        StructType schema = DataTypes.createStructType(fields);
        Dataset df = this.spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("people");
        List actual = this.spark.sql("SELECT * FROM people").collectAsList();
        ArrayList<Row> expected = new ArrayList<Row>(2);
        expected.add(RowFactory.create((Object[])new Object[]{"Michael", 29}));
        expected.add(RowFactory.create((Object[])new Object[]{"Yin", 28}));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void dataFrameRDDOperations() {
        ArrayList<Person> personList = new ArrayList<Person>(2);
        Person person1 = new Person();
        person1.setName("Michael");
        person1.setAge(29);
        personList.add(person1);
        Person person2 = new Person();
        person2.setName("Yin");
        person2.setAge(28);
        personList.add(person2);
        JavaRDD rowRDD = this.jsc.parallelize(personList).map((Function & Serializable)person -> RowFactory.create((Object[])new Object[]{person.getName(), person.getAge()}));
        ArrayList<StructField> fields = new ArrayList<StructField>(2);
        fields.add(DataTypes.createStructField((String)"", (DataType)DataTypes.StringType, (boolean)false));
        fields.add(DataTypes.createStructField((String)"age", (DataType)DataTypes.IntegerType, (boolean)false));
        StructType schema = DataTypes.createStructType(fields);
        Dataset df = this.spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("people");
        List actual = this.spark.sql("SELECT * FROM people").toJavaRDD().map((Function & Serializable)row -> row.getString(0) + "_" + row.get(1)).collect();
        ArrayList<String> expected = new ArrayList<String>(2);
        expected.add("Michael_29");
        expected.add("Yin_28");
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void applySchemaToJSON() {
        Dataset jsonDS = this.spark.createDataset(Arrays.asList("{\"string\":\"this is a simple string.\", \"integer\":10, \"long\":21474836470, \"bigInteger\":92233720368547758070, \"double\":1.7976931348623157E308, \"boolean\":true, \"null\":null}", "{\"string\":\"this is another simple string.\", \"integer\":11, \"long\":21474836469, \"bigInteger\":92233720368547758069, \"double\":1.7976931348623157E305, \"boolean\":false, \"null\":null}"), Encoders.STRING());
        ArrayList<StructField> fields = new ArrayList<StructField>(7);
        fields.add(DataTypes.createStructField((String)"bigInteger", (DataType)DataTypes.createDecimalType((int)20, (int)0), (boolean)true));
        fields.add(DataTypes.createStructField((String)"boolean", (DataType)DataTypes.BooleanType, (boolean)true));
        fields.add(DataTypes.createStructField((String)"double", (DataType)DataTypes.DoubleType, (boolean)true));
        fields.add(DataTypes.createStructField((String)"integer", (DataType)DataTypes.LongType, (boolean)true));
        fields.add(DataTypes.createStructField((String)"long", (DataType)DataTypes.LongType, (boolean)true));
        fields.add(DataTypes.createStructField((String)"null", (DataType)DataTypes.StringType, (boolean)true));
        fields.add(DataTypes.createStructField((String)"string", (DataType)DataTypes.StringType, (boolean)true));
        StructType expectedSchema = DataTypes.createStructType(fields);
        ArrayList<Row> expectedResult = new ArrayList<Row>(2);
        expectedResult.add(RowFactory.create((Object[])new Object[]{new BigDecimal("92233720368547758070"), true, Double.MAX_VALUE, 10, 0x4FFFFFFF6L, null, "this is a simple string."}));
        expectedResult.add(RowFactory.create((Object[])new Object[]{new BigDecimal("92233720368547758069"), false, 1.7976931348623156E305, 11, 0x4FFFFFFF5L, null, "this is another simple string."}));
        Dataset df1 = this.spark.read().json(jsonDS);
        StructType actualSchema1 = df1.schema();
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema1);
        df1.createOrReplaceTempView("jsonTable1");
        List actual1 = this.spark.sql("select * from jsonTable1").collectAsList();
        Assertions.assertEquals(expectedResult, (Object)actual1);
        Dataset df2 = this.spark.read().schema(expectedSchema).json(jsonDS);
        StructType actualSchema2 = df2.schema();
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema2);
        df2.createOrReplaceTempView("jsonTable2");
        List actual2 = this.spark.sql("select * from jsonTable2").collectAsList();
        Assertions.assertEquals(expectedResult, (Object)actual2);
    }

    public static class Person
    implements Serializable {
        private String name;
        private int age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

