/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import org.apache.spark.sql.streaming.ExpiredTimerInfo;
import org.apache.spark.sql.streaming.RunningCountStatefulProcessor;
import org.apache.spark.sql.streaming.TimerValues;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-3A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00053!)1\b\u0001C!y\ty#+\u001e8oS:<7i\\;oiN#\u0018\r^3gk2\u0004&o\\2fgN|'oV5uQ6+H\u000e^5qY\u0016$\u0016.\\3sg*\u0011aaB\u0001\ngR\u0014X-Y7j]\u001eT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0003\n\u0005Q)!!\b*v]:LgnZ\"pk:$8\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\n\u0001\u0003}A\u0017M\u001c3mKB\u0013xnY3tg&tw\rV5nK\n\u000b7/\u001a3US6,'o\u001d\u000b\u00045Q2\u0004cA\u000e&Q9\u0011AD\t\b\u0003;\u0001j\u0011A\b\u0006\u0003?=\ta\u0001\u0010:p_Rt\u0014\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\"\u0013a\u00029bG.\fw-\u001a\u0006\u0002C%\u0011ae\n\u0002\t\u0013R,'/\u0019;pe*\u00111\u0005\n\t\u0005S)bC&D\u0001%\u0013\tYCE\u0001\u0004UkBdWM\r\t\u0003[Er!AL\u0018\u0011\u0005u!\u0013B\u0001\u0019%\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\"\u0003\"B\u001b\u0003\u0001\u0004a\u0013aA6fs\")qG\u0001a\u0001q\u0005\tR\r\u001f9jef$\u0016.\\3ti\u0006l\u0007/T:\u0011\u0005%J\u0014B\u0001\u001e%\u0005\u0011auN\\4\u0002\u001f!\fg\u000e\u001a7f\u0013:\u0004X\u000f\u001e*poN$RAG\u001f?\u0003\u001aCQ!N\u0002A\u00021BQaP\u0002A\u0002\u0001\u000b\u0011\"\u001b8qkR\u0014vn^:\u0011\u0007m)C\u0006C\u0003C\u0007\u0001\u00071)A\u0006uS6,'OV1mk\u0016\u001c\bC\u0001\nE\u0013\t)UAA\u0006US6,'OV1mk\u0016\u001c\b\"B$\u0004\u0001\u0004A\u0015\u0001E3ya&\u0014X\r\u001a+j[\u0016\u0014\u0018J\u001c4p!\t\u0011\u0012*\u0003\u0002K\u000b\t\u0001R\t\u001f9je\u0016$G+[7fe&sgm\u001c")
public class RunningCountStatefulProcessorWithMultipleTimers
extends RunningCountStatefulProcessor {
    private Iterator<Tuple2<String, String>> handleProcessingTimeBasedTimers(String key, long expiryTimestampMs) {
        long currCount = BoxesRunTime.unboxToLong((Object)this._countState().getOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        if (this.getHandle().listTimers().size() == 1) {
            this._countState().clear();
        }
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)Long.toString(currCount))}));
    }

    @Override
    public Iterator<Tuple2<String, String>> handleInputRows(String key, Iterator<String> inputRows, TimerValues timerValues, ExpiredTimerInfo expiredTimerInfo) {
        block1: {
            if (expiredTimerInfo.isValid()) {
                return this.handleProcessingTimeBasedTimers(key, expiredTimerInfo.getExpiryTimeInMs());
            }
            long currCount = BoxesRunTime.unboxToLong((Object)this._countState().getOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            long count = currCount + (long)inputRows.size();
            this._countState().update((Object)BoxesRunTime.boxToLong((long)count));
            if (!this.getHandle().listTimers().isEmpty()) break block1;
            this.getHandle().registerTimer(timerValues.getCurrentProcessingTimeInMs() + 5000L);
            this.getHandle().registerTimer(timerValues.getCurrentProcessingTimeInMs() + 10000L);
            this.getHandle().registerTimer(timerValues.getCurrentProcessingTimeInMs() + 15000L);
            Predef$.MODULE$.assert(this.getHandle().listTimers().size() == 3);
        }
        return package$.MODULE$.Iterator().empty();
    }
}

