/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.execution.streaming.CleanSourceMode$;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.CountListingLocalFileSystem;
import org.apache.spark.sql.streaming.CountListingLocalFileSystem$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem$;
import org.apache.spark.sql.streaming.FileStreamSourceSuite$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.tags.SlowSQLTest;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@SlowSQLTest
@ScalaSignature(bytes="\u0006\u0005\r\u001da\u0001B\u0015+\u0001UBQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001C\u0002\u0013\u0005c\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\u0006\u0011\u0002!I!\u0013\u0005\b]\u0002\t\n\u0011\"\u0003p\u0011\u0015Q\b\u0001\"\u0003|\u0011!\t\t\u0001AI\u0001\n\u0013y\u0007bBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\u0003\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\n\u0003{\u0003\u0011\u0013!C\u0005\u0003\u007fC\u0011\"a1\u0001#\u0003%I!!2\t\u0013\u0005%\u0007!%A\u0005\n\u0005}\u0006\"CAf\u0001E\u0005I\u0011BAg\r\u0019\t\t\u000e\u0001\u0001\u0002T\"I\u0011Q\u001d\u000b\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0007uQ!\t!a:\t\u000f\u0005=H\u0003\"\u0011\u0002r\"9\u0011Q \u000b\u0005B\u0005}\bb\u0002B\t)\u0011\u0005#1\u0003\u0005\b\u00057!B\u0011\tB\u000f\u0011\u001d\u0011Y\u0003\u0006C!\u0005[AqA!\u0011\u0015\t\u0003\u0012\u0019\u0005C\u0004\u0003zQ!\tEa\u001f\t\u000f\t\rE\u0003\"\u0011\u0003\u0006\"9!Q\u0012\u000b\u0005B\t=\u0005b\u0002BP)\u0011\u0005#\u0011\u0015\u0005\b\u0005O#B\u0011\tBU\u0011\u001d\u0011Y\u000b\u0006C!\u0005[CqA!-\u0001\t\u0013\u0011\u0019\fC\u0004\u0003>\u0002!IAa0\t\u000f\t\u0015\u0007\u0001\"\u0003\u0003H\"9!1\u001b\u0001\u0005\n\tU\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0005U1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWmU;ji\u0016T!a\u000b\u0017\u0002\u0013M$(/Z1nS:<'BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011C\u0001\u00017!\t9\u0004(D\u0001+\u0013\tI$F\u0001\u000bGS2,7\u000b\u001e:fC6\u001cv.\u001e:dKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"a\u000e\u0001\u0002!M$(/Z1nS:<G+[7f_V$X#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u0002;j[\u0016T!\u0001\u0012\u001a\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001$B\u0005\u0011\u0019\u0006/\u00198\u0002#M$(/Z1nS:<G+[7f_V$\b%\u0001\fde\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f)\u0011Q\u0015\u000b\u00192\u0011\u0005-{U\"\u0001'\u000b\u0005-j%B\u0001(-\u0003%)\u00070Z2vi&|g.\u0003\u0002Q\u0019\n\u0001b)\u001b7f'R\u0014X-Y7T_V\u00148-\u001a\u0005\u0006%\u0012\u0001\raU\u0001\u0007M>\u0014X.\u0019;\u0011\u0005QkfBA+\\!\t1\u0016,D\u0001X\u0015\tAF'\u0001\u0004=e>|GO\u0010\u0006\u00025\u0006)1oY1mC&\u0011A,W\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]3\")\u0011\r\u0002a\u0001'\u0006!\u0001/\u0019;i\u0011\u001d\u0019G\u0001%AA\u0002\u0011\faa]2iK6\f\u0007cA3gQ6\t\u0011,\u0003\u0002h3\n1q\n\u001d;j_:\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0017\u0002\u000bQL\b/Z:\n\u00055T'AC*ueV\u001cG\u000fV=qK\u0006\u00013M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005\u0001(F\u00013rW\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003%)hn\u00195fG.,GM\u0003\u0002x3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e$(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00113M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW-\u00118e\u000f\u0016$8k\u00195f[\u0006$B\u0001\u001b?\u007f\u007f\")!K\u0002a\u0001{B\u0019QMZ*\t\u000b\u00054\u0001\u0019A?\t\u000f\r4\u0001\u0013!a\u0001I\u0006a3M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW-\u00118e\u000f\u0016$8k\u00195f[\u0006$C-\u001a4bk2$HeM\u0001\nE\u00164wN]3BY2$\"!a\u0002\u0011\u0007\u0015\fI!C\u0002\u0002\fe\u0013A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG.\u0001\nuKN$H\u000b\u001b:fg\"|G\u000e\u001a'pO&\u001cG\u0003BA\u0004\u0003'Aa!!\u0006\u000b\u0001\u0004\u0019\u0016AB8qi&|g.\u0001\u000fuKN$\u0018J\\2peJ,7\r\u001e+ie\u0016\u001c\bn\u001c7e-\u0006dW/Z:\u0015\t\u0005\u001d\u00111\u0004\u0005\u0007\u0003+Y\u0001\u0019A*\u0002EQ,7\u000f^%h]>\u0014X\r\u00165sKNDw\u000e\u001c3XSRDGK]5hO\u0016\u0014xJ\\2f)\u0011\t9!!\t\t\r\u0005\rB\u00021\u0001T\u0003)y\u0007\u000f^5p]:\u000bW.Z\u0001\u0014e\u0016\fG\rT8h\rJ|WNU3t_V\u00148-\u001a\u000b\u0005\u0003S\t\t\u0007\u0005\u0004\u0002,\u0005U\u00121\b\b\u0005\u0003[\t\tDD\u0002W\u0003_I\u0011AW\u0005\u0004\u0003gI\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003o\tIDA\u0002TKFT1!a\rZ!\u0011\ti$a\u0017\u000f\t\u0005}\u0012q\u000b\b\u0005\u0003\u0003\n)F\u0004\u0003\u0002D\u0005Mc\u0002BA#\u0003#rA!a\u0012\u0002P9!\u0011\u0011JA'\u001d\r1\u00161J\u0005\u0002g%\u0011\u0011GM\u0005\u0003_AJ!!\f\u0018\n\u00059c\u0013BA\u0016N\u0013\r\tI\u0006T\u0001\u0011\r&dWm\u0015;sK\u0006l7k\\;sG\u0016LA!!\u0018\u0002`\tIa)\u001b7f\u000b:$(/\u001f\u0006\u0004\u00033b\u0005BBA2\u001b\u0001\u00071+A\u0002eSJ\faC]3bI>3gm]3u\rJ|WNU3t_V\u00148-\u001a\u000b\u0005\u0003S\ny\u0007E\u0002L\u0003WJ1!!\u001cM\u0005A\u0019VM]5bY&TX\rZ(gMN,G\u000f\u0003\u0004\u0002r9\u0001\raU\u0001\u0005M&dW-A\u000fsk:$vo\u001c\"bi\u000eDWm]!oIZ+'/\u001b4z%\u0016\u001cX\u000f\u001c;t)I\t9!a\u001e\u0002\f\u0006U\u0015\u0011TAO\u0003C\u000b),!/\t\u000f\u0005et\u00021\u0001\u0002|\u0005\u00191O]2\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u000b\u000bAA[1wC&!\u0011\u0011RA@\u0005\u00111\u0015\u000e\\3\t\u000f\u00055u\u00021\u0001\u0002\u0010\u0006YA.\u0019;fgR4\u0015N]:u!\r)\u0017\u0011S\u0005\u0004\u0003'K&a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003/{\u0001\u0019A*\u0002\u0015\u0019L'o\u001d;CCR\u001c\u0007\u000e\u0003\u0004\u0002\u001c>\u0001\raU\u0001\fg\u0016\u001cwN\u001c3CCR\u001c\u0007\u000e\u0003\u0005\u0002 >\u0001\n\u00111\u0001~\u0003)i\u0017\r\u001f$jY\u0016\fu-\u001a\u0005\n\u0003G{\u0001\u0013!a\u0001\u0003K\u000b1b\u00197fC:\u001cv.\u001e:dKB!\u0011qUAW\u001d\rY\u0015\u0011V\u0005\u0004\u0003Wc\u0015aD\"mK\u0006t7k\\;sG\u0016lu\u000eZ3\n\t\u0005=\u0016\u0011\u0017\u0002\u0006-\u0006dW/Z\u0005\u0004\u0003gK&aC#ok6,'/\u0019;j_:D\u0001\"a.\u0010!\u0003\u0005\r!`\u0001\u000bCJ\u001c\u0007.\u001b<f\t&\u0014\b\u0002CA^\u001fA\u0005\t\u0019A*\u0002\u001fQD'/Z:i_2$w\n\u001d;j_:\fqE];o)^|')\u0019;dQ\u0016\u001c\u0018I\u001c3WKJLg-\u001f*fgVdGo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0019\u0016\u0003{F\fqE];o)^|')\u0019;dQ\u0016\u001c\u0018I\u001c3WKJLg-\u001f*fgVdGo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0019\u0016\u0004\u0003K\u000b\u0018a\n:v]R;xNQ1uG\",7/\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e^:%I\u00164\u0017-\u001e7uI]\nqE];o)^|')\u0019;dQ\u0016\u001c\u0018I\u001c3WKJLg-\u001f*fgVdGo\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u0011q\u001a\u0016\u0003'F\u0014aBR1lK\u001aKG.Z*zgR,WnE\u0002\u0015\u0003+\u0004B!a6\u0002b6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.\u0001\u0002gg*\u0019\u0011q\u001c\u0019\u0002\r!\fGm\\8q\u0013\u0011\t\u0019/!7\u0003\u0015\u0019KG.Z*zgR,W.\u0001\u0004tG\",W.\u001a\u000b\u0005\u0003S\fi\u000fE\u0002\u0002lRi\u0011\u0001\u0001\u0005\u0007\u0003K4\u0002\u0019A*\u0002\r\u0015D\u0018n\u001d;t)\u0011\ty)a=\t\u000f\u0005Ux\u00031\u0001\u0002x\u0006\ta\r\u0005\u0003\u0002X\u0006e\u0018\u0002BA~\u00033\u0014A\u0001U1uQ\u00061Qn\u001b3jeN$b!a$\u0003\u0002\t\r\u0001bBA{1\u0001\u0007\u0011q\u001f\u0005\b\u0005\u000bA\u0002\u0019\u0001B\u0004\u0003)\u0001XM]7jgNLwN\u001c\t\u0005\u0005\u0013\u0011i!\u0004\u0002\u0003\f)!!QAAm\u0013\u0011\u0011yAa\u0003\u0003\u0019\u0019\u001b\b+\u001a:nSN\u001c\u0018n\u001c8\u0002\rI,g.Y7f)\u0019\tyI!\u0006\u0003\u0018!9\u0011\u0011P\rA\u0002\u0005]\bb\u0002B\r3\u0001\u0007\u0011q_\u0001\u0004IN$\u0018AB4fiV\u0013\u0018\u000e\u0006\u0002\u0003 A!!\u0011\u0005B\u0014\u001b\t\u0011\u0019C\u0003\u0003\u0003&\u0005\r\u0015a\u00018fi&!!\u0011\u0006B\u0012\u0005\r)&+S\u0001\u0005_B,g\u000e\u0006\u0004\u00030\tU\"q\u0007\t\u0005\u0003/\u0014\t$\u0003\u0003\u00034\u0005e'!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\"9\u0011Q_\u000eA\u0002\u0005]\bb\u0002B\u001d7\u0001\u0007!1H\u0001\u000bEV4g-\u001a:TSj,\u0007cA3\u0003>%\u0019!qH-\u0003\u0007%sG/\u0001\u0004de\u0016\fG/\u001a\u000b\u0011\u0005\u000b\u0012YE!\u0014\u0003P\tM#Q\u000bB0\u0005S\u0002B!a6\u0003H%!!\u0011JAm\u0005I15\u000bR1uC>+H\u000f];u'R\u0014X-Y7\t\u000f\u0005UH\u00041\u0001\u0002x\"9!Q\u0001\u000fA\u0002\t\u001d\u0001b\u0002B)9\u0001\u0007\u0011qR\u0001\n_Z,'o\u001e:ji\u0016DqA!\u000f\u001d\u0001\u0004\u0011Y\u0004C\u0004\u0003Xq\u0001\rA!\u0017\u0002\u0017I,\u0007\u000f\\5dCRLwN\u001c\t\u0004K\nm\u0013b\u0001B/3\n)1\u000b[8si\"9!\u0011\r\u000fA\u0002\t\r\u0014!\u00032m_\u000e\\7+\u001b>f!\r)'QM\u0005\u0004\u0005OJ&\u0001\u0002'p]\u001eDqAa\u001b\u001d\u0001\u0004\u0011i'\u0001\u0005qe><'/Z:t!\u0011\u0011yG!\u001e\u000e\u0005\tE$\u0002\u0002B:\u0003;\fA!\u001e;jY&!!q\u000fB9\u00051\u0001&o\\4sKN\u001c\u0018M\u00197f\u0003\u0019\t\u0007\u000f]3oIRA!Q\tB?\u0005\u007f\u0012\t\tC\u0004\u0002vv\u0001\r!a>\t\u000f\teR\u00041\u0001\u0003<!9!1N\u000fA\u0002\t5\u0014A\u00023fY\u0016$X\r\u0006\u0004\u0002\u0010\n\u001d%\u0011\u0012\u0005\b\u0003kt\u0002\u0019AA|\u0011\u001d\u0011YI\ba\u0001\u0003\u001f\u000b\u0011B]3dkJ\u001c\u0018N^3\u0002\u00151L7\u000f^*uCR,8\u000f\u0006\u0003\u0003\u0012\nu\u0005#B3\u0003\u0014\n]\u0015b\u0001BK3\n)\u0011I\u001d:bsB!\u0011q\u001bBM\u0013\u0011\u0011Y*!7\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0004\u0002v~\u0001\r!a>\u0002'M,GoV8sW&tw\rR5sK\u000e$xN]=\u0015\t\u0005\u001d!1\u0015\u0005\b\u0005K\u0003\u0003\u0019AA|\u0003\u001dqWm^0eSJ\f1cZ3u/>\u00148.\u001b8h\t&\u0014Xm\u0019;pef$\"!a>\u0002\u001b\u001d,GOR5mKN#\u0018\r^;t)\u0011\u00119Ja,\t\u000f\u0005U(\u00051\u0001\u0002x\u0006\u0019\u0012m]:feR4\u0015\u000e\\3JgJ+Wn\u001c<fIR1\u0011q\u0001B[\u0005sCqAa.$\u0001\u0004\tY(A\u0005t_V\u00148-\u001a#je\"1!1X\u0012A\u0002M\u000b\u0001BZ5mK:\u000bW.Z\u0001\u0017CN\u001cXM\u001d;GS2,\u0017j\u001d(piJ+Wn\u001c<fIR1\u0011q\u0001Ba\u0005\u0007DqAa.%\u0001\u0004\tY\b\u0003\u0004\u0003<\u0012\u0002\raU\u0001\u0015CN\u001cXM\u001d;GS2,\u0017j\u001d(pi6{g/\u001a3\u0015\u0011\u0005\u001d!\u0011\u001aBf\u0005\u001fDqAa.&\u0001\u0004\tY\bC\u0004\u0003N\u0016\u0002\r!a\u001f\u0002\u0017\u0015D\b/Z2uK\u0012$\u0015N\u001d\u0005\u0007\u0005#,\u0003\u0019A*\u0002\u0015\u0019LG.\u001a)sK\u001aL\u00070A\tbgN,'\u000f\u001e$jY\u0016L5/T8wK\u0012$\u0002\"a\u0002\u0003X\ne'1\u001c\u0005\b\u0005o3\u0003\u0019AA>\u0011\u001d\u0011iM\na\u0001\u0003wBaA!5'\u0001\u0004\u0019\u0016\u0001M<ji\"\u001cu.\u001e8u\u0019&\u001cH/\u001b8h\u0019>\u001c\u0017\r\u001c$jY\u0016\u001c\u0016p\u001d;f[\u0006\u001bHj\\2bY\u001aKG.Z*zgR,W\u000e\u0006\u0003\u0002\b\t\u0005\b\u0002\u0003BrO\u0011\u0005\rA!:\u0002\t\t|G-\u001f\t\u0006K\n\u001d\u0018qA\u0005\u0004\u0005SL&\u0001\u0003\u001fcs:\fW.\u001a \u0002\u0015\r\u0014X-\u0019;f\r&dW\r\u0006\u0005\u0002|\t=(1\u001fB{\u0011\u0019\u0011\t\u0010\u000ba\u0001'\u000691m\u001c8uK:$\bbBA=Q\u0001\u0007\u00111\u0010\u0005\b\u0005oD\u0003\u0019AA>\u0003\r!X\u000e\u001d\u0015\u0004\u0001\tm\b\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\u0007\r\u0005a&\u0001\u0003uC\u001e\u001c\u0018\u0002BB\u0003\u0005\u007f\u00141b\u00157poN\u000bF\nV3ti\u0002")
public class FileStreamSourceSuite
extends FileStreamSourceTest {
    private final Span streamingTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(80).seconds();

    @Override
    public Span streamingTimeout() {
        return this.streamingTimeout;
    }

    private FileStreamSource createFileStreamSource(String format, String path, Option<StructType> schema) {
        return this.getSourceFromFileStream(this.createFileStream(format, path, schema, this.createFileStream$default$4()));
    }

    private StructType createFileStreamSourceAndGetSchema(Option<String> format, Option<String> path, Option<StructType> schema2) {
        DataStreamReader reader = this.spark().readStream();
        format.foreach((Function1 & Serializable)source -> reader.format(source));
        schema2.foreach((Function1 & Serializable)schema -> reader.schema(schema));
        Dataset df = path.isDefined() ? reader.load((String)path.get()) : reader.load();
        return (StructType)df.queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StreamingRelation) {
                    StreamingRelation streamingRelation = (StreamingRelation)A1;
                    return (B1)streamingRelation.schema();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof StreamingRelation;
            }
        }).head();
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        this.spark().conf().set(SQLConf$.MODULE$.ORC_IMPLEMENTATION(), (Object)"native");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().sessionState().conf().unsetConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
        }
        finally {
            StreamTest.afterAll$(this);
        }
    }

    private void testThresholdLogic(String option) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)x0$1 -> {
            FileStreamSourceSuite.$anonfun$testThresholdLogic$1(this, option, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void testIncorrectThresholdValues(String option) {
        String testTable = option + "_test";
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)x0$1 -> {
            FileStreamSourceSuite.$anonfun$testIncorrectThresholdValues$2(this, option, testTable, x0$1);
            return BoxedUnit.UNIT;
        }));
    }

    private void testIgnoreThresholdWithTriggerOnce(String optionName) {
        this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(src, target) -> {
            FileStreamSourceSuite.$anonfun$testIgnoreThresholdWithTriggerOnce$1(this, optionName, src, target);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<FileStreamSource.FileEntry> readLogFromResource(String dir) {
        URL input = this.getClass().getResource("/structured-streaming/" + dir);
        FileStreamSourceLog log = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)log.allFiles()).toImmutableArraySeq();
    }

    private SerializedOffset readOffsetFromResource(String file) {
        return (SerializedOffset)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> Source$.MODULE$.fromFile(this.getClass().getResource("/structured-streaming/" + file).toURI(), Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)source -> new SerializedOffset(source.mkString().trim()));
    }

    private void runTwoBatchesAndVerifyResults(File src, boolean latestFirst, String firstBatch, String secondBatch, Option<String> maxFileAge, Enumeration.Value cleanSource, Option<String> archiveDir, String thresholdOption) {
        Map srcOptions = (Map)((MapOps)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)Boolean.toString(latestFirst)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)thresholdOption), (Object)"1")}))).$plus$plus((IterableOnce)maxFileAge.map((Function1 & Serializable)x$35 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), x$35)))).$plus$plus((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanSource.toString()), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)archiveDir.map((Function1 & Serializable)x$36 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), x$36)));
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = srcOptions;
        Option<StructType> x$4 = this.createFileStream$default$3();
        Dataset<Row> fileStream = this.createFileStream("text", x$2, x$4, (Map<String, String>)x$3);
        StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
        this.testStream(fileStream, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, Trigger.ProcessingTime((long)10L), (Clock)clock, this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$3(this, clock, x$37)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{firstBatch}), this.testImplicits().newStringEncoder()), new StreamTest.AdvanceManualClock(this, 10L), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$5(this, clock, x$38)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{secondBatch}), this.testImplicits().newStringEncoder())}));
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$5() {
        return None$.MODULE$;
    }

    private Enumeration.Value runTwoBatchesAndVerifyResults$default$6() {
        return CleanSourceMode$.MODULE$.OFF();
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$7() {
        return None$.MODULE$;
    }

    private String runTwoBatchesAndVerifyResults$default$8() {
        return "maxFilesPerTrigger";
    }

    private void assertFileIsRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list()), (Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)x$47.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$47: String) => x$47.startsWith(fileName)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2223));
    }

    private void assertFileIsNotRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list()), (Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)x$48.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$48: String) => x$48.startsWith(fileName)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2227));
    }

    private void assertFileIsNotMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2231));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list()), (Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)x$49.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$49: String) => x$49.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2232));
        if (!expectedDir.exists()) {
            return;
        }
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list()), (Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)x$50.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$50: String) => x$50.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2236));
    }

    private void assertFileIsMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2241));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list()), (Function1 & Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)x$51.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$51: String) => x$51.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2242));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedDir.exists(), "expectedDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2243));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list()), (Function1 & Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)x$52.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$52: String) => x$52.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2244));
    }

    private void withCountListingLocalFileSystemAsLocalFileSystem(Function0<BoxedUnit> body) {
        String optionKey = "fs." + CountListingLocalFileSystem$.MODULE$.scheme() + ".impl";
        Option originClassForLocalFileSystem = this.spark().conf().getOption(optionKey);
        try {
            this.spark().conf().set(optionKey, CountListingLocalFileSystem.class.getName());
            body.apply$mcV$sp();
        }
        finally {
            Option option = originClassForLocalFileSystem;
            if (option instanceof Some) {
                Some some = (Some)option;
                String fsClazz = (String)some.value();
                this.spark().conf().set(optionKey, fsClazz);
            } else {
                this.spark().conf().unset(optionKey);
            }
        }
    }

    private File createFile(String content, File src, File tmp) {
        File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
        File finalFile = new File(src, tempFile.getName());
        Predef$.MODULE$.require(!src.exists(), (Function0 & Serializable)() -> src + " exists, dir: " + src.isDirectory() + ", file: " + src.isFile());
        Predef$.MODULE$.require(src.mkdirs(), (Function0 & Serializable)() -> "Cannot create " + src);
        Predef$.MODULE$.require(src.isDirectory(), (Function0 & Serializable)() -> src + " is not a directory");
        Predef$.MODULE$.require(package$.MODULE$.stringToFile(tempFile, content).renameTo(finalFile));
        return finalFile;
    }

    private Option<StructType> createFileStreamSource$default$3() {
        return None$.MODULE$;
    }

    private Option<StructType> createFileStreamSourceAndGetSchema$default$3() {
        return None$.MODULE$;
    }

    private final void testError$1() {
        IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "path";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    public static final /* synthetic */ void $anonfun$new$12(FileStreamSourceSuite $this, File src) {
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
    }

    public static final /* synthetic */ void $anonfun$new$14(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
    }

    public static final /* synthetic */ void $anonfun$new$16(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
    }

    public static final /* synthetic */ void $anonfun$new$18(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).orc(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0 & Serializable)() -> (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().orc(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
    }

    public static final /* synthetic */ void $anonfun$new$25(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).parquet(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0 & Serializable)() -> (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().parquet(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
    }

    public static final /* synthetic */ void $anonfun$new$36(FileStreamSourceSuite $this, File src) {
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0 & Serializable)() -> (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c': '3'}");
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("c", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c', '3'}");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
    }

    public static final /* synthetic */ void $anonfun$new$43(FileStreamSourceSuite $this, File x0$1, File x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$46(FileStreamSourceSuite $this, String special_str$1, File x0$2, File x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, "text" + special_str$1 + "text"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$50(FileStreamSourceSuite $this, String special_str$2, String testTableName$1, File x0$3, File x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File checkpoint = (File)tuple2._2();
            File output = new File(src, "text" + special_str$2 + "text");
            MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            Dataset ds = inputData.toDS();
            StreamingQuery query = ds.writeStream().option("checkpointLocation", checkpoint.getCanonicalPath()).format("text").start(output.getCanonicalPath());
            try {
                inputData.addData((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}));
                $this.failAfter($this.streamingTimeout(), (Function0)(JFunction0.mcV.sp & Serializable)() -> query.processAllAvailable(), $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512), Timed$.MODULE$.timed());
            }
            finally {
                query.stop();
            }
            String input_path = output.getCanonicalPath().replace("[", "\\[").replace("]", "\\]");
            Dataset df2 = $this.spark().readStream().format("text").load(input_path);
            StreamingQuery query2 = df2.writeStream().format("memory").queryName(testTableName$1).start();
            try {
                query2.processAllAvailable();
                $this.checkDatasetUnorderly((Function0 & Serializable)() -> $this.spark().table(testTableName$1).as($this.testImplicits().newStringEncoder()), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
            }
            finally {
                query2.stop();
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$55(FileStreamSourceSuite $this, String testTableName$2, File output) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDS().write().text(output.getCanonicalPath());
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"bar", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDS().write().mode("append").orc(output.getCanonicalPath());
        Dataset df = $this.spark().readStream().option("pathGlobFilter", "*.txt").format("text").load(output.getCanonicalPath());
        StreamingQuery query = df.writeStream().format("memory").queryName(testTableName$2).start();
        try {
            query.processAllAvailable();
            $this.checkDatasetUnorderly((Function0 & Serializable)() -> $this.spark().table(testTableName$2).as($this.testImplicits().newStringEncoder()), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
        }
        finally {
            query.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$58(FileStreamSourceSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        String defaultFs = "nonexistFS://nonexistFS";
        String expectMessage = "No FileSystem for scheme nonexistFS";
        String message = ((Throwable)$this.intercept((Function0 & Serializable)() -> $this.spark().readStream().option("fs.defaultFS", defaultFs).text(path), ClassTag$.MODULE$.apply(IOException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562))).getMessage();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{':', '\"'}));
        String $org_scalatest_assert_macro_left = StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(message), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem)))));
        String $org_scalatest_assert_macro_right = expectMessage;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
    }

    public static final /* synthetic */ void $anonfun$new$62(FileStreamSourceSuite $this, File x0$4, File x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset textStream = $this.spark().readStream().textFile(src.getCanonicalPath());
            Dataset filtered = textStream.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("keep")));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$66(StreamExecution x$4) {
        Thread.sleep(1000L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$67(FileStreamSourceSuite $this, StreamExecution streamExecution) {
        FileStreamSource source = (FileStreamSource)$this.getSourcesFromStreamingQuery(streamExecution).head();
        FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = source.seenFiles();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$65(FileStreamSourceSuite $this, File x0$5, File x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            String x$7 = "text";
            String x$8 = src.getCanonicalPath();
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), (Object)"5ms")}));
            Option<StructType> x$10 = $this.createFileStream$default$3();
            Dataset<Row> textStream = $this.createFileStream("text", x$8, x$10, (Map<String, String>)x$9);
            $this.testStream(textStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "a\nb", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$66(x$4)), $this.AssertOnQuery().apply$default$2()), new FileStreamSourceTest.AddTextFileData($this, "c\nd", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("seen files should contain only one entry", (Function1<StreamExecution, Object>)(Function1 & Serializable)streamExecution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$67($this, streamExecution)))}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$69(FileStreamSourceSuite $this, File x0$6, File x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}\n{'value': 'keep3'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop4'}\n{'value': 'keep5'}\n{'value': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop7'}\n{'value': 'keep8'}\n{'value': 'keep9'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$71(FileStreamSourceSuite $this, File x0$7, File x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
                Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
                StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$74(FileStreamSourceSuite $this, File x0$8, File x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)x1$8);
        if (tuple2 != null) {
            File baseSrc = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                File src = new File(baseSrc, "type=X");
                src.mkdirs();
                package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
                Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$77(FileStreamSourceSuite $this, File x0$9, File x1$9) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)x1$9);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                package$.MODULE$.stringToFile(new File(src, "existing"), "{'k': 'value0'}");
                Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
                StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
                package$.MODULE$.stringToFile(new File(src, "existing2"), "{'k': 'value1', 'v': 'new'}");
                $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value2'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value3', 'v': 'new'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'v': 'value4'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder())}));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$80(FileStreamSourceSuite $this, File x0$10, File x1$10) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)x1$10);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddOrcFileData().apply((Seq<String>)new .colon.colon((Object)"drop1", (List)new .colon.colon((Object)"keep2", (List)new .colon.colon((Object)"keep3", (List)Nil$.MODULE$))), src, tmp), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddOrcFileData().apply((Seq<String>)new .colon.colon((Object)"drop4", (List)new .colon.colon((Object)"keep5", (List)new .colon.colon((Object)"keep6", (List)Nil$.MODULE$))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddOrcFileData().apply((Seq<String>)new .colon.colon((Object)"drop7", (List)new .colon.colon((Object)"keep8", (List)new .colon.colon((Object)"keep9", (List)Nil$.MODULE$))), src, tmp), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$82(FileStreamSourceSuite $this, File x0$11, File x1$11) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)x1$11);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value0", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
                Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
                StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator158$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator158$1(FileStreamSourceSuite $outer) {
                    }
                }
                $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator158$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
                StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
                streamActionArray[0] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value2", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
                streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator180$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator180$1(FileStreamSourceSuite $outer) {
                    }
                }
                streamActionArray[2] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator180$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
                streamActionArray[3] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
                streamActionArray[4] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value5", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
                streamActionArray[5] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
                $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$85(FileStreamSourceSuite $this, File x0$12, File x1$12) {
        Tuple2 tuple2 = new Tuple2((Object)x0$12, (Object)x1$12);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddParquetFileData().apply((Seq<String>)new .colon.colon((Object)"drop1", (List)new .colon.colon((Object)"keep2", (List)new .colon.colon((Object)"keep3", (List)Nil$.MODULE$))), src, tmp), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddParquetFileData().apply((Seq<String>)new .colon.colon((Object)"drop4", (List)new .colon.colon((Object)"keep5", (List)new .colon.colon((Object)"keep6", (List)Nil$.MODULE$))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddParquetFileData().apply((Seq<String>)new .colon.colon((Object)"drop7", (List)new .colon.colon((Object)"keep8", (List)new .colon.colon((Object)"keep9", (List)Nil$.MODULE$))), src, tmp), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$87(FileStreamSourceSuite $this, File x0$13, File x1$13) {
        Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)x1$13);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value0", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
                Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
                StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator226$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator226$1(FileStreamSourceSuite $outer) {
                    }
                }
                $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator226$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
                StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
                streamActionArray[0] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value2", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
                streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator248$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator248$1(FileStreamSourceSuite $outer) {
                    }
                }
                streamActionArray[2] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator248$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
                streamActionArray[3] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
                streamActionArray[4] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value5", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
                streamActionArray[5] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
                $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$90(FileStreamSourceSuite $this, File x0$14, File x1$14) {
        Tuple2 tuple2 = new Tuple2((Object)x0$14, (Object)x1$14);
        if (tuple2 != null) {
            File dir = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> fileStream = $this.createFileStream("text", dir.getCanonicalPath() + "/*/*", $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            File subDir = new File(dir, "subdir");
            File subSubDir = new File(subDir, "subsubdir");
            File subSubSubDir = new File(subSubDir, "subsubsubdir");
            Predef$.MODULE$.require(!subDir.exists());
            Predef$.MODULE$.require(!subSubDir.exists());
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep4", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep5", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep6", dir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep7", subSubSubDir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep8", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5", "keep8"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$92(FileStreamSourceSuite $this, File x0$15, File x1$15) {
        Tuple2 tuple2 = new Tuple2((Object)x0$15, (Object)x1$15);
        if (tuple2 != null) {
            File dir = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            File partitionFooSubDir = new File(dir, "partition=foo");
            File partitionBarSubDir = new File(dir, "partition=bar");
            StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
            Dataset<Row> fileStream = $this.createFileStream("json", dir.getCanonicalPath() + "/*/*", (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            Object nullStr = null;
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator289$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator289$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator289$1(null))));
            streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator294$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator294$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[3] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator294$1(null))));
            streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator299$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator299$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[5] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator299$1(null))));
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator304$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator304$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[7] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr), new Tuple2((Object)"keep5", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator304$1(null))));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$94(FileStreamSourceSuite $this, File x0$16, File x1$16) {
        Tuple2 tuple2 = new Tuple2((Object)x0$16, (Object)x1$16);
        if (tuple2 != null) {
            File dir = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            File partitionFooSubDir = new File(dir, "partition=foo");
            File partitionBarSubDir = new File(dir, "partition=bar");
            StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
            Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator309$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator309$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator309$1(null))));
            streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator314$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator314$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[3] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator314$1(null))));
            streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator319$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator319$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[5] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator319$1(null))));
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator324$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator324$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[7] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator324$1(null))));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$98(MemoryStream q1Source$1, Seq data$1, StreamingQuery q1$1, StreamExecution x$5) {
        q1Source$1.addData((IterableOnce)data$1);
        q1$1.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$1(Seq data, MemoryStream q1Source$1, StreamingQuery q1$1) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$5 -> {
            FileStreamSourceSuite.$anonfun$new$98(q1Source$1, data, q1$1, x$5);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$1() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$97(FileStreamSourceSuite $this, File x0$17, File x1$17) {
        Tuple2 tuple2 = new Tuple2((Object)x0$17, (Object)x1$17);
        if (tuple2 != null) {
            File outputDir = (File)tuple2._1();
            File checkpointDir = (File)tuple2._2();
            MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
            Dataset q2 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(q2, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
                File shouldNotKeep = new File(outputDir, "should_not_keep.txt");
                package$.MODULE$.stringToFile(shouldNotKeep, "should_not_keep!!!");
                return shouldNotKeep.exists();
            }, $this.Assert().apply$default$2()), $this.q1AddData$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$1((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> new File(outputDir, FileStreamSink$.MODULE$.metadataDir() + "/2.compact").exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$6 -> {
                q1.stop();
                return BoxedUnit.UNIT;
            })}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$107(MemoryStream q1Source$2, Seq data$2, StreamingQuery q1$2, StreamExecution x$7) {
        q1Source$2.addData((IterableOnce)data$2);
        q1$2.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$2(Seq data, MemoryStream q1Source$2, StreamingQuery q1$2) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$7 -> {
            FileStreamSourceSuite.$anonfun$new$107(q1Source$2, data, q1$2, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$2() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$106(FileStreamSourceSuite $this, File outputDir$2, File checkpointDir2) {
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir2.getCanonicalPath()).format("text").start(outputDir$2.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir$2.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$2((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$2((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$2((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> new File(outputDir$2, FileStreamSink$.MODULE$.metadataDir() + "/2.compact").exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$8 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
    }

    public static final /* synthetic */ void $anonfun$new$105(FileStreamSourceSuite $this, File x0$18, File x1$18) {
        Tuple2 tuple2 = new Tuple2((Object)x0$18, (Object)x1$18);
        if (tuple2 != null) {
            File outputDir = (File)tuple2._1();
            File checkpointDir1 = (File)tuple2._2();
            MemoryStream q0Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            StreamingQuery q0 = q0Source.toDF().writeStream().option("checkpointLocation", checkpointDir1.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
            q0Source.addData((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep0"}));
            q0.processAllAvailable();
            q0.stop();
            Utils$.MODULE$.deleteRecursively(new File(outputDir.getCanonicalPath() + "/" + FileStreamSink$.MODULE$.metadataDir()));
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)checkpointDir2 -> {
                FileStreamSourceSuite.$anonfun$new$106($this, outputDir, checkpointDir2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$113(FileStreamSourceSuite $this, StreamExecution q2) {
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)None$.MODULE$, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$114(ObjectRef q1$3, DataStreamWriter q1Write$1, File outputDir$3, MemoryStream q1Source$3, StreamExecution x$9) {
        q1$3.elem = q1Write$1.start(outputDir$3.getCanonicalPath());
        q1Source$3.addData((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}));
        ((StreamingQuery)q1$3.elem).processAllAvailable();
    }

    public static final /* synthetic */ boolean $anonfun$new$115(FileStreamSourceSuite $this, StreamExecution q2) {
        q2.processAllAvailable();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$116(ObjectRef q1$3, StreamExecution x$10) {
        ((StreamingQuery)q1$3.elem).stop();
    }

    public static final /* synthetic */ void $anonfun$new$112(FileStreamSourceSuite $this, File x0$19, File x1$19) {
        Tuple2 tuple2 = new Tuple2((Object)x0$19, (Object)x1$19);
        if (tuple2 != null) {
            File outputDir = (File)tuple2._1();
            File checkpointDir = (File)tuple2._2();
            MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            DataStreamWriter q1Write = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text");
            ObjectRef q1 = ObjectRef.create(null);
            Dataset q22 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(q22, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$113($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$9 -> {
                FileStreamSourceSuite.$anonfun$new$114(q1, q1Write, outputDir, q1Source, x$9);
                return BoxedUnit.UNIT;
            }), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$115($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$10 -> {
                FileStreamSourceSuite.$anonfun$new$116(q1, x$10);
                return BoxedUnit.UNIT;
            })}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$119(FileStreamSourceSuite $this, File x0$20, File x1$20) {
        Tuple2 tuple2 = new Tuple2((Object)x0$20, (Object)x1$20);
        if (tuple2 != null) {
            File dir = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            File partitionFooSubDir = new File(dir, "partition=foo");
            File partitionBarSubDir = new File(dir, "partition=bar");
            $this.createFile("{'value': 'drop0'}", partitionFooSubDir, tmp);
            Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[10];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator373$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator373$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator373$1(null))));
            streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator378$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator378$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[3] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator378$1(null))));
            streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator383$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator383$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[5] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator383$1(null))));
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator388$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator388$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[7] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator388$1(null))));
            streamActionArray[8] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep6'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
            JavaUniverse $u5 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m5 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator393$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator393$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[9] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar"), new Tuple2((Object)"keep6", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator393$1(null))));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$121(FileStreamSourceSuite $this, File x0$21, File x1$21) {
        Tuple2 tuple2 = new Tuple2((Object)x0$21, (Object)x1$21);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final File createFile$1(String data, File x1$1, ObjectRef lastFileModTime$1) {
        File file = package$.MODULE$.stringToFile(new File(x1$1, data + ".txt"), data);
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return file;
    }

    public static final /* synthetic */ String $anonfun$testThresholdLogic$3(char x$11) {
        return Character.toString(x$11);
    }

    private final void checkLastBatchData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.latestBatchData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable)x$11 -> FileStreamSourceSuite.$anonfun$testThresholdLogic$3(BoxesRunTime.unboxToChar((Object)x$11))), this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    public static final /* synthetic */ String $anonfun$testThresholdLogic$5(char x$12) {
        return Character.toString(x$12);
    }

    private final void checkAllData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.allData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable)x$12 -> FileStreamSourceSuite.$anonfun$testThresholdLogic$5(BoxesRunTime.unboxToChar((Object)x$12))), this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    private final void checkNumBatchesSinceLastCheck$1(int numBatches, LongRef lastBatchId$1, MemorySink memorySink$1) {
        Predef$.MODULE$.require(lastBatchId$1.elem >= 0L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(memorySink$1.latestBatchId().get());
        long $org_scalatest_assert_macro_right = lastBatchId$1.elem + (long)numBatches;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1215));
        lastBatchId$1.elem = BoxesRunTime.unboxToLong((Object)memorySink$1.latestBatchId().get());
    }

    public static final /* synthetic */ void $anonfun$testThresholdLogic$1(FileStreamSourceSuite $this, String option$1, File x0$1) {
        File file = x0$1;
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$1("a", file, lastFileModTime);
        FileStreamSourceSuite.createFile$1("b", file, lastFileModTime);
        FileStreamSourceSuite.createFile$1("c", file, lastFileModTime);
        Dataset df = $this.spark().readStream().option(option$1, 2L).text(file.getCanonicalPath());
        StreamExecution q = ((StreamingQueryWrapper)df.writeStream().format("memory").queryName("file_data").start()).streamingQuery();
        q.processAllAvailable();
        MemorySink memorySink = (MemorySink)q.sink();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q).head();
        LongRef lastBatchId = LongRef.create((long)-1L);
        $this.checkLastBatchData$1((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'c'}), memorySink);
        $this.checkAllData$1((Seq)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'c')), memorySink);
        lastBatchId.elem = BoxesRunTime.unboxToLong((Object)memorySink.latestBatchId().get());
        fileSource.withBatchingLocked((Function0 & Serializable)() -> {
            FileStreamSourceSuite.createFile$1("d", file, lastFileModTime);
            FileStreamSourceSuite.createFile$1("e", file, lastFileModTime);
            FileStreamSourceSuite.createFile$1("f", file, lastFileModTime);
            return FileStreamSourceSuite.createFile$1("g", file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(2, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'f', 'g'}), memorySink);
        $this.checkAllData$1((Seq)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'g')), memorySink);
        fileSource.withBatchingLocked((Function0 & Serializable)() -> {
            FileStreamSourceSuite.createFile$1("h", file, lastFileModTime);
            FileStreamSourceSuite.createFile$1("i", file, lastFileModTime);
            FileStreamSourceSuite.createFile$1("j", file, lastFileModTime);
            FileStreamSourceSuite.createFile$1("k", file, lastFileModTime);
            return FileStreamSourceSuite.createFile$1("l", file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(3, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'l'}), memorySink);
        $this.checkAllData$1((Seq)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'l')), memorySink);
        q.stop();
    }

    private final void testIncorrectValue$1(String value, String option$2, File x1$2, String testTable$1) {
        Dataset df = this.spark().readStream().option(option$2, value).text(x1$2.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)this.intercept((Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$1).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1264));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
        new .colon.colon((Object)option$2, (List)new .colon.colon((Object)value, (List)new .colon.colon((Object)"positive integer", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1275));
        });
    }

    public static final /* synthetic */ void $anonfun$testIncorrectThresholdValues$2(FileStreamSourceSuite $this, String option$2, String testTable$1, File x0$1) {
        File file = x0$1;
        $this.testIncorrectValue$1("not-a-integer", option$2, file, testTable$1);
        $this.testIncorrectValue$1("-1", option$2, file, testTable$1);
        $this.testIncorrectValue$1("0", option$2, file, testTable$1);
        $this.testIncorrectValue$1("10.1", option$2, file, testTable$1);
    }

    public static final /* synthetic */ void $anonfun$new$128(FileStreamSourceSuite $this, String testTable$2, File x0$22) {
        File file = x0$22;
        Dataset df = $this.spark().readStream().option("maxBytesPerTrigger", "1").option("maxFilesPerTrigger", "1").text(file.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)$this.intercept((Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$2).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
        new .colon.colon((Object)"maxBytesPerTrigger", (List)new .colon.colon((Object)"maxFilesPerTrigger", (List)new .colon.colon((Object)"can't be both set", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
        });
    }

    private static final File createFile$2(int data, File src$11, ObjectRef lastFileModTime$2) {
        File file = package$.MODULE$.stringToFile(new File(src$11, data + ".txt"), Integer.toString(data));
        Object object = ((Option)lastFileModTime$2.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$2.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return file;
    }

    private static final StreamingQuery startQuery$1(Dataset df$5, String checkpoint$1, String targetDir$1) {
        return df$5.writeStream().format("parquet").trigger(Trigger.Once()).option("checkpointLocation", checkpoint$1).start(targetDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$testIgnoreThresholdWithTriggerOnce$2(StreamingQueryProgress x$13) {
        return x$13.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$testIgnoreThresholdWithTriggerOnce$4(int x$14) {
        return Integer.toString(x$14);
    }

    public static final /* synthetic */ boolean $anonfun$testIgnoreThresholdWithTriggerOnce$5(StreamingQueryProgress x$15) {
        return x$15.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$testIgnoreThresholdWithTriggerOnce$7(int x$16) {
        return Integer.toString(x$16);
    }

    public static final /* synthetic */ void $anonfun$testIgnoreThresholdWithTriggerOnce$1(FileStreamSourceSuite $this, String optionName$1, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        String targetDir = new File(target, "data").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$2(1, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(2, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(3, src, lastFileModTime);
        Dataset df = $this.spark().readStream().option(optionName$1, 1L).text(src.getCanonicalPath());
        StreamingQuery q = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1355));
            int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress()), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$testIgnoreThresholdWithTriggerOnce$2(x$13)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1356));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * from parquet.`" + targetDir + "`")), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x$14 -> FileStreamSourceSuite.$anonfun$testIgnoreThresholdWithTriggerOnce$4(BoxesRunTime.unboxToInt((Object)x$14))), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q.stop();
        }
        FileStreamSourceSuite.createFile$2(4, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(5, src, lastFileModTime);
        StreamingQuery q2 = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1368));
            int $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$testIgnoreThresholdWithTriggerOnce$5(x$15)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1369));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * from parquet.`" + targetDir + "`")), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)x$16 -> FileStreamSourceSuite.$anonfun$testIgnoreThresholdWithTriggerOnce$7(BoxesRunTime.unboxToInt((Object)x$16))), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q2.stop();
        }
    }

    private static final File createFile$3(int data, File src$12, ObjectRef lastFileModTime$3) {
        File file = package$.MODULE$.stringToFile(new File(src$12, data + ".txt"), Integer.toString(data));
        Object object = ((Option)lastFileModTime$3.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$3.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$3.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return file;
    }

    public static final /* synthetic */ void $anonfun$new$135(Dataset x$17, long x$18) {
    }

    private static final StreamingQuery startTriggerOnceQuery$1(Dataset df$6, String checkpoint$2) {
        return df$6.writeStream().foreachBatch((Function2 & Serializable)(x$17, x$18) -> {
            FileStreamSourceSuite.$anonfun$new$135(x$17, BoxesRunTime.unboxToLong((Object)x$18));
            return BoxedUnit.UNIT;
        }).trigger(Trigger.Once()).option("checkpointLocation", checkpoint$2).start();
    }

    public static final /* synthetic */ void $anonfun$new$136(FileStreamSourceSuite $this, IntRef index$1, Dataset df, long x$19) {
        ++index$1.elem;
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toString(index$1.elem)})));
    }

    private final StreamingQuery startTriggerAvailableNowQuery$1(Dataset df$6, IntRef index$1, String checkpoint$2) {
        return df$6.writeStream().foreachBatch((Function2 & Serializable)(df, x$19) -> {
            FileStreamSourceSuite.$anonfun$new$136(this, index$1, df, BoxesRunTime.unboxToLong((Object)x$19));
            return BoxedUnit.UNIT;
        }).trigger(Trigger.AvailableNow()).option("checkpointLocation", checkpoint$2).start();
    }

    public static final /* synthetic */ void $anonfun$new$134(FileStreamSourceSuite $this, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$3(1, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(2, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(3, src, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 1L).text(src.getCanonicalPath());
        StreamingQuery q = FileStreamSourceSuite.startTriggerOnceQuery$1(df, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
        }
        finally {
            q.stop();
        }
        IntRef index = IntRef.create((int)3);
        FileStreamSourceSuite.createFile$3(4, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(5, src, lastFileModTime);
        StreamingQuery q2 = $this.startTriggerAvailableNowQuery$1(df, index, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1440));
            int $org_scalatest_assert_macro_left = index.elem;
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1441));
        }
        finally {
            q2.stop();
        }
        FileStreamSourceSuite.createFile$3(6, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(7, src, lastFileModTime);
        StreamingQuery q3 = $this.startTriggerAvailableNowQuery$1(df, index, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q3.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q3.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1452));
            int $org_scalatest_assert_macro_left = index.elem;
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
        }
        finally {
            q3.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$139(FileStreamSourceSuite $this, File x0$23, File x1$22) {
        Tuple2 tuple2 = new Tuple2((Object)x0$23, (Object)x1$22);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            src.mkdirs();
            Dataset df = $this.spark().readStream().format("text").load(src.getCanonicalPath()).map((Function1 & Serializable)x$20 -> x$20.toString() + "-x", $this.testImplicits().newStringEncoder());
            df.explain();
            StreamExecution q = ((StreamingQueryWrapper)df.writeStream().queryName("file_explain").format("memory").start()).streamingQuery();
            try {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right = q.explainInternal(false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right2 = q.explainInternal(true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1473));
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                Predef$.MODULE$.require(package$.MODULE$.stringToFile(tempFile, "foo").renameTo(finalFile));
                q.processAllAvailable();
                String explainWithoutExtended = q.explainInternal(false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Relation.*text")).findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1483));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(": Text")).findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1484));
                String explainWithExtended = q.explainInternal(true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Relation.*text")).findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1489));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(": Text")).findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1490));
            }
            finally {
                q.stop();
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$new$143(int x$21) {
        return Integer.toString(x$21);
    }

    public static final /* synthetic */ void $anonfun$new$142(FileStreamSourceSuite $this, int numFiles$1, File x0$24, File x1$23) {
        Tuple2 tuple2 = new Tuple2((Object)x0$24, (Object)x1$23);
        if (tuple2 != null) {
            File root = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            File src = new File(root, "a=1");
            src.mkdirs();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numFiles$1).map((Function1 & Serializable)x$21 -> FileStreamSourceSuite.$anonfun$new$143(BoxesRunTime.unboxToInt((Object)x$21))).foreach((Function1 & Serializable)i -> {
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                return package$.MODULE$.stringToFile(finalFile, i);
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)src.listFiles().length));
            int $org_scalatest_assert_macro_right = numFiles$1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1518));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator414$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator414$1(FileStreamSourceSuite $outer) {
                }
            }
            Dataset files = $this.spark().readStream().text(root.getCanonicalPath()).as($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator414$1(null))));
            Dataset df = files.filter("1 == 0").groupBy((Seq)Nil$.MODULE$).count();
            $this.testStream(df, OutputMode.Complete(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "0", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}), $this.testImplicits().newIntEncoder())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean verify$1(StreamExecution execution, long batchId, int expectedBatches, int expectedCompactInterval, PrivateMethodTester.PrivateMethod _metadataLog$1) {
        FileStreamSource fileSource = (FileStreamSource)this.getSourcesFromStreamingQuery(execution).head();
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)this.anyRefToInvoker(fileSource).invokePrivate(_metadataLog$1.apply((Seq)Nil$.MODULE$));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, expectedCompactInterval)) {
            Path path = metadataLog.batchIdToPath(batchId);
            String $org_scalatest_assert_macro_left = path.getName();
            String $org_scalatest_assert_macro_right = CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path does not end with compact file suffix", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1551));
            Option entries = metadataLog.get(batchId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(entries.isDefined(), "entries.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Entries not defined", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1556));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])entries.get()).length));
            int $org_scalatest_assert_macro_right2 = ((FileStreamSource.FileEntry[])metadataLog.allFiles()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"clean up check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1557));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId)))), (Function1 & Serializable)x$22 -> (FileStreamSource.FileEntry[])x$22._2(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))).length));
            int $org_scalatest_assert_macro_right3 = ((FileStreamSource.FileEntry[])entries.get()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Length check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1558));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps(metadataLog.allFiles()), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)x$23.batchId()), (Ordering)Ordering.Long$.MODULE$));
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = (FileStreamSource.FileEntry[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId)))), (Function1 & Serializable)x$24 -> (FileStreamSource.FileEntry[])x$24._2(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))), (Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.batchId()), (Ordering)Ordering.Long$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch id mismatch", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1562));
        return this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId)))), (Function1 & Serializable)x$26 -> (FileStreamSource.FileEntry[])x$26._2(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expectedBatches), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$154(FileStreamSourceSuite $this, PrivateMethodTester.PrivateMethod _metadataLog$1, File x0$25, File x1$24) {
        Tuple2 tuple2 = new Tuple2((Object)x0$25, (Object)x1$24);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                Map updateConf = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}));
                StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[18];
                streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4());
                streamActionArray[1] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder());
                streamActionArray[2] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$27, 0L, 1, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                streamActionArray[3] = new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4());
                streamActionArray[4] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder());
                streamActionArray[5] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$28, 1L, 2, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4());
                streamActionArray[7] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder());
                streamActionArray[8] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$29, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                streamActionArray[9] = $this.StopStream();
                Map x$11 = updateConf;
                Trigger x$12 = $this.StartStream().apply$default$1();
                Clock x$13 = $this.StartStream().apply$default$2();
                String x$14 = $this.StartStream().apply$default$4();
                streamActionArray[10] = new StreamTest.StartStream($this, x$12, x$13, (Map<String, String>)x$11, x$14);
                streamActionArray[11] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$30, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                streamActionArray[12] = new FileStreamSourceTest.AddTextFileData($this, "drop10\nkeep11", src, tmp, $this.AddTextFileData().apply$default$4());
                streamActionArray[13] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11"}), $this.testImplicits().newStringEncoder());
                streamActionArray[14] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$31, 3L, 4, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                streamActionArray[15] = new FileStreamSourceTest.AddTextFileData($this, "drop12\nkeep13", src, tmp, $this.AddTextFileData().apply$default$4());
                streamActionArray[16] = $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11", "keep13"}), $this.testImplicits().newStringEncoder());
                streamActionArray[17] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$32, 4L, 5, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ FileStreamSource.FileEntry $anonfun$new$163(long batchId$1, int count$1, int idx) {
        return new FileStreamSource.FileEntry("path_" + batchId$1 + "_" + idx, 10000L * batchId$1 + (long)count$1, batchId$1);
    }

    private static final FileStreamSource.FileEntry[] createEntries$1(long batchId, int count) {
        return (FileStreamSource.FileEntry[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)idx -> FileStreamSourceSuite.$anonfun$new$163(batchId, count, BoxesRunTime.unboxToInt((Object)idx))).toArray(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class));
    }

    public static final /* synthetic */ Assertion $anonfun$new$165(LinkedHashMap fileEntryCache$1, int batchId) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fileEntryCache$1.containsKey(BoxesRunTime.boxToLong((long)batchId)), "fileEntryCache.containsKey(batchId.toLong)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614));
    }

    public static final /* synthetic */ Assertion $anonfun$new$166(LinkedHashMap fileEntryCache$1, int batchId) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fileEntryCache$1.containsKey(BoxesRunTime.boxToLong((long)batchId)), "fileEntryCache.containsKey(batchId.toLong)", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1617));
    }

    private static final void verifyBatchAvailabilityInCache$1(LinkedHashMap fileEntryCache, Seq expectNotAvailable, Seq expectAvailable) {
        expectNotAvailable.foreach((Function1 & Serializable)batchId -> FileStreamSourceSuite.$anonfun$new$165(fileEntryCache, BoxesRunTime.unboxToInt((Object)batchId)));
        expectAvailable.foreach((Function1 & Serializable)batchId -> FileStreamSourceSuite.$anonfun$new$166(fileEntryCache, BoxesRunTime.unboxToInt((Object)batchId)));
    }

    public static final /* synthetic */ void $anonfun$new$167(FileStreamSourceSuite $this, File chk) {
        PrivateMethodTester.PrivateMethod _fileEntryCache = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "fileEntryCache"));
        FileStreamSourceLog metadata = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache = (LinkedHashMap)$this.anyRefToInvoker(metadata).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)(JFunction1.mcZI.sp & Serializable)batchId -> metadata.add((long)batchId, FileStreamSourceSuite.createEntries$1(batchId, 100)));
        FileStreamSource.FileEntry[] allFiles = (FileStreamSource.FileEntry[])metadata.allFiles();
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})));
        FileStreamSourceLog metadata2 = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache2 = (LinkedHashMap)$this.anyRefToInvoker(metadata2).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(metadata2.allFiles());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = allFiles;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1641));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})), (Seq)scala.package$.MODULE$.Seq().empty());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(metadata2.restore());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right2 = allFiles;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1645));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache2, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 5 + FileStreamSourceLog$.MODULE$.PREV_NUM_BATCHES_TO_READ_IN_RESTORE()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)batchId -> metadata2.add((long)batchId, FileStreamSourceSuite.createEntries$1(batchId, 100)));
        FileStreamSourceLog metadata3 = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache3 = (LinkedHashMap)$this.anyRefToInvoker(metadata3).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(metadata3.restore());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right3 = (FileStreamSource.FileEntry[])metadata2.allFiles();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1659));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache3, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})), (Seq)scala.package$.MODULE$.Seq().empty());
    }

    public static final /* synthetic */ FileStreamSourceOffset $anonfun$new$174(int x$33) {
        return new FileStreamSourceOffset((long)x$33);
    }

    private final void verify$2(Option startId, int endId, Seq expected, FileStreamSource fileSource$1) {
        Option start = startId.map((Function1 & Serializable)x$33 -> FileStreamSourceSuite.$anonfun$new$174(BoxesRunTime.unboxToInt((Object)x$33)));
        FileStreamSourceOffset end = new FileStreamSourceOffset((long)endId);
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.UNSUPPORTED_OPERATION_CHECK_ENABLED().key()), (Object)"false")}), (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])fileSource$1.getBatch(start, (org.apache.spark.sql.execution.streaming.Offset)end).as(this.testImplicits().newStringEncoder()).collect())));
            Seq $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1691));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$173(FileStreamSourceSuite $this, StreamExecution execution) {
        PrivateMethodTester.PrivateMethod _sources = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(execution).head();
        $this.verify$2((Option)None$.MODULE$, 2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), 2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), fileSource);
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$171(FileStreamSourceSuite $this, File x0$26, File x1$25) {
        Tuple2 tuple2 = new Tuple2((Object)x0$26, (Object)x1$25);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("check getBatch", (Function1<StreamExecution, Object>)(Function1 & Serializable)execution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$173($this, execution)))}));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$179(StreamingQueryProgress x$34) {
        return x$34.numInputRows() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$178(FileStreamSourceSuite $this, StreamExecution query) {
        StreamingQueryProgress actualProgress = (StreamingQueryProgress)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$179(x$34))).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("Could not find records with data."));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actualProgress.numInputRows()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1716));
        double $org_scalatest_assert_macro_left2 = actualProgress.sources()[0].processedRowsPerSecond();
        double $org_scalatest_assert_macro_right2 = 0.0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1717));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$177(FileStreamSourceSuite $this, File x0$27, File x1$26) {
        Tuple2 tuple2 = new Tuple2((Object)x0$27, (Object)x1$26);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            Dataset input = $this.spark().readStream().format("text").load(src.getCanonicalPath());
            $this.testStream(input, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "100", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"100"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)query -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$178($this, query)), $this.AssertOnQuery().apply$default$2())}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$3(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$37) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1786));
        }, $this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1785));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$5(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$38) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(10L), "clock.isStreamWaitingAt(10L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1795));
        }, $this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1794));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$186(FileStreamSourceSuite $this, File src) {
        File f1 = package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 1000L);
        $this.runTwoBatchesAndVerifyResults(src, false, "1", "2", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7(), $this.runTwoBatchesAndVerifyResults$default$8());
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7(), $this.runTwoBatchesAndVerifyResults$default$8());
    }

    public static final /* synthetic */ void $anonfun$new$188(FileStreamSourceSuite $this, File src) {
        File f1 = package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", (Option<String>)new Some((Object)"1m"), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7(), $this.runTwoBatchesAndVerifyResults$default$8());
    }

    public static final /* synthetic */ void $anonfun$new$190(FileStreamSourceSuite $this, File src) {
        File f1 = package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        File x$15 = src;
        boolean x$16 = true;
        String x$17 = "2";
        String x$18 = "1";
        Some x$19 = new Some((Object)"1m");
        String x$20 = "maxBytesPerTrigger";
        Enumeration.Value x$21 = $this.runTwoBatchesAndVerifyResults$default$6();
        Option<String> x$22 = $this.runTwoBatchesAndVerifyResults$default$7();
        $this.runTwoBatchesAndVerifyResults(x$15, true, "2", "1", (Option<String>)x$19, x$21, x$22, "maxBytesPerTrigger");
    }

    public static final /* synthetic */ void $anonfun$new$195(FileStreamSourceSuite $this, String scheme$1, File temp) {
        $this.spark().conf().set("fs." + scheme$1 + ".impl", ExistsThrowsExceptionFileSystem.class.getName());
        File dir = new File(temp, "dir");
        FileStreamSourceLog metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), dir.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadataLog.add(0L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(scheme$1 + ":///file1", 100L, 0L)})), "metadataLog.add(0L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(\"\".+(scheme).+(\":///file1\"), 100L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1921));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadataLog.add(1L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(scheme$1 + ":///file2", 200L, 0L)})), "metadataLog.add(1L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(\"\".+(scheme).+(\":///file2\"), 200L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1922));
        FileStreamSource newSource = new FileStreamSource($this.spark(), scheme$1 + ":///", "parquet", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, dir.getAbsolutePath(), Predef$.MODULE$.Map().empty());
        newSource.getBatch((Option)None$.MODULE$, (org.apache.spark.sql.execution.streaming.Offset)new FileStreamSourceOffset(1L));
    }

    public static final /* synthetic */ boolean $anonfun$new$198(FileStreamSourceTest.AddTextFileData x$39) {
        return x$39.content() != null;
    }

    private final StreamTest.StreamAction addMultiTextFileData$1(String source1Content, String source2Content, File sourceDir1$1, File tmp$9, File sourceDir2$1) {
        Seq actions = (Seq)new .colon.colon((Object)new FileStreamSourceTest.AddTextFileData(this, source1Content, sourceDir1$1, tmp$9, this.AddTextFileData().apply$default$4()), (List)new .colon.colon((Object)new FileStreamSourceTest.AddTextFileData(this, source2Content, sourceDir2$1, tmp$9, this.AddTextFileData().apply$default$4()), (List)Nil$.MODULE$)).filter((Function1 & Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$198(x$39)));
        return new StreamTest.StreamProgressLockedActions(this, (Seq<StreamTest.StreamAction>)actions, actions.mkString("[ ", " | ", " ]"));
    }

    public static final /* synthetic */ void $anonfun$new$197(FileStreamSourceSuite $this, File x0$28, File x1$27) {
        Tuple2 tuple2 = new Tuple2((Object)x0$28, (Object)x1$27);
        if (tuple2 != null) {
            File dir = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            File sourceDir1 = new File(dir, "source1");
            File sourceDir2 = new File(dir, "source2");
            sourceDir1.mkdirs();
            sourceDir2.mkdirs();
            Dataset<Row> source1 = $this.createFileStream("text", String.valueOf(sourceDir1.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset<Row> source2 = $this.createFileStream("text", String.valueOf(sourceDir2.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset unioned = source1.union(source2);
            $this.testStream(unioned, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_0", "source2_0", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_0", ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source2_0"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_1", null, sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_1", Nil$.MODULE$, $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1(null, "source2_2", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source2_2", Nil$.MODULE$, $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_3", "source2_3", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_3", ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source2_3"}), $this.testImplicits().newStringEncoder()), $this.StopStream()}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$200(FileStreamSourceSuite $this, File temp) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("foo", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType nullableSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("foo", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(nullableSchema);
        StructType $org_scalatest_assert_macro_right = streamingSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1984));
        StructType batchSchema = $this.spark().read().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchSchema);
        StructType $org_scalatest_assert_macro_right2 = streamingSchema;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1988));
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_SCHEMA_FORCE_NULLABLE().key()), (Object)"false")}), (Function0 & Serializable)() -> {
            StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = streamingSchema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1993));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$205(FileStreamSourceSuite $this, File src$16, StreamExecution x$40) {
        $this.assertFileIsNotRemoved(src$16, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$206(FileStreamSourceSuite $this, File src$16, StreamExecution x$41) {
        $this.assertFileIsRemoved(src$16, "keep1");
        $this.assertFileIsNotRemoved(src$16, "ke ep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$207(FileStreamSourceSuite $this, File src$16, StreamExecution x$42) {
        $this.assertFileIsRemoved(src$16, "ke ep2 %");
        $this.assertFileIsNotRemoved(src$16, "keep3");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$203(FileStreamSourceSuite $this, File x0$29, File x1$28) {
        Tuple2 tuple2 = new Tuple2((Object)x0$29, (Object)x1$28);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (JFunction0.mcV.sp & Serializable)() -> {
                Map option = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"delete")}));
                String x$23 = "text";
                String x$24 = src.getCanonicalPath();
                Map x$25 = option;
                Option<StructType> x$26 = $this.createFileStream$default$3();
                Dataset<Row> fileStream = $this.createFileStream("text", x$24, x$26, (Map<String, String>)x$25);
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$205($this, src, x$40))), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, "ke ep2 %"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$206($this, src, x$41))), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, "keep3"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file renamed", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$207($this, src, x$42)))}));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$211(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, StreamExecution x$43) {
        $this.assertFileIsNotMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$212(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, File dirForKeep2$1, File expectedMovedDir2$1, StreamExecution x$44) {
        $this.assertFileIsMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        $this.assertFileIsNotMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$213(FileStreamSourceSuite $this, File dirForKeep2$1, File expectedMovedDir2$1, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$45) {
        $this.assertFileIsMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$214(FileStreamSourceSuite $this, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$46) {
        $this.assertFileIsMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep4");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$209(FileStreamSourceSuite $this, File x0$30, File x1$29, File x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$30, (Object)x1$29, (Object)x2$1);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File tmp = (File)tuple3._2();
            File archiveDir = (File)tuple3._3();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (JFunction0.mcV.sp & Serializable)() -> {
                Map option = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"archive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
                String x$27 = "text";
                String x$28 = src.getCanonicalPath() + "/*/*";
                Map x$29 = option;
                Option<StructType> x$30 = $this.createFileStream$default$3();
                Dataset<Row> fileStream = $this.createFileStream("text", x$28, x$30, (Map<String, String>)x$29);
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                File dirForKeep1 = new File(src, "k %1");
                File dirForKeep2 = new File(dirForKeep1, "k 2");
                File dirForKeep3 = new File(src, "k3");
                File expectedMovedDir1 = new File(archiveDir.getAbsolutePath() + dirForKeep1.toURI().getPath());
                File expectedMovedDir2 = new File(archiveDir.getAbsolutePath() + dirForKeep2.toURI().getPath());
                File expectedMovedDir3 = new File(archiveDir.getAbsolutePath() + dirForKeep3.toURI().getPath());
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", dirForKeep1, tmp, "keep1"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$211($this, dirForKeep1, expectedMovedDir1, x$43))), new FileStreamSourceTest.AddTextFileData($this, "keep2", dirForKeep2, tmp, "keep2 %"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$212($this, dirForKeep1, expectedMovedDir1, dirForKeep2, expectedMovedDir2, x$44))), new FileStreamSourceTest.AddTextFileData($this, "keep3", dirForKeep3, tmp, "keep3"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$213($this, dirForKeep2, expectedMovedDir2, dirForKeep3, expectedMovedDir3, x$45))), new FileStreamSourceTest.AddTextFileData($this, "keep4", dirForKeep3, tmp, "keep4"), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$214($this, dirForKeep3, expectedMovedDir3, x$46)))}));
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$new$219(Path path) {
        return path.getName().startsWith("keep1");
    }

    public static final /* synthetic */ void $anonfun$new$220(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "Clean up source files is not supported";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2142));
    }

    public static final /* synthetic */ void $anonfun$new$217(FileStreamSourceSuite $this, String cleanOption$1, File x0$31, File x1$30, File x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)x0$31, (Object)x1$30, (Object)x2$2);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File tmp = (File)tuple3._2();
            File archiveDir = (File)tuple3._3();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (JFunction0.mcV.sp & Serializable)() -> {
                Map option = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanOption$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
                String x$31 = "text";
                String x$32 = src.getCanonicalPath();
                Map x$33 = option;
                Option<StructType> x$34 = $this.createFileStream$default$3();
                Dataset<Row> fileStream = $this.createFileStream("text", x$32, x$34, (Map<String, String>)x$33);
                Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
                FileStreamSinkLog sinkLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), $this.spark(), new File(src, FileStreamSink$.MODULE$.metadataDir()).getCanonicalPath(), FileStreamSinkLog$.MODULE$.$lessinit$greater$default$4());
                Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration($this.sparkConf());
                Path srcPath = new Path(src.getCanonicalPath());
                FileSystem fileSystem = srcPath.getFileSystem(hadoopConf);
                $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), new FileStreamSourceTest.AddFilesToFileStreamSinkLog($this, fileSystem, srcPath, sinkLog, 0, (Function1<Path, Object>)(Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$219(path))), new StreamTest.ExpectFailure($this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
                    FileStreamSourceSuite.$anonfun$new$220(t);
                    return BoxedUnit.UNIT;
                }, false, ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class))}));
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private final void assertThrowIllegalArgumentException$1(Path sourcePattern, Path baseArchivePath, FakeFileSystem fakeFileSystem$1) {
        this.intercept((Function0 & Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem$1, sourcePattern, (FileSystem)fakeFileSystem$1, baseArchivePath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2188));
    }

    public static final /* synthetic */ boolean $anonfun$new$229(long batchId$2, FileStreamSource.FileEntry x$53) {
        return x$53.batchId() == batchId$2;
    }

    private final void verifyBatch$1(FileStreamSourceOffset offset, long expectedBatchId, Seq inputFiles, int expectedListingCount, FileStreamSourceLog metadataLog$1, File src$19) {
        long batchId = offset.logOffset();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)batchId));
        long $org_scalatest_assert_macro_right = expectedBatchId;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2277));
        FileStreamSource.FileEntry[] files = (FileStreamSource.FileEntry[])metadataLog$1.get(batchId).getOrElse((Function0 & Serializable)() -> (FileStreamSource.FileEntry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$229(batchId, x$53))), "scala.Predef.refArrayOps[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](files).forall(((x$53: org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry) => x$53.batchId.==(batchId)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2280));
        String[] actualInputFiles = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)p -> p.sparkPath().toUri().getPath(), ClassTag$.MODULE$.apply(String.class));
        Seq expectedInputFiles = (Seq)((IterableOps)inputFiles.slice((int)batchId * 10, (int)batchId * 10 + 10)).map((Function1 & Serializable)x$54 -> x$54.getCanonicalPath());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualInputFiles);
        Seq $org_scalatest_assert_macro_right2 = expectedInputFiles;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2285));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedListingCount));
        Object $org_scalatest_assert_macro_right3 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src$19.getCanonicalPath()).map((Function1 & Serializable)x$55 -> BoxesRunTime.boxToLong((long)x$55.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2287));
    }

    public static final /* synthetic */ File $anonfun$new$234(FileStreamSourceSuite $this, File src$19, File tmp$13, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$19, Integer.toString(idx)), tmp$13);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$227(FileStreamSourceSuite $this, File x0$32, File x1$31, File x2$3) {
        Tuple3 tuple3 = new Tuple3((Object)x0$32, (Object)x1$31, (Object)x2$3);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File meta = (File)tuple3._2();
            File tmp = (File)tuple3._3();
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"10")}));
            String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
            FileStreamSource source = new FileStreamSource($this.spark(), scheme + ":///" + src.getCanonicalPath() + "/*/*", "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().empty(), meta.getCanonicalPath(), options);
            PrivateMethodTester.PrivateMethod _metadataLog = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            FileStreamSourceLog metadataLog = (FileStreamSourceLog)$this.anyRefToInvoker(source).invokePrivate(_metadataLog.apply((Seq)Nil$.MODULE$));
            CountListingLocalFileSystem$.MODULE$.resetCount();
            IndexedSeq inputFiles = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 40).map((Function1 & Serializable)idx -> FileStreamSourceSuite.$anonfun$new$234($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)batchId -> {
                FileStreamSourceOffset offsetBatch = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
                $this.verifyBatch$1(offsetBatch, batchId, (Seq)inputFiles, 1, metadataLog, src);
            });
            FileStreamSourceOffset offsetBatch = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)4));
            long $org_scalatest_assert_macro_right = offsetBatch.logOffset();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2312));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
            Object $org_scalatest_assert_macro_right2 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$56 -> BoxesRunTime.boxToLong((long)x$56.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2313));
            FileStreamSourceOffset offsetBatch2 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)4));
            long $org_scalatest_assert_macro_right3 = offsetBatch2.logOffset();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2319));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)3));
            Object $org_scalatest_assert_macro_right4 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$57 -> BoxesRunTime.boxToLong((long)x$57.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2321));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ File $anonfun$new$243(FileStreamSourceSuite $this, File src$20, File tmp$14, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$20, Integer.toString(idx)), tmp$14);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$242(FileStreamSourceSuite $this, File x0$33, File x1$32, File x2$4) {
        Tuple3 tuple3 = new Tuple3((Object)x0$33, (Object)x1$32, (Object)x2$4);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File meta = (File)tuple3._2();
            File tmp = (File)tuple3._3();
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"5")}));
            String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
            FileStreamSource source = new FileStreamSource($this.spark(), scheme + ":///" + src.getCanonicalPath() + "/*/*", "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().empty(), meta.getCanonicalPath(), options);
            CountListingLocalFileSystem$.MODULE$.resetCount();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 19).map((Function1 & Serializable)idx -> FileStreamSourceSuite.$anonfun$new$243($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)));
            FileStreamSourceOffset cfr_ignored_0 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1));
            Object $org_scalatest_assert_macro_right = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$58 -> BoxesRunTime.boxToLong((long)x$58.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2346));
            FileStreamSourceOffset cfr_ignored_1 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
            Object $org_scalatest_assert_macro_right2 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$59 -> BoxesRunTime.boxToLong((long)x$59.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2354));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$new$252(long batchId$3, FileStreamSource.FileEntry x$60) {
        return x$60.batchId() == batchId$3;
    }

    private final void verifyBatch$2(FileStreamSourceOffset offset, long expectedBatchId, Seq inputFiles, int expectedFileOffset, int expectedFilesInBatch, int expectedListingCount, FileStreamSourceLog metadataLog$2, File src$21) {
        long batchId = offset.logOffset();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)batchId));
        long $org_scalatest_assert_macro_right = expectedBatchId;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2379));
        FileStreamSource.FileEntry[] files = (FileStreamSource.FileEntry[])metadataLog$2.get(batchId).getOrElse((Function0 & Serializable)() -> (FileStreamSource.FileEntry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$252(batchId, x$60))), "scala.Predef.refArrayOps[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](files).forall(((x$60: org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry) => x$60.batchId.==(batchId)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2382));
        String[] actualInputFiles = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)p -> p.sparkPath().toUri().getPath(), ClassTag$.MODULE$.apply(String.class));
        Seq expectedInputFiles = (Seq)((IterableOps)inputFiles.slice(expectedFileOffset, expectedFileOffset + expectedFilesInBatch)).map((Function1 & Serializable)x$61 -> x$61.getCanonicalPath());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualInputFiles);
        Seq $org_scalatest_assert_macro_right2 = expectedInputFiles;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2390));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedListingCount));
        Object $org_scalatest_assert_macro_right3 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src$21.getCanonicalPath()).map((Function1 & Serializable)x$62 -> BoxesRunTime.boxToLong((long)x$62.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2392));
    }

    public static final /* synthetic */ File $anonfun$new$257(FileStreamSourceSuite $this, File src$21, File tmp$15, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$21, Integer.toString(idx)), tmp$15);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$250(FileStreamSourceSuite $this, File x0$34, File x1$33, File x2$5) {
        Tuple3 tuple3 = new Tuple3((Object)x0$34, (Object)x1$33, (Object)x2$5);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File meta = (File)tuple3._2();
            File tmp = (File)tuple3._3();
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxCachedFiles"), (Object)"12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"discardCachedInputRatio"), (Object)"0.1")}));
            String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
            FileStreamSource source = new FileStreamSource($this.spark(), scheme + ":///" + src.getCanonicalPath() + "/*/*", "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().empty(), meta.getCanonicalPath(), options);
            PrivateMethodTester.PrivateMethod _metadataLog = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            FileStreamSourceLog metadataLog = (FileStreamSourceLog)$this.anyRefToInvoker(source).invokePrivate(_metadataLog.apply((Seq)Nil$.MODULE$));
            CountListingLocalFileSystem$.MODULE$.resetCount();
            IndexedSeq inputFiles = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 43).map((Function1 & Serializable)idx -> FileStreamSourceSuite.$anonfun$new$257($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)));
            FileStreamSourceOffset offsetBatch0 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch0, 0L, (Seq)inputFiles, 0, 10, 1, metadataLog, src);
            FileStreamSourceOffset offsetBatch1 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch1, 1L, (Seq)inputFiles, 10, 10, 1, metadataLog, src);
            FileStreamSourceOffset offsetBatch2 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch2, 2L, (Seq)inputFiles, 20, 2, 1, metadataLog, src);
            FileStreamSourceOffset offsetBatch3 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch3, 3L, (Seq)inputFiles, 22, 10, 2, metadataLog, src);
            FileStreamSourceOffset offsetBatch4 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch4, 4L, (Seq)inputFiles, 32, 10, 2, metadataLog, src);
            FileStreamSourceOffset offsetBatch5 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$2(offsetBatch5, 5L, (Seq)inputFiles, 42, 2, 2, metadataLog, src);
            FileStreamSourceOffset offsetBatch = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)5));
            long $org_scalatest_assert_macro_right = offsetBatch.logOffset();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2444));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)3));
            Object $org_scalatest_assert_macro_right2 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$63 -> BoxesRunTime.boxToLong((long)x$63.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2445));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ File $anonfun$new$263(FileStreamSourceSuite $this, File src$22, File tmp$16, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$22, Integer.toString(idx)), tmp$16);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$262(FileStreamSourceSuite $this, File x0$35, File x1$34, File x2$6) {
        Tuple3 tuple3 = new Tuple3((Object)x0$35, (Object)x1$34, (Object)x2$6);
        if (tuple3 != null) {
            File src = (File)tuple3._1();
            File meta = (File)tuple3._2();
            File tmp = (File)tuple3._3();
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxCachedFiles"), (Object)"2")}));
            String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
            FileStreamSource source = new FileStreamSource($this.spark(), scheme + ":///" + src.getCanonicalPath() + "/*/*", "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().empty(), meta.getCanonicalPath(), options);
            PrivateMethodTester.PrivateMethod _metadataLog = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            FileStreamSourceLog metadataLog = (FileStreamSourceLog)$this.anyRefToInvoker(source).invokePrivate(_metadataLog.apply((Seq)Nil$.MODULE$));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 19).map((Function1 & Serializable)idx -> FileStreamSourceSuite.$anonfun$new$263($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)));
            source.prepareForTriggerAvailableNow();
            CountListingLocalFileSystem$.MODULE$.resetCount();
            FileStreamSourceOffset offset = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
            FileStreamSource.FileEntry[] files = (FileStreamSource.FileEntry[])metadataLog.get(offset.logOffset()).getOrElse((Function0 & Serializable)() -> (FileStreamSource.FileEntry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)0));
            Object $org_scalatest_assert_macro_right = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$64 -> BoxesRunTime.boxToLong((long)x$64.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2477));
            FileStreamSource.FileEntry[] $org_scalatest_assert_macro_left2 = files;
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2480));
            offset = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
            files = (FileStreamSource.FileEntry[])metadataLog.get(offset.logOffset()).getOrElse((Function0 & Serializable)() -> (FileStreamSource.FileEntry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)0));
            Object $org_scalatest_assert_macro_right3 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable)x$65 -> BoxesRunTime.boxToLong((long)x$65.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2488));
            FileStreamSource.FileEntry[] $org_scalatest_assert_macro_left4 = files;
            int $org_scalatest_assert_macro_right4 = 5;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2491));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private static final String formatTime$1(LocalDateTime time) {
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public static final /* synthetic */ void $anonfun$new$271(ObjectRef dsReader$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            dsReader$1.elem = ((DataStreamReader)dsReader$1.elem).option(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$272(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "is not allowed in file stream source";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2514));
    }

    private final void assertOptionIsNotSupported$1(Map options, String path) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        ObjectRef dsReader = ObjectRef.create((Object)this.spark().readStream().format("csv").option("timeZone", "UTC").schema(schema));
        options.foreach((Function1 & Serializable)x0$1 -> {
            FileStreamSourceSuite.$anonfun$new$271(dsReader, x0$1);
            return BoxedUnit.UNIT;
        });
        Dataset df = ((DataStreamReader)dsReader.elem).load(path);
        this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.ExpectFailure(this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
            FileStreamSourceSuite.$anonfun$new$272(t);
            return BoxedUnit.UNIT;
        }, false, ClassTag$.MODULE$.apply(IllegalArgumentException.class))}));
    }

    public static final /* synthetic */ void $anonfun$new$273(FileStreamSourceSuite $this, File dir) {
        LocalDateTime futureTime = LocalDateTime.now(ZoneOffset.UTC).plusYears(1L);
        String formattedFutureTime = FileStreamSourceSuite.formatTime$1(futureTime);
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)formattedFutureTime)})), dir.getCanonicalPath());
        LocalDateTime prevTime = LocalDateTime.now(ZoneOffset.UTC).minusYears(1L);
        String formattedPrevTime = FileStreamSourceSuite.formatTime$1(prevTime);
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)formattedPrevTime)})), dir.getCanonicalPath());
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)formattedFutureTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)formattedPrevTime)})), dir.getCanonicalPath());
    }

    public static final /* synthetic */ void $anonfun$new$276(FileStreamSourceSuite $this, DataType schema$2, File dir) {
        String colName = "col";
        String msg = "can only contain STRING as a key type for a MAP";
        AnalysisException thrown1 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable)() -> $this.spark().readStream().schema(StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField(colName, schema$2, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).json(dir.getCanonicalPath()).schema(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2558)));
        String $org_scalatest_assert_macro_left = thrown1.getMessage();
        String $org_scalatest_assert_macro_right = msg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2561));
    }

    public FileStreamSourceSuite() {
        this.test("FileStreamSource schema: no path", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> this.testError$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.testError$1());
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("FileStreamSource schema: path doesn't exist (without schema) should throw exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)None$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("FileStreamSource schema: path doesn't exist (with schema) should throw exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)new Some((Object)userSchema));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("FileStreamSource schema: text, no existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$12(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("FileStreamSource schema: text, existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$14(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("FileStreamSource schema: text, existing files, schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$16(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("FileStreamSource schema: orc, existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$18(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("FileStreamSource schema: orc, existing files, schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$23(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.test("FileStreamSource schema: parquet, existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$25(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        this.test("FileStreamSource schema: parquet, existing files, schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$30(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("FileStreamSource schema: json, no existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$1 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418))));
                String x$2 = "UNABLE_TO_INFER_SCHEMA";
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"JSON")}));
                Option x$4 = $this.checkError$default$3();
                boolean x$5 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$1, "UNABLE_TO_INFER_SCHEMA", x$4, x$3, x$5, x$6);
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("FileStreamSource schema: json, existing files, no schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$36(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("FileStreamSource schema: json, existing files, schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$41(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("read from text files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            FileStreamSourceSuite.$anonfun$new$43(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("SPARK-21996/SPARK-43343 read from text files -- file name has special chars", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)" ", (List)new .colon.colon((Object)"[", (List)new .colon.colon((Object)"[123]", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)special_str -> {
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$2, x1$2) -> {
                FileStreamSourceSuite.$anonfun$new$46($this, special_str, x0$2, x1$2);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        this.test("SPARK-21996/SPARK-43343 read from text files generated by file sink --file name has special chars", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            new .colon.colon((Object)" ", (List)new .colon.colon((Object)"[", (List)new .colon.colon((Object)"[123]", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)special_str -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$3, x1$3) -> {
                    FileStreamSourceSuite.$anonfun$new$50($this, special_str, testTableName$1, x0$3, x1$3);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("Option pathGlobFilter", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)output -> {
                FileStreamSourceSuite.$anonfun$new$55(this, testTableName, output);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("SPARK-31935: Hadoop file system config should be effective in data source options", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FileStreamSourceSuite.$anonfun$new$58(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        this.test("read from textfile", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$4, x1$4) -> {
            FileStreamSourceSuite.$anonfun$new$62(this, x0$4, x1$4);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        this.test("SPARK-17165 should not track the list of seen files indefinitely", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$5, x1$5) -> {
            FileStreamSourceSuite.$anonfun$new$65(this, x0$5, x1$5);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        this.test("read from json files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$6, x1$6) -> {
            FileStreamSourceSuite.$anonfun$new$69(this, x0$6, x1$6);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        this.test("read from json files with inferring schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$7, x1$7) -> {
            FileStreamSourceSuite.$anonfun$new$71(this, x0$7, x1$7);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
        this.test("reading from json files inside partitioned directory", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$8, x1$8) -> {
            FileStreamSourceSuite.$anonfun$new$74(this, x0$8, x1$8);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        this.test("reading from json files with changing schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$9, x1$9) -> {
            FileStreamSourceSuite.$anonfun$new$77(this, x0$9, x1$9);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        this.test("read from orc files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$10, x1$10) -> {
            FileStreamSourceSuite.$anonfun$new$80(this, x0$10, x1$10);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        this.test("read from orc files with changing schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$11, x1$11) -> {
            FileStreamSourceSuite.$anonfun$new$82(this, x0$11, x1$11);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
        this.test("read from parquet files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$12, x1$12) -> {
            FileStreamSourceSuite.$anonfun$new$85(this, x0$12, x1$12);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
        this.test("read from parquet files with changing schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$13, x1$13) -> {
            FileStreamSourceSuite.$anonfun$new$87(this, x0$13, x1$13);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        this.test("read new files in nested directories with globbing", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$14, x1$14) -> {
            FileStreamSourceSuite.$anonfun$new$90(this, x0$14, x1$14);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
        this.test("read new files in partitioned table with globbing, should not read partition data", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$15, x1$15) -> {
            FileStreamSourceSuite.$anonfun$new$92(this, x0$15, x1$15);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
        this.test("read new files in partitioned table without globbing, should read partition data", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$16, x1$16) -> {
            FileStreamSourceSuite.$anonfun$new$94(this, x0$16, x1$16);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
        this.test("read data from outputs of another streaming query", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$17, x1$17) -> {
            FileStreamSourceSuite.$anonfun$new$97(this, x0$17, x1$17);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        this.test("SPARK-35565: read data from outputs of another streaming query but ignore its metadata", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILESTREAM_SINK_METADATA_IGNORED().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$18, x1$18) -> {
            FileStreamSourceSuite.$anonfun$new$105(this, x0$18, x1$18);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        this.test("start before another streaming query, and read its output", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$19, x1$19) -> {
            FileStreamSourceSuite.$anonfun$new$112(this, x0$19, x1$19);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
        this.test("when schema inference is turned on, should read partition data", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$20, x1$20) -> {
            FileStreamSourceSuite.$anonfun$new$119(this, x0$20, x1$20);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
        this.test("fault tolerance", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$21, x1$21) -> {
            FileStreamSourceSuite.$anonfun$new$121(this, x0$21, x1$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1138));
        this.test("max files per trigger", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testThresholdLogic("maxFilesPerTrigger"), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1156));
        this.test("SPARK-46641: max bytes per trigger", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testThresholdLogic("maxBytesPerTrigger"), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1160));
        this.testQuietly("max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testIncorrectThresholdValues("maxFilesPerTrigger"));
        this.testQuietly("SPARK-46641: max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testIncorrectThresholdValues("maxBytesPerTrigger"));
        this.testQuietly("SPARK-46641: max bytes per trigger & max files per trigger - both set", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String testTable = "maxBytesPerTrigger_maxFilesPerTrigger_test";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)x0$22 -> {
                FileStreamSourceSuite.$anonfun$new$128(this, testTable, x0$22);
                return BoxedUnit.UNIT;
            }));
        });
        this.test("SPARK-30669: maxFilesPerTrigger - ignored when using Trigger.Once", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testIgnoreThresholdWithTriggerOnce("maxFilesPerTrigger"), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1312));
        this.test("SPARK-46641: maxBytesPerTrigger - ignored when using Trigger.Once", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testIgnoreThresholdWithTriggerOnce("maxBytesPerTrigger"), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1316));
        this.test("SPARK-36533: Trigger.AvailableNow - multiple queries with checkpoint", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(src, target) -> {
            FileStreamSourceSuite.$anonfun$new$134(this, src, target);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        this.test("explain", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$23, x1$22) -> {
            FileStreamSourceSuite.$anonfun$new$139(this, x0$23, x1$22);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
        this.test("SPARK-17372 - write file names to WAL as Array[String]", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            int numFiles = 10000;
            this.spark().conf().set(SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)(numFiles * 2)));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$24, x1$23) -> {
                FileStreamSourceSuite.$anonfun$new$142(this, numFiles, x0$24, x1$23);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1497));
        this.test("compact interval metadata log", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            PrivateMethodTester.PrivateMethod _sources = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
            PrivateMethodTester.PrivateMethod _metadataLog = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$25, x1$24) -> {
                FileStreamSourceSuite.$anonfun$new$154(this, _metadataLog, x0$25, x1$24);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1533));
        this.test("restore from file stream source log", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}), (JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)chk -> {
            FileStreamSourceSuite.$anonfun$new$167(this, chk);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1601));
        this.test("get arbitrary batch from FileStreamSource", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$26, x1$25) -> {
            FileStreamSourceSuite.$anonfun$new$171(this, x0$26, x1$25);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1665));
        this.test("input row metrics", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$27, x1$26) -> {
            FileStreamSourceSuite.$anonfun$new$177(this, x0$27, x1$26);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1706));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FileStreamOptions options = new FileStreamOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxfilespertrigger"), (Object)"1")})));
            Option $org_scalatest_assert_macro_left = options.maxFilesPerTrigger();
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1726));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1724));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset json format", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-json.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1731));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1729));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset long format", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-long.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1736));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1734));
        this.test("FileStreamSourceLog - read Spark 2.1.0 log format", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readLogFromResource("file-source-log-version-2.1.0"));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/0", 1480730949000L, 0L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/1", 1480730950000L, 1L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/2", 1480730950000L, 2L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/3", 1480730950000L, 3L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/4", 1480730951000L, 4L), (List)Nil$.MODULE$)))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1740));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1739));
        this.test("FileStreamSource - latestFirst", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$186(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1803));
        this.test("SPARK-19813: Ignore maxFileAge when maxFilesPerTrigger and latestFirst is used", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$188(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1818));
        this.test("SPARK-46641: Ignore maxFileAge when maxBytesPerTrigger and latestFirst is used", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$190(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1831));
        this.test("SeenFilesMap", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add(SparkPath$.MODULE$.fromUrlString("a"), 5L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1847));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left2 = map;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1849));
            map.add(SparkPath$.MODULE$.fromUrlString("b"), 15L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left3 = map;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left4 = map;
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1855));
            map.add(SparkPath$.MODULE$.fromUrlString("c"), 16L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left5 = map;
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1859));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left6 = map;
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1861));
            map.add(SparkPath$.MODULE$.fromUrlString("c"), 25L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left7 = map;
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1865));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("c"), 20L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"c\"), 20L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1868));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("d"), 5L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"d\"), 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1871));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("e"), 20L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"e\"), 20L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1874));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1843));
        this.test("SeenFilesMap with fileNameOnly = true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, true);
            map.add(SparkPath$.MODULE$.fromUrlString("file:///a/b/c/d"), 5L);
            map.add(SparkPath$.MODULE$.fromUrlString("file:///a/b/c/e"), 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1882));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("d"), 5L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"d\"), 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1884));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("file:///d"), 5L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"file:///d\"), 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1885));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("file:///x/d"), 5L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"file:///x/d\"), 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1886));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("file:///x/y/d"), 5L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"file:///x/y/d\"), 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1887));
            map.add(SparkPath$.MODULE$.fromUrlString("s3:///bucket/d"), 5L);
            map.add(SparkPath$.MODULE$.fromUrlString("s3n:///bucket/d"), 5L);
            map.add(SparkPath$.MODULE$.fromUrlString("s3a:///bucket/d"), 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1892));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1877));
        this.test("SeenFilesMap should only consider a file old if it is earlier than last purge time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add(SparkPath$.MODULE$.fromUrlString("a"), 20L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1899));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("b"), 9L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"b\"), 9L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1902));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("b"), 10L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"b\"), 10L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1903));
            map.purge();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("b"), 9L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"b\"), 9L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1907));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(map.isNewFile(SparkPath$.MODULE$.fromUrlString("b"), 10L), "map.isNewFile(org.apache.spark.paths.SparkPath.fromUrlString(\"b\"), 10L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1895));
        this.test("do not recheck that files exist during getBatch", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String scheme = ExistsThrowsExceptionFileSystem$.MODULE$.scheme();
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)temp -> {
                FileStreamSourceSuite.$anonfun$new$195(this, scheme, temp);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1911));
        this.test("SPARK-26629: multiple file sources work with restarts when a source does not have data", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$28, x1$27) -> {
            FileStreamSourceSuite.$anonfun$new$197(this, x0$28, x1$27);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1931));
        this.test("SPARK-28651: force streaming file source to be nullable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$200(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1979));
        this.test("remove completed files when remove option is enabled", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable)(x0$29, x1$28) -> {
            FileStreamSourceSuite.$anonfun$new$203(this, x0$29, x1$28);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1998));
        this.test("move completed files to archive directory when archive option is enabled", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$30, x1$29, x2$1) -> {
            FileStreamSourceSuite.$anonfun$new$209(this, x0$30, x1$29, x2$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2043));
        new .colon.colon((Object)"delete", (List)new .colon.colon((Object)"archive", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cleanOption -> {
            this.test("Throw UnsupportedOperationException on configuring " + cleanOption + " when source path refers the output dir of FileStreamSink", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$31, x1$30, x2$2) -> {
                FileStreamSourceSuite.$anonfun$new$217($this, cleanOption, x0$31, x1$30, x2$2);
                return BoxedUnit.UNIT;
            }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2113));
            return BoxedUnit.UNIT;
        });
        this.test("SourceFileArchiver - fail when base archive path matches source pattern", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            Path sourcePatternPath = new Path("/hello*/spar?");
            Path baseArchiveDirPath = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath, baseArchiveDirPath, fakeFileSystem);
            Path sourcePatternPath2 = new Path("/hello*/spar?/structured/streaming");
            Path baseArchiveDirPath2 = new Path("/hello/spark/structured");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath2, baseArchiveDirPath2, fakeFileSystem);
            Path sourcePatternPath3 = new Path("/hello*/spar?/structured/*");
            Path baseArchiveDirPath3 = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath3, baseArchiveDirPath3, fakeFileSystem);
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2184));
        this.test("SourceFileArchiver - different filesystems between source and archive", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            FakeFileSystem fakeFileSystem2 = new FakeFileSystem(this, "fake2");
            Path sourcePatternPath = new Path("/hello*/h{e,f}ll?");
            Path baseArchiveDirPath = new Path("/hello");
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem, sourcePatternPath, (FileSystem)fakeFileSystem2, baseArchiveDirPath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2216));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2209));
        this.test("Caches and leverages unread files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$32, x1$31, x2$3) -> {
            FileStreamSourceSuite.$anonfun$new$227(this, x0$32, x1$31, x2$3);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2261));
        this.test("Don't cache unread files when latestFirst is true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$33, x1$32, x2$4) -> {
            FileStreamSourceSuite.$anonfun$new$242(this, x0$33, x1$32, x2$4);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2327));
        this.test("Options for caching unread files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$34, x1$33, x2$5) -> {
            FileStreamSourceSuite.$anonfun$new$250(this, x0$34, x1$33, x2$5);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2360));
        this.test("SPARK-48314: Don't cache unread files when using Trigger.AvailableNow", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable)(x0$35, x1$34, x2$6) -> {
            FileStreamSourceSuite.$anonfun$new$262(this, x0$35, x1$34, x2$6);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2451));
        this.test("SPARK-31962: file stream source shouldn't allow modifiedBefore/modifiedAfter", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FileStreamSourceSuite.$anonfun$new$273(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2496));
        this.test("SPARK-35320: Reading JSON with key type different to String in a map should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("test", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)), (List)new .colon.colon((Object)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)schema -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                FileStreamSourceSuite.$anonfun$new$276($this, schema, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2547));
    }

    public class FakeFileSystem
    extends FileSystem {
        private final String scheme;
        public final /* synthetic */ FileStreamSourceSuite $outer;

        public boolean exists(Path f) {
            return true;
        }

        public boolean mkdirs(Path f, FsPermission permission) {
            return true;
        }

        public boolean rename(Path src, Path dst) {
            return true;
        }

        public URI getUri() {
            return URI.create(this.scheme + ":///");
        }

        public FSDataInputStream open(Path f, int bufferSize) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public boolean delete(Path f, boolean recursive) {
            throw new NotImplementedError();
        }

        public FileStatus[] listStatus(Path f) {
            throw new NotImplementedError();
        }

        public void setWorkingDirectory(Path new_dir) {
            throw new NotImplementedError();
        }

        public Path getWorkingDirectory() {
            return new Path("/somewhere");
        }

        public FileStatus getFileStatus(Path f) {
            throw new NotImplementedError();
        }

        public /* synthetic */ FileStreamSourceSuite org$apache$spark$sql$streaming$FileStreamSourceSuite$FakeFileSystem$$$outer() {
            return this.$outer;
        }

        public FakeFileSystem(FileStreamSourceSuite $outer, String scheme) {
            this.scheme = scheme;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

