/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor$;
import org.apache.spark.sql.execution.columnar.ColumnBuilder;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.compression.ColumnBuilderHelper$;
import org.apache.spark.sql.execution.vectorized.Dictionary;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0002\u0007\u000e\u0001iAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\n1BQA\u0010\u0001\u0005\n}BQa\u0014\u0001\u0005\nACqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019i\u0007\u0001)A\u0005U\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0003u\u0001\u0011\u0005QOA\tD_2,XN\u001c,fGR|'oU;ji\u0016T!AD\b\u0002\u0015Y,7\r^8sSj,GM\u0003\u0002\u0011#\u0005IQ\r_3dkRLwN\u001c\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0004\u0001my\u0002C\u0001\u000f\u001e\u001b\u0005\u0019\u0012B\u0001\u0010\u0014\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006a2\fgn\u001d\u0006\u0003IE\t\u0001bY1uC2L8\u000f^\u0005\u0003M\u0005\u0012\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005i\u0011AC<ji\"4Vm\u0019;peR\u0011Q\u0006\u0010\u000b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012A!\u00168ji\")QG\u0001a\u0001m\u0005)!\r\\8dWB!qfN\u001d/\u0013\tA\u0004GA\u0005Gk:\u001cG/[8ocA\u0011!FO\u0005\u0003w5\u0011Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\b\"B\u001f\u0003\u0001\u0004I\u0014A\u0002<fGR|'/A\u0006xSRDg+Z2u_J\u001cHc\u0001!C\u000fR\u0011a&\u0011\u0005\u0006k\r\u0001\rA\u000e\u0005\u0006\u0007\u000e\u0001\r\u0001R\u0001\u0005g&TX\r\u0005\u00020\u000b&\u0011a\t\r\u0002\u0004\u0013:$\b\"\u0002%\u0004\u0001\u0004I\u0015A\u00013u!\tQU*D\u0001L\u0015\ta\u0015#A\u0003usB,7/\u0003\u0002O\u0017\nAA)\u0019;b)f\u0004X-A\u0006uKN$h+Z2u_J\u001cH\u0003B)TA\u0006$\"A\f*\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000bQ#\u0001\u0019A+\u0002\t9\fW.\u001a\t\u0003-vs!aV.\u0011\u0005a\u0003T\"A-\u000b\u0005iK\u0012A\u0002\u001fs_>$h(\u0003\u0002]a\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta\u0006\u0007C\u0003D\t\u0001\u0007A\tC\u0003I\t\u0001\u0007\u0011*A\u0005beJ\f\u0017\u0010V=qKV\tA\r\u0005\u0002KK&\u0011am\u0013\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f!\"\u0019:sCf$\u0016\u0010]3!\u0003\u001di\u0017\r\u001d+za\u0016,\u0012A\u001b\t\u0003\u0015.L!\u0001\\&\u0003\u000f5\u000b\u0007\u000fV=qK\u0006AQ.\u00199UsB,\u0007%\u0001\u0006tiJ,8\r\u001e+za\u0016,\u0012\u0001\u001d\t\u0003\u0015FL!A]&\u0003\u0015M#(/^2u)f\u0004X-A\u0006tiJ,8\r\u001e+za\u0016\u0004\u0013!B2iK\u000e\\G\u0003\u0002\u0018w\u0003\u0013AQa^\u0006A\u0002a\f\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0005sz\f\u0019A\u0004\u0002{y:\u0011\u0001l_\u0005\u0002c%\u0011Q\u0010M\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?1!\ry\u0013QA\u0005\u0004\u0003\u000f\u0001$aA!os\"1\u00111B\u0006A\u0002e\n!\u0002^3tiZ+7\r^8s\u0001")
public class ColumnVectorSuite
extends SparkFunSuite
implements SQLHelper {
    private final ArrayType arrayType;
    private final MapType mapType;
    private final StructType structType;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        ColumnVectorSuite columnVectorSuite = this;
        synchronized (columnVectorSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void withVector(WritableColumnVector vector, Function1<WritableColumnVector, BoxedUnit> block) {
        try {
            block.apply((Object)vector);
        }
        finally {
            vector.close();
        }
    }

    private void withVectors(int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.withVector((WritableColumnVector)new OnHeapColumnVector(size, dt), block);
        this.withVector((WritableColumnVector)new OffHeapColumnVector(size, dt), block);
    }

    private void testVectors(String name, int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVectors(size, dt, block), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public ArrayType arrayType() {
        return this.arrayType;
    }

    public MapType mapType() {
        return this.mapType;
    }

    public StructType structType() {
        return this.structType;
    }

    public void check(Seq<Object> expected, WritableColumnVector testVector) {
        ((IterableOnceOps)expected.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Integer) {
                    Integer n = (Integer)v;
                    int $org_scalatest_assert_macro_left = testVector.getInt(idx);
                    Integer $org_scalatest_assert_macro_right = n;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)$org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), (Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
                    int $org_scalatest_assert_macro_left2 = testVector.getInts(0, testVector$15.capacity)[idx];
                    Integer $org_scalatest_assert_macro_right2 = n;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Short) {
                    short s = BoxesRunTime.unboxToShort((Object)v);
                    short $org_scalatest_assert_macro_left = testVector.getShort(idx);
                    short $org_scalatest_assert_macro_right = s;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
                    short $org_scalatest_assert_macro_left3 = testVector.getShorts(0, testVector$15.capacity)[idx];
                    short $org_scalatest_assert_macro_right3 = s;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)v);
                    byte $org_scalatest_assert_macro_left = testVector.getByte(idx);
                    byte $org_scalatest_assert_macro_right = by;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
                    byte $org_scalatest_assert_macro_left4 = testVector.getBytes(0, testVector$15.capacity)[idx];
                    byte $org_scalatest_assert_macro_right4 = by;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)v);
                    long $org_scalatest_assert_macro_left = testVector.getLong(idx);
                    long $org_scalatest_assert_macro_right = l;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
                    long $org_scalatest_assert_macro_left5 = testVector.getLongs(0, testVector$15.capacity)[idx];
                    long $org_scalatest_assert_macro_right5 = l;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)v);
                    float $org_scalatest_assert_macro_left = testVector.getFloat(idx);
                    float $org_scalatest_assert_macro_right = f;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
                    float $org_scalatest_assert_macro_left6 = testVector.getFloats(0, testVector$15.capacity)[idx];
                    float $org_scalatest_assert_macro_right6 = f;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (v instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)v);
                    double $org_scalatest_assert_macro_left = testVector.getDouble(idx);
                    double $org_scalatest_assert_macro_right = d;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
                    double $org_scalatest_assert_macro_left7 = testVector.getDoubles(0, testVector$15.capacity)[idx];
                    double $org_scalatest_assert_macro_right7 = d;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
                }
            }
            if (tuple2 != null) {
                Object object = tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (object == null) {
                    return BoxesRunTime.boxToBoolean((boolean)testVector.isNullAt(idx));
                }
            }
            if (tuple2 != null) {
                int idx = tuple2._2$mcI$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Unexpected value at " + idx), Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            }
            throw new MatchError((Object)tuple2);
        });
        ColumnarArray arr = new ColumnarArray((ColumnVector)testVector, 0, testVector.capacity);
        IndexedSeq $org_scalatest_assert_macro_left = arr.toSeq(testVector.dataType());
        Seq<Object> $org_scalatest_assert_macro_right = expected;
        IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
        Seq<Object> seq = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        IndexedSeq $org_scalatest_assert_macro_left2 = arr.copy().toSeq(testVector.dataType());
        Seq<Object> $org_scalatest_assert_macro_right2 = expected;
        IndexedSeq indexedSeq2 = $org_scalatest_assert_macro_left2;
        Seq<Object> seq2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", $org_scalatest_assert_macro_right2, !(indexedSeq2 != null ? !indexedSeq2.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(ColumnVectorSuite $this, ColumnarArray array$1, ArrayData arrayCopy$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }

    public static final /* synthetic */ void $anonfun$new$1(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendBoolean(i % 2 == 0));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$3($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(ColumnVectorSuite $this, ColumnarArray array$2, ArrayData arrayCopy$2, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right = (byte)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right2 = (byte)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }

    public static final /* synthetic */ void $anonfun$new$4(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendByte((byte)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$6($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(ColumnVectorSuite $this, ColumnarArray array$3, ArrayData arrayCopy$3, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right = (short)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right2 = (short)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    public static final /* synthetic */ void $anonfun$new$7(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendShort((short)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$9($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$12(ColumnVectorSuite $this, ColumnarArray array$4, ArrayData arrayCopy$4, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    public static final /* synthetic */ void $anonfun$new$10(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$12($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$15(ColumnVectorSuite $this, ColumnarArray array$5, ArrayData arrayCopy$5, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    public static final /* synthetic */ void $anonfun$new$13(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$15($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(ColumnVectorSuite $this, ColumnarArray array$6, ArrayData arrayCopy$6, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    public static final /* synthetic */ void $anonfun$new$16(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$18($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$21(ColumnVectorSuite $this, ColumnarArray array$7, ArrayData arrayCopy$7, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    public static final /* synthetic */ void $anonfun$new$19(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$21($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$24(ColumnVectorSuite $this, ColumnarArray array$8, ArrayData arrayCopy$8, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }

    public static final /* synthetic */ void $anonfun$new$22(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$24($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$27(ColumnVectorSuite $this, ColumnarArray array$9, ArrayData arrayCopy$9, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
    }

    public static final /* synthetic */ void $anonfun$new$25(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendFloat((float)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$27($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$30(ColumnVectorSuite $this, ColumnarArray array$10, ArrayData arrayCopy$10, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public static final /* synthetic */ void $anonfun$new$28(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendDouble((double)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$30($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$33(ColumnVectorSuite $this, ColumnarArray array$11, ArrayData arrayCopy$11, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)("str" + i));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)("str" + i));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }

    public static final /* synthetic */ void $anonfun$new$31(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = ("str" + i).getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$33($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$36(ColumnVectorSuite $this, ColumnarArray array$12, ArrayData arrayCopy$12, int i) {
        byte[] utf8 = ("str" + i).getBytes("utf8");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right = utf8;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right2 = utf8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }

    public static final /* synthetic */ void $anonfun$new$34(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = ("str" + i).getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$36($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$40(ColumnVectorSuite $this, ColumnarArray array$13, YearMonthIntervalType dt$2, ArrayData arrayCopy$13, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
    }

    public static final /* synthetic */ void $anonfun$new$38(ColumnVectorSuite $this, YearMonthIntervalType dt$2, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$40($this, array, dt$2, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$44(ColumnVectorSuite $this, ColumnarArray array$14, DayTimeIntervalType dt$3, ArrayData arrayCopy$14, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
    }

    public static final /* synthetic */ void $anonfun$new$42(ColumnVectorSuite $this, DayTimeIntervalType dt$3, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$44($this, array, dt$3, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$47(ColumnVectorSuite $this, MutableColumnarRow mutableRow$1, int i) {
        mutableRow$1.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mutableRow$1.getInt(0)));
        int $org_scalatest_assert_macro_right = 10 - i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }

    public static final /* synthetic */ void $anonfun$new$45(ColumnVectorSuite $this, WritableColumnVector testVector) {
        MutableColumnarRow mutableRow = new MutableColumnarRow((WritableColumnVector[])((Object[])new WritableColumnVector[]{testVector}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            mutableRow$1.rowId = i;
            mutableRow.setInt(0, 10 - i);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$47($this, mutableRow, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$48(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        for (int i = 0; i < 6; ++i) {
            data.putInt(i, i);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
    }

    public static final /* synthetic */ void $anonfun$new$49(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        testVector.appendArray(1);
        data.appendInt(0);
        testVector.appendArray(2);
        data.appendInt(1);
        data.appendInt(2);
        testVector.appendArray(0);
        testVector.appendArray(3);
        data.appendInt(3);
        data.appendInt(4);
        data.appendInt(5);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$51(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$52(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ void $anonfun$new$50(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        for (int i2 = 0; i2 < 6; ++i2) {
            keys.appendInt(i2);
            byte[] utf8 = ("str" + i2).getBytes("utf8");
            values.appendByteArray(utf8, 0, utf8.length);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$51(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$52(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
    }

    private static final void appendPair$1(int i, WritableColumnVector keys$1, WritableColumnVector values$1) {
        keys$1.appendInt(i);
        byte[] utf8 = ("str" + i).getBytes("utf8");
        values$1.appendByteArray(utf8, 0, utf8.length);
    }

    public static final /* synthetic */ UTF8String $anonfun$new$54(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$55(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ void $anonfun$new$53(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        testVector.appendArray(1);
        ColumnVectorSuite.appendPair$1(0, keys, values);
        testVector.appendArray(2);
        ColumnVectorSuite.appendPair$1(1, keys, values);
        ColumnVectorSuite.appendPair$1(2, keys, values);
        testVector.appendArray(0);
        testVector.appendArray(3);
        ColumnVectorSuite.appendPair$1(3, keys, values);
        ColumnVectorSuite.appendPair$1(4, keys, values);
        ColumnVectorSuite.appendPair$1(5, keys, values);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$54(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$55(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }

    public static final /* synthetic */ void $anonfun$new$56(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector c1 = testVector.getChild(0);
        WritableColumnVector c2 = testVector.getChild(1);
        c1.putInt(0, 123);
        c2.putDouble(0, 3.45);
        c1.putInt(1, 456);
        c2.putDouble(1, 5.67);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getStruct(0).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = 123;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getStruct(0).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = 3.45;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getStruct(1).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right3 = 456;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getStruct(1).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right4 = 5.67;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
    }

    public static final /* synthetic */ void $anonfun$new$57(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        int $org_scalatest_assert_macro_left = testVector.getInts(0, 3)[0];
        int $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        int $org_scalatest_assert_macro_left2 = testVector.getInts(0, 3)[1];
        int $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        int $org_scalatest_assert_macro_left3 = testVector.getInts(0, 3)[2];
        int $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
    }

    public static final /* synthetic */ void $anonfun$new$58(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        short $org_scalatest_assert_macro_left = testVector.getShorts(0, 3)[0];
        short $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        short $org_scalatest_assert_macro_left2 = testVector.getShorts(0, 3)[1];
        short $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        short $org_scalatest_assert_macro_left3 = testVector.getShorts(0, 3)[2];
        short $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
    }

    public static final /* synthetic */ void $anonfun$new$59(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        byte $org_scalatest_assert_macro_left = testVector.getBytes(0, 3)[0];
        byte $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        byte $org_scalatest_assert_macro_left2 = testVector.getBytes(0, 3)[1];
        byte $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        byte $org_scalatest_assert_macro_left3 = testVector.getBytes(0, 3)[2];
        byte $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
    }

    public static final /* synthetic */ void $anonfun$new$60(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new long[]{0x80000000L, 0x80000001L, 0x80000002L});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        long $org_scalatest_assert_macro_left = testVector.getLongs(0, 3)[0];
        long $org_scalatest_assert_macro_right = 0x80000000L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        long $org_scalatest_assert_macro_left2 = testVector.getLongs(0, 3)[1];
        long $org_scalatest_assert_macro_right2 = 0x80000001L;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        long $org_scalatest_assert_macro_left3 = testVector.getLongs(0, 3)[2];
        long $org_scalatest_assert_macro_right3 = 0x80000002L;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
    }

    public static final /* synthetic */ void $anonfun$new$61(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new float[]{0.1f, 0.2f, 0.3f});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        float $org_scalatest_assert_macro_left = testVector.getFloats(0, 3)[0];
        float $org_scalatest_assert_macro_right = 0.1f;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        float $org_scalatest_assert_macro_left2 = testVector.getFloats(0, 3)[1];
        float $org_scalatest_assert_macro_right2 = 0.2f;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        float $org_scalatest_assert_macro_left3 = testVector.getFloats(0, 3)[2];
        float $org_scalatest_assert_macro_right3 = 0.3f;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
    }

    public static final /* synthetic */ void $anonfun$new$62(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new double[]{1342.17727, 1342.17728, 1342.17729});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        double $org_scalatest_assert_macro_left = testVector.getDoubles(0, 3)[0];
        double $org_scalatest_assert_macro_right = 1342.17727;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        double $org_scalatest_assert_macro_left2 = testVector.getDoubles(0, 3)[1];
        double $org_scalatest_assert_macro_right2 = 1342.17728;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        double $org_scalatest_assert_macro_left3 = testVector.getDoubles(0, 3)[2];
        double $org_scalatest_assert_macro_right3 = 1342.17729;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
    }

    public static final /* synthetic */ int $anonfun$new$64(WritableColumnVector testVector$16, Object x0$1) {
        Object object = x0$1;
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return testVector$16.appendInt(Predef$.MODULE$.Integer2int(n));
        }
        return testVector$16.appendNull();
    }

    public static final /* synthetic */ int $anonfun$new$65(Object x0$2) {
        Object object = x0$2;
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return Predef$.MODULE$.Integer2int(n);
        }
        return -1;
    }

    public static final /* synthetic */ void $anonfun$new$63(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)3)}));
        expected.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$64(testVector, x0$1)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), null, BoxesRunTime.boxToInteger((int)9)}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$65(x0$2))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$67(WritableColumnVector testVector$17, Object x0$3) {
        Object object = x0$3;
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return testVector$17.appendShort(s);
        }
        return testVector$17.appendNull();
    }

    public static final /* synthetic */ int $anonfun$new$68(Object x0$4) {
        Object object = x0$4;
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s;
        }
        return -1;
    }

    public static final /* synthetic */ void $anonfun$new$66(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1)), null, BoxesRunTime.boxToShort((short)((short)3))}));
        expected.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$67(testVector, x0$3)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)7)), null, BoxesRunTime.boxToShort((short)((short)9))}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$68(x0$4))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$70(WritableColumnVector testVector$18, Object x0$5) {
        Object object = x0$5;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return testVector$18.appendByte(by);
        }
        return testVector$18.appendNull();
    }

    public static final /* synthetic */ int $anonfun$new$71(Object x0$6) {
        Object object = x0$6;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by;
        }
        return -1;
    }

    public static final /* synthetic */ void $anonfun$new$69(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)1)), null, BoxesRunTime.boxToByte((byte)((byte)3))}));
        expected.foreach((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$70(testVector, x0$5)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)7)), null, BoxesRunTime.boxToByte((byte)((byte)9))}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$71(x0$6))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$73(WritableColumnVector testVector$19, Object x0$7) {
        Object object = x0$7;
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return testVector$19.appendLong(l);
        }
        return testVector$19.appendNull();
    }

    public static final /* synthetic */ long $anonfun$new$74(Object x0$8) {
        Object object = x0$8;
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l;
        }
        return -1L;
    }

    public static final /* synthetic */ void $anonfun$new$72(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2147483L), null, BoxesRunTime.boxToLong((long)2147485L)}));
        expected.foreach((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$73(testVector, x0$7)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), null, BoxesRunTime.boxToLong((long)0x80000002L)}));
        long[] dictArray = (long[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-1L, -1L})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$8 -> BoxesRunTime.boxToLong((long)ColumnVectorSuite.$anonfun$new$74(x0$8))))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$76(WritableColumnVector testVector$20, Object x0$9) {
        Object object = x0$9;
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return testVector$20.appendFloat(f);
        }
        return testVector$20.appendNull();
    }

    public static final /* synthetic */ float $anonfun$new$77(Object x0$10) {
        Object object = x0$10;
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f;
        }
        return -1.0f;
    }

    public static final /* synthetic */ void $anonfun$new$75(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)1.1f), null, BoxesRunTime.boxToFloat((float)3.3f)}));
        expected.foreach((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$76(testVector, x0$9)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)0.1f), null, BoxesRunTime.boxToFloat((float)0.3f)}));
        float[] dictArray = (float[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{-1.0f, -1.0f})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$10 -> BoxesRunTime.boxToFloat((float)ColumnVectorSuite.$anonfun$new$77(x0$10))))).toArray((ClassTag)ClassTag$.MODULE$.Float());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$79(WritableColumnVector testVector$21, Object x0$11) {
        Object object = x0$11;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return testVector$21.appendDouble(d);
        }
        return testVector$21.appendNull();
    }

    public static final /* synthetic */ double $anonfun$new$80(Object x0$12) {
        Object object = x0$12;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d;
        }
        return -1.0;
    }

    public static final /* synthetic */ void $anonfun$new$78(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.1), null, BoxesRunTime.boxToDouble((double)3.3)}));
        expected.foreach((Function1 & Serializable)x0$11 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$79(testVector, x0$11)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1342.17727), null, BoxesRunTime.boxToDouble((double)1342.17729)}));
        double[] dictArray = (double[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-1.0, -1.0})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$12 -> BoxesRunTime.boxToDouble((double)ColumnVectorSuite.$anonfun$new$80(x0$12))))).toArray((ClassTag)ClassTag$.MODULE$.Double());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ Assertion $anonfun$new$85(ColumnVectorSuite $this, WritableColumnVector testVector$22, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector$22.getArray(i).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{i};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
    }

    public static final /* synthetic */ void $anonfun$new$82(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> data.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> testVector.putArray(i, i, 1));
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$85($this, testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$89(WritableColumnVector testVector$23, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$23.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
    }

    public static final /* synthetic */ void $anonfun$new$87(WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i % 2 == 0) {
                testVector.putNull(i);
                return;
            }
            testVector.putNotNull(i);
        });
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$89(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$93(WritableColumnVector testVector$24, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$24.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        boolean $org_scalatest_assert_macro_left2 = testVector$24.getBoolean(i);
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
    }

    public static final /* synthetic */ void $anonfun$new$92(BooleanType$ dataType$1, ColumnBuilder columnBuilder$1, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$1, columnBuilder$1.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$93(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$97(WritableColumnVector testVector$25, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$25.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        byte $org_scalatest_assert_macro_left2 = testVector$25.getByte(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
    }

    public static final /* synthetic */ void $anonfun$new$96(ByteType$ dataType$2, ColumnBuilder columnBuilder$2, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$2, columnBuilder$2.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$97(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$101(WritableColumnVector testVector$26, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$26.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        short $org_scalatest_assert_macro_left2 = testVector$26.getShort(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
    }

    public static final /* synthetic */ void $anonfun$new$100(ShortType$ dataType$3, ColumnBuilder columnBuilder$3, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$3, columnBuilder$3.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$101(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$105(WritableColumnVector testVector$27, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$27.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        int $org_scalatest_assert_macro_left2 = testVector$27.getInt(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
    }

    public static final /* synthetic */ void $anonfun$new$104(IntegerType$ dataType$4, ColumnBuilder columnBuilder$4, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$4, columnBuilder$4.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$105(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$110(WritableColumnVector testVector$28, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$28.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
        long $org_scalatest_assert_macro_left2 = testVector$28.getLong(i);
        long $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
    }

    public static final /* synthetic */ void $anonfun$new$109(AtomicType dataType$5, ColumnBuilder columnBuilder$5, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$5, columnBuilder$5.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$110(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$107(ColumnVectorSuite $this, AtomicType dataType) {
        ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
        SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new AtomicType[]{dataType}).toImmutableArraySeq());
        row.setNullAt(0);
        columnBuilder.appendFrom((InternalRow)row, 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            row.setLong(0, (long)i);
            columnBuilder.appendFrom((InternalRow)row, 0);
        });
        $this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$109(dataType, columnBuilder, testVector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$114(WritableColumnVector testVector$29, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$29.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        float $org_scalatest_assert_macro_left2 = testVector$29.getFloat(i);
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
    }

    public static final /* synthetic */ void $anonfun$new$113(FloatType$ dataType$6, ColumnBuilder columnBuilder$6, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$6, columnBuilder$6.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$114(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$118(WritableColumnVector testVector$30, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$30.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
        double $org_scalatest_assert_macro_left2 = testVector$30.getDouble(i);
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
    }

    public static final /* synthetic */ void $anonfun$new$117(DoubleType$ dataType$7, ColumnBuilder columnBuilder$7, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$7, columnBuilder$7.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$118(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$125(ColumnVectorSuite $this, WritableColumnVector v$1, YearMonthIntervalType dt$4, int i) {
        ColumnarRow row = v$1.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
    }

    public static final /* synthetic */ void $anonfun$new$123(ColumnVectorSuite $this, YearMonthIntervalType dt$4, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$125($this, v, dt$4, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$122(ColumnVectorSuite $this, YearMonthIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors("ColumnarRow " + dt.typeName(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$123($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$129(ColumnVectorSuite $this, WritableColumnVector v$2, DayTimeIntervalType dt$5, int i) {
        ColumnarRow row = v$2.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
    }

    public static final /* synthetic */ void $anonfun$new$127(ColumnVectorSuite $this, DayTimeIntervalType dt$5, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putLong(i, (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$129($this, v, dt$5, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$126(ColumnVectorSuite $this, DayTimeIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors("ColumnarRow " + dt.typeName(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$127($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVectorSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        this.testVectors("boolean", 10, (DataType)BooleanType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$1(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("byte", 10, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$4(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("short", 10, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$7(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("int", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$10(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("date", 10, (DataType)DateType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$13(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("long", 10, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$16(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp", 10, (DataType)TimestampType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$19(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp_ntz", 10, (DataType)TimestampNTZType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$22(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("float", 10, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$25(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("double", 10, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$28(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("string", 10, (DataType)StringType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$31(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("binary", 10, (DataType)BinaryType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$34(this, testVector);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$38($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$42($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.testVectors("mutable ColumnarRow", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$45(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testVectors("array", 10, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$48(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: array append", 1, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$49(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
        this.testVectors("SPARK-35898: map", 5, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$50(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: map append", 1, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$53(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.structType = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$);
        this.testVectors("struct", 10, (DataType)this.structType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$56(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getInts with dictionary", 3, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$57(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getShorts with dictionary", 3, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$58(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getBytes with dictionary", 3, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$59(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getLongs with dictionary", 3, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$60(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getFloats with dictionary", 3, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$61(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getDoubles with dictionary", 3, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$62(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getInts with dictionary and nulls", 3, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$63(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getShorts with dictionary and nulls", 3, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$66(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getBytes with dictionary and nulls", 3, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$69(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getLongs with dictionary and nulls", 3, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$72(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getFloats with dictionary and nulls", 3, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$75(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getDoubles with dictionary and nulls", 3, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$78(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts array data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.arrayType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$82(this, testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts struct nullability", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.structType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$87(testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        this.test("CachedBatch boolean Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BooleanType$ dataType = BooleanType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new BooleanType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setBoolean(0, i % 2 == 0);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$92(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        this.test("CachedBatch byte Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ByteType$ dataType = ByteType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new ByteType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setByte(0, (byte)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$96(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        this.test("CachedBatch short Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ShortType$ dataType = ShortType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new ShortType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setShort(0, (short)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$100(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        this.test("CachedBatch int Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntegerType$ dataType = IntegerType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new IntegerType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setInt(0, i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$104(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
        this.test("CachedBatch long Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)dataType -> {
            ColumnVectorSuite.$anonfun$new$107(this, dataType);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        this.test("CachedBatch float Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FloatType$ dataType = FloatType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new FloatType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setFloat(0, (float)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$113(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        this.test("CachedBatch double Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DoubleType$ dataType = DoubleType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)new DoubleType$[]{dataType}).toImmutableArraySeq());
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setDouble(0, (double)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$117(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 822));
        this.test("SPARK-44239: Test column vector reserve policy", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.VECTORIZED_HUGE_VECTOR_THRESHOLD().key()), (Object)"300"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.VECTORIZED_HUGE_VECTOR_RESERVE_RATIO().key()), (Object)"1.2")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ByteType$ dataType = ByteType$.MODULE$;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])new WritableColumnVector[]{new OnHeapColumnVector(80, (DataType)dataType), new OffHeapColumnVector(80, (DataType)dataType)}), (Function1 & Serializable)vector -> {
                Assertion assertion;
                try {
                    vector.appendBytes(100, (byte)0);
                    int $org_scalatest_assert_macro_left = vector.capacity;
                    int $org_scalatest_assert_macro_right = 200;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
                    vector.reset();
                    int $org_scalatest_assert_macro_left2 = vector.capacity;
                    int $org_scalatest_assert_macro_right2 = 200;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
                    vector.appendBytes(300, (byte)0);
                    int $org_scalatest_assert_macro_left3 = vector.capacity;
                    int $org_scalatest_assert_macro_right3 = 360;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
                    vector.reset();
                    int $org_scalatest_assert_macro_left4 = vector.capacity;
                    int $org_scalatest_assert_macro_right4 = 80;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
                }
                finally {
                    vector.close();
                }
                return assertion;
            });
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$122(this, dt);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$126(this, dt);
            return BoxedUnit.UNIT;
        });
    }
}

