/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.CSVDataWriterFactory;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.execution.ui.CustomMetricsCSVDataWriter;
import org.apache.spark.util.SerializableConfiguration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3AAB\u0004\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\u001d\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"\u0002\u001d\u0001\t\u0003J$AG\"vgR|W.T3ue&\u001c7o\u0016:ji\u0016\u0014h)Y2u_JL(B\u0001\u0005\n\u0003\t)\u0018N\u0003\u0002\u000b\u0017\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q!\u0001G\u0006\u0002\u0013\r|gN\\3di>\u0014\u0018B\u0001\u000e\u0018\u0005Q\u00195K\u0016#bi\u0006<&/\u001b;fe\u001a\u000b7\r^8ss\u0006!\u0001/\u0019;i!\tibE\u0004\u0002\u001fIA\u0011qDI\u0007\u0002A)\u0011\u0011eE\u0001\u0007yI|w\u000e\u001e \u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\t\nQA[8c\u0013\u0012\fAaY8oMB\u0011AfL\u0007\u0002[)\u0011a&D\u0001\u0005kRLG.\u0003\u00021[\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q!1'\u000e\u001c8!\t!\u0004!D\u0001\b\u0011\u0015YB\u00011\u0001\u001d\u0011\u0015IC\u00011\u0001\u001d\u0011\u0015QC\u00011\u0001,\u00031\u0019'/Z1uK^\u0013\u0018\u000e^3s)\rQd\t\u0014\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0005u:\u0012!B<sSR,\u0017BA =\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007.\t\u0001bY1uC2L8\u000f^\u0005\u0003\u000b\n\u00131\"\u00138uKJt\u0017\r\u001c*po\")q)\u0002a\u0001\u0011\u0006Y\u0001/\u0019:uSRLwN\\%e!\tI%*D\u0001#\u0013\tY%EA\u0002J]RDQ!T\u0003A\u00029\u000ba\u0001^1tW&#\u0007CA%P\u0013\t\u0001&E\u0001\u0003M_:<\u0007")
public class CustomMetricsWriterFactory
extends CSVDataWriterFactory {
    private final String path;
    private final String jobId;
    private final SerializableConfiguration conf;

    @Override
    public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
        Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
        Path filePath = new Path(jobPath, this.jobId + "-" + partitionId + "-" + taskId);
        FileSystem fs = filePath.getFileSystem(this.conf.value());
        return new CustomMetricsCSVDataWriter(fs, filePath);
    }

    public CustomMetricsWriterFactory(String path, String jobId, SerializableConfiguration conf) {
        this.path = path;
        this.jobId = jobId;
        this.conf = conf;
        super(path, jobId, conf);
    }
}

