/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl$;
import org.apache.spark.sql.execution.streaming.ValueStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.POJOTestClass;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMultipleColumnFamiliesNotSupportedException;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.StateVariableSuiteBase;
import org.apache.spark.sql.execution.streaming.state.TestClass;
import org.apache.spark.sql.execution.streaming.state.ValueStateSuite$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.ValueState;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005i1AAA\u0002\u0001%!)q\u0003\u0001C\u00011\tya+\u00197vKN#\u0018\r^3Tk&$XM\u0003\u0002\u0005\u000b\u0005)1\u000f^1uK*\u0011aaB\u0001\ngR\u0014X-Y7j]\u001eT!\u0001C\u0005\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u0004\u0013\t12A\u0001\fTi\u0006$XMV1sS\u0006\u0014G.Z*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0001")
public class ValueStateSuite
extends StateVariableSuiteBase {
    public static final /* synthetic */ void $anonfun$new$2(ValueStateSuite $this, StateStoreProvider provider) {
        Exception ex;
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        String stateName = "testState";
        ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.scalaLong());
        Option $org_scalatest_assert_macro_left = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        Exception $org_scalatest_assert_macro_left2 = ex = (Exception)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> testState.update((Object)BoxesRunTime.boxToLong((long)123L)), ClassTag$.MODULE$.apply(Exception.class), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.SparkException", $org_scalatest_assert_macro_left2 instanceof SparkException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        SparkException x$1 = (SparkException)((Object)ex);
        String x$2 = "INTERNAL_ERROR_TWS";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("Implicit key not found in state store for stateName=" + stateName))}));
        boolean x$4 = true;
        Option x$5 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "INTERNAL_ERROR_TWS", x$5, x$3, true, x$6);
        ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption().isDefined(), "org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker.getImplicitKeyOption.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        testState.update((Object)BoxesRunTime.boxToLong((long)123L));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testState.get());
        int $org_scalatest_assert_macro_right = 123;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        ImplicitGroupingKeyTracker$.MODULE$.removeImplicitKey();
        Option $org_scalatest_assert_macro_left4 = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        Exception ex1 = (Exception)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> testState.update((Object)BoxesRunTime.boxToLong((long)123L)), ClassTag$.MODULE$.apply(Exception.class), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        SparkException x$7 = (SparkException)((Object)ex1);
        String x$8 = "INTERNAL_ERROR_TWS";
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("Implicit key not found in state store for stateName=" + stateName))}));
        boolean x$10 = true;
        Option x$11 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$12 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$7, "INTERNAL_ERROR_TWS", x$11, x$9, true, x$12);
    }

    public static final /* synthetic */ void $anonfun$new$10(ValueStateSuite $this, StateStoreProvider provider) {
        SparkUnsupportedOperationException ex;
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        String cfName = "_testState";
        SparkUnsupportedOperationException x$13 = ex = (SparkUnsupportedOperationException)$this.intercept((Function0 & Serializable)() -> handle.getValueState(cfName, Encoders$.MODULE$.scalaLong()), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        String x$14 = "STATE_STORE_CANNOT_CREATE_COLUMN_FAMILY_WITH_RESERVED_CHARS";
        Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colFamilyName"), (Object)cfName)}));
        boolean x$16 = true;
        Option x$17 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$18 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$13, "STATE_STORE_CANNOT_CREATE_COLUMN_FAMILY_WITH_RESERVED_CHARS", x$17, x$15, true, x$18);
    }

    public static final /* synthetic */ void $anonfun$new$26(ValueStateSuite $this, StatefulProcessorHandleImpl handle$2, Duration ttlDuration) {
        SparkUnsupportedOperationException ex;
        TTLConfig ttlConfig = new TTLConfig(ttlDuration);
        SparkUnsupportedOperationException x$46 = ex = (SparkUnsupportedOperationException)$this.intercept((Function0 & Serializable)() -> handle$2.getValueState("testState", Encoders$.MODULE$.STRING(), ttlConfig), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        String x$47 = "STATEFUL_PROCESSOR_TTL_DURATION_MUST_BE_POSITIVE";
        Map x$48 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)"update"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)"testState")}));
        boolean x$49 = true;
        Option x$50 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$51 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$46, "STATEFUL_PROCESSOR_TTL_DURATION_MUST_BE_POSITIVE", x$50, x$48, true, x$51);
    }

    public static final /* synthetic */ void $anonfun$new$25(ValueStateSuite $this, StateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        int batchTimestampMs = 10;
        StateStore x$39 = store;
        UUID x$40 = UUID.randomUUID();
        ExpressionEncoder x$41 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
        TimeMode x$42 = TimeMode.ProcessingTime();
        Some x$43 = new Some((Object)BoxesRunTime.boxToLong((long)batchTimestampMs));
        boolean x$44 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
        Map x$45 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$39, x$40, x$41, x$42, x$44, (Option)x$43, x$45);
        new .colon.colon(null, (List)new .colon.colon((Object)Duration.ZERO, (List)new .colon.colon((Object)Duration.ofMinutes(-1L), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)ttlDuration -> {
            ValueStateSuite.$anonfun$new$26($this, handle, ttlDuration);
            return BoxedUnit.UNIT;
        });
    }

    public ValueStateSuite() {
        this.test("Implicit key operations", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            ValueStateSuite.$anonfun$new$2(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Value state operations for single instance", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            testState.update((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right3 = 456;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right4 = 456;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            testState.update((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right5 = 123;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right6 = null;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", null, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Value state operations for multiple instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ValueState testState1 = handle.getValueState("testState1", Encoders$.MODULE$.scalaLong());
            ValueState testState2 = handle.getValueState("testState2", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState1.update((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState1.get());
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            testState1.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState1.exists(), "testState1.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState1.get());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            testState2.update((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(testState2.get());
            int $org_scalatest_assert_macro_right3 = 456;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            testState2.clear();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState2.exists(), "testState2.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(testState2.get());
            Null$ $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", null, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            testState1.update((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(testState1.get());
            int $org_scalatest_assert_macro_right5 = 456;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(testState1.get());
            int $org_scalatest_assert_macro_right6 = 456;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            testState1.update((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(testState1.get());
            int $org_scalatest_assert_macro_right7 = 123;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            testState2.update((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(testState2.get());
            int $org_scalatest_assert_macro_right8 = 123;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(testState2.get());
            int $org_scalatest_assert_macro_right9 = 123;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            testState2.update((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(testState2.get());
            int $org_scalatest_assert_macro_right10 = 456;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            testState1.clear();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState1.exists(), "testState1.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(testState1.get());
            Null$ $org_scalatest_assert_macro_right11 = null;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", null, $org_scalatest_assert_macro_left11.$eq$eq$eq($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            testState2.clear();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState2.exists(), "testState2.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(testState2.get());
            Null$ $org_scalatest_assert_macro_right12 = null;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", null, $org_scalatest_assert_macro_left12.$eq$eq$eq($org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("Value state operations for unsupported type name should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            ValueStateSuite.$anonfun$new$10(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("colFamily with HDFSBackedStateStoreProvider should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStoreMultipleColumnFamiliesNotSupportedException ex;
            StateStoreId storeId = new StateStoreId(StateStoreTestsHelper$.MODULE$.newDir(), (long)Random$.MODULE$.nextInt(), 0, StateStoreId$.MODULE$.apply$default$4());
            HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
            StateStoreConf storeConf = new StateStoreConf(new SQLConf(), StateStoreConf$.MODULE$.$lessinit$greater$default$2());
            StateStoreMultipleColumnFamiliesNotSupportedException x$19 = ex = (StateStoreMultipleColumnFamiliesNotSupportedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> provider.init(storeId, StateStoreTestsHelper$.MODULE$.keySchema(), StateStoreTestsHelper$.MODULE$.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(StateStoreTestsHelper$.MODULE$.keySchema()), true, storeConf, new Configuration(), provider.init$default$8()), ClassTag$.MODULE$.apply(StateStoreMultipleColumnFamiliesNotSupportedException.class), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            String x$20 = "UNSUPPORTED_FEATURE.STATE_STORE_MULTIPLE_COLUMN_FAMILIES";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateStoreProvider"), (Object)"HDFSBackedStateStoreProvider")}));
            boolean x$22 = true;
            Option x$23 = this.checkError$default$3();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "UNSUPPORTED_FEATURE.STATE_STORE_MULTIPLE_COLUMN_FAMILIES", x$23, x$21, true, x$24);
        }, new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("test SQL encoder - Value state operations for Primitive(Double) instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.scalaDouble());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)BoxesRunTime.boxToDouble((double)1.0));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToDouble((double)1.0)), "testState.get().equals(1.0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            testState.update((Object)BoxesRunTime.boxToDouble((double)2.0));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToDouble((double)2.0)), "testState.get().equals(2.0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            testState.update((Object)BoxesRunTime.boxToDouble((double)3.0));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToDouble((double)3.0)), "testState.get().equals(3.0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("test SQL encoder - Value state operations for Primitive(Long) instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)BoxesRunTime.boxToLong((long)1L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToLong((long)1L)), "testState.get().equals(1L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            testState.update((Object)BoxesRunTime.boxToLong((long)2L));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToLong((long)2L)), "testState.get().equals(2L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            testState.update((Object)BoxesRunTime.boxToLong((long)3L));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(testState.get().equals(BoxesRunTime.boxToLong((long)3L)), "testState.get().equals(3L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("test SQL encoder - Value state operations for case class instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ValueStateSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_streaming_state_ValueStateSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.execution.streaming.state.TestClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_execution_streaming_state_ValueStateSuite$$typecreator1$1(ValueStateSuite $outer) {
                }
            }
            ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_streaming_state_ValueStateSuite$$typecreator1$1(null))));
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)new TestClass(1L, "testcase1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((TestClass)testState.get()).equals(new TestClass(1L, "testcase1")), "testState.get().equals(TestClass.apply(1L, \"testcase1\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            testState.update((Object)new TestClass(2L, "testcase2"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get());
            TestClass $org_scalatest_assert_macro_right2 = new TestClass(2L, "testcase2");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            testState.update((Object)new TestClass(3L, "testcase3"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(testState.get());
            TestClass $org_scalatest_assert_macro_right3 = new TestClass(3L, "testcase3");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", null, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("test SQL encoder - Value state operations for POJO instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ValueState testState = handle.getValueState("testState", Encoders$.MODULE$.bean(POJOTestClass.class));
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)new POJOTestClass("testcase1", 1));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((POJOTestClass)testState.get()).equals(new POJOTestClass("testcase1", 1)), "testState.get().equals(new POJOTestClass(\"testcase1\", 1))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            testState.update((Object)new POJOTestClass("testcase2", 2));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((POJOTestClass)testState.get()).equals(new POJOTestClass("testcase2", 2)), "testState.get().equals(new POJOTestClass(\"testcase2\", 2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            testState.update((Object)new POJOTestClass("testcase3", 3));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((POJOTestClass)testState.get()).equals(new POJOTestClass("testcase3", 3)), "testState.get().equals(new POJOTestClass(\"testcase3\", 3))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("test Value state TTL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            int timestampMs = 10;
            StateStore x$25 = store;
            UUID x$26 = UUID.randomUUID();
            ExpressionEncoder x$27 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
            TimeMode x$28 = TimeMode.ProcessingTime();
            Some x$29 = new Some((Object)BoxesRunTime.boxToLong((long)timestampMs));
            boolean x$30 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$31 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$25, x$26, x$27, x$28, x$30, (Option)x$29, x$31);
            TTLConfig ttlConfig = new TTLConfig(Duration.ofMinutes(1L));
            ValueStateImplWithTTL testState = (ValueStateImplWithTTL)handle.getValueState("testState", Encoders$.MODULE$.STRING(), ttlConfig);
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.update((Object)"v1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get());
            String $org_scalatest_assert_macro_right = "v1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.getWithoutEnforcingTTL().get());
            String $org_scalatest_assert_macro_right2 = "v1";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            int ttlExpirationMs = timestampMs + 60000;
            Option ttlValue = testState.getTTLValue();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ttlValue.isDefined(), "ttlValue.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((Tuple2)ttlValue.get())._2$mcJ$sp()));
            int $org_scalatest_assert_macro_right3 = ttlExpirationMs;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            Iterator ttlStateValueIterator = testState.getValuesInTTLState();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ttlStateValueIterator.hasNext(), "ttlStateValueIterator.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            StateStore x$32 = store;
            UUID x$33 = UUID.randomUUID();
            ExpressionEncoder x$34 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
            TimeMode x$35 = TimeMode.ProcessingTime();
            Some x$36 = new Some((Object)BoxesRunTime.boxToLong((long)ttlExpirationMs));
            boolean x$37 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$38 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl nextBatchHandle = new StatefulProcessorHandleImpl(x$32, x$33, x$34, x$35, x$37, (Option)x$36, x$38);
            ValueStateImplWithTTL nextBatchTestState = (ValueStateImplWithTTL)nextBatchHandle.getValueState("testState", Encoders$.MODULE$.STRING(), ttlConfig);
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nextBatchTestState.exists(), "nextBatchTestState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(nextBatchTestState.get());
            Null$ $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", null, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            ttlValue = nextBatchTestState.getTTLValue();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(ttlValue.isDefined(), "ttlValue.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((Tuple2)ttlValue.get())._2$mcJ$sp()));
            int $org_scalatest_assert_macro_right5 = ttlExpirationMs;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            ttlStateValueIterator = nextBatchTestState.getValuesInTTLState();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ttlStateValueIterator.hasNext(), "ttlStateValueIterator.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(ttlStateValueIterator.next());
            int $org_scalatest_assert_macro_right6 = ttlExpirationMs;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            Iterator $org_scalatest_assert_macro_left7 = ttlStateValueIterator;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(nextBatchTestState.getWithoutEnforcingTTL().get());
            String $org_scalatest_assert_macro_right7 = "v1";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            nextBatchTestState.clear();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nextBatchTestState.exists(), "nextBatchTestState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(nextBatchTestState.get());
            Null$ $org_scalatest_assert_macro_right8 = null;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", null, $org_scalatest_assert_macro_left9.$eq$eq$eq($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("test negative or zero TTL duration throws error", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            ValueStateSuite.$anonfun$new$25(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("ValueStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
    }
}

