/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl$;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleState$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateVariableSuiteBase;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.ValueState;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00194Aa\u0002\u0005\u0001/!)A\u0004\u0001C\u0001;!)q\u0004\u0001C\u0005A!)q\u0006\u0001C\u0005a!)1\t\u0001C\u0005\t\")\u0001\r\u0001C\u0005C\")1\r\u0001C\u0005I\na2\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:IC:$G.Z*vSR,'BA\u0005\u000b\u0003\u0015\u0019H/\u0019;f\u0015\tYA\"A\u0005tiJ,\u0017-\\5oO*\u0011QBD\u0001\nKb,7-\u001e;j_:T!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eQR\"\u0001\u0005\n\u0005mA!AF*uCR,g+\u0019:jC\ndWmU;ji\u0016\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005q\u0002CA\r\u0001\u00039YW-_#yaJ,enY8eKJ,\u0012!\t\t\u0004E\u001dJS\"A\u0012\u000b\u0005\u0011*\u0013\u0001C3oG>$WM]:\u000b\u0005\u0019r\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005!\u001a#!E#yaJ,7o]5p]\u0016s7m\u001c3feB\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t\u0019\u0011I\\=\u0002\u0017\u001d,G\u000fV5nK6{G-\u001a\u000b\u0003cY\u0002\"A\r\u001b\u000e\u0003MR!a\u0003\b\n\u0005U\u001a$\u0001\u0003+j[\u0016lu\u000eZ3\t\u000b]\u001a\u0001\u0019\u0001\u001d\u0002\u0011QLW.Z'pI\u0016\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e,\u001b\u0005a$BA\u001f\u0017\u0003\u0019a$o\\8u}%\u0011qhK\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@W\u00051b/\u001a:jMfLeN^1mS\u0012|\u0005/\u001a:bi&|g\u000e\u0006\u0003F%RsFC\u0001$J!\tQs)\u0003\u0002IW\t!QK\\5u\u0011\u0015QE\u00011\u0001L\u0003\t1g\u000e\u0005\u0003+\u0019:3\u0015BA',\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002P!6\t!\"\u0003\u0002R\u0015\tY2\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:IC:$G.Z%na2DQa\u0015\u0003A\u00029\u000ba\u0001[1oI2,\u0007\"B+\u0005\u0001\u00041\u0016a\u00035b]\u0012dWm\u0015;bi\u0016\u0004\"a\u0016.\u000f\u0005=C\u0016BA-\u000b\u0003q\u0019F/\u0019;fMVd\u0007K]8dKN\u001cxN\u001d%b]\u0012dWm\u0015;bi\u0016L!a\u0017/\u0003\u000bY\u000bG.^3\n\u0005u[#aC#ok6,'/\u0019;j_:DQa\u0018\u0003A\u0002a\nQb\u001c9fe\u0006$\u0018n\u001c8UsB,\u0017\u0001G2sK\u0006$XMV1mk\u0016\u001cF/\u0019;f\u0013:\u001cH/\u00198dKR\u0011aI\u0019\u0005\u0006'\u0016\u0001\rAT\u0001\u000ee\u0016<\u0017n\u001d;feRKW.\u001a:\u0015\u0005\u0019+\u0007\"B*\u0007\u0001\u0004q\u0005")
public class StatefulProcessorHandleSuite
extends StateVariableSuiteBase {
    private ExpressionEncoder<Object> keyExprEncoder() {
        return (ExpressionEncoder)Encoders$.MODULE$.STRING();
    }

    private TimeMode getTimeMode(String timeMode) {
        String string = timeMode;
        switch (string == null ? 0 : string.hashCode()) {
            case -806027104: {
                if (!"ProcessingTime".equals(string)) break;
                return TimeMode.ProcessingTime();
            }
            case 2433880: {
                if (!"None".equals(string)) break;
                return TimeMode.None();
            }
            case 2035383399: {
                if (!"EventTime".equals(string)) break;
                return TimeMode.EventTime();
            }
        }
        throw new IllegalArgumentException("Invalid timeMode=" + timeMode);
    }

    private void verifyInvalidOperation(StatefulProcessorHandleImpl handle, Enumeration.Value handleState, String operationType, Function1<StatefulProcessorHandleImpl, BoxedUnit> fn) {
        SparkUnsupportedOperationException ex;
        handle.setHandleState(handleState);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(handle.getHandleState());
        Enumeration.Value $org_scalatest_assert_macro_right = handleState;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        SparkUnsupportedOperationException x$1 = ex = (SparkUnsupportedOperationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> fn.apply((Object)handle), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        String x$2 = "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_HANDLE_STATE";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)operationType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handleState"), (Object)handleState.toString())}));
        boolean x$4 = true;
        Option x$5 = this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_HANDLE_STATE", x$5, x$3, true, x$6);
    }

    private void createValueStateInstance(StatefulProcessorHandleImpl handle) {
        handle.getValueState("testState", Encoders$.MODULE$.scalaLong());
    }

    private void registerTimer(StatefulProcessorHandleImpl handle) {
        handle.registerTimer(1000L);
    }

    public static final /* synthetic */ void $anonfun$new$6(StatefulProcessorHandleSuite $this, String timeMode$2, StateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), $this.getTimeMode(timeMode$2), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.INITIALIZED(), (List)new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.DATA_PROCESSED(), (List)new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.TIMER_PROCESSED(), (List)new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.CLOSED(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)state -> {
            $this.verifyInvalidOperation(handle, state, "get_value_state", (Function1<StatefulProcessorHandleImpl, BoxedUnit>)(Function1 & Serializable)handle -> {
                $this.createValueStateInstance(handle);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(StatefulProcessorHandleSuite $this, StateStoreProvider provider) {
        SparkUnsupportedOperationException ex2;
        SparkUnsupportedOperationException ex;
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        SparkUnsupportedOperationException x$1 = ex = (SparkUnsupportedOperationException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> handle.registerTimer(10000L), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        String x$2 = "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_TIME_MODE";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)"register_timer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeMode"), (Object)TimeMode.None().toString())}));
        boolean x$4 = true;
        Option x$5 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_TIME_MODE", x$5, x$3, true, x$6);
        SparkUnsupportedOperationException x$7 = ex2 = (SparkUnsupportedOperationException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> handle.deleteTimer(10000L), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        String x$8 = "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_TIME_MODE";
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)"delete_timer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeMode"), (Object)TimeMode.None().toString())}));
        boolean x$10 = true;
        Option x$11 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$12 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$7, "STATEFUL_PROCESSOR_CANNOT_PERFORM_OPERATION_WITH_INVALID_TIME_MODE", x$11, x$9, true, x$12);
    }

    public static final /* synthetic */ void $anonfun$new$23(StatefulProcessorHandleSuite $this, String timeMode$5, StateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), $this.getTimeMode(timeMode$5), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.CREATED(), (List)new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.TIMER_PROCESSED(), (List)new .colon.colon((Object)StatefulProcessorHandleState$.MODULE$.CLOSED(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)state -> {
            $this.verifyInvalidOperation(handle, state, "register_timer", (Function1<StatefulProcessorHandleImpl, BoxedUnit>)(Function1 & Serializable)handle -> {
                $this.registerTimer(handle);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public StatefulProcessorHandleSuite() {
        new .colon.colon((Object)"None", (List)new .colon.colon((Object)"ProcessingTime", (List)new .colon.colon((Object)"EventTime", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)timeMode -> {
            this.test("value state creation with timeMode=" + timeMode + " should succeed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (ValueState)$this.tryWithProviderResource((StateStoreProvider)$this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
                StateStore store = provider.getStore(0L);
                StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), $this.getTimeMode(timeMode), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(handle.getHandleState());
                Enumeration.Value $org_scalatest_assert_macro_right = StatefulProcessorHandleState$.MODULE$.CREATED();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
                return handle.getValueState("testState", Encoders$.MODULE$.scalaLong());
            }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"None", (List)new .colon.colon((Object)"ProcessingTime", (List)new .colon.colon((Object)"EventTime", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)timeMode -> {
            this.test("value state creation with timeMode=" + timeMode + " and invalid state should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
                StatefulProcessorHandleSuite.$anonfun$new$6($this, timeMode, provider);
                return BoxedUnit.UNIT;
            }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            return BoxedUnit.UNIT;
        });
        this.test("registering processing/event time timeouts with None timeMode should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StatefulProcessorHandleSuite.$anonfun$new$10(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        new .colon.colon((Object)"ProcessingTime", (List)new .colon.colon((Object)"EventTime", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)timeMode -> {
            this.test("registering timeouts with timeMode=" + timeMode + " should succeed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)$this.tryWithProviderResource((StateStoreProvider)$this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
                StateStore store = provider.getStore(0L);
                StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), $this.getTimeMode(timeMode), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
                handle.setHandleState(StatefulProcessorHandleState$.MODULE$.INITIALIZED());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(handle.getHandleState());
                Enumeration.Value $org_scalatest_assert_macro_right = StatefulProcessorHandleState$.MODULE$.INITIALIZED();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption().isDefined(), "org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker.getImplicitKeyOption.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                handle.registerTimer(10000L);
                handle.deleteTimer(10000L);
                ImplicitGroupingKeyTracker$.MODULE$.removeImplicitKey();
                Option $org_scalatest_assert_macro_left2 = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"ProcessingTime", (List)new .colon.colon((Object)"EventTime", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)timeMode -> {
            this.test("verify listing of registered timers with timeMode=" + timeMode, (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)$this.tryWithProviderResource((StateStoreProvider)$this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
                StateStore store = provider.getStore(0L);
                StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), $this.keyExprEncoder(), $this.getTimeMode(timeMode), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
                handle.setHandleState(StatefulProcessorHandleState$.MODULE$.DATA_PROCESSED());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(handle.getHandleState());
                Enumeration.Value $org_scalatest_assert_macro_right = StatefulProcessorHandleState$.MODULE$.DATA_PROCESSED();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key1");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption().isDefined(), "org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker.getImplicitKeyOption.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                Seq timerTimestamps1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{931L, 8000L, 452300L, 4200L, 90L, 1L, 2L, 8L, 3L, 35L, 6L, 9L, 5L}));
                timerTimestamps1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> handle.registerTimer(timestamp));
                Iterator timers1 = handle.listTimers();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(timers1.toSeq().sorted((Ordering)Ordering.Long$.MODULE$));
                Seq $org_scalatest_assert_macro_right2 = (Seq)timerTimestamps1.sorted((Ordering)Ordering.Long$.MODULE$);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                ImplicitGroupingKeyTracker$.MODULE$.removeImplicitKey();
                ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key2");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption().isDefined(), "org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker.getImplicitKeyOption.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                Seq timerTimestamps2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{12000L, 14500L, 16000L}));
                timerTimestamps2.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> handle.registerTimer(timestamp));
                Iterator timers2 = handle.listTimers();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(timers2.toSeq().sorted((Ordering)Ordering.Long$.MODULE$));
                Seq $org_scalatest_assert_macro_right3 = (Seq)timerTimestamps2.sorted((Ordering)Ordering.Long$.MODULE$);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
                ImplicitGroupingKeyTracker$.MODULE$.removeImplicitKey();
                Option $org_scalatest_assert_macro_left4 = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"ProcessingTime", (List)new .colon.colon((Object)"EventTime", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)timeMode -> {
            this.test("registering timeouts with timeMode=" + timeMode + " and invalid state should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
                StatefulProcessorHandleSuite.$anonfun$new$23($this, timeMode, provider);
                return BoxedUnit.UNIT;
            }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            return BoxedUnit.UNIT;
        });
        this.test("ttl States are populated for valueState and timeMode=ProcessingTime", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store;
            StateStore x$13 = store = provider.getStore(0L);
            UUID x$14 = UUID.randomUUID();
            ExpressionEncoder<Object> x$15 = this.keyExprEncoder();
            TimeMode x$16 = TimeMode.ProcessingTime();
            Some x$17 = new Some((Object)BoxesRunTime.boxToLong((long)10L));
            boolean x$18 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$19 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$13, x$14, x$15, x$16, x$18, (Option)x$17, x$19);
            ValueState valueStateWithTTL = handle.getValueState("testState", Encoders$.MODULE$.STRING(), new TTLConfig(Duration.ofHours(1L)));
            handle.getValueState("testState", Encoders$.MODULE$.STRING());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)handle.ttlStates().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(handle.ttlStates().get(0));
            ValueState $org_scalatest_assert_macro_right2 = valueStateWithTTL;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("ttl States are populated for listState and timeMode=ProcessingTime", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store;
            StateStore x$20 = store = provider.getStore(0L);
            UUID x$21 = UUID.randomUUID();
            ExpressionEncoder<Object> x$22 = this.keyExprEncoder();
            TimeMode x$23 = TimeMode.ProcessingTime();
            Some x$24 = new Some((Object)BoxesRunTime.boxToLong((long)10L));
            boolean x$25 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$26 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$20, x$21, x$22, x$23, x$25, (Option)x$24, x$26);
            ListState listStateWithTTL = handle.getListState("testState", Encoders$.MODULE$.STRING(), new TTLConfig(Duration.ofHours(1L)));
            handle.getListState("testState", Encoders$.MODULE$.STRING());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)handle.ttlStates().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(handle.ttlStates().get(0));
            ListState $org_scalatest_assert_macro_right2 = listStateWithTTL;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("ttl States are populated for mapState and timeMode=ProcessingTime", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store;
            StateStore x$27 = store = provider.getStore(0L);
            UUID x$28 = UUID.randomUUID();
            ExpressionEncoder<Object> x$29 = this.keyExprEncoder();
            TimeMode x$30 = TimeMode.ProcessingTime();
            Some x$31 = new Some((Object)BoxesRunTime.boxToLong((long)10L));
            boolean x$32 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$33 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$27, x$28, x$29, x$30, x$32, (Option)x$31, x$33);
            MapState mapStateWithTTL = handle.getMapState("testState", Encoders$.MODULE$.STRING(), Encoders$.MODULE$.STRING(), new TTLConfig(Duration.ofHours(1L)));
            handle.getMapState("testState", Encoders$.MODULE$.STRING(), Encoders$.MODULE$.STRING());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)handle.ttlStates().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(handle.ttlStates().get(0));
            MapState $org_scalatest_assert_macro_right2 = mapStateWithTTL;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("ttl States are not populated for timeMode=None", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), this.keyExprEncoder(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            handle.getValueState("testValueState", Encoders$.MODULE$.STRING());
            handle.getListState("testListState", Encoders$.MODULE$.STRING());
            handle.getMapState("testMapState", Encoders$.MODULE$.STRING(), Encoders$.MODULE$.STRING());
            java.util.List $org_scalatest_assert_macro_left = handle.ttlStates();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }), new Position("StatefulProcessorHandleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
    }
}

