/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreMap;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\r\u001b\u0001%BQa\u000e\u0001\u0005\u0002aBQA\u000f\u0001\u0005\nmBQ!\u0016\u0001\u0005BYCQ!\u0016\u0001\u0005B]CQ!\u0016\u0001\u0005BuCQ!\u0016\u0001\u0005\u0002\u0011DQ!\u0016\u0001\u0005B=DQa\u001e\u0001\u0005BaD\u0011\"a\u0002\u0001#\u0003%\t!!\u0003\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u0019)\u0006\u0001\"\u0001\u0002D!I\u0011\u0011\u0010\u0001\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003\u0003C\u0011\"!\"\u0001#\u0003%\t!a\"\t\u0013\u0005-\u0005!%A\u0005\u0002\u00055\u0005\"CAI\u0001E\u0005I\u0011AAG\u0011%\t\u0019\nAI\u0001\n\u0003\t)\n\u0003\u0004V\u0001\u0011\u0005\u0013\u0011\u0014\u0005\u0007+\u0002!\t%!)\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0002\u0010'R\fG/Z*u_J,7+^5uK*\u00111\u0004H\u0001\u0006gR\fG/\u001a\u0006\u0003;y\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005}\u0001\u0013!C3yK\u000e,H/[8o\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\r\u0001!&\r\t\u0004W1rS\"\u0001\u000e\n\u00055R\"aE*uCR,7\u000b^8sKN+\u0018\u000e^3CCN,\u0007CA\u00160\u0013\t\u0001$D\u0001\u000fI\t\u001a\u001b&)Y2lK\u0012\u001cF/\u0019;f'R|'/\u001a)s_ZLG-\u001a:\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0013!C:dC2\fG/Z:u\u0013\t14G\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u0005I\u0004CA\u0016\u0001\u0003}1XM]5gsN#xN]3Pa\u0016\u0014\u0018\r^5p]Vs7/\u001e9q_J$X\r\u001a\u000b\u0003y!#\"!P\"\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\tUs\u0017\u000e\u001e\u0005\u0007\t\n!\t\u0019A#\u0002\rQ,7\u000f\u001e$o!\rqd)P\u0005\u0003\u000f~\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006\u0013\n\u0001\rAS\u0001\u000e_B,'/\u0019;j_:t\u0015-\\3\u0011\u0005-\u0013fB\u0001'Q!\tiu(D\u0001O\u0015\ty\u0005&\u0001\u0004=e>|GOP\u0005\u0003#~\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011kP\u0001\u0011]\u0016<8\u000b^8sKB\u0013xN^5eKJ$\u0012A\f\u000b\u0003]aCQ!\u0017\u0003A\u0002i\u000bqa\u001d;pe\u0016LE\r\u0005\u0002,7&\u0011AL\u0007\u0002\r'R\fG/Z*u_J,\u0017\n\u001a\u000b\u0004]y{\u0006\"B-\u0006\u0001\u0004Q\u0006\"\u00021\u0006\u0001\u0004\t\u0017!E;tK\u000e{G.^7o\r\u0006l\u0017\u000e\\5fgB\u0011aHY\u0005\u0003G~\u0012qAQ8pY\u0016\fg\u000eF\u0002/K\u001aDQ!\u0017\u0004A\u0002iCQa\u001a\u0004A\u0002!\fAaY8oMB\u0011\u0011.\\\u0007\u0002U*\u0011qm\u001b\u0006\u0003Y\u0012\na\u0001[1e_>\u0004\u0018B\u00018k\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]R\u0019a\u0006];\t\u000bE<\u0001\u0019\u0001:\u0002)5Lg\u000eR3mi\u0006\u001chi\u001c:T]\u0006\u00048\u000f[8u!\tq4/\u0003\u0002u\u007f\t\u0019\u0011J\u001c;\t\u000bY<\u0001\u0019\u0001:\u000239,Xn\u00144WKJ\u001cHk\u001c*fi\u0006Lg.\u00138NK6|'/_\u0001\u000eO\u0016$H*\u0019;fgR$\u0015\r^1\u0015\u000be\f\t!!\u0002\u0011\u0007-SH0\u0003\u0002|)\n\u00191+\u001a;\u0011\tyjxP]\u0005\u0003}~\u0012a\u0001V;qY\u0016\u0014\u0004\u0003\u0002 ~\u0015JDa!a\u0001\t\u0001\u0004q\u0013!D:u_J,\u0007K]8wS\u0012,'\u000fC\u0004a\u0011A\u0005\t\u0019A1\u0002/\u001d,G\u000fT1uKN$H)\u0019;bI\u0011,g-Y;mi\u0012\u0012TCAA\u0006U\r\t\u0017QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011D \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069q-\u001a;ECR\fGcB=\u0002$\u0005\u001d\u00121\u0006\u0005\u0007\u0003KQ\u0001\u0019\u0001\u0018\u0002\u0011A\u0014xN^5eKJDa!!\u000b\u000b\u0001\u0004\u0011\u0018a\u0002<feNLwN\u001c\u0005\bA*\u0001\n\u00111\u0001b\u0003E9W\r\u001e#bi\u0006$C-\u001a4bk2$HeM\u0001\u0012O\u0016$H)\u001a4bk2$8+\u0015'D_:4GCBA\u001a\u0003\u007f\t\t\u0005\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004I\u0001\tS:$XM\u001d8bY&!\u0011QHA\u001c\u0005\u001d\u0019\u0016\u000bT\"p]\u001aDQ!\u001d\u0007A\u0002IDQA\u001e\u0007A\u0002I$\u0012CLA#\u0003\u001f\n\u0019&!\u0018\u0002n\u0005E\u00141OA;\u0011\u001d\t9%\u0004a\u0001\u0003\u0013\nAa\u001c9JIB\u0019a(a\u0013\n\u0007\u00055sH\u0001\u0003M_:<\u0007BBA)\u001b\u0001\u0007!/A\u0005qCJ$\u0018\u000e^5p]\"I\u0011QK\u0007\u0011\u0002\u0003\u0007\u0011qK\u0001\u0014W\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003Xm\u0019\t\u0004W\u0005e\u0013bAA.5\t\u00192*Z=Ti\u0006$X-\u00128d_\u0012,'o\u00159fG\"I\u0011qL\u0007\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\nW\u0016L8k\u00195f[\u0006\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003O\u0002\u0013!\u0002;za\u0016\u001c\u0018\u0002BA6\u0003K\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011!\ty'\u0004I\u0001\u0002\u0004Q\u0015a\u00013je\"9\u0011/\u0004I\u0001\u0002\u0004\u0011\bb\u0002<\u000e!\u0003\u0005\rA\u001d\u0005\t\u0003oj\u0001\u0013!a\u0001Q\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u000259,wo\u0015;pe\u0016\u0004&o\u001c<jI\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u$\u0006BA,\u0003\u001b\t!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a!+\t\u0005\u0005\u0014QB\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0013S3ASA\u0007\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tyIK\u0002s\u0003\u001b\t!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uI]\n!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uIa*\"!a&+\u0007!\fi\u0001F\u0004/\u00037\u000bi*a(\t\u000f\u0005}C\u00031\u0001\u0002b!9\u0011Q\u000b\u000bA\u0002\u0005]\u0003\"\u00021\u0015\u0001\u0004\tGc\u0001\u0018\u0002$\")\u0001-\u0006a\u0001C\u0006\u00192\r[3dW2{\u0017\rZ3e-\u0016\u00148/[8ogRIQ(!+\u0002D\u0006\u001d\u00171\u001a\u0005\b\u0003W3\u0002\u0019AAW\u0003)aw.\u00193fI6\u000b\u0007o\u001d\t\t\u0003_\u000bI,!\u0013\u0002>6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0003vi&d'BAA\\\u0003\u0011Q\u0017M^1\n\t\u0005m\u0016\u0011\u0017\u0002\n'>\u0014H/\u001a3NCB\u00042aKA`\u0013\r\t\tM\u0007\u0002\u0018\u0011\u001235KQ1dW\u0016$7\u000b^1uKN#xN]3NCBDa!!2\u0017\u0001\u0004\u0011\u0018!B2pk:$\bbBAe-\u0001\u0007\u0011\u0011J\u0001\fK\u0006\u0014H.[3ti.+\u0017\u0010C\u0004\u0002NZ\u0001\r!!\u0013\u0002\u00131\fG/Z:u\u0017\u0016L\u0018\u0001D2iK\u000e\\g+\u001a:tS>tGcB\u001f\u0002T\u0006U\u0017q\u001b\u0005\b\u0003W;\u0002\u0019AAW\u0011\u001d\tIc\u0006a\u0001\u0003\u0013Bq!!7\u0018\u0001\u0004\tY.\u0001\u0007fqB,7\r^3e\t\u0006$\u0018\rE\u0003L\u0003;|(/C\u0002\u0002`R\u00131!T1q\u0003-\u0019wN\u001d:vaR4\u0015\u000e\\3\u0015\u000fu\n)/a:\u0002j\"1\u0011Q\u0005\rA\u00029Bq!!\u000b\u0019\u0001\u0004\tI\u0005\u0003\u0004\u0002lb\u0001\r!Y\u0001\u000bSN\u001cf.\u00199tQ>$\bf\u0001\u0001\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\n\nA\u0001^1hg&!\u0011\u0011`Az\u0005=)\u0005\u0010^3oI\u0016$7+\u0015'UKN$\b")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter {
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private void verifyStoreOperationUnsupported(String operationName, Function0<BoxedUnit> testFn) {
        SparkUnsupportedOperationException ex;
        String string = operationName;
        String string2 = "merge";
        if (string == null ? string2 != null : !string.equals(string2)) {
            SparkUnsupportedOperationException ex2;
            SparkUnsupportedOperationException x$1 = ex2 = (SparkUnsupportedOperationException)this.intercept(testFn, ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            String x$2 = "UNSUPPORTED_FEATURE.STATE_STORE_MULTIPLE_COLUMN_FAMILIES";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateStoreProvider"), (Object)"HDFSBackedStateStoreProvider")}));
            boolean x$4 = true;
            Option x$5 = this.checkError$default$3();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "UNSUPPORTED_FEATURE.STATE_STORE_MULTIPLE_COLUMN_FAMILIES", x$5, x$3, true, x$6);
            return;
        }
        SparkUnsupportedOperationException x$7 = ex = (SparkUnsupportedOperationException)this.intercept(testFn, ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        String x$8 = "STATE_STORE_UNSUPPORTED_OPERATION";
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)operationName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity"), (Object)"HDFSBackedStateStoreProvider")}));
        boolean x$10 = true;
        Option x$11 = this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$7, "STATE_STORE_UNSUPPORTED_OPERATION", x$11, x$9, true, x$12);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7(), this.newStoreProvider$default$8());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        KeyStateEncoderSpec x$4 = this.newStoreProvider$default$3();
        StructType x$5 = this.newStoreProvider$default$4();
        int x$6 = this.newStoreProvider$default$6();
        int x$7 = this.newStoreProvider$default$7();
        Configuration x$8 = this.newStoreProvider$default$8();
        return this.newStoreProvider(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId, boolean useColumnFamilies) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        KeyStateEncoderSpec x$4 = this.newStoreProvider$default$3();
        StructType x$5 = this.newStoreProvider$default$4();
        int x$6 = this.newStoreProvider$default$6();
        int x$7 = this.newStoreProvider$default$7();
        Configuration x$8 = this.newStoreProvider$default$8();
        return this.newStoreProvider(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId, Configuration conf) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        Configuration x$4 = conf;
        KeyStateEncoderSpec x$5 = this.newStoreProvider$default$3();
        StructType x$6 = this.newStoreProvider$default$4();
        int x$7 = this.newStoreProvider$default$6();
        int x$8 = this.newStoreProvider$default$7();
        return this.newStoreProvider(x$1, x$2, x$5, x$6, x$3, x$7, x$8, x$4);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        long x$1 = Random$.MODULE$.nextInt();
        boolean x$2 = false;
        int x$3 = minDeltasForSnapshot;
        int x$4 = numOfVersToRetainInMemory;
        KeyStateEncoderSpec x$5 = this.newStoreProvider$default$3();
        StructType x$6 = this.newStoreProvider$default$4();
        String x$7 = this.newStoreProvider$default$5();
        Configuration x$8 = this.newStoreProvider$default$8();
        return this.newStoreProvider(x$1, 0, x$5, x$6, x$7, x$3, x$4, x$8);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider, boolean useColumnFamilies) {
        return this.getData(storeProvider, -1, useColumnFamilies);
    }

    public boolean getLatestData$default$2() {
        return false;
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getData(HDFSBackedStateStoreProvider provider, int version, boolean useColumnFamilies) {
        return (Set)this.tryWithProviderResource(this.newStoreProvider(provider.stateStoreId(), useColumnFamilies), (Function1 & Serializable)reloadedProvider -> {
            if (version < 0) {
                return reloadedProvider.latestIterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
            }
            StateStore qual$1 = reloadedProvider.getStore((long)version);
            String x$1 = qual$1.iterator$default$1();
            return qual$1.iterator(x$1).map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
        });
    }

    public boolean getData$default$3() {
        return false;
    }

    @Override
    public SQLConf getDefaultSQLConf(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY(), (Object)BoxesRunTime.boxToInteger((int)numOfVersToRetainInMemory));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_COMPRESSION_CODEC(), (Object)SQLConf$.MODULE$.get().stateStoreCompressionCodec());
        return sqlConf;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, KeyStateEncoderSpec keyStateEncoderSpec, StructType keySchema, String dir, int minDeltasForSnapshot, int numOfVersToRetainInMemory, Configuration hadoopConf) {
        SQLConf sqlConf = this.getDefaultSQLConf(minDeltasForSnapshot, numOfVersToRetainInMemory);
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), keySchema, this.valueSchema(), keyStateEncoderSpec, false, new StateStoreConf(sqlConf, StateStoreConf$.MODULE$.$lessinit$greater$default$2()), hadoopConf, provider.init$default$8());
        return provider;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StructType keySchema, KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies) {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, keyStateEncoderSpec, this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7(), this.newStoreProvider$default$8());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(boolean useColumnFamilies) {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7(), this.newStoreProvider$default$8());
    }

    public KeyStateEncoderSpec newStoreProvider$default$3() {
        return new NoPrefixKeyStateEncoderSpec(this.keySchema());
    }

    public StructType newStoreProvider$default$4() {
        return this.keySchema();
    }

    public String newStoreProvider$default$5() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$6() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public int newStoreProvider$default$7() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get());
    }

    public Configuration newStoreProvider$default$8() {
        return new Configuration();
    }

    public void checkLoadedVersions(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, int count, long earliestKey, long latestKey) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(loadedMaps.firstKey());
        long $org_scalatest_assert_macro_right2 = earliestKey;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1020));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(loadedMaps.lastKey());
        long $org_scalatest_assert_macro_right3 = latestKey;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1021));
    }

    public void checkVersion(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, long version, Map<Tuple2<String, Object>, Object> expectedData) {
        Map originValueMap = ((HDFSBackedStateStoreMap)loadedMaps.get(BoxesRunTime.boxToLong((long)version))).iterator().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StateStoreTestsHelper$.MODULE$.keyRowToData(entry.key())), (Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(entry.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originValueMap);
        Map<Tuple2<String, Object>, Object> $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? version + ".snapshot" : version + ".delta";
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    public static final /* synthetic */ void $anonfun$new$4(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 2L, 1L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 3L, 2L);
        $this.checkVersion(loadedMaps, 3L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}))));
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
    }

    public static final /* synthetic */ void $anonfun$new$6(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        UnsafeRow keyRow = StateStoreTestsHelper$.MODULE$.dataToKeyRow("a", 0);
        UnsafeRow valueRow = StateStoreTestsHelper$.MODULE$.dataToValueRow(1);
        String colFamilyName = "test";
        $this.verifyStoreOperationUnsupported("put", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.put(keyRow, valueRow, colFamilyName));
        $this.verifyStoreOperationUnsupported("remove", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.remove(keyRow, colFamilyName));
        $this.verifyStoreOperationUnsupported("get", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.get(keyRow, colFamilyName));
        $this.verifyStoreOperationUnsupported("merge", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.merge(keyRow, valueRow, colFamilyName));
        $this.verifyStoreOperationUnsupported("iterator", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.iterator(colFamilyName));
        $this.verifyStoreOperationUnsupported("prefixScan", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> store.prefixScan(keyRow, colFamilyName));
    }

    public static final /* synthetic */ void $anonfun$new$17(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        currentVersion = 1;
        StateStore store = provider.getStore((long)currentVersion);
        StateStoreTestsHelper$.MODULE$.put(store, "a", 0, -2);
        store.commit();
        ++currentVersion;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider, false));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}))));
    }

    public static final /* synthetic */ boolean $anonfun$new$26(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    public static final /* synthetic */ void $anonfun$new$28(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        SparkException e;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = provider.getStore((long)(i - 1));
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            provider.doMaintenance();
        });
        int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable)() -> $this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getData(provider, snapshotVersion, false));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        $this.corruptFile(provider, snapshotVersion, true);
        SparkException x$55 = e = (SparkException)((Object)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion, false), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337)));
        String x$56 = "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED";
        Map x$57 = Predef$.MODULE$.Map().empty();
        Option x$58 = $this.checkError$default$3();
        boolean x$59 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$60 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$55, "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED", x$58, x$57, x$59, x$60);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getData(provider, snapshotVersion - 1, $this.getData$default$3()));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        $this.corruptFile(provider, snapshotVersion - 1, false);
        SparkException x$61 = e = (SparkException)((Object)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion - 1, $this.getData$default$3()), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349)));
        String x$62 = "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED";
        Map x$63 = Predef$.MODULE$.Map().empty();
        Option x$64 = $this.checkError$default$3();
        boolean x$65 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$66 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$61, "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED", x$64, x$63, x$65, x$66);
        $this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
        e = (SparkException)((Object)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion - 1, $this.getData$default$3()), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360)));
        SparkThrowable x$67 = (SparkThrowable)e.getCause();
        String x$68 = "CANNOT_LOAD_STATE_STORE.CANNOT_READ_DELTA_FILE_NOT_EXISTS";
        Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileToRead"), (Object)(provider.stateStoreId().storeCheckpointLocation() + "/1.delta")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)String.valueOf(provider.toString()))}));
        Option x$70 = $this.checkError$default$3();
        boolean x$71 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$72 = $this.checkError$default$6();
        $this.checkError(x$67, "CANNOT_LOAD_STATE_STORE.CANNOT_READ_DELTA_FILE_NOT_EXISTS", x$70, x$69, x$71, x$72);
    }

    public static final /* synthetic */ boolean $anonfun$new$36(Tuple2 x$2) {
        String string = ((StateStoreCustomMetric)x$2._1()).name();
        String string2 = "stateOnCurrentVersionSizeBytes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getSizeOfStateForCurrentVersion$1(StateStoreMetrics metrics) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$36(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    public static final /* synthetic */ String $anonfun$new$40(int i) {
        return "a" + i;
    }

    public static final /* synthetic */ void $anonfun$new$41(HDFSBackedStateStoreProvider.HDFSBackedStateStore store$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            int v = tuple2._2$mcI$sp();
            StateStoreTestsHelper$.MODULE$.put((StateStore)store$2, k, 0, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$1, this.keySchema(), this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(this.keySchema()), (long)latestStoreVersion$1.elem, false, storeConf$1, hadoopConf$1, StateStore$.MODULE$.get$default$9());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$46(StateStoreSuite $this, Span timeoutDuration$1, StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1, StateStoreProviderId storeProviderId2$1, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492)));
        coordinatorRef.deactivateInstances(storeProviderId1$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec($this.keySchema()), (long)latestStoreVersion$1.elem, false, storeConf$1, hadoopConf$1, StateStore$.MODULE$.get$default$9());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec($this.keySchema()), (long)latestStoreVersion$1.elem, false, storeConf$1, hadoopConf$1, StateStore$.MODULE$.get$default$9());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        StateStore$.MODULE$.get(storeProviderId2$1, $this.keySchema(), $this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec($this.keySchema()), 0L, false, storeConf$1, hadoopConf$1, StateStore$.MODULE$.get$default$9());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2$1), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
    }

    private final void generateStoreVersions$2(StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$2, this.keySchema(), this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(this.keySchema()), (long)latestStoreVersion$2.elem, false, storeConf$2, hadoopConf$2, StateStore$.MODULE$.get$default$9());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$2.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$60(StateStoreSuite $this, Span timeoutDuration$2, StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$2.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        coordinatorRef.deactivateInstances(storeProviderId1$2.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$2), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$70(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$7, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        if (deltaFileDir$1.exists()) {
            return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$3 -> x$3.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)n.endsWith(".tmp")));
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$79(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        if (deltaFileDir$1.exists()) {
            return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$4 -> x$4.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$79(n)));
        }
        return 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$82(Tuple2 x$5) {
        Object object = x$5._1();
        String string = "a";
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(MemoryStream inputData$1, File checkpointLocation$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Nil$.MODULE$).agg((Column)functions$.MODULE$.count("*"), (Seq)Nil$.MODULE$);
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$85(SparkSession spark) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active()), (Function1 & Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ String $anonfun$new$90(long x$7) {
        return Long.toString(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$new$95(String name$1, Tuple2 x$8) {
        String string = ((StateStoreCustomMetric)x$8._1()).name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getCustomMetric$1(StateStoreMetrics metrics, String name) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$95(name, x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private static final long getLoadedMapSizeMetric$1(StateStoreMetrics metrics) {
        return metrics.memoryUsedBytes();
    }

    private final void assertCacheHitAndMiss$1(StateStoreMetrics metrics, long expectedCacheHitCount, long expectedCacheMissCount) {
        long cacheHitCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheHitCount");
        long cacheMissCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheMissCount");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheHitCount));
        long $org_scalatest_assert_macro_right = expectedCacheHitCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheMissCount));
        long $org_scalatest_assert_macro_right2 = expectedCacheMissCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
    }

    public static final /* synthetic */ boolean $anonfun$new$97(Tuple2 x$9) {
        return ((String)x$9._1()).startsWith("a");
    }

    public static final /* synthetic */ void $anonfun$new$96(StateStoreSuite $this, ObjectRef store$4, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider provider) {
        long loadedMapSizeForVersion1And2;
        long initialLoadedMapSize;
        Set<Tuple2<Tuple2<String, Object>, Object>> $org_scalatest_assert_macro_left = $this.getLatestData(provider, false);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854));
        store$4.elem = provider.getStore(0L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((StateStore)store$4.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$4.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        long $org_scalatest_assert_macro_left3 = initialLoadedMapSize = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$4.elem).metrics());
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        $this.assertCacheHitAndMiss$1(((StateStore)store$4.elem).metrics(), 0L, 0L);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$4.elem, "a", 0, 1);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$4.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$4.elem, "b", 0, 2);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$4.elem, "aa", 0, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$4.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right4 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        StateStoreTestsHelper$.MODULE$.remove((StateStore)store$4.elem, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$97(x$9)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$4.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$4.elem).commit()));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((StateStore)store$4.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
        long $org_scalatest_assert_macro_left8 = loadedMapSizeForVersion1$1.elem = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$4.elem).metrics());
        long $org_scalatest_assert_macro_right7 = initialLoadedMapSize;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        $this.assertCacheHitAndMiss$1(((StateStore)store$4.elem).metrics(), 0L, 0L);
        StateStore storeV2 = provider.getStore(1L);
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right8 = 1;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        StateStoreTestsHelper$.MODULE$.put(storeV2, "cc", 0, 4);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right9 = 2;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.commit()));
        int $org_scalatest_assert_macro_right10 = 2;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
        long $org_scalatest_assert_macro_left12 = loadedMapSizeForVersion1And2 = StateStoreSuite.getLoadedMapSizeMetric$1(storeV2.metrics());
        long $org_scalatest_assert_macro_right11 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
        $this.assertCacheHitAndMiss$1(storeV2.metrics(), 1L, 0L);
    }

    public static final /* synthetic */ void $anonfun$new$98(StateStoreSuite $this, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider reloadedProvider) {
        StateStore reloadedStore = reloadedProvider.getStore(1L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStore.metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
        $this.assertCacheHitAndMiss$1(reloadedStore.metrics(), 0L, 1L);
        StateStore reloadedStoreV2 = reloadedProvider.getStore(2L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStoreV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 907));
        long $org_scalatest_assert_macro_left3 = StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStoreV2.metrics());
        long $org_scalatest_assert_macro_right3 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
        $this.assertCacheHitAndMiss$1(reloadedStoreV2.metrics(), 0L, 2L);
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("retaining only two latest versions when MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource(this.newStoreProvider(10, 2), (Function1 & Serializable)provider -> {
            StateStoreSuite.$anonfun$new$4(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("get, put, remove etc operations on non-default col family should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$1 = Random$.MODULE$.nextInt();
            boolean x$2 = false;
            int x$3 = 5;
            KeyStateEncoderSpec x$4 = this.newStoreProvider$default$3();
            StructType x$5 = this.newStoreProvider$default$4();
            String x$6 = this.newStoreProvider$default$5();
            int x$7 = this.newStoreProvider$default$7();
            Configuration x$8 = this.newStoreProvider$default$8();
            this.tryWithProviderResource(this.newStoreProvider(x$1, 0, x$4, x$5, x$6, 5, x$7, x$8), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$6(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("running with range scan encoder should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkUnsupportedOperationException ex;
            SparkUnsupportedOperationException x$9 = ex = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable)() -> (StateStore)this.tryWithProviderResource(this.newStoreProvider(StateStoreTestsHelper$.MODULE$.keySchemaWithRangeScan(), (KeyStateEncoderSpec)new RangeKeyScanStateEncoderSpec(StateStoreTestsHelper$.MODULE$.keySchemaWithRangeScan(), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), false), (Function1 & Serializable)provider -> provider.getStore(0L)), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            String x$10 = "STATE_STORE_UNSUPPORTED_OPERATION";
            Map x$11 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)"Range scan"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity"), (Object)"HDFSBackedStateStoreProvider")}));
            boolean x$12 = true;
            Option x$13 = this.checkError$default$3();
            SparkFunSuite.ExpectedContext[] x$14 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$9, "STATE_STORE_UNSUPPORTED_OPERATION", x$13, x$11, true, x$14);
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("failure after committing with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$15 = Random$.MODULE$.nextInt();
            boolean x$16 = false;
            boolean x$17 = true;
            KeyStateEncoderSpec x$18 = this.newStoreProvider$default$3();
            StructType x$19 = this.newStoreProvider$default$4();
            String x$20 = this.newStoreProvider$default$5();
            int x$21 = this.newStoreProvider$default$6();
            Configuration x$22 = this.newStoreProvider$default$8();
            this.tryWithProviderResource(this.newStoreProvider(x$15, 0, x$18, x$19, x$20, x$21, 1, x$22), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$17(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("no cache data with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 0", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$23 = Random$.MODULE$.nextInt();
            boolean x$24 = false;
            boolean x$25 = false;
            KeyStateEncoderSpec x$26 = this.newStoreProvider$default$3();
            StructType x$27 = this.newStoreProvider$default$4();
            String x$28 = this.newStoreProvider$default$5();
            int x$29 = this.newStoreProvider$default$6();
            Configuration x$30 = this.newStoreProvider$default$8();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$23, 0, x$26, x$27, x$28, x$29, 0, x$30), (Function1 & Serializable)provider -> {
                int currentVersion = 0;
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
                SortedMap loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false));
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("cleaning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$31 = Random$.MODULE$.nextInt();
            boolean x$32 = false;
            int x$33 = 5;
            KeyStateEncoderSpec x$34 = this.newStoreProvider$default$3();
            StructType x$35 = this.newStoreProvider$default$4();
            String x$36 = this.newStoreProvider$default$5();
            int x$37 = this.newStoreProvider$default$7();
            Configuration x$38 = this.newStoreProvider$default$8();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$31, 0, x$34, x$35, x$36, 5, x$37, x$38), (Function1 & Serializable)provider -> {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    StateStore store = provider.getStore((long)(i - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
                    store.commit();
                    provider.doMaintenance();
                });
                Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowPairsToDataSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 20, false));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 19, false));
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)19))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.testQuietly("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$39 = Random$.MODULE$.nextInt();
            boolean x$40 = false;
            Configuration x$41 = conf;
            KeyStateEncoderSpec x$42 = this.newStoreProvider$default$3();
            StructType x$43 = this.newStoreProvider$default$4();
            String x$44 = this.newStoreProvider$default$5();
            int x$45 = this.newStoreProvider$default$6();
            int x$46 = this.newStoreProvider$default$7();
            this.tryWithProviderResource(this.newStoreProvider(x$39, 0, x$42, x$43, x$44, x$45, x$46, x$41), (Function1 & Serializable)provider -> {
                Iterable tempFiles;
                provider.getStore(0L).commit();
                provider.getStore(0L).commit();
                Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$26(x$1)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            });
        });
        this.test("corrupted file handling", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$47 = Random$.MODULE$.nextInt();
            boolean x$48 = false;
            int x$49 = 5;
            KeyStateEncoderSpec x$50 = this.newStoreProvider$default$3();
            StructType x$51 = this.newStoreProvider$default$4();
            String x$52 = this.newStoreProvider$default$5();
            int x$53 = this.newStoreProvider$default$7();
            Configuration x$54 = this.newStoreProvider$default$8();
            this.tryWithProviderResource(this.newStoreProvider(x$47, 0, x$50, x$51, x$52, 5, x$53, x$54), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$28(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("reports memory usage on current version", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, 1);
            store.commit();
            long $org_scalatest_assert_macro_left = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("SPARK-48105: state store unload/close happens during the maintenance", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$73 = Random$.MODULE$.nextInt();
            boolean x$74 = false;
            boolean x$75 = true;
            KeyStateEncoderSpec x$76 = this.newStoreProvider$default$3();
            StructType x$77 = this.newStoreProvider$default$4();
            String x$78 = this.newStoreProvider$default$5();
            int x$79 = this.newStoreProvider$default$7();
            Configuration x$80 = this.newStoreProvider$default$8();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$73, 0, x$76, x$77, x$78, 1, x$79, x$80), (Function1 & Serializable)provider -> {
                HDFSBackedStateStoreProvider.HDFSBackedStateStore store = (HDFSBackedStateStoreProvider.HDFSBackedStateStore)provider.getStore(0L);
                Range.Inclusive values = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20);
                IndexedSeq keys = values.map((Function1 & Serializable)i -> StateStoreSuite.$anonfun$new$40(BoxesRunTime.unboxToInt((Object)i)));
                ((IndexedSeqOps)keys.zip((IterableOnce)values)).map((Function1 & Serializable)x0$1 -> {
                    StateStoreSuite.$anonfun$new$41(store, x0$1);
                    return BoxedUnit.UNIT;
                });
                store.commit();
                Iterator storeIterator = store.iterator(store.iterator$default$1());
                ArrayBuffer outputKeys = new ArrayBuffer();
                ArrayBuffer outputValues = new ArrayBuffer();
                int cnt = 0;
                while (storeIterator.hasNext()) {
                    UnsafeRowPair unsafeRowPair;
                    Tuple2<String, Object> tuple2;
                    if (cnt == 10) {
                        provider.close();
                    }
                    if ((tuple2 = StateStoreTestsHelper$.MODULE$.keyRowToData((unsafeRowPair = (UnsafeRowPair)storeIterator.next()).key())) == null) {
                        throw new MatchError(tuple2);
                    }
                    String key = (String)tuple2._1();
                    String key2 = key;
                    outputKeys.append((Object)key2);
                    outputValues.append((Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(unsafeRowPair.value())));
                    ++cnt;
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(keys.sorted((Ordering)Ordering.String$.MODULE$));
                ArrayBuffer $org_scalatest_assert_macro_right = (ArrayBuffer)outputKeys.sorted((Ordering)Ordering.String$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(values.sorted((Ordering)Ordering.Int$.MODULE$));
                ArrayBuffer $org_scalatest_assert_macro_right2 = (ArrayBuffer)outputValues.sorted((Ordering)Ordering.Int$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("maintenance", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            String dir2 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(dir2, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)10L));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(SparkContext$.MODULE$.getOrCreate(conf), (Function1 & Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$46($this, timeoutDuration$1, storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1, storeProviderId2$1, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("SPARK-40492: maintenance before unload", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-40492");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute()).toMillis()));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            package$.MODULE$.quietly((Function0)(JFunction0.mcV.sp & Serializable)() -> LocalSparkContext$.MODULE$.withSpark(SparkContext$.MODULE$.getOrCreate(conf), (Function1 & Serializable)sc -> {
                StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                    StateStoreSuite.$anonfun$new$60($this, timeoutDuration$2, storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2, coordinatorRef);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("snapshotting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(5, 2), (Function1 & Serializable)provider -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            int currentVersion = 0;
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 2);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentVersion).foreach((Function1 & Serializable)i -> StateStoreSuite.$anonfun$new$70(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 6);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()), false));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 20);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider, false));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(dir + "/0/0/");
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(this.keySchema()), 0L, false, storeConf, hadoopConf, StateStore$.MODULE$.get$default$9()), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 0, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(this.keySchema()), 1L, false, storeConf, hadoopConf, StateStore$.MODULE$.get$default$9()), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$82(x$5)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (KeyStateEncoderSpec)new NoPrefixKeyStateEncoderSpec(this.keySchema()), 2L, false, storeConf, hadoopConf, StateStore$.MODULE$.get$default$9()), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir().getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$85(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        this.test("error writing [version].delta cancels the output stream", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir().getAbsolutePath();
            long x$81 = Random$.MODULE$.nextInt();
            boolean x$82 = false;
            String x$83 = remoteDir;
            Configuration x$84 = hadoopConf;
            KeyStateEncoderSpec x$85 = this.newStoreProvider$default$3();
            StructType x$86 = this.newStoreProvider$default$4();
            int x$87 = this.newStoreProvider$default$6();
            int x$88 = this.newStoreProvider$default$7();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$81, 0, x$85, x$86, x$83, x$87, x$88, x$84), (Function1 & Serializable)provider -> {
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable)version -> {
                    StateStore store = provider.getStore((long)(version - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, Integer.toString(version), 0, version);
                    return store.commit();
                });
                Set version10Data = ((IterableOnceOps)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable)x$7 -> StateStoreSuite.$anonfun$new$90(BoxesRunTime.unboxToLong((Object)x$7)))).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x))).toSet();
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store = provider.getStore(10L);
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
                StateStoreTestsHelper$.MODULE$.put(store, "11", 0, 11);
                SparkException e = (SparkException)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable)() -> store.commit())), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815)))));
                Throwable $org_scalatest_assert_macro_left = e.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right = "Cannot perform commit";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store2 = provider.getStore(10L);
                StateStoreTestsHelper$.MODULE$.put(store2, "11", 0, 11);
                store2.abort();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        this.test("expose metrics with custom metrics to StateStoreMetrics", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef store = ObjectRef.create(null);
            LongRef loadedMapSizeForVersion1 = LongRef.create((long)-1L);
            this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$96(this, store, loadedMapSizeForVersion1, provider);
                return BoxedUnit.UNIT;
            });
            this.tryWithProviderResource(this.newStoreProvider(((StateStore)store.elem).id()), (Function1 & Serializable)reloadedProvider -> {
                StateStoreSuite.$anonfun$new$98(this, loadedMapSizeForVersion1, reloadedProvider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
        Statics.releaseFence();
    }
}

