/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.time.Duration;
import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateVariableSuiteBase;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.ValueState;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]2A\u0001B\u0003\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C!;!)A\u0005\u0001C\u0005K\tqA*[:u'R\fG/Z*vSR,'B\u0001\u0004\b\u0003\u0015\u0019H/\u0019;f\u0015\tA\u0011\"A\u0005tiJ,\u0017-\\5oO*\u0011!bC\u0001\nKb,7-\u001e;j_:T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\u0003\n\u0005a)!AF*uCR,g+\u0019:jC\ndWmU;ji\u0016\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003])8/Z'vYRL\u0007\u000f\\3WC2,Xm\u001d)fe.+\u00170F\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0011un\u001c7fC:\f1\u0004^3ti6\u000b\u0007o\u0015;bi\u0016<\u0016\u000e\u001e5Ok2dWk]3s\u0017\u0016LH#\u0001\u0014\u0015\u0005\u001dR\u0003CA\u0010)\u0013\tI\u0003E\u0001\u0003V]&$\b\"B\u0016\u0004\u0001\u0004a\u0013A\u0003:v]2K7\u000f^(qgB!q$L\u0018(\u0013\tq\u0003EA\u0005Gk:\u001cG/[8ocA\u0019\u0001G\r\u001b\u000e\u0003ER!\u0001C\u0006\n\u0005M\n$!\u0003'jgR\u001cF/\u0019;f!\tyR'\u0003\u00027A\t!Aj\u001c8h\u0001")
public class ListStateSuite
extends StateVariableSuiteBase {
    @Override
    public boolean useMultipleValuesPerKey() {
        return true;
    }

    private void testMapStateWithNullUserKey(Function1<ListState<Object>, BoxedUnit> runListOps) {
        this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            ListStateSuite.$anonfun$testMapStateWithNullUserKey$1(this, runListOps, provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testMapStateWithNullUserKey$1(ListStateSuite $this, Function1 runListOps$1, StateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
        ListState listState = handle.getListState("listState", Encoders$.MODULE$.scalaLong());
        ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
        SparkIllegalArgumentException e = (SparkIllegalArgumentException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> runListOps$1.apply((Object)listState), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        $this.checkError((SparkThrowable)e, "ILLEGAL_STATE_STORE_VALUE.NULL_VALUE", (Option)new Some((Object)"42601"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)"listState")})), $this.checkError$default$5(), $this.checkError$default$6());
    }

    public static final /* synthetic */ void $anonfun$new$3(String listImplFunc$1, ListState listState) {
        block4: {
            String string = listImplFunc$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -2139629864: {
                    if (!"appendList".equals(string)) break;
                    listState.appendList(null);
                    break block4;
                }
                case 111375: {
                    if (!"put".equals(string)) break;
                    listState.put(null);
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$12(ListStateSuite $this, int ttlExpirationMs$1, Tuple2 x$1) {
        return $this.convertToEqualizer(BoxesRunTime.boxToLong((long)x$1._2$mcJ$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)ttlExpirationMs$1), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ boolean $anonfun$new$13(ListStateSuite $this, int ttlExpirationMs$1, Tuple2 x$2) {
        return $this.convertToEqualizer(BoxesRunTime.boxToLong((long)x$2._2$mcJ$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)ttlExpirationMs$1), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$16(ListStateSuite $this, StatefulProcessorHandleImpl handle$1, Duration ttlDuration) {
        SparkUnsupportedOperationException ex;
        TTLConfig ttlConfig = new TTLConfig(ttlDuration);
        SparkUnsupportedOperationException x$22 = ex = (SparkUnsupportedOperationException)$this.intercept((Function0 & Serializable)() -> handle$1.getListState("testState", Encoders$.MODULE$.STRING(), ttlConfig), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        String x$23 = "STATEFUL_PROCESSOR_TTL_DURATION_MUST_BE_POSITIVE";
        Map x$24 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationType"), (Object)"update"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)"testState")}));
        boolean x$25 = true;
        Option x$26 = $this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$27 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$22, "STATEFUL_PROCESSOR_TTL_DURATION_MUST_BE_POSITIVE", x$26, x$24, true, x$27);
    }

    public static final /* synthetic */ void $anonfun$new$15(ListStateSuite $this, StateStoreProvider provider) {
        StateStore store = provider.getStore(0L);
        int batchTimestampMs = 10;
        StateStore x$15 = store;
        UUID x$16 = UUID.randomUUID();
        ExpressionEncoder x$17 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
        TimeMode x$18 = TimeMode.ProcessingTime();
        Some x$19 = new Some((Object)BoxesRunTime.boxToLong((long)batchTimestampMs));
        boolean x$20 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
        Map x$21 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
        StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$15, x$16, x$17, x$18, x$20, (Option)x$19, x$21);
        new .colon.colon(null, (List)new .colon.colon((Object)Duration.ZERO, (List)new .colon.colon((Object)Duration.ofMinutes(-1L), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)ttlDuration -> {
            ListStateSuite.$anonfun$new$16($this, handle, ttlDuration);
            return BoxedUnit.UNIT;
        });
    }

    public ListStateSuite() {
        new .colon.colon((Object)"appendList", (List)new .colon.colon((Object)"put", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)listImplFunc -> {
            this.test("Test list operation(" + listImplFunc + ") with null", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMapStateWithNullUserKey((Function1<ListState<Object>, BoxedUnit>)(Function1 & Serializable)listState -> {
                ListStateSuite.$anonfun$new$3(listImplFunc, listState);
                return BoxedUnit.UNIT;
            }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            return BoxedUnit.UNIT;
        });
        this.test("List state operations for single instance", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ListState testState = handle.getListState("testState", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.appendValue((Object)BoxesRunTime.boxToLong((long)123L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get().toSeq());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.get().toSeq());
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            testState.appendList((Object)new long[]{123L, 456L});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(testState.get().toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123, 456}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            testState.appendValue((Object)BoxesRunTime.boxToLong((long)789L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(testState.get().toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123, 456, 789}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            testState.clear();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState.exists(), "testState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(testState.get().toSeq());
            Seq $org_scalatest_assert_macro_right5 = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("List state operations for multiple instance", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ListState testState1 = handle.getListState("testState1", Encoders$.MODULE$.scalaLong());
            ListState testState2 = handle.getListState("testState2", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState1.appendValue((Object)BoxesRunTime.boxToLong((long)123L));
            testState2.appendValue((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState2.get().toSeq());
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{456}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            testState1.clear();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState1.exists(), "testState1.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(testState2.exists(), "testState2.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(testState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            testState1.appendList((Object)new long[]{123L, 456L});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(testState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123, 456}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            testState2.appendList((Object)new long[]{123L});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(testState2.get().toSeq());
            Seq $org_scalatest_assert_macro_right5 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{456, 123}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            testState1.appendValue((Object)BoxesRunTime.boxToLong((long)789L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(testState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right6 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123, 456, 789}));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(testState2.get().toSeq());
            Seq $org_scalatest_assert_macro_right7 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{456, 123}));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            testState2.clear();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testState2.exists(), "testState2.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(testState1.exists(), "testState1.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(testState2.get().toSeq());
            Seq $org_scalatest_assert_macro_right8 = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("List state operations with list, value, another list instances", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(store, UUID.randomUUID(), (ExpressionEncoder)Encoders$.MODULE$.STRING(), TimeMode.None(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6(), StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7());
            ListState listState1 = handle.getListState("listState1", Encoders$.MODULE$.scalaLong());
            ListState listState2 = handle.getListState("listState2", Encoders$.MODULE$.scalaLong());
            ValueState valueState = handle.getValueState("valueState", Encoders$.MODULE$.scalaLong());
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            valueState.update((Object)BoxesRunTime.boxToLong((long)123L));
            listState1.appendValue((Object)BoxesRunTime.boxToLong((long)123L));
            listState2.appendValue((Object)BoxesRunTime.boxToLong((long)456L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(listState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{123}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(listState2.get().toSeq());
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{456}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(valueState.get());
            int $org_scalatest_assert_macro_right3 = 123;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            listState1.clear();
            valueState.clear();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(listState1.exists(), "listState1.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(listState2.exists(), "listState2.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(valueState.exists(), "valueState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(listState1.get().toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("test List state TTL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            Iterator ttlValues;
            StateStore store = provider.getStore(0L);
            int timestampMs = 10;
            StateStore x$12 = store;
            UUID x$22 = UUID.randomUUID();
            ExpressionEncoder x$3 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
            TimeMode x$4 = TimeMode.ProcessingTime();
            Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)timestampMs));
            boolean x$6 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$7 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl handle = new StatefulProcessorHandleImpl(x$12, x$22, x$3, x$4, x$6, (Option)x$5, x$7);
            TTLConfig ttlConfig = new TTLConfig(Duration.ofMinutes(1L));
            ListStateImplWithTTL testState = (ListStateImplWithTTL)handle.getListState("testState", Encoders$.MODULE$.STRING(), ttlConfig);
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            testState.put((Object)new String[]{"v1", "v2", "v3"});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(testState.get().toSeq());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"v1", (List)new .colon.colon((Object)"v2", (List)new .colon.colon((Object)"v3", (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(testState.getWithoutEnforcingTTL().toSeq());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"v1", (List)new .colon.colon((Object)"v2", (List)new .colon.colon((Object)"v3", (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            int ttlExpirationMs = timestampMs + 60000;
            Iterator $org_scalatest_assert_macro_left3 = ttlValues = testState.getTTLValues();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ttlValues.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ListStateSuite.$anonfun$new$12(this, ttlExpirationMs, x$1))), "ttlValues.forall(((x$1: (String, Long)) => ListStateSuite.this.convertToEqualizer[Long](x$1._2).===(ttlExpirationMs)(scalactic.this.Equality.default[Long])))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            Iterator ttlStateValueIterator = testState.getValuesInTTLState();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ttlStateValueIterator.hasNext(), "ttlStateValueIterator.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            StateStore x$8 = store;
            UUID x$9 = UUID.randomUUID();
            ExpressionEncoder x$10 = (ExpressionEncoder)Encoders$.MODULE$.STRING();
            TimeMode x$11 = TimeMode.ProcessingTime();
            Some x$122 = new Some((Object)BoxesRunTime.boxToLong((long)ttlExpirationMs));
            boolean x$13 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
            Map x$14 = StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
            StatefulProcessorHandleImpl nextBatchHandle = new StatefulProcessorHandleImpl(x$8, x$9, x$10, x$11, x$13, (Option)x$122, x$14);
            ListStateImplWithTTL nextBatchTestState = (ListStateImplWithTTL)nextBatchHandle.getListState("testState", Encoders$.MODULE$.STRING(), ttlConfig);
            ImplicitGroupingKeyTracker$.MODULE$.setImplicitKey((Object)"test_key");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nextBatchTestState.exists(), "nextBatchTestState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            Iterator $org_scalatest_assert_macro_left4 = nextBatchTestState.get();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            Iterator $org_scalatest_assert_macro_left5 = ttlValues = nextBatchTestState.getTTLValues();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(ttlValues.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ListStateSuite.$anonfun$new$13(this, ttlExpirationMs, x$2))), "ttlValues.forall(((x$2: (String, Long)) => ListStateSuite.this.convertToEqualizer[Long](x$2._2).===(ttlExpirationMs)(scalactic.this.Equality.default[Long])))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            ttlStateValueIterator = nextBatchTestState.getValuesInTTLState();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ttlStateValueIterator.hasNext(), "ttlStateValueIterator.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(ttlStateValueIterator.next());
            int $org_scalatest_assert_macro_right3 = ttlExpirationMs;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Iterator $org_scalatest_assert_macro_left7 = ttlStateValueIterator;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(nextBatchTestState.getWithoutEnforcingTTL().toSeq());
            .colon.colon $org_scalatest_assert_macro_right4 = new .colon.colon((Object)"v1", (List)new .colon.colon((Object)"v2", (List)new .colon.colon((Object)"v3", (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            nextBatchTestState.clear();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nextBatchTestState.exists(), "nextBatchTestState.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Iterator $org_scalatest_assert_macro_left9 = nextBatchTestState.get();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("test negative or zero TTL duration throws error", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource((StateStoreProvider)this.newStoreProviderWithStateVariable(true), (Function1 & Serializable)provider -> {
            ListStateSuite.$anonfun$new$15(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("ListStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }
}

