/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger$;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.util.Clock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileLongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005]3A!\u0003\u0006\u0001/!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0007I\u0003BB\u0017\u0001A\u0003%!\u0006C\u0004/\u0001\t\u0007I\u0011A\u0018\t\rY\u0002\u0001\u0015!\u00031\u0011\u00159\u0004\u0001\"\u00039\u0011\u0015!\u0005\u0001\"\u0003F\u0011\u0015Y\u0005\u0001\"\u0003M\u0005m\u0001&o\\2fgNLgn\u001a+j[\u0016,\u00050Z2vi>\u00148+^5uK*\u00111\u0002D\u0001\ngR\u0014X-Y7j]\u001eT!!\u0004\b\u0002\u0013\u0015DXmY;uS>t'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u00199A\u0011\u0011DG\u0007\u0002!%\u00111\u0004\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013AC2p]\u000e,(O]3oi*\u0011\u0011\u0005F\u0001\ng\u000e\fG.\u0019;fgRL!a\t\u0010\u0003\u0015QKW.\u001a'j[&$8/\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u0011q\u0005A\u0007\u0002\u0015\u0005yA-\u001a4bk2$8+[4oC2,'/F\u0001+!\ti2&\u0003\u0002-=\tA1+[4oC2,'/\u0001\teK\u001a\fW\u000f\u001c;TS\u001et\u0017\r\\3sA\u00059A/[7f_V$X#\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u0002\u0013\u0001\u0002;j[\u0016L!!\u000e\u001a\u0003\tM\u0003\u0018M\\\u0001\ti&lWm\\;uA\u0005!B/Z:u\u0005\u0006$8\r\u001b+fe6Lg.\u0019;j_:$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0001\u001a\u0001\r!Q\u0001\u000bS:$XM\u001d<bY6\u001b\bC\u0001\u001eC\u0013\t\u00195H\u0001\u0003M_:<\u0017AC3wK:$X/\u00197msR\u0011\u0011H\u0012\u0005\u0007\u000f\u001e!\t\u0019\u0001%\u0002\t\t|G-\u001f\t\u0004u%K\u0014B\u0001&<\u0005!a$-\u001f8b[\u0016t\u0014!E<bSR4uN\u001d+ie\u0016\fGMS8j]R\u0011\u0011(\u0014\u0005\u0006\u001d\"\u0001\raT\u0001\u0007i\"\u0014X-\u00193\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\n1A\u000b\u001b:fC\u0012\u0004")
public class ProcessingTimeExecutorSuite
extends SparkFunSuite {
    private final Signaler defaultSignaler = ThreadSignaler$.MODULE$;
    private final Span timeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds();

    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    public Span timeout() {
        return this.timeout;
    }

    private void testBatchTermination(long intervalMs) {
        IntRef batchCounts = IntRef.create((int)0);
        ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTimeTrigger(intervalMs), ProcessingTimeExecutor$.MODULE$.apply$default$2());
        processingTimeExecutor.execute((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProcessingTimeExecutorSuite.$anonfun$testBatchTermination$1(batchCounts, x$2)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounts.elem));
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    private void eventually(Function0<BoxedUnit> body) {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(this.timeout()), body, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }

    private void waitForThreadJoin(Thread thread) {
        this.failAfter(this.timeout(), (Function0)(JFunction0.mcV.sp & Serializable)() -> thread.join(), this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156), Timed$.MODULE$.timed());
    }

    public static final /* synthetic */ boolean $anonfun$testBatchTermination$1(IntRef batchCounts$1, MicroBatchExecutionContext x$2) {
        ++batchCounts$1.elem;
        return batchCounts$1.elem < 3;
    }

    public ProcessingTimeExecutorSuite() {
        this.test("nextBatchTime", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTimeTrigger(100L), ProcessingTimeExecutor$.MODULE$.apply$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(0L)));
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(1L)));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(99L)));
            int $org_scalatest_assert_macro_right3 = 100;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(100L)));
            int $org_scalatest_assert_macro_right4 = 200;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(101L)));
            int $org_scalatest_assert_macro_right5 = 200;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)processingTimeExecutor.nextBatchTime(150L)));
            int $org_scalatest_assert_macro_right6 = 200;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("trigger timing", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ConcurrentHashMap.KeySetView triggerTimes = ConcurrentHashMap.newKeySet();
            StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
            VolatileBooleanRef continueExecuting = VolatileBooleanRef.create((boolean)true);
            VolatileLongRef clockIncrementInTrigger = VolatileLongRef.create((long)0L);
            ProcessingTimeExecutor executor = new ProcessingTimeExecutor(ProcessingTimeTrigger$.MODULE$.apply("1000 milliseconds"), (Clock)clock);
            Thread executorThread = new Thread(null, executor, triggerTimes, clock, clockIncrementInTrigger, continueExecuting){
                private final ProcessingTimeExecutor executor$1;
                private final ConcurrentHashMap.KeySetView triggerTimes$1;
                private final StreamManualClock clock$1;
                private final VolatileLongRef clockIncrementInTrigger$1;
                private final VolatileBooleanRef continueExecuting$1;

                public void run() {
                    this.executor$1.execute((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$run$1(this, x$1)));
                }

                public static final /* synthetic */ boolean $anonfun$run$1($anon$1 $this, MicroBatchExecutionContext x$1) {
                    $this.triggerTimes$1.add(BoxesRunTime.boxToInteger((int)((int)$this.clock$1.getTimeMillis())));
                    $this.clock$1.advance($this.clockIncrementInTrigger$1.elem);
                    $this.clockIncrementInTrigger$1.elem = 0L;
                    return $this.continueExecuting$1.elem;
                }
                {
                    this.executor$1 = executor$1;
                    this.triggerTimes$1 = triggerTimes$1;
                    this.clock$1 = clock$1;
                    this.clockIncrementInTrigger$1 = clockIncrementInTrigger$1;
                    this.continueExecuting$1 = continueExecuting$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$$anon$1 org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext )}, serializedLambda);
                }
            };
            executorThread.start();
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                ConcurrentHashMap.KeySetView $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains(BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(1000L), "clock.isStreamWaitingFor(1000L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            });
            clockIncrementInTrigger.elem = 500L;
            clock.setTime(1000L);
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                ConcurrentHashMap.KeySetView $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains(BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(1500L), "clock.isStreamWaitingAt(1500L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(2000L), "clock.isStreamWaitingFor(2000L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            });
            clockIncrementInTrigger.elem = 1500L;
            clock.setTime(2000L);
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                ConcurrentHashMap.KeySetView $org_scalatest_assert_macro_left = triggerTimes;
                int $org_scalatest_assert_macro_right = 2000;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains(BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    ConcurrentHashMap.KeySetView $org_scalatest_assert_macro_left3 = triggerTimes;
                    int $org_scalatest_assert_macro_right2 = 3500;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.contains(BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingAt(3500L), "clock.isStreamWaitingAt(3500L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(4000L), "clock.isStreamWaitingFor(4000L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            });
            continueExecuting.elem = false;
            clock.advance(1000L);
            this.waitForThreadJoin(executorThread);
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("calling nextBatchTime with the result of a previous call should return the next interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int intervalMS = 100;
            ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(new ProcessingTimeTrigger((long)intervalMS), ProcessingTimeExecutor$.MODULE$.apply$default$2());
            int ITERATION = 10;
            LongRef nextBatchTime = LongRef.create((long)0L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), ITERATION).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)it -> {
                nextBatchTime$1.elem = processingTimeExecutor.nextBatchTime(nextBatchTime$1.elem);
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nextBatchTime.elem));
            int $org_scalatest_assert_macro_right = intervalMS * ITERATION;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("batch termination", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testBatchTermination(0L);
            this.testBatchTermination(10L);
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("notifyBatchFallingBehind", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
            VolatileBooleanRef batchFallingBehindCalled = VolatileBooleanRef.create((boolean)false);
            Thread t = new Thread(null, clock, batchFallingBehindCalled){
                public final StreamManualClock clock$2;
                public final VolatileBooleanRef batchFallingBehindCalled$1;

                public void run() {
                    ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(this){
                        private final /* synthetic */ $anon$2 $outer;

                        public void notifyBatchFallingBehind(long realElapsedTimeMs) {
                            this.$outer.batchFallingBehindCalled$1.elem = true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            super(new ProcessingTimeTrigger(100L), (Clock)$outer.clock$2);
                        }
                    };
                    processingTimeExecutor.execute((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$run$2(this, x$3)));
                }

                public static final /* synthetic */ boolean $anonfun$run$2($anon$2 $this, MicroBatchExecutionContext x$3) {
                    $this.clock$2.waitTillTime(200L);
                    return false;
                }
                {
                    this.clock$2 = clock$2;
                    this.batchFallingBehindCalled$1 = batchFallingBehindCalled$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2$adapted(org.apache.spark.sql.execution.streaming.ProcessingTimeExecutorSuite$$anon$2 org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext )}, serializedLambda);
                }
            };
            t.start();
            this.eventually((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock.isStreamWaitingFor(200L), "clock.isStreamWaitingFor(200L)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            });
            clock.advance(200L);
            this.waitForThreadJoin(t);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(batchFallingBehindCalled.elem, "batchFallingBehindCalled", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("ProcessingTimeExecutorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }
}

