/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.IntegratedUDFTestUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExecBase;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.datasources.v2.python.UserDefinedPythonDataSource;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.python.PythonDataSourceSuiteBase;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t)\u0002+\u001f;i_:$\u0015\r^1T_V\u00148-Z*vSR,'B\u0001\u0003\u0006\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011aaB\u0001\nKb,7-\u001e;j_:T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0002\n\u0005Q\u0019!!\u0007)zi\"|g\u000eR1uCN{WO]2f'VLG/\u001a\"bg\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0001")
public class PythonDataSourceSuite
extends PythonDataSourceSuiteBase {
    public static final /* synthetic */ void $anonfun$new$42(PythonDataSourceSuite $this, String query$1, File dir) {
        Dataset df = (Dataset)$this.sql().apply((Object)query$1);
        String path = dir.getAbsolutePath();
        df.write().format($this.dataSourceName()).mode("append").save(path);
        Dataset df2 = $this.spark().read().json(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Dataset<Row>)df2);
    }

    public static final /* synthetic */ void $anonfun$new$56(PythonDataSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().range(1L).write().format($this.dataSourceName()).mode("append").save(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().json(path), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
        $this.spark().range(1L).write().format($this.dataSourceName()).mode("append").save(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().json(path), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)));
        $this.spark().range(2L, 3L).write().format($this.dataSourceName()).mode("overwrite").save(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().json(path), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$new$61(PythonDataSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.withClue("commit", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ((Dataset)$this.sql().apply((Object)"SELECT * FROM range(0, 5, 1, 3)")).write().format($this.dataSourceName()).mode("append").save(path);
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().format("json").schema("num_files bigint, count bigint").load(path + "/success.json"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)5)})), (List)Nil$.MODULE$));
        });
        $this.withClue("commit again", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ((Dataset)$this.sql().apply((Object)"SELECT * FROM range(5, 7, 1, 1)")).write().format($this.dataSourceName()).mode("append").save(path);
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().format("json").schema("num_files bigint, count bigint").load(path + "/success.json"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
        });
        $this.withClue("abort", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM range(8, 12, 1, 4)")).write().format($this.dataSourceName()).mode("append").save(path), ClassTag$.MODULE$.apply(SparkException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().text(path + "/failed.txt"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"failed"})), (List)Nil$.MODULE$));
        });
    }

    public PythonDataSourceSuite() {
        this.test("SPARK-45917: automatic registration of Python Data Source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Dataset df = this.spark().read().format(this.staticSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))))));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("simple data source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataSourceV2ScanRelation dataSourceV2ScanRelation;
            LogicalPlan plan;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.datasource import DataSource\n        |" + this.simpleDataSourceReaderScript() + "\n        |\n        |class " + this.dataSourceName() + "(DataSource):\n        |    def reader(self, schema):\n        |        return SimpleDataSourceReader()\n        |"));
            StructType schema = StructType$.MODULE$.fromDDL("id INT, partition INT");
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).schema(schema).load();
            int $org_scalatest_assert_macro_left = df.rdd().getNumPartitions();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            LogicalPlan logicalPlan = plan = df.queryExecution().optimizedPlan();
            if (!(logicalPlan instanceof DataSourceV2ScanRelation) || !(dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan).relation().table().getClass().toString().contains("PythonTable")) {
                throw this.fail("Plan did not match the expected pattern. Actual plan:\n" + plan, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            }
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))))));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("simple data source with string schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |" + this.simpleDataSourceReaderScript() + "\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"id INT, partition INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))))));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("simple data source with StructType schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |from pyspark.sql.types import IntegerType, StructType, StructField\n         |" + this.simpleDataSourceReaderScript() + "\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return StructType([\n         |            StructField(\"id\", IntegerType()),\n         |            StructField(\"partition\", IntegerType())\n         |        ])\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))))));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("data source with invalid schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |" + this.simpleDataSourceReaderScript() + "\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().read().format(this.dataSourceName()).load(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            String x$2 = "INVALID_SCHEMA.NON_STRUCT_TYPE";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSchema"), (Object)"INT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"INT\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INVALID_SCHEMA.NON_STRUCT_TYPE", x$4, x$3, x$5, x$6);
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("register data source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |" + this.simpleDataSourceReaderScript() + "\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"id INT, partition INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sessionState().dataSourceManager().dataSourceExists(this.dataSourceName()), "PythonDataSourceSuite.this.spark.sessionState.dataSourceManager.dataSourceExists(PythonDataSourceSuite.this.dataSourceName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().read().format(this.dataSourceName()).load(), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))))));
            String newScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def read(self, partition):\n         |        yield (0, )\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"id INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource newDataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), newScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), newDataSource);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().sessionState().dataSourceManager().dataSourceExists(this.dataSourceName()), "PythonDataSourceSuite.this.spark.sessionState.dataSourceManager.dataSourceExists(PythonDataSourceSuite.this.dataSourceName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().read().format(this.dataSourceName()).load(), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("load data source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader, InputPartition\n         |import json\n         |\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def __init__(self, options):\n         |        self.options = options\n         |\n         |    def partitions(self):\n         |        if \"paths\" in self.options:\n         |            paths = json.loads(self.options[\"paths\"])\n         |        elif \"path\" in self.options:\n         |            paths = [self.options[\"path\"]]\n         |        else:\n         |            paths = []\n         |        return [InputPartition(p) for p in paths]\n         |\n         |    def read(self, part):\n         |        if part is not None:\n         |            assert isinstance(part, InputPartition)\n         |            yield (part.value, 1)\n         |        else:\n         |            yield (part, 1)\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    @classmethod\n         |    def name(cls) -> str:\n         |        return \"test\"\n         |\n         |    def schema(self) -> str:\n         |        return \"id STRING, value INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader(self.options)\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython("test", dataSource);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().read().format("test").load(), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().read().format("test").load("1"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().read().format("test").load((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"2", BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tblA"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE tblA USING test");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("tblA").selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$));
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("SPARK-46522: data source name conflicts", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    ...\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"text", "json", "csv", "avro", "orc", "parquet", "jdbc", "binaryFile", "xml", "kafka", "noop", "org.apache.spark.sql.test", "org.apache.spark.sql.hive.orc"})).foreach((Function1 & Serializable)provider -> {
                this.withClue("Data source: " + provider, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$7 = (AnalysisException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.spark().dataSource().registerPython(provider, dataSource$1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                    String x$8 = "DATA_SOURCE_ALREADY_EXISTS";
                    Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider)}));
                    Option x$10 = $this.checkError$default$3();
                    boolean x$11 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$12 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$7, "DATA_SOURCE_ALREADY_EXISTS", x$10, x$9, x$11, x$12);
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("reader not implemented", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.datasource import DataSource, DataSourceReader\n        |class " + this.dataSourceName() + "(DataSource):\n        |    pass\n        |"));
            StructType schema = StructType$.MODULE$.fromDDL("id INT, partition INT");
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            AnalysisException err = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().format(this.dataSourceName()).schema(schema).load().collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            String $org_scalatest_assert_macro_left = err.getErrorClass();
            String $org_scalatest_assert_macro_right = "PYTHON_DATA_SOURCE_ERROR";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            String $org_scalatest_assert_macro_left2 = err.getMessage();
            String $org_scalatest_assert_macro_right2 = "PySparkNotImplementedError";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("error creating reader", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.datasource import DataSource\n        |class " + this.dataSourceName() + "(DataSource):\n        |    def reader(self, schema):\n        |        raise Exception(\"error creating reader\")\n        |"));
            StructType schema = StructType$.MODULE$.fromDDL("id INT, partition INT");
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            AnalysisException err = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().format(this.dataSourceName()).schema(schema).load().collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            String $org_scalatest_assert_macro_left = err.getErrorClass();
            String $org_scalatest_assert_macro_right = "PYTHON_DATA_SOURCE_ERROR";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            String $org_scalatest_assert_macro_left2 = err.getMessage();
            String $org_scalatest_assert_macro_right2 = "error creating reader";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("data source assertion error", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class " + this.dataSourceName() + ":\n        |   def __init__(self, options):\n        |       ...\n        |"));
            StructType schema = StructType$.MODULE$.fromDDL("id INT, partition INT");
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            AnalysisException err = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().format(this.dataSourceName()).schema(schema).load().collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            String $org_scalatest_assert_macro_left = err.getErrorClass();
            String $org_scalatest_assert_macro_right = "PYTHON_DATA_SOURCE_ERROR";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            String $org_scalatest_assert_macro_left2 = err.getMessage();
            String $org_scalatest_assert_macro_right2 = "DATA_SOURCE_TYPE_MISMATCH";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            String $org_scalatest_assert_macro_left3 = err.getMessage();
            String $org_scalatest_assert_macro_right3 = "PySparkAssertionError";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("data source read with custom partitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader, InputPartition\n         |class RangePartition(InputPartition):\n         |    def __init__(self, start, end):\n         |        self.start = start\n         |        self.end = end\n         |\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        return [RangePartition(1, 2), RangePartition(3, 4)]\n         |\n         |    def read(self, partition: RangePartition):\n         |        start, end = partition.start, partition.end\n         |        for i in range(start, end):\n         |            yield (i, )\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"id INT\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        this.test("data source read with empty partitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        return []\n         |\n         |    def read(self, partition):\n         |        if partition is None:\n         |            yield (\"success\", )\n         |        else:\n         |            yield (\"failed\", )\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"status STRING\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"success"})));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("data source read with invalid partitions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            String reader1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        return 1\n         |    def read(self, partition):\n         |        ...\n         |"));
            String reader2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        return [1, 2]\n         |    def read(self, partition):\n         |        ...\n         |"));
            String reader3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        raise Exception(\"error\")\n         |    def read(self, partition):\n         |        ...\n         |"));
            new .colon.colon((Object)reader1, (List)new .colon.colon((Object)reader2, (List)new .colon.colon((Object)reader3, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)readerScript -> {
                String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |from pyspark.sql.datasource import DataSource, DataSourceReader\n           |" + readerScript + "\n           |\n           |class " + this.dataSourceName() + "(DataSource):\n           |    def schema(self) -> str:\n           |        return \"id INT\"\n           |\n           |    def reader(self, schema):\n           |        return SimpleDataSourceReader()\n           |"));
                UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
                this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
                AnalysisException err = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().format(this.dataSourceName()).load().collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
                String $org_scalatest_assert_macro_left = err.getErrorClass();
                String $org_scalatest_assert_macro_right = "PYTHON_DATA_SOURCE_ERROR";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
                String $org_scalatest_assert_macro_left2 = err.getMessage();
                String $org_scalatest_assert_macro_right2 = "partitions";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        this.test("SPARK-46540: data source read output named rows", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def read(self, partition):\n         |        from pyspark.sql import Row\n         |        yield Row(x = 0, y = 1)\n         |        yield Row(y = 2, x = 1)\n         |        yield Row(2, 3)\n         |        yield (3, 4)\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"x int, y int\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("SPARK-46424: Support Python metrics", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceReader\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def partitions(self):\n         |        return []\n         |\n         |    def read(self, partition):\n         |        if partition is None:\n         |            yield (\"success\", )\n         |        else:\n         |            yield (\"failed\", )\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"status STRING\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader()\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().format(this.dataSourceName()).load();
            SQLAppStatusStore statusStore = this.spark().sharedState().statusStore();
            int oldCount = statusStore.executionsList().size();
            df.collect();
            while (statusStore.executionsCount() < (long)oldCount) {
                Thread.sleep(100L);
            }
            while (statusStore.executionsList().isEmpty() || ((SQLExecutionUIData)statusStore.executionsList().last()).metricValues() == null) {
                Thread.sleep(100L);
            }
            Option executedPlan = df.queryExecution().executedPlan().collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof BatchScanExec) {
                        BatchScanExec batchScanExec = (BatchScanExec)A1;
                        return (B1)batchScanExec;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan2 = x1;
                    return sparkPlan2 instanceof BatchScanExec;
                }
            });
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executedPlan.isDefined(), "executedPlan.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            long execId = ((SQLExecutionUIData)statusStore.executionsList().last()).executionId();
            Map metrics = statusStore.executionMetrics(execId);
            SQLMetric pythonDataSent = (SQLMetric)((DataSourceV2ScanExecBase)executedPlan.get()).metrics().apply((Object)"pythonDataSent");
            SQLMetric pythonDataReceived = (SQLMetric)((DataSourceV2ScanExecBase)executedPlan.get()).metrics().apply((Object)"pythonDataReceived");
            Map $org_scalatest_assert_macro_left = metrics;
            long $org_scalatest_assert_macro_right = pythonDataSent.id();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
            String $org_scalatest_assert_macro_left2 = (String)metrics.apply((Object)BoxesRunTime.boxToLong((long)pythonDataSent.id()));
            String $org_scalatest_assert_macro_right2 = "B";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "endsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.endsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
            Map $org_scalatest_assert_macro_left3 = metrics;
            long $org_scalatest_assert_macro_right3 = pythonDataReceived.id();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
            String $org_scalatest_assert_macro_left4 = (String)metrics.apply((Object)BoxesRunTime.boxToLong((long)pythonDataReceived.id()));
            String $org_scalatest_assert_macro_right4 = "B";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "endsWith", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.endsWith($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("simple data source write", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |import json\n         |import os\n         |from pyspark import TaskContext\n         |from pyspark.sql.datasource import DataSource, DataSourceWriter, WriterCommitMessage\n         |\n         |class SimpleDataSourceWriter(DataSourceWriter):\n         |    def __init__(self, options):\n         |        self.options = options\n         |\n         |    def write(self, iterator):\n         |        context = TaskContext.get()\n         |        partition_id = context.partitionId()\n         |        path = self.options.get(\"path\")\n         |        assert path is not None\n         |        output_path = os.path.join(path, f\"{partition_id}.json\")\n         |        cnt = 0\n         |        with open(output_path, \"w\") as file:\n         |            for row in iterator:\n         |                file.write(json.dumps(row.asDict()) + \"\\n\")\n         |                cnt += 1\n         |        return WriterCommitMessage()\n         |\n         |class SimpleDataSource(DataSource):\n         |    def writer(self, schema, overwrite):\n         |        return SimpleDataSourceWriter(self.options)\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            new .colon.colon((Object)"SELECT * FROM range(0, 5, 1, 3)", (List)new .colon.colon((Object)"SELECT * FROM testData LIMIT 5", (List)new .colon.colon((Object)"SELECT * FROM testData3", (List)new .colon.colon((Object)"SELECT * FROM arrayData", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)query -> {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                    PythonDataSourceSuite.$anonfun$new$42($this, query, dir);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("data source write - error cases", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import DataSource, DataSourceWriter\n         |\n         |class SimpleDataSourceWriter(DataSourceWriter):\n         |    def write(self, iterator):\n         |        num_rows = 0\n         |        for row in iterator:\n         |            num_rows += 1\n         |            if num_rows > 2:\n         |                raise Exception(\"something is wrong\")\n         |\n         |class SimpleDataSource(DataSource):\n         |    def writer(self, schema, saveMode):\n         |        return SimpleDataSourceWriter()\n         |"));
            this.spark().dataSource().registerPython(this.dataSourceName(), IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript));
            this.withClue("user error", (Function0 & Serializable)() -> {
                SparkException error = (SparkException)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().range(10L).write().format(this.dataSourceName()).mode("append").save(), ClassTag$.MODULE$.apply(SparkException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641)))));
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "something is wrong";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
            });
            this.withClue("no commit message", (Function0 & Serializable)() -> {
                SparkException error = (SparkException)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().range(1L).write().format(this.dataSourceName()).mode("append").save(), ClassTag$.MODULE$.apply(SparkException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648)))));
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "DATA_SOURCE_TYPE_MISMATCH";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
                String $org_scalatest_assert_macro_left2 = error.getMessage();
                String $org_scalatest_assert_macro_right2 = "WriterCommitMessage";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            });
            this.withClue("without mode", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$13 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().range(1L).write().format(this.dataSourceName()).save(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
                String x$14 = "UNSUPPORTED_DATA_SOURCE_SAVE_MODE";
                Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)"SimpleDataSource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createMode"), (Object)"\"ErrorIfExists\"")}));
                Option x$16 = this.checkError$default$3();
                boolean x$17 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$13, "UNSUPPORTED_DATA_SOURCE_SAVE_MODE", x$16, x$15, x$17, x$18);
            });
            this.withClue("with unsupported mode", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$19 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().range(1L).write().format(this.dataSourceName()).mode("ignore").save(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
                String x$20 = "UNSUPPORTED_DATA_SOURCE_SAVE_MODE";
                Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)"SimpleDataSource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createMode"), (Object)"\"Ignore\"")}));
                Option x$22 = this.checkError$default$3();
                boolean x$23 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$19, "UNSUPPORTED_DATA_SOURCE_SAVE_MODE", x$22, x$21, x$23, x$24);
            });
            this.withClue("invalid mode", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$25 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().range(1L).write().format(this.dataSourceName()).mode("foo").save(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
                String x$26 = "INVALID_SAVE_MODE";
                Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"\"foo\"")}));
                Option x$28 = this.checkError$default$3();
                boolean x$29 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$25, "INVALID_SAVE_MODE", x$28, x$27, x$29, x$30);
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        this.test("data source write - overwrite mode", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |import json\n         |import os\n         |from pyspark import TaskContext\n         |from pyspark.sql.datasource import DataSource, DataSourceWriter, WriterCommitMessage\n         |\n         |class SimpleDataSourceWriter(DataSourceWriter):\n         |    def __init__(self, options, overwrite):\n         |        self.options = options\n         |        self.overwrite = overwrite\n         |\n         |    def write(self, iterator):\n         |        context = TaskContext.get()\n         |        partition_id = context.partitionId()\n         |        path = self.options.get(\"path\")\n         |        assert path is not None\n         |        output_path = os.path.join(path, f\"{partition_id}.json\")\n         |        cnt = 0\n         |        mode = \"w\" if self.overwrite else \"a\"\n         |        with open(output_path, mode) as file:\n         |            for row in iterator:\n         |                file.write(json.dumps(row.asDict()) + \"\\n\")\n         |                cnt += 1\n         |        return WriterCommitMessage()\n         |\n         |class SimpleDataSource(DataSource):\n         |    def writer(self, schema, overwrite):\n         |        return SimpleDataSourceWriter(self.options, overwrite)\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                PythonDataSourceSuite.$anonfun$new$56(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        this.test("data source write commit and abort", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |import json\n         |import os\n         |from dataclasses import dataclass\n         |from pyspark import TaskContext\n         |from pyspark.sql.datasource import DataSource, DataSourceWriter, WriterCommitMessage\n         |\n         |@dataclass\n         |class SimpleCommitMessage(WriterCommitMessage):\n         |    partition_id: int\n         |    count: int\n         |\n         |class SimpleDataSourceWriter(DataSourceWriter):\n         |    def __init__(self, options):\n         |        self.options = options\n         |        self.path = self.options.get(\"path\")\n         |        assert self.path is not None\n         |\n         |    def write(self, iterator):\n         |        context = TaskContext.get()\n         |        partition_id = context.partitionId()\n         |        output_path = os.path.join(self.path, f\"{partition_id}.json\")\n         |        cnt = 0\n         |        with open(output_path, \"w\") as file:\n         |            for row in iterator:\n         |                if row.id >= 10:\n         |                    raise Exception(\"invalid value\")\n         |                file.write(json.dumps(row.asDict()) + \"\\n\")\n         |                cnt += 1\n         |        return SimpleCommitMessage(partition_id=partition_id, count=cnt)\n         |\n         |    def commit(self, messages) -> None:\n         |        status = dict(num_files=len(messages), count=sum(m.count for m in messages))\n         |\n         |        with open(os.path.join(self.path, \"success.json\"), \"a\") as file:\n         |            file.write(json.dumps(status) + \"\\n\")\n         |\n         |    def abort(self, messages) -> None:\n         |        with open(os.path.join(self.path, \"failed.txt\"), \"a\") as file:\n         |            file.write(\"failed\")\n         |\n         |class SimpleDataSource(DataSource):\n         |    def writer(self, schema, saveMode):\n         |        return SimpleDataSourceWriter(self.options)\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                PythonDataSourceSuite.$anonfun$new$61(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        this.test("SPARK-46568: case insensitive options", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
            String dataSourceScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql.datasource import (\n         |    DataSource, DataSourceReader, DataSourceWriter, WriterCommitMessage)\n         |class SimpleDataSourceReader(DataSourceReader):\n         |    def __init__(self, options):\n         |        self.options = options\n         |\n         |    def read(self, partition):\n         |        foo = self.options.get(\"Foo\")\n         |        bar = self.options.get(\"BAR\")\n         |        baz = \"BaZ\" in self.options\n         |        yield (foo, bar, baz)\n         |\n         |class SimpleDataSourceWriter(DataSourceWriter):\n         |    def __init__(self, options):\n         |        self.options = options\n         |\n         |    def write(self, row):\n         |        if \"FOO\" not in self.options or \"BAR\" not in self.options:\n         |            raise Exception(\"FOO or BAR not found\")\n         |        return WriterCommitMessage()\n         |\n         |class " + this.dataSourceName() + "(DataSource):\n         |    def schema(self) -> str:\n         |        return \"a string, b string, c string\"\n         |\n         |    def reader(self, schema):\n         |        return SimpleDataSourceReader(self.options)\n         |\n         |    def writer(self, schema, overwrite):\n         |        return SimpleDataSourceWriter(self.options)\n         |"));
            UserDefinedPythonDataSource dataSource = IntegratedUDFTestUtils$.MODULE$.createUserDefinedPythonDataSource(this.dataSourceName(), dataSourceScript);
            this.spark().dataSource().registerPython(this.dataSourceName(), dataSource);
            Dataset df = this.spark().read().option("foo", 1L).option("bar", 2L).option("BAZ", 3L).format(this.dataSourceName()).load();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2", "true"})));
            df.write().option("foo", 1L).option("bar", 2L).format(this.dataSourceName()).mode("append").save();
        }, new Position("PythonDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
    }
}

