/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml.parsers;

import java.io.Serializable;
import java.io.StringReader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.xml.StaxXmlParserUtils$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005E2A\u0001B\u0003\u0003-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002\u0019\u0001A\u0003%qEA\fTi\u0006D\b,\u001c7QCJ\u001cXM]+uS2\u001c8+^5uK*\u0011aaB\u0001\ba\u0006\u00148/\u001a:t\u0015\tA\u0011\"A\u0002y[2T!AC\u0006\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u00195\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u000192\u0004\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\n\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u0011\u001e\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\u0015\tqAZ1di>\u0014\u00180F\u0001(!\tAc&D\u0001*\u0015\tQ3&\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u00111R\u0011!L\u0001\u0006U\u00064\u0018\r_\u0005\u0003_%\u0012q\u0002W'M\u0013:\u0004X\u000f\u001e$bGR|'/_\u0001\tM\u0006\u001cGo\u001c:zA\u0001")
public final class StaxXmlParserUtilsSuite
extends SparkFunSuite {
    private final XMLInputFactory factory = StaxXmlParserUtils$.MODULE$.factory();

    private XMLInputFactory factory() {
        return this.factory;
    }

    public StaxXmlParserUtilsSuite() {
        this.test("Test if elements are skipped until the given event type", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_1;
            void var3_2;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("2"));
            $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_2)));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("Sam Mad Dog Smith"));
            $buf.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("93"));
            $buf.$amp$plus((Object)new Elem(null, "amount", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            Elem input = new Elem(null, "ROW", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_1));
            XMLEventReader parser = this.factory().createXMLEventReader(new StringReader(input.toString()));
            XMLEvent event = StaxXmlParserUtils$.MODULE$.skipUntil(parser, 8);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(event.isEndDocument(), "event.isEndDocument()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Check the end of element", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_1;
            void var3_2;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("2"));
            $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_2)));
            Elem input = new Elem(null, "ROW", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_1));
            XMLEventReader parser = this.factory().createXMLEventReader(new StringReader(input.toString()));
            StaxXmlParserUtils$.MODULE$.skipUntil(parser, 2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StaxXmlParserUtils$.MODULE$.checkEndElement(parser), "org.apache.spark.sql.catalyst.xml.StaxXmlParserUtils.checkEndElement(parser)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("Convert attributes to a map with keys and values", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("id", (Seq)new Text("2"), (MetaData)$md);
            Elem input = new Elem(null, "ROW", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$);
            XMLEventReader parser = this.factory().createXMLEventReader(new StringReader(input.toString()));
            XMLEvent event = StaxXmlParserUtils$.MODULE$.skipUntil(parser, 1);
            Attribute[] attributes = (Attribute[])CollectionConverters$.MODULE$.IteratorHasAsScala(event.asStartElement().getAttributes()).asScala().toArray(ClassTag$.MODULE$.apply(Attribute.class));
            Map valuesMap = StaxXmlParserUtils$.MODULE$.convertAttributesToValuesMap(attributes, new XmlOptions(XmlOptions$.MODULE$.$lessinit$greater$default$1(), XmlOptions$.MODULE$.$lessinit$greater$default$2(), XmlOptions$.MODULE$.$lessinit$greater$default$3(), XmlOptions$.MODULE$.$lessinit$greater$default$4()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(valuesMap);
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(XmlOptions$.MODULE$.DEFAULT_ATTRIBUTE_PREFIX() + "id")), (Object)"2")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Convert current structure to string", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_1;
            void var3_2;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("2"));
            $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_2)));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n      "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Sam Mad Dog Smith"));
            $buf3.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            NodeBuffer $buf5 = new NodeBuffer();
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("1"));
            $buf5.$amp$plus((Object)new Elem(null, "small", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("9"));
            $buf5.$amp$plus((Object)new Elem(null, "large", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf3.$amp$plus((Object)new Elem(null, "amount", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Elem(null, "info", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            Elem input = new Elem(null, "ROW", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_1));
            XMLEventReader parser = this.factory().createXMLEventReader(new StringReader(input.toString()));
            StaxXmlParserUtils$.MODULE$.skipUntil(parser, 2);
            String xmlString = StaxXmlParserUtils$.MODULE$.currentStructureAsString(parser, "ROW", new XmlOptions(XmlOptions$.MODULE$.$lessinit$greater$default$1(), XmlOptions$.MODULE$.$lessinit$greater$default$2(), XmlOptions$.MODULE$.$lessinit$greater$default$3(), XmlOptions$.MODULE$.$lessinit$greater$default$4()));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n      "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("Sam Mad Dog Smith"));
            $buf8.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
            NodeBuffer $buf10 = new NodeBuffer();
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("1"));
            $buf10.$amp$plus((Object)new Elem(null, "small", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("9"));
            $buf10.$amp$plus((Object)new Elem(null, "large", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            $buf8.$amp$plus((Object)new Elem(null, "amount", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
            Elem expected = new Elem(null, "info", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(xmlString);
            String $org_scalatest_assert_macro_right = expected.toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Skip XML children", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_1;
            void var3_2;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n      "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("Sam Mad Dog Smith"));
            $buf2.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            NodeBuffer $buf4 = new NodeBuffer();
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("1"));
            $buf4.$amp$plus((Object)new Elem(null, "small", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("9"));
            $buf4.$amp$plus((Object)new Elem(null, "large", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf2.$amp$plus((Object)new Elem(null, "amount", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Elem(null, "info", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_2)));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("2"));
            $buf.$amp$plus((Object)new Elem(null, "abc", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("2"));
            $buf.$amp$plus((Object)new Elem(null, "test", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            Elem input = new Elem(null, "ROW", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_1));
            XmlOptions xmlOptions = new XmlOptions(XmlOptions$.MODULE$.$lessinit$greater$default$1(), XmlOptions$.MODULE$.$lessinit$greater$default$2(), XmlOptions$.MODULE$.$lessinit$greater$default$3(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
            XMLEventReader parser1 = this.factory().createXMLEventReader(new StringReader(input.toString()));
            StaxXmlParserUtils$.MODULE$.skipUntil(parser1, 1);
            StaxXmlParserUtils$.MODULE$.skipChildren(parser1, "ROW", xmlOptions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)parser1.peek().getEventType()));
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            XMLEventReader parser2 = this.factory().createXMLEventReader(new StringReader(input.toString()));
            StaxXmlParserUtils$.MODULE$.skipUntil(parser2, 4);
            String elementName1 = StaxXmlParserUtils$.MODULE$.getName(parser2.nextEvent().asStartElement().getName(), xmlOptions);
            StaxXmlParserUtils$.MODULE$.skipChildren(parser2, elementName1, xmlOptions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)parser2.peek().getEventType()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            String elementName2 = StaxXmlParserUtils$.MODULE$.getName(parser2.peek().asStartElement().getName(), xmlOptions);
            String $org_scalatest_assert_macro_left3 = StaxXmlParserUtils$.MODULE$.getName(parser2.peek().asStartElement().getName(), xmlOptions);
            String $org_scalatest_assert_macro_right3 = elementName2;
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            parser2.nextEvent();
            StaxXmlParserUtils$.MODULE$.skipChildren(parser2, elementName2, xmlOptions);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)parser2.peek().getEventType()));
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            String $org_scalatest_assert_macro_left5 = StaxXmlParserUtils$.MODULE$.getName(parser2.peek().asEndElement().getName(), xmlOptions);
            String $org_scalatest_assert_macro_right5 = "info";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("XML Input Factory disables DTD parsing", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.factory().getProperty("javax.xml.stream.isSupportingExternalEntities"));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.factory().getProperty("javax.xml.stream.supportDTD"));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("StaxXmlParserUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }
}

