/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Locale;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaSuite$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaTest;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u001d4AAB\u0004\u0001-!)1\u0004\u0001C\u00019!)a\u0004\u0001C\u0001?!)\u0011\b\u0001C\u0005u!9a\nAI\u0001\n\u0013y\u0005\"B\u001d\u0001\t\u0013Q&A\u0005)beF,X\r^*dQ\u0016l\u0017mU;ji\u0016T!\u0001C\u0005\u0002\u000fA\f'/];fi*\u0011!bC\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\r\u001b\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003\u001dI!AG\u0004\u0003#A\u000b'/];fiN\u001b\u0007.Z7b)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\u0013i\u0016\u001cHoU2iK6\fW*[:nCR\u001c\u0007\u000eF\u0002!IM\u0002\"!\t\u0012\u000e\u0003=I!aI\b\u0003\u001dM\u0003\u0018M]6Fq\u000e,\u0007\u000f^5p]\")QE\u0001a\u0001M\u0005!\u0001/\u0019;i!\t9\u0003G\u0004\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\u00111&F\u0001\u0007yI|w\u000e\u001e \u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_1BQ\u0001\u000e\u0002A\u0002U\nqC^3di>\u0014\u0018N_3e%\u0016\fG-\u001a:F]\u0006\u0014G.\u001a3\u0011\u0005Y:T\"\u0001\u0017\n\u0005ab#a\u0002\"p_2,\u0017M\\\u0001\u0013i\u0016\u001cHoU2iK6\f7\t\\5qa&tw\r\u0006\u0004<}\u0001\u0013%\n\u0014\t\u0003mqJ!!\u0010\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f\r\u0001\rAJ\u0001\ti\u0016\u001cHOT1nK\")\u0011i\u0001a\u0001M\u0005i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006DQaQ\u0002A\u0002\u0011\u000babY1uC2L8\u000f^*dQ\u0016l\u0017\r\u0005\u0002F\u00116\taI\u0003\u0002H\u001b\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B&\u0004\u0001\u00041\u0013AD3ya\u0016\u001cG/\u001a3TG\",W.\u0019\u0005\b\u001b\u000e\u0001\n\u00111\u00016\u00035\u0019\u0017m]3TK:\u001c\u0018\u000e^5wK\u0006aB/Z:u'\u000eDW-\\1DY&\u0004\b/\u001b8hI\u0011,g-Y;mi\u0012*T#\u0001)+\u0005U\n6&\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016!C;oG\",7m[3e\u0015\t9F&\u0001\u0006b]:|G/\u0019;j_:L!!\u0017+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\u0004<7rkfL\u001a\u0005\u0006\u007f\u0015\u0001\rA\n\u0005\u0006\u0003\u0016\u0001\rA\n\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u0017\u0016\u0001\ra\u0018\t\u0003A\u0012l\u0011!\u0019\u0006\u0003E\u000e\faa]2iK6\f'B\u0001\u0005\u0012\u0013\t)\u0017MA\u0006NKN\u001c\u0018mZ3UsB,\u0007\"B'\u0006\u0001\u0004)\u0004")
public class ParquetSchemaSuite
extends ParquetSchemaTest {
    public SparkException testSchemaMismatch(String path, boolean vectorizedReaderEnabled) {
        ObjectRef e = ObjectRef.create(null);
        this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)Boolean.toString(vectorizedReaderEnabled))}), (JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$2(ParquetSchemaSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)"bcd", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$2(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).coalesce(1).write().mode("overwrite").parquet(path + "/parquet");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$2(ParquetSchemaSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"abc"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$2(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).coalesce(1).write().mode("append").parquet(path + "/parquet");
            e$1.elem = (SparkException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().parquet(path + "/parquet").collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1033));
        });
        return (SparkException)e.elem;
    }

    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, String expectedSchema, boolean caseSensitive) {
        this.testSchemaClipping(testName, parquetSchema, catalystSchema, MessageTypeParser.parseMessageType((String)expectedSchema), caseSensitive);
    }

    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, MessageType expectedSchema, boolean caseSensitive) {
        this.test("Clipping - " + testName, (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            MessageType actual = ParquetReadSupport$.MODULE$.clipParquetSchema(MessageTypeParser.parseMessageType((String)parquetSchema), catalystSchema, caseSensitive, false);
            try {
                expectedSchema.checkContains((Type)actual);
                actual.checkContains((Type)expectedSchema);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable cause) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Expected clipped schema:\n             |" + expectedSchema + "\n             |Actual clipped schema:\n             |" + actual + "\n           ")), cause, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2469));
            }
            return boxedUnit;
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2458));
    }

    private boolean testSchemaClipping$default$5() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$4(ParquetSchemaSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df1 = $this.spark().range(3L);
        df1.write().parquet(path + "/p=1");
        Dataset df2 = $this.spark().range(3L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).cast((DataType)IntegerType$.MODULE$).as((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
        df2.write().parquet(path + "/p=2");
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> $this.spark().read().option("mergeSchema", "true").parquet(path), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989)), "CANNOT_MERGE_SCHEMAS", "42KD9", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)df1.schema())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)df2.schema()))})));
    }

    public static final /* synthetic */ void $anonfun$new$9(ParquetSchemaSuite $this, boolean caseSensitive$1, File path) {
        $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), $this.testImplicits().newIntEncoder()).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col"})).write().mode("append").parquet(path.getCanonicalPath());
        $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), $this.testImplicits().newIntEncoder()).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COL"})).write().mode("append").parquet(path.getCanonicalPath());
        Dataset df = $this.spark().read().option("mergeSchema", "true").parquet(path.getCanonicalPath());
        if (caseSensitive$1) {
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.columns())).sorted((Ordering)Ordering.String$.MODULE$);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"COL", (List)new .colon.colon((Object)"col", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
            Row[] $org_scalatest_assert_macro_left2 = (Row[])df.collect();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
            return;
        }
        scala.collection.immutable.Seq $org_scalatest_assert_macro_left = (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT));
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"col", (List)Nil$.MODULE$);
        scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
        .colon.colon colon3 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
        Row[] $org_scalatest_assert_macro_left3 = (Row[])df.collect();
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1014));
    }

    public static final /* synthetic */ void $anonfun$new$12(ParquetSchemaSuite $this, File dir) {
        SparkException e = $this.testSchemaMismatch(dir.getCanonicalPath(), false);
        String expectedMessage = "Encountered error while reading file";
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.parquet.io.ParquetDecodingException", $org_scalatest_assert_macro_left instanceof ParquetDecodingException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
        String $org_scalatest_assert_macro_left2 = e.getMessage();
        String $org_scalatest_assert_macro_right = expectedMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1045));
    }

    public static final /* synthetic */ boolean $anonfun$new$15(StructField x$2) {
        String string = x$2.name();
        String string2 = "a";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$14(ParquetSchemaSuite $this, File dir) {
        StructField[] col;
        SparkException e = $this.testSchemaMismatch(dir.getCanonicalPath(), true);
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException", $org_scalatest_assert_macro_left instanceof SchemaColumnConvertNotSupportedException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
        String file = (String)e.getMessageParameters().get("path");
        StructField[] $org_scalatest_assert_macro_left2 = col = (StructField[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().parquet(file).schema().fields()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaSuite.$anonfun$new$15(x$2)));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1055));
        DataType dataType = col[0].dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            $this.checkErrorMatchPVals((SparkThrowable)e, "FAILED_READ_FILE.PARQUET_COLUMN_DATA_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)(".*" + dir.getCanonicalPath() + ".*")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)"\\[a\\]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)"int"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)"BINARY")})));
            return;
        }
        $this.checkErrorMatchPVals((SparkThrowable)e, "FAILED_READ_FILE.PARQUET_COLUMN_DATA_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)(".*" + dir.getCanonicalPath() + ".*")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)"\\[a\\]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)"string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)"INT32")})));
    }

    public static final /* synthetic */ void $anonfun$new$17(ParquetSchemaSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        LocalDateTime timestamp = LocalDateTime.of(1, 2, 3, 4, 5);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$3(ParquetSchemaSuite $outer) {
            }
        }
        Dataset df1 = $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)timestamp), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator10$3(null)))).toDF();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ParquetSchemaSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$3(ParquetSchemaSuite $outer) {
            }
        }
        Dataset df2 = $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new LocalDateTime[]{timestamp}), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetSchemaSuite$$typecreator20$3(null)))).toDF();
        df1.write().mode("overwrite").parquet(path + "/parquet");
        df2.write().mode("append").parquet(path + "/parquet");
        $this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            SparkException e = (SparkException)$this.intercept((Function0 & Serializable)() -> (Row[])$this.spark().read().schema(df2.schema()).parquet(path + "/parquet").collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1094));
            Throwable $org_scalatest_assert_macro_left = e.getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException", $org_scalatest_assert_macro_left instanceof SchemaColumnConvertNotSupportedException, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(ParquetSchemaSuite $this, boolean int96AsTimestamp) {
        new .colon.colon((Object)SQLConf.ParquetOutputTimestampType$.MODULE$.INT96(), (List)new .colon.colon((Object)SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS(), (List)new .colon.colon((Object)SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)outputTsType -> {
            $this.testSchema("TimestampNTZ written and read as INT64 with TIMESTAMP_MICROS - int96AsTimestamp as " + int96AsTimestamp + ", outputTimestampType: " + outputTsType, StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n          |  optional INT64 f1 (TIMESTAMP(MICROS,false));\n          |}\n        ")), true, int96AsTimestamp, true, outputTsType, $this.testSchema$default$8(), $this.testSchema$default$9());
            return BoxedUnit.UNIT;
        });
        String x$191 = "TimestampNTZ read as INT64 with TIMESTAMP_MILLIS - int96AsTimestamp as " + int96AsTimestamp;
        StructType x$192 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$193 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  optional INT64 f1 (TIMESTAMP(MILLIS,false));\n        |}\n        "));
        boolean x$194 = true;
        boolean x$195 = int96AsTimestamp;
        boolean x$196 = true;
        boolean x$197 = $this.testParquetToCatalyst$default$6();
        Option<StructType> x$198 = $this.testParquetToCatalyst$default$8();
        Option<ParquetColumn> x$199 = $this.testParquetToCatalyst$default$9();
        boolean x$200 = $this.testParquetToCatalyst$default$10();
        $this.testParquetToCatalyst(x$191, x$192, x$193, true, x$195, x$197, true, x$198, x$199, x$200);
    }

    public static final /* synthetic */ void $anonfun$new$26(ParquetSchemaSuite $this, boolean inferTimestampNTZ) {
        TimestampNTZType$ dataType = inferTimestampNTZ ? TimestampNTZType$.MODULE$ : TimestampType$.MODULE$;
        String x$207 = "TimestampNTZ Parquet to Spark conversion for complex types, inferTimestampNTZ: " + inferTimestampNTZ;
        StructType x$208 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)ArrayType$.MODULE$.apply((DataType)dataType), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f3", (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f4", (DataType)dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        String x$209 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message spark_schema {\n        |  optional int64 f1 (TIMESTAMP(MICROS,false));\n        |  optional group f2 (LIST) {\n        |    repeated group list {\n        |      optional int64 element (TIMESTAMP(MICROS,false));\n        |    }\n        |  }\n        |  optional group f3 {\n        |    optional int64 f4 (TIMESTAMP(MICROS,false));\n        |  }\n        |}\n        "));
        boolean x$210 = true;
        boolean x$211 = false;
        boolean x$212 = inferTimestampNTZ;
        boolean x$213 = $this.testParquetToCatalyst$default$6();
        Option<StructType> x$214 = $this.testParquetToCatalyst$default$8();
        Option<ParquetColumn> x$215 = $this.testParquetToCatalyst$default$9();
        boolean x$216 = $this.testParquetToCatalyst$default$10();
        $this.testParquetToCatalyst(x$207, x$208, x$209, true, false, x$213, x$212, x$214, x$215, x$216);
    }

    public static final /* synthetic */ void $anonfun$new$28(ParquetSchemaSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        .colon.colon data = new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Decimal$.MODULE$.apply("13.0")})), (List)Nil$.MODULE$);
        DecimalType wideDecimal = new DecimalType(32, 10);
        StructType initialSchema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)wideDecimal, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType evolvedSchemaWithDefaultValue = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)wideDecimal, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)wideDecimal, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withExistenceDefaultValue("42.0"), (List)Nil$.MODULE$)));
        Dataset df = $this.spark().createDataFrame(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)data).asJava(), initialSchema);
        df.write().mode("overwrite").parquet(path + "/parquet");
        $this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            Row[] res;
            Row[] $org_scalatest_assert_macro_left = res = (Row[])$this.spark().read().schema(evolvedSchemaWithDefaultValue).parquet(path + "/parquet").collect();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2435));
            long $org_scalatest_assert_macro_left2 = res[0].getDecimal(0).toBigInteger().longValueExact();
            int $org_scalatest_assert_macro_right2 = 13;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2436));
            long $org_scalatest_assert_macro_left3 = res[0].getDecimal(1).toBigInteger().longValueExact();
            int $org_scalatest_assert_macro_right3 = 42;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2437));
        });
    }

    public ParquetSchemaSuite() {
        this.test("DataType string parser compatibility", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String caseClassString = "StructType(List(StructField(c1,IntegerType,false), StructField(c2,BinaryType,true)))";
            String jsonString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"c1\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"c2\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}}]}";
            StructType fromCaseClassString = StructType$.MODULE$.fromString(caseClassString);
            StructType fromJson = StructType$.MODULE$.fromString(jsonString);
            fromCaseClassString.lazyZip((Iterable)fromJson).foreach((Function2 & Serializable)(a, b) -> {
                String $org_scalatest_assert_macro_left = a.name();
                String $org_scalatest_assert_macro_right = b.name();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 973));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(a.dataType());
                DataType $org_scalatest_assert_macro_right2 = b.dataType();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)a.nullable()));
                boolean $org_scalatest_assert_macro_right3 = b.nullable();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
            });
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        this.test("CANNOT_MERGE_SCHEMAS: Failed merging schemas", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$4(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
        this.test("SPARK-45346: merge schema should respect case sensitivity", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)caseSensitive -> {
            this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)caseSensitive)))}), (JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
                ParquetSchemaSuite.$anonfun$new$9($this, caseSensitive, path);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1000));
        this.test("schema mismatch failure error message for parquet reader", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$12(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1040));
        this.test("schema mismatch failure error message for parquet vectorized reader", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$14(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1049));
        this.test("SPARK-45604: schema mismatch failure error on timestamp_ntz to array<timestamp_ntz>", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$17(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
        this.test("SPARK-40819: parquet file with TIMESTAMP(NANOS, true) (with nanosAsLong=true)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String tsAttribute = "birthday";
            return (Assertion)this.withSQLConf((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                String testDataPath = this.testFile("test-data/timestamp-nanos.parquet");
                Dataset data = this.spark().read().parquet(testDataPath).select(tsAttribute, (scala.collection.immutable.Seq)Nil$.MODULE$);
                DataType $org_scalatest_assert_macro_left = ((StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()))).dataType();
                LongType$ $org_scalatest_assert_macro_right = LongType$.MODULE$;
                DataType dataType = $org_scalatest_assert_macro_left;
                LongType$ longType$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1107));
                long $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToLong((Object)((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])data.orderBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.desc(tsAttribute)})).take(1)))).getAs(0));
                long $org_scalatest_assert_macro_right2 = 1668537129123534758L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108));
            });
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
        this.test("SPARK-40819: parquet file with TIMESTAMP(NANOS, true) (with default nanosAsLong=false)", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String testDataPath = this.testFile("test-data/timestamp-nanos.parquet");
            AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().parquet(testDataPath).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1114));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Illegal Parquet type: INT64 (TIMESTAMP(NANOS,true)).";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1117));
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
        String x$1 = "Backwards-compatibility: LIST with nullable element type - 1 - standard";
        StructType x$2 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    "));
        boolean x$4 = true;
        boolean x$5 = true;
        Some x$6 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL, 1, 3, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$7 = this.testParquetToCatalyst$default$6();
        boolean x$8 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$9 = this.testParquetToCatalyst$default$8();
        boolean x$10 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 1 - standard", x$2, x$3, true, true, x$7, x$8, x$9, (Option<ParquetColumn>)x$6, x$10);
        String x$11 = "Backwards-compatibility: LIST with nullable element type - 2";
        StructType x$12 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$13 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      optional int32 num;\n      |    }\n      |  }\n      |}\n    "));
        boolean x$14 = true;
        boolean x$15 = true;
        Some x$16 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL, 1, 3, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"num", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$17 = this.testParquetToCatalyst$default$6();
        boolean x$18 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$19 = this.testParquetToCatalyst$default$8();
        boolean x$20 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with nullable element type - 2", x$12, x$13, true, true, x$17, x$18, x$19, (Option<ParquetColumn>)x$16, x$20);
        String x$21 = "Backwards-compatibility: LIST with non-nullable element type - 1 - standard";
        StructType x$22 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$23 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    "));
        boolean x$24 = true;
        boolean x$25 = true;
        Some x$26 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"list", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$27 = this.testParquetToCatalyst$default$6();
        boolean x$28 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$29 = this.testParquetToCatalyst$default$8();
        boolean x$30 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 1 - standard", x$22, x$23, true, true, x$27, x$28, x$29, (Option<ParquetColumn>)x$26, x$30);
        String x$31 = "Backwards-compatibility: LIST with non-nullable element type - 2";
        StructType x$32 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$33 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    "));
        boolean x$34 = true;
        boolean x$35 = true;
        Some x$36 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"num", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$37 = this.testParquetToCatalyst$default$6();
        boolean x$38 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$39 = this.testParquetToCatalyst$default$8();
        boolean x$40 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 2", x$32, x$33, true, true, x$37, x$38, x$39, (Option<ParquetColumn>)x$36, x$40);
        String x$41 = "Backwards-compatibility: LIST with non-nullable element type - 3";
        StructType x$42 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$43 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 element;\n      |  }\n      |}\n    "));
        boolean x$44 = true;
        boolean x$45 = true;
        Some x$46 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REPEATED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$47 = this.testParquetToCatalyst$default$6();
        boolean x$48 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$49 = this.testParquetToCatalyst$default$8();
        boolean x$50 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 3", x$42, x$43, true, true, x$47, x$48, x$49, (Option<ParquetColumn>)x$46, x$50);
        String x$51 = "Backwards-compatibility: LIST with non-nullable element type - 4";
        StructType x$52 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$53 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group element {\n      |      required binary str (UTF8);\n      |      required int32 num;\n      |    }\n      |  }\n      |}\n    "));
        boolean x$54 = true;
        boolean x$55 = true;
        Some x$56 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("num", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (Option)None$.MODULE$, 1, 2, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"str", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"num", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$57 = this.testParquetToCatalyst$default$6();
        boolean x$58 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$59 = this.testParquetToCatalyst$default$8();
        boolean x$60 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 4", x$52, x$53, true, true, x$57, x$58, x$59, (Option<ParquetColumn>)x$56, x$60);
        String x$61 = "Backwards-compatibility: LIST with non-nullable element type - 5 - parquet-avro style";
        StructType x$62 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$63 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group array {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$64 = true;
        boolean x$65 = true;
        Some x$66 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 1, 2, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"array", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"array", (List)new .colon.colon((Object)"str", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$67 = this.testParquetToCatalyst$default$6();
        boolean x$68 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$69 = this.testParquetToCatalyst$default$8();
        boolean x$70 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 5 - parquet-avro style", x$62, x$63, true, true, x$67, x$68, x$69, (Option<ParquetColumn>)x$66, x$70);
        String x$71 = "Backwards-compatibility: LIST with non-nullable element type - 6 - parquet-thrift style";
        StructType x$72 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$73 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group f1_tuple {\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$74 = true;
        boolean x$75 = true;
        Some x$76 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("str", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 1, 2, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"f1_tuple", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"f1_tuple", (List)new .colon.colon((Object)"str", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$77 = this.testParquetToCatalyst$default$6();
        boolean x$78 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$79 = this.testParquetToCatalyst$default$8();
        boolean x$80 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type - 6 - parquet-thrift style", x$72, x$73, true, true, x$77, x$78, x$79, (Option<ParquetColumn>)x$76, x$80);
        String x$81 = "Backwards-compatibility: LIST with non-nullable element type 7 - parquet-protobuf primitive lists";
        StructType x$82 = new StructType().add("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false);
        String x$83 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  repeated int32 f1;\n      |}\n    "));
        boolean x$84 = true;
        boolean x$85 = true;
        Some x$86 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (Option)None$.MODULE$, 0, 0, true, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REPEATED, 1, 1, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$87 = this.testParquetToCatalyst$default$6();
        boolean x$88 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$89 = this.testParquetToCatalyst$default$8();
        boolean x$90 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 7 - parquet-protobuf primitive lists", x$82, x$83, true, true, x$87, x$88, x$89, (Option<ParquetColumn>)x$86, x$90);
        String x$91 = "Backwards-compatibility: LIST with non-nullable element type 8 - parquet-protobuf non-primitive lists";
        StructType elementType = new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false);
        StructType x$92 = new StructType().add("f1", (DataType)new ArrayType((DataType)elementType, false), false);
        String x$93 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  repeated group f1 {\n      |    optional binary c1 (UTF8);\n      |    required int32 c2;\n      |  }\n      |}\n    "));
        boolean x$94 = true;
        boolean x$95 = true;
        Some x$96 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false), false), false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new ArrayType((DataType)new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false), false), (Option)None$.MODULE$, 0, 0, true, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new StructType().add("c1", (DataType)StringType$.MODULE$, true).add("c2", (DataType)IntegerType$.MODULE$, false), (Option)None$.MODULE$, 1, 1, true, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 1, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"c2", (List)Nil$.MODULE$)), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
        boolean x$97 = this.testParquetToCatalyst$default$6();
        boolean x$98 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$99 = this.testParquetToCatalyst$default$8();
        boolean x$100 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: LIST with non-nullable element type 8 - parquet-protobuf non-primitive lists", x$92, x$93, true, true, x$97, x$98, x$99, (Option<ParquetColumn>)x$96, x$100);
        this.testCatalystToParquet("Backwards-compatibility: LIST with nullable element type - 1 - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      optional int32 element;\n      |    }\n      |  }\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: LIST with nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group bag {\n      |      optional int32 array;\n      |    }\n      |  }\n      |}\n    ")), true, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: LIST with non-nullable element type - 1 - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated group list {\n      |      required int32 element;\n      |    }\n      |  }\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: LIST with non-nullable element type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (LIST) {\n      |    repeated int32 array;\n      |  }\n      |}\n    ")), true, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        String x$101 = "Backwards-compatibility: MAP with non-nullable value type - 1 - standard";
        StructType x$102 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$103 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$104 = true;
        boolean x$105 = true;
        Some x$106 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$107 = this.testParquetToCatalyst$default$6();
        boolean x$108 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$109 = this.testParquetToCatalyst$default$8();
        boolean x$110 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 1 - standard", x$102, x$103, true, true, x$107, x$108, x$109, (Option<ParquetColumn>)x$106, x$110);
        String x$111 = "Backwards-compatibility: MAP with non-nullable value type - 2";
        StructType x$112 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$113 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group key_value {\n      |      required int32 num;\n      |      required binary str (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$114 = true;
        boolean x$115 = true;
        Some x$116 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"num", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"str", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$117 = this.testParquetToCatalyst$default$6();
        boolean x$118 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$119 = this.testParquetToCatalyst$default$8();
        boolean x$120 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 2", x$112, x$113, true, true, x$117, x$118, x$119, (Option<ParquetColumn>)x$116, x$120);
        String x$121 = "Backwards-compatibility: MAP with non-nullable value type - 3 - prior to 1.4.x";
        StructType x$122 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$123 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$124 = true;
        boolean x$125 = true;
        Some x$126 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$127 = this.testParquetToCatalyst$default$6();
        boolean x$128 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$129 = this.testParquetToCatalyst$default$8();
        boolean x$130 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with non-nullable value type - 3 - prior to 1.4.x", x$122, x$123, true, true, x$127, x$128, x$129, (Option<ParquetColumn>)x$126, x$130);
        String x$131 = "Backwards-compatibility: MAP with nullable value type - 1 - standard";
        StructType x$132 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$133 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$134 = true;
        boolean x$135 = true;
        Some x$136 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL, 1, 3, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$137 = this.testParquetToCatalyst$default$6();
        boolean x$138 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$139 = this.testParquetToCatalyst$default$8();
        boolean x$140 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 1 - standard", x$132, x$133, true, true, x$137, x$138, x$139, (Option<ParquetColumn>)x$136, x$140);
        String x$141 = "Backwards-compatibility: MAP with nullable value type - 2";
        StructType x$142 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$143 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group key_value {\n      |      required int32 num;\n      |      optional binary str (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$144 = true;
        boolean x$145 = true;
        Some x$146 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"num", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL, 1, 3, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"str", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$147 = this.testParquetToCatalyst$default$6();
        boolean x$148 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$149 = this.testParquetToCatalyst$default$8();
        boolean x$150 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 2", x$142, x$143, true, true, x$147, x$148, x$149, (Option<ParquetColumn>)x$146, x$150);
        String x$151 = "Backwards-compatibility: MAP with nullable value type - 3 - parquet-avro style";
        StructType x$152 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$153 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    "));
        boolean x$154 = true;
        boolean x$155 = true;
        Some x$156 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL, 1, 3, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$157 = this.testParquetToCatalyst$default$6();
        boolean x$158 = this.testParquetToCatalyst$default$7();
        Option<StructType> x$159 = this.testParquetToCatalyst$default$8();
        boolean x$160 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("Backwards-compatibility: MAP with nullable value type - 3 - parquet-avro style", x$152, x$153, true, true, x$157, x$158, x$159, (Option<ParquetColumn>)x$156, x$160);
        this.testCatalystToParquet("Backwards-compatibility: MAP with non-nullable value type - 1 - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: MAP with non-nullable value type - 2 - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      required binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")), true, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: MAP with nullable value type - 1 - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("Backwards-compatibility: MAP with nullable value type - 3 - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP) {\n      |    repeated group key_value (MAP_KEY_VALUE) {\n      |      required int32 key;\n      |      optional binary value (UTF8);\n      |    }\n      |  }\n      |}\n    ")), true, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        String x$161 = "SPARK-36935: test case insensitive when converting Parquet schema";
        StructType x$162 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$163 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1;\n      |}\n    "));
        boolean x$164 = true;
        boolean x$165 = true;
        Some x$166 = new Some((Object)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        Some x$167 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)ShortType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL, 0, 1, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)));
        boolean x$168 = this.testParquetToCatalyst$default$6();
        boolean x$169 = this.testParquetToCatalyst$default$7();
        boolean x$170 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("SPARK-36935: test case insensitive when converting Parquet schema", x$162, x$163, true, true, x$168, x$169, (Option<StructType>)x$166, (Option<ParquetColumn>)x$167, x$170);
        String x$171 = "SPARK-36935: test case sensitive when converting Parquet schema";
        StructType x$172 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$173 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1;\n      |}\n    "));
        boolean x$174 = true;
        boolean x$175 = true;
        boolean x$176 = true;
        Some x$177 = new Some((Object)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        Some x$178 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)IntegerType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL, 0, 1, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), this.primitiveParquetColumn$default$7()), (List)Nil$.MODULE$)));
        boolean x$179 = this.testParquetToCatalyst$default$7();
        boolean x$180 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("SPARK-36935: test case sensitive when converting Parquet schema", x$172, x$173, true, true, true, x$179, (Option<StructType>)x$177, (Option<ParquetColumn>)x$178, x$180);
        String x$181 = "SPARK-36935: test Spark read schema with case sensitivity";
        StructType x$182 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)new MapType((DataType)ShortType$.MODULE$, (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("G1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("G2", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        String x$183 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional group f1 (MAP_KEY_VALUE) {\n      |    repeated group key_value {\n      |      required int32 key;\n      |      optional group value {\n      |        optional binary g1 (UTF8);\n      |        optional group g2 (LIST) {\n      |          repeated group list {\n      |            optional group element {\n      |              required int32 h1;\n      |              required double h2;\n      |            }\n      |          }\n      |        }\n      |      }\n      |    }\n      |  }\n      |}\n    "));
        boolean x$184 = true;
        boolean x$185 = true;
        Some x$186 = new Some((Object)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)new MapType((DataType)ShortType$.MODULE$, (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("G1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("G2", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        Some x$187 = new Some((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("F1", (DataType)new MapType((DataType)ShortType$.MODULE$, (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("G1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("G2", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option)None$.MODULE$, 0, 0, false, (scala.collection.immutable.Seq)Nil$.MODULE$, (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)new MapType((DataType)ShortType$.MODULE$, (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("G1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("G2", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), true), (Option)None$.MODULE$, 0, 1, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)ShortType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 1, 2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), this.primitiveParquetColumn$default$7()), (List)new .colon.colon((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("G1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("G2", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (Option)None$.MODULE$, 1, 3, false, (scala.collection.immutable.Seq)new .colon.colon((Object)"f1", (List)new .colon.colon((Object)"key_value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq)new .colon.colon((Object)this.primitiveParquetColumn((DataType)StringType$.MODULE$, PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL, 1, 4, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f1", "key_value", "value", "g1"}))), (Option<LogicalTypeAnnotation>)new Some((Object)LogicalTypeAnnotation.stringType())), (List)new .colon.colon((Object)new ParquetColumn((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), (Option)None$.MODULE$, 1, 4, false, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f1", "key_value", "value", "g2"})), (scala.collection.immutable.Seq)new .colon.colon((Object)new ParquetColumn((DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("H1", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("H2", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), (Option)None$.MODULE$, 2, 6, false, (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f1", "key_value", "value", "g2", "list", "element"})), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParquetColumn[]{this.primitiveParquetColumn((DataType)ByteType$.MODULE$, PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED, 2, 6, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f1", "key_value", "value", "g2", "list", "element", "h1"}))), this.primitiveParquetColumn$default$7()), this.primitiveParquetColumn((DataType)FloatType$.MODULE$, PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REQUIRED, 2, 6, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f1", "key_value", "value", "g2", "list", "element", "h2"}))), this.primitiveParquetColumn$default$7())}))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
        boolean x$188 = this.testParquetToCatalyst$default$6();
        boolean x$189 = this.testParquetToCatalyst$default$7();
        boolean x$190 = this.testParquetToCatalyst$default$10();
        this.testParquetToCatalyst("SPARK-36935: test Spark read schema with case sensitivity", x$182, x$183, true, true, x$188, x$189, (Option<StructType>)x$186, (Option<ParquetColumn>)x$187, x$190);
        this.testSchema("DECIMAL(1, 0) - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(1, 0));\n      |}\n    ")), true, true, false, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(8, 3) - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(8, 3));\n      |}\n    ")), true, true, false, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(9, 3) - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int32 f1 (DECIMAL(9, 3));\n      |}\n    ")), true, true, false, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(18, 3) - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional int64 f1 (DECIMAL(18, 3));\n      |}\n    ")), true, true, false, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(19, 3) - standard", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(19, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(9) f1 (DECIMAL(19, 3));\n      |}\n    ")), true, true, false, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(1, 0) - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(1, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(1) f1 (DECIMAL(1, 0));\n      |}\n    ")), true, true, true, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(8, 3) - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(8, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(4) f1 (DECIMAL(8, 3));\n      |}\n    ")), true, true, true, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(9, 3) - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(9, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(5) f1 (DECIMAL(9, 3));\n      |}\n    ")), true, true, true, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("DECIMAL(18, 3) - prior to 1.4.x", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)new DecimalType(18, 3), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional fixed_len_byte_array(8) f1 (DECIMAL(18, 3));\n      |}\n    ")), true, true, true, this.testSchema$default$7(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("Timestamp written and read as INT64 with TIMESTAMP_MILLIS", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional INT64 f1 (TIMESTAMP_MILLIS);\n      |}\n    ")), true, false, true, SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testSchema("Timestamp written and read as INT64 with TIMESTAMP_MICROS", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional INT64 f1 (TIMESTAMP_MICROS);\n      |}\n    ")), true, false, true, SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS(), this.testSchema$default$8(), this.testSchema$default$9());
        this.testCatalystToParquet("SPARK-36825: Year-month interval written and read as INT32", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)YearMonthIntervalType$.MODULE$.apply(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional INT32 f1;\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        this.testCatalystToParquet("SPARK-36825: Day-time interval written and read as INT64", StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)DayTimeIntervalType$.MODULE$.apply(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n      |  optional INT64 f1;\n      |}\n    ")), false, this.testCatalystToParquet$default$5(), this.testCatalystToParquet$default$6());
        scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)int96AsTimestamp -> {
            ParquetSchemaSuite.$anonfun$new$24(this, BoxesRunTime.unboxToBoolean((Object)int96AsTimestamp));
            return BoxedUnit.UNIT;
        });
        String x$201 = "TimestampNTZ Spark to Parquet conversion for complex types";
        StructType x$202 = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f1", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)ArrayType$.MODULE$.apply((DataType)TimestampNTZType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f3", (DataType)StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("f4", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        String x$203 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message spark_schema {\n      |  optional int64 f1 (TIMESTAMP(MICROS,false));\n      |  optional group f2 (LIST) {\n      |    repeated group list {\n      |      optional int64 element (TIMESTAMP(MICROS,false));\n      |    }\n      |  }\n      |  optional group f3 {\n      |    optional int64 f4 (TIMESTAMP(MICROS,false));\n      |  }\n      |}\n      "));
        boolean x$204 = false;
        boolean x$205 = true;
        Enumeration.Value x$206 = this.testCatalystToParquet$default$5();
        this.testCatalystToParquet("TimestampNTZ Spark to Parquet conversion for complex types", x$202, x$203, false, x$206, true);
        scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)inferTimestampNTZ -> {
            ParquetSchemaSuite.$anonfun$new$26(this, BoxesRunTime.unboxToBoolean((Object)inferTimestampNTZ));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-46056: schema with default existence value and binary array decimal type", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetSchemaSuite.$anonfun$new$28(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2411));
        StructType f0Type = new StructType().add("f00", (DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("simple nested struct", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |    optional int32 f01;\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type, false).add("f1", (DataType)IntegerType$.MODULE$, true), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |  }\n        |  optional int32 f1;\n        |}\n      ")), this.testSchemaClipping$default$5());
        ArrayType f00Type = new ArrayType((DataType)StringType$.MODULE$, false);
        ArrayType f01Type = new ArrayType((DataType)new StructType().add("f011", (DataType)DoubleType$.MODULE$, true), false);
        StructType f0Type2 = new StructType().add("f00", (DataType)f00Type, false).add("f01", (DataType)f01Type, false);
        ArrayType f1Type = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("parquet-protobuf style array", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional int32 f010;\n        |      optional double f011;\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type2, false).add("f1", (DataType)f1Type, true), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    repeated binary f00 (UTF8);\n        |    repeated group f01 {\n        |      optional double f011;\n        |    }\n        |  }\n        |\n        |  optional group f1 (LIST) {\n        |    repeated group list {\n        |      optional int32 element;\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType f01ElementType = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type3 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType, false), true);
        this.testSchemaClipping("parquet-thrift style array", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type3, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary f00_tuple (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group f01_tuple {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType f01ElementType2 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type4 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType2, false), true);
        this.testSchemaClipping("parquet-avro style array", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional int32 f010;\n        |        optional double f011;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type4, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated binary array (UTF8);\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group array {\n        |        optional double f011;\n        |        optional int64 f012;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType f01ElementType3 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type5 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType3, true), true);
        this.testSchemaClipping("parquet-hive style array", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type5, true), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  optional group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group bag {\n        |        optional binary array_element;\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group bag {\n        |        optional group array_element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType f00ElementType = new StructType().add("f001", (DataType)LongType$.MODULE$, true).add("f002", (DataType)DoubleType$.MODULE$, false);
        ArrayType f00Type2 = new ArrayType((DataType)f00ElementType, false);
        StructType f0Type6 = new StructType().add("f00", (DataType)f00Type2, false);
        this.testSchemaClipping("2-level list of required struct", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        required int32 f000;\n         |        optional int64 f001;\n         |      }\n         |    }\n         |  }\n         |}\n       ")), new StructType().add("f0", (DataType)f0Type6, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n         |  required group f0 {\n         |    required group f00 (LIST) {\n         |      repeated group element {\n         |        optional int64 f001;\n         |        required double f002;\n         |      }\n         |    }\n         |  }\n         |}\n       ")), this.testSchemaClipping$default$5());
        StructType f01ElementType4 = new StructType().add("f011", (DataType)DoubleType$.MODULE$, true).add("f012", (DataType)LongType$.MODULE$, true);
        StructType f0Type7 = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true).add("f01", (DataType)new ArrayType((DataType)f01ElementType4, false), true);
        this.testSchemaClipping("standard array", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional int32 f010;\n        |          optional double f011;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type7, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional group f00 (LIST) {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) {\n        |      repeated group list {\n        |        required group element {\n        |          optional double f011;\n        |          optional int64 f012;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        this.testSchemaClipping("empty requested schema", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")), new StructType(), ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE(), true);
        this.testSchemaClipping("disjoint field sets", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    required int32 f00;\n        |    required int64 f01;\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)new StructType().add("f02", (DataType)FloatType$.MODULE$, true).add("f03", (DataType)DoubleType$.MODULE$, true), true), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional float f02;\n        |    optional double f03;\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType valueType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type8 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType, false);
        this.testSchemaClipping("parquet-avro style map", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type8, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value (MAP_KEY_VALUE) {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType valueType2 = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type9 = new MapType((DataType)IntegerType$.MODULE$, (DataType)valueType2, false);
        this.testSchemaClipping("standard map", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type9, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required int32 key;\n        |      required group value {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType keyType = new StructType().add("value_f1", (DataType)LongType$.MODULE$, false).add("value_f2", (DataType)DoubleType$.MODULE$, false);
        MapType f0Type10 = new MapType((DataType)keyType, (DataType)IntegerType$.MODULE$, false);
        this.testSchemaClipping("standard map with complex key", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int32 value_f0;\n        |        required int64 value_f1;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")), new StructType().add("f0", (DataType)f0Type10, false), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) {\n        |    repeated group key_value {\n        |      required group key {\n        |        required int64 value_f1;\n        |        required double value_f2;\n        |      }\n        |      required int32 value;\n        |    }\n        |  }\n        |}\n      ")), this.testSchemaClipping$default$5());
        StructType nestedType = new StructType().add("b", (DataType)IntegerType$.MODULE$, true);
        this.testSchemaClipping("case-insensitive resolution: no ambiguity", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group A {\n        |    optional int32 B;\n        |  }\n        |  optional int32 c;\n        |}\n      ")), new StructType().add("a", (DataType)nestedType, true).add("c", (DataType)IntegerType$.MODULE$, true), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n        |  required group A {\n        |    optional int32 B;\n        |  }\n        |  optional int32 c;\n        |}\n      ")), false);
        this.test("Clipping - case-insensitive resolution: more than one field is matched", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String parquetSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("message root {\n          |  required group A {\n          |    optional int32 B;\n          |  }\n          |  optional int32 c;\n          |  optional int32 a;\n          |}\n        "));
            StructType nestedType = new StructType().add("b", (DataType)IntegerType$.MODULE$, true);
            StructType catalystSchema = new StructType().add("a", (DataType)nestedType, true).add("c", (DataType)IntegerType$.MODULE$, true);
            return this.assertThrows((Function0 & Serializable)() -> ParquetReadSupport$.MODULE$.clipParquetSchema(MessageTypeParser.parseMessageType((String)parquetSchema), catalystSchema, false, false), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3025));
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3009));
    }
}

