/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.time.Period;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.CommonFileDataSourceSuite;
import org.apache.spark.sql.execution.datasources.FileBasedDataSourceTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TestUDT;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005M2Qa\u0001\u0003\u0002\u0002MAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005R)\u0012a\u0003U1scV,GOR5mK\u001a{'/\\1u'VLG/\u001a\u0006\u0003\u000b\u0019\tq\u0001]1scV,GO\u0003\u0002\b\u0011\u0005YA-\u0019;bg>,(oY3t\u0015\tI!\"A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0002D\u0001\u0004gFd'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0006\r\u001dEA\u0011QCF\u0007\u0002\u0015%\u0011qC\u0003\u0002\n#V,'/\u001f+fgR\u0004\"!\u0007\u000e\u000e\u0003\u0011I!a\u0007\u0003\u0003\u0017A\u000b'/];fiR+7\u000f\u001e\t\u0003;\u0001j\u0011A\b\u0006\u0003?)\tA\u0001^3ti&\u0011\u0011E\b\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002$I5\ta!\u0003\u0002&\r\tI2i\\7n_:4\u0015\u000e\\3ECR\f7k\\;sG\u0016\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002\u001a\u0001\u0005\u0001B-\u0019;b'>,(oY3G_Jl\u0017\r^\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\r")
public abstract class ParquetFileFormatSuite
extends QueryTest
implements ParquetTest,
SharedSparkSession,
CommonFileDataSourceSuite {
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private String dataSourceName;
    private String vectorizedReaderEnabledKey;
    private String vectorizedReaderNestedEnabledKey;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public Dataset<?> inputDataset() {
        return CommonFileDataSourceSuite.inputDataset$(this);
    }

    @Override
    public void withCorruptFile(Function1<File, BoxedUnit> f) {
        CommonFileDataSourceSuite.withCorruptFile$(this, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$(this, path, testVectorized, f);
    }

    @Override
    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$(this, data, f, evidence$1, evidence$2);
    }

    @Override
    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$(this, data, testVectorized, f, evidence$3, evidence$4);
    }

    @Override
    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$(this, data, tableName, testVectorized, f, evidence$5, evidence$6);
    }

    @Override
    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$(this);
    }

    @Override
    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, path, evidence$7, evidence$8);
    }

    @Override
    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, path, evidence$9, evidence$10);
    }

    @Override
    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$(this, basePath, defaultPartitionName, partitionCols);
    }

    @Override
    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$(this, schema, path, configuration);
    }

    @Override
    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$(this, parquetSchema, path, configuration, extraMetadata);
    }

    @Override
    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$(this);
    }

    @Override
    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$(this, path, configuration);
    }

    @Override
    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$(this, path, configuration);
    }

    @Override
    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$(this, testName, f);
    }

    @Override
    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$(this, name);
    }

    @Override
    public String getResourceParquetFilePath(String name) {
        return ParquetTest.getResourceParquetFilePath$(this, name);
    }

    @Override
    public <T> StructType schemaFor(TypeTags.TypeTag<T> evidence$11) {
        return ParquetTest.schemaFor$(this, evidence$11);
    }

    @Override
    public void withAllParquetReaders(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetReaders$(this, code);
    }

    @Override
    public void withAllParquetWriters(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetWriters$(this, code);
    }

    @Override
    public Map<String, String> getMetaData(File dir) {
        return ParquetTest.getMetaData$(this, dir);
    }

    @Override
    public void readFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        FileBasedDataSourceTest.readFile$(this, path, testVectorized, f);
    }

    @Override
    public boolean readFile$default$2() {
        return FileBasedDataSourceTest.readFile$default$2$(this);
    }

    @Override
    public <T extends Product> void withDataSourceFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        FileBasedDataSourceTest.withDataSourceFile$(this, data, f, evidence$1, evidence$2);
    }

    @Override
    public <T extends Product> void withDataSourceDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        FileBasedDataSourceTest.withDataSourceDataFrame$(this, data, testVectorized, f, evidence$3, evidence$4);
    }

    @Override
    public <T extends Product> boolean withDataSourceDataFrame$default$2() {
        return FileBasedDataSourceTest.withDataSourceDataFrame$default$2$(this);
    }

    @Override
    public <T extends Product> void withDataSourceTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        FileBasedDataSourceTest.withDataSourceTable$(this, data, tableName, testVectorized, f, evidence$5, evidence$6);
    }

    @Override
    public <T extends Product> boolean withDataSourceTable$default$3() {
        return FileBasedDataSourceTest.withDataSourceTable$default$3$(this);
    }

    @Override
    public <T extends Product> void makeDataSourceFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, data, path, evidence$7, evidence$8);
    }

    @Override
    public <T extends Product> void makeDataSourceFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, df, path, evidence$9, evidence$10);
    }

    @Override
    public Seq<Tuple3<Dataset<Row>, String, Function1<Object, Object>>> withNestedDataFrame(Dataset<Row> inputDF) {
        return FileBasedDataSourceTest.withNestedDataFrame$(this, inputDF);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ Object org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        return SQLConfHelper.withSQLConf$((SQLConfHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$(this, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public String dataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public String vectorizedReaderEnabledKey() {
        return this.vectorizedReaderEnabledKey;
    }

    @Override
    public String vectorizedReaderNestedEnabledKey() {
        return this.vectorizedReaderNestedEnabledKey;
    }

    @Override
    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$dataSourceName_$eq(String x$1) {
        this.dataSourceName = x$1;
    }

    @Override
    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderEnabledKey_$eq(String x$1) {
        this.vectorizedReaderEnabledKey = x$1;
    }

    @Override
    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderNestedEnabledKey_$eq(String x$1) {
        this.vectorizedReaderNestedEnabledKey = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    @Override
    public String dataSourceFormat() {
        return "parquet";
    }

    private final void testImplicits$lzycompute$1() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        ParquetFileFormatSuite parquetFileFormatSuite = this;
        synchronized (parquetFileFormatSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(ParquetFileFormatSuite $this, boolean ignoreCorruptFiles$1, File dir) {
        Seq footers;
        FileSystem fs = FileSystem.get((Configuration)$this.spark().sessionState().newHadoopConf());
        String basePath = dir.getCanonicalPath();
        Path path1 = new Path(basePath, "first");
        Path path2 = new Path(basePath, "second");
        Path path3 = new Path(basePath, "third");
        $this.spark().range(1L).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(1).write().parquet(path1.toString());
        $this.spark().range(1L, 2L).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(1).write().parquet(path2.toString());
        $this.spark().range(2L, 3L).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(1).write().json(path3.toString());
        Seq fileStatuses = (Seq)new .colon.colon((Object)fs.listStatus(path1), (List)new .colon.colon((Object)fs.listStatus(path2), (List)new .colon.colon((Object)fs.listStatus(path3), (List)Nil$.MODULE$))).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        Seq $org_scalatest_assert_macro_left = footers = ParquetFileFormat$.MODULE$.readParquetFootersInParallel($this.spark().sessionState().newHadoopConf(), fileStatuses, ignoreCorruptFiles$1);
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }

    private final void testReadFooters$1(boolean ignoreCorruptFiles) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            ParquetFileFormatSuite.$anonfun$new$2(this, ignoreCorruptFiles, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Period $anonfun$new$8(int i) {
        return Period.of(i, i, 0);
    }

    public static final /* synthetic */ Duration $anonfun$new$9(int i) {
        return Duration.ofDays(i).plusSeconds(i);
    }

    public static final /* synthetic */ void $anonfun$new$12(ParquetFileFormatSuite $this, IndexedSeq data$1, StructType schema$1, File file) {
        SparkContext qual$1 = $this.sparkContext();
        IndexedSeq x$1 = data$1;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = $this.spark().createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema$1);
        df.write().parquet(file.getCanonicalPath());
        $this.withAllParquetReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df2 = $this.spark().read().parquet(file.getCanonicalPath());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df2, (Seq<Row>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect())));
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(ParquetFileFormatSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AnsiIntervalType it = (AnsiIntervalType)tuple2._1();
            Function1 f = (Function1)tuple2._2();
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), f.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)))})));
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("d", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("i", (DataType)it, false, StructField$.MODULE$.apply$default$4())}));
            $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                ParquetFileFormatSuite.$anonfun$new$12($this, data, schema, file);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ParquetFileFormatSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        FileBasedDataSourceTest.$init$(this);
        ParquetTest.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        CommonFileDataSourceSuite.$init$(this);
        this.test("read parquet footers in parallel", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.testReadFooters$1(true);
            this.checkErrorMatchPVals((SparkThrowable)((SparkException)((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testReadFooters$1(false), ClassTag$.MODULE$.apply(SparkException.class), new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65))).getCause()), "FAILED_READ_FILE.CANNOT_READ_FILE_FOOTER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"file:.*")})));
        }, new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("SPARK-36825, SPARK-36854: year-month/day-time intervals written and read as INT32/INT64", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)offHeapEnabled -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.COLUMN_VECTOR_OFFHEAP_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)offHeapEnabled)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)YearMonthIntervalType$.MODULE$.apply()), (Function1 & Serializable)i -> ParquetFileFormatSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)i))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DayTimeIntervalType$.MODULE$.apply()), (Function1 & Serializable)i -> ParquetFileFormatSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)i))), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                ParquetFileFormatSuite.$anonfun$new$10($this, x0$1);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("support batch reads for schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestUDT.MyDenseVectorUDT testUDT = new TestUDT.MyDenseVectorUDT();
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enabled)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)new StructField("f1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)new StructField("f1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)new StructField("f1", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)testUDT, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Seq schema = (Seq)tuple2._1();
                        boolean expected = tuple2._2$mcZ$sp();
                        boolean $org_scalatest_assert_macro_left = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema($this.conf(), StructType$.MODULE$.apply(schema));
                        boolean $org_scalatest_assert_macro_right = expected;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                    }
                    throw new MatchError((Object)tuple2);
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("support batch reads for data type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestUDT.MyDenseVectorUDT testUDT = new TestUDT.MyDenseVectorUDT();
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enabled)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BooleanType$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrayType$.MODULE$.apply((DataType)TimestampType$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("f1", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)DateType$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testUDT), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrayType$.MODULE$.apply((DataType)testUDT)), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("f1", (DataType)ByteType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("f2", (DataType)testUDT, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MapType$.MODULE$.apply((DataType)testUDT, (DataType)BinaryType$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled)))})).foreach((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        DataType dt = (DataType)tuple2._1();
                        boolean expected = tuple2._2$mcZ$sp();
                        boolean $org_scalatest_assert_macro_left = ParquetUtils$.MODULE$.isBatchReadSupported($this.conf(), dt);
                        boolean $org_scalatest_assert_macro_right = expected;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                    }
                    throw new MatchError((Object)tuple2);
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        Statics.releaseFence();
    }
}

