/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForLong;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDeltaEncodingSuite;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005u4A\u0001E\t\u0001A!)1\u0006\u0001C\u0001Y!)a\u0006\u0001C)_!)a\u0007\u0001C)o!)a\u0007\u0001C)\u0001\")q\t\u0001C)\u0011\")\u0011\n\u0001C)\u0015\")Q\n\u0001C)\u001d\")q\n\u0001C)\u001d\")\u0001\u000b\u0001C)\u001d\")\u0011\u000b\u0001C)%\")q\f\u0001C)A\")!\r\u0001C)G\")a\r\u0001C)O\")A\u000e\u0001C)[\")A\u000f\u0001C)k\nA\u0002+\u0019:rk\u0016$H)\u001a7uC\u0016s7m\u001c3j]\u001eduN\\4\u000b\u0005I\u0019\u0012a\u00029beF,X\r\u001e\u0006\u0003)U\t1\u0002Z1uCN|WO]2fg*\u0011acF\u0001\nKb,7-\u001e;j_:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0007\t\u001aS%D\u0001\u0012\u0013\t!\u0013CA\rQCJ\fX/\u001a;EK2$\u0018-\u00128d_\u0012LgnZ*vSR,\u0007C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001\u0002'p]\u001e\fa\u0001P5oSRtD#A\u0017\u0011\u0005\t\u0002\u0011aD4fiN\u0003\u0018M]6Tc2$\u0016\u0010]3\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!aM\f\u0002\u000bQL\b/Z:\n\u0005U\u0012$\u0001D%oi\u0016<'/\u00197UsB,\u0017!C<sSR,G)\u0019;b)\tA4\b\u0005\u0002's%\u0011!h\n\u0002\u0005+:LG\u000fC\u0003=\u0007\u0001\u0007Q(\u0001\u0003eCR\f\u0007c\u0001\u0014?K%\u0011qh\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u000b\u0004q\u0005\u0013\u0005\"\u0002\u001f\u0005\u0001\u0004i\u0004\"B\"\u0005\u0001\u0004!\u0015A\u00027f]\u001e$\b\u000e\u0005\u0002'\u000b&\u0011ai\n\u0002\u0004\u0013:$\u0018\u0001E5oSR4\u0016\r\\;fg^\u0013\u0018\u000e^3s)\u0005A\u0014AD1mY>\u001cG)\u0019;b\u0003J\u0014\u0018-\u001f\u000b\u0003{-CQ\u0001\u0014\u0004A\u0002\u0011\u000bAa]5{K\u0006iq-\u001a;OKb$(+\u00198e_6,\u0012!J\u0001\u0010O\u0016$H+\u001f9f\u001b&tg+\u00197vK\u0006yq-\u001a;UsB,W*\u0019=WC2,X-\u0001\u0005sK\u0006$G)\u0019;b)\u0011A4+V/\t\u000bQS\u0001\u0019\u0001#\u0002\u000bQ|G/\u00197\t\u000bYS\u0001\u0019A,\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\u0005a[V\"A-\u000b\u0005i+\u0012A\u0003<fGR|'/\u001b>fI&\u0011A,\u0017\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\u000byS\u0001\u0019\u0001#\u0002\u000bI|w/\u00133\u0002\tM\\\u0017\u000e\u001d\u000b\u0003q\u0005DQ\u0001V\u0006A\u0002\u0011\u000b!C]3bI\u0012\u000bG/\u0019$s_64Vm\u0019;peR\u0019Q\u0005Z3\t\u000bYc\u0001\u0019A,\t\u000byc\u0001\u0019\u0001#\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f)\tA7\u000e\u0005\u0002'S&\u0011!n\n\u0002\u0007\t>,(\r\\3\t\u000b\rk\u0001\u0019\u0001#\u0002\u0011M,GOV1mk\u0016$B\u0001\u000f8qe\")qN\u0004a\u0001{\u0005\u0019\u0011M\u001d:\t\u000bEt\u0001\u0019\u0001#\u0002\u000b%tG-\u001a=\t\u000bMt\u0001\u0019\u0001#\u0002\u000bY\fG.^3\u0002\u001b\r|W\u000e]1sKZ\u000bG.^3t)\r1\u0018p\u001f\t\u0003M]L!\u0001_\u0014\u0003\u000f\t{w\u000e\\3b]\")!p\u0004a\u0001\t\u0006AQ\r\u001f9fGR,G\rC\u0003}\u001f\u0001\u0007Q%\u0001\u0004bGR,\u0018\r\u001c")
public class ParquetDeltaEncodingLong
extends ParquetDeltaEncodingSuite<Object> {
    @Override
    public IntegralType getSparkSqlType() {
        return LongType$.MODULE$;
    }

    public void writeData(long[] data) {
        this.writeData(data, data.length);
    }

    public void writeData(long[] data, int length) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.writer().writeLong(data[i]));
    }

    @Override
    public void initValuesWriter() {
        this.writer_$eq((ValuesWriter)new DeltaBinaryPackingValuesWriterForLong(this.blockSize(), this.miniBlockNum(), 100, 200, (ByteBufferAllocator)new DirectByteBufferAllocator()));
    }

    public long[] allocDataArray(int size) {
        return new long[size];
    }

    @Override
    public long getNextRandom() {
        return this.random().nextLong();
    }

    @Override
    public long getTypeMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public long getTypeMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public void readData(int total, WritableColumnVector columnVector, int rowId) {
        this.reader().readLongs(total, columnVector, rowId);
    }

    @Override
    public void skip(int total) {
        this.reader().skipLongs(total);
    }

    @Override
    public long readDataFromVector(WritableColumnVector columnVector, int rowId) {
        return columnVector.getLong(rowId);
    }

    @Override
    public double estimatedSize(int length) {
        int miniBlockSize = this.blockSize() / this.miniBlockNum();
        double miniBlockFlushed = Math.ceil(((double)length - 1.0) / (double)miniBlockSize);
        double blockFlushed = Math.ceil(((double)length - 1.0) / (double)this.blockSize());
        return (double)25 + (double)8 * miniBlockFlushed * (double)miniBlockSize + blockFlushed * (double)this.miniBlockNum() + 10.0 * blockFlushed;
    }

    public void setValue(long[] arr, int index, int value) {
        arr[index] = value;
    }

    @Override
    public boolean compareValues(int expected, long actual) {
        return (long)expected == actual;
    }
}

