/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcCompressionCodec;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcQuerySuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00012QAA\u0002\u0002\u0002IAQ!\b\u0001\u0005\u0002y\u0011Qb\u0014:d#V,'/_*vSR,'B\u0001\u0003\u0006\u0003\ry'o\u0019\u0006\u0003\r\u001d\t1\u0002Z1uCN|WO]2fg*\u0011\u0001\"C\u0001\nKb,7-\u001e;j_:T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u0018!\t!R#D\u0001\u0004\u0013\t12A\u0001\u0007Pe\u000e\fV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0013\u0005!A/Z:u\u0013\ta\u0012D\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0001 !\t!\u0002\u0001")
public abstract class OrcQuerySuite
extends OrcQueryTest
implements SharedSparkSession {
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        OrcTest.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        OrcTest.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$176(File x$31) {
        return x$31.getName().endsWith(".lzo.orc");
    }

    public static final /* synthetic */ void $anonfun$new$175(OrcQuerySuite $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", OrcCompressionCodec.LZO.name()).orc(file.getCanonicalPath());
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$176(x$31)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(OrcCompressionCodec.LZO.name());
            String $org_scalatest_assert_macro_right = reader.getCompressionKind().name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        });
    }

    public static final /* synthetic */ void $anonfun$new$180(OrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"empty_orc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"empty", "single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE empty_orc(key INT, value STRING)\n               |USING ORC\n               |LOCATION '" + dir.toURI() + "'\n             ")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator10$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator10$2(OrcQuerySuite $outer) {
                }
            }
            Dataset emptyDF = $this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().empty(), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator10$2(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            emptyDF.createOrReplaceTempView("empty");
            $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM empty\n             ")));
            Dataset df = $this.spark().read().orc(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = emptyDF.schema().asNullable();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Dataset<Row>)emptyDF);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$185(OrcQuerySuite $this, File dir) {
        String path = new File(dir, "orc").getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator20$1(OrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col.dots"})).write().orc(path);
        Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().read().orc(path).collect();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$196(Long x$36, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(x$36) + (long)i)), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x$36)), 5));
    }

    public static final /* synthetic */ boolean $anonfun$new$198(SparkPlan x0$1) {
        SparkPlan sparkPlan2 = x0$1;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$194(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})))}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator25$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(10L).map((Function1 & Serializable)x -> {
            String stringColumn = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 10);
            Tuple2 structColumn = new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 100));
            IndexedSeq arrayColumn = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> OrcQuerySuite.$anonfun$new$196(x, BoxesRunTime.unboxToInt((Object)i)));
            Map mapColumn = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(x)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.1)), (Object)new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 2)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.2)), (Object)new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 3)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.3)), (Object)new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 300))))}));
            return new Tuple5(x, (Object)stringColumn, (Object)structColumn, (Object)arrayColumn, (Object)mapColumn);
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator25$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int_col", "string_col", "struct_col", "array_col", "map_col"}));
        df.write().format("orc").save(path);
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
            Dataset readDf = $this.spark().read().orc(path);
            boolean vectorizationEnabled = readDf.queryExecution().executedPlan().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$198(x0$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vectorizationEnabled, "vectorizationEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> readDf, (Dataset<Row>)df);
        });
    }

    public static final /* synthetic */ String $anonfun$new$204(int k) {
        return Integer.toString(k);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$new$203(int x$33) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable)k -> OrcQuerySuite.$anonfun$new$204(BoxesRunTime.unboxToInt((Object)k)));
    }

    public static final /* synthetic */ boolean $anonfun$new$206(SparkPlan x0$2) {
        SparkPlan sparkPlan2 = x0$2;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$201(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator28$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator28$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(100L).map((Function1 & Serializable)x$32 -> {
            IndexedSeq arrayColumn = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable)x$33 -> OrcQuerySuite.$anonfun$new$203(BoxesRunTime.unboxToInt((Object)x$33)));
            return arrayColumn;
        }, $this.testImplicits().newSequenceEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator28$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"record"})).repartition(1);
        df.write().format("orc").save(path);
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
            Dataset readDf = $this.spark().read().orc(path);
            boolean vectorizationEnabled = readDf.queryExecution().executedPlan().exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$206(x0$2)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vectorizationEnabled, "vectorizationEnabled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> readDf, (Dataset<Row>)df);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$211(Long x$37, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(x$37) + (long)i)), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x$37)), 5));
    }

    public static final /* synthetic */ boolean $anonfun$new$214(SparkPlan x0$4) {
        SparkPlan sparkPlan2 = x0$4;
        if (sparkPlan2 instanceof FileSourceScanExec ? true : sparkPlan2 instanceof BatchScanExec) {
            return sparkPlan2.supportsColumnar();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$209(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator34$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})))}))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator34$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(10L).map((Function1 & Serializable)x -> {
            String stringColumn = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 10);
            Tuple2 structColumn = new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 100));
            IndexedSeq arrayColumn = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> OrcQuerySuite.$anonfun$new$211(x, BoxesRunTime.unboxToInt((Object)i)));
            Map mapColumn = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(x)), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)Predef$.MODULE$.Long2long(x) * 0.1)), (Object)new Tuple2(x, (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 100))))}));
            return new Tuple5(x, (Object)stringColumn, (Object)structColumn, (Object)arrayColumn, (Object)mapColumn);
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator34$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int_col", "string_col", "struct_col", "array_col", "map_col"}));
        df.write().format("orc").save(path);
        new .colon.colon((Object)new Tuple2((Object)"5", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"10", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String maxNumFields = (String)tuple2._1();
                boolean vectorizedEnabled = tuple2._2$mcZ$sp();
                return (Assertion)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_MAX_NUM_FIELDS().key()), (Object)maxNumFields)}), (Function0 & Serializable)() -> {
                    SparkPlan scanPlan = $this.spark().read().orc(path).queryExecution().executedPlan();
                    boolean $org_scalatest_assert_macro_left = scanPlan.exists((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$214(x0$4)));
                    boolean $org_scalatest_assert_macro_right = vectorizedEnabled;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$216(int i) {
        return new Tuple2((Object)new Timestamp(i), (Object)LocalDateTime.of(2019, 3, 21, 0, 2, 3, 456000000 + i));
    }

    public static final /* synthetic */ void $anonfun$new$222(OrcQuerySuite $this, String sqlText$1, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df = (Dataset)$this.sql().apply((Object)sqlText$1);
        df.write().mode("overwrite").orc(path);
        String query = "select * from `orc`.`" + path + "`";
        DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zoneId -> {
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zoneId, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)query$1), (Dataset<Row>)df)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$231(byte[] byteData$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)byteData$1);
    }

    public static final /* synthetic */ void $anonfun$new$228(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.IndexedSeq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(1L, 22L, 1L, 1).map((Function1 & Serializable)x$34 -> {
            byte[] byteData = (byte[])Array$.MODULE$.fill(0x100000, (Function0)(JFunction0.mcB.sp & Serializable)() -> 88, (ClassTag)ClassTag$.MODULE$.Byte());
            IndexedSeq mapData = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)i -> OrcQuerySuite.$anonfun$new$231(byteData, BoxesRunTime.unboxToInt((Object)i)));
            return mapData;
        }, $this.testImplicits().newSequenceEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator48$1(null)))).toDF();
        df.write().format("orc").save(path);
    }

    public static final /* synthetic */ void $anonfun$new$235(OrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df = $this.spark().range(1L, 1024L, 1L, 1).map((Function1 & Serializable)x$35 -> {
            byte[] byteData = (byte[])Array$.MODULE$.fill(0x500000, (Function0)(JFunction0.mcB.sp & Serializable)() -> 88, (ClassTag)ClassTag$.MODULE$.Byte());
            return byteData;
        }, $this.testImplicits().newByteArrayEncoder()).toDF();
        df.write().format("orc").save(path);
    }

    public static final /* synthetic */ void $anonfun$new$240(OrcQuerySuite $this, File dir) {
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator58$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator58$2(OrcQuerySuite $outer) {
            }
        }
        String path = dir.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        Dataset df = $this.spark().range(1L, 513L, 1L, 1).map((Function1 & Serializable)i -> {
            if (BoxesRunTime.equalsNumObject((Number)i, (Object)BoxesRunTime.boxToInteger((int)1))) {
                return new Tuple2(i, Array$.MODULE$.fill(0x500000, (Function0)(JFunction0.mcB.sp & Serializable)() -> 88, (ClassTag)ClassTag$.MODULE$.Byte()));
            }
            return new Tuple2(i, Array$.MODULE$.fill(1, (Function0)(JFunction0.mcB.sp & Serializable)() -> 88, (ClassTag)ClassTag$.MODULE$.Byte()));
        }, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator58$2(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"}));
        df.write().format("orc").save(path);
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().sql("create table t1 (c1 string,c2 binary) using orc location '" + path + "'");
            $this.spark().sql("select * from t1").collect();
        });
    }

    public OrcQuerySuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("LZO compression options for writing to an ORC file", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
            OrcQuerySuite.$anonfun$new$175(this, file);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("Schema discovery on empty ORC files", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$180(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        this.test("SPARK-21791 ORC should support column names with dot", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$185(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("SPARK-25579 ORC PPD should support column names with dot", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.checkPredicatePushDown((Dataset<Row>)this.spark().range(10L).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col.dot"})), 10, "`col.dot` == 2")), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        this.test("SPARK-20728 Make ORCFileFormat configurable between sql/hive and sql/core", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"hive")}), (Function0 & Serializable)() -> {
                AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
                String $org_scalatest_assert_macro_left = e.message();
                String $org_scalatest_assert_macro_right = "Hive built-in ORC data source must be used with Hive support";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"native")}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_20728"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Option fileFormat;
                this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC");
                Option $org_scalatest_assert_macro_left = fileFormat = ((Dataset)this.sql().apply((Object)"SELECT * FROM spark_20728")).queryExecution().analyzed().collectFirst((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation) {
                            LogicalRelation logicalRelation = (LogicalRelation)A1;
                            return (B1)((HadoopFsRelation)logicalRelation.relation()).fileFormat().getClass();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        return logicalPlan instanceof LogicalRelation;
                    }
                });
                Some $org_scalatest_assert_macro_right = new Some(OrcFileFormat.class);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            }));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("SPARK-34862: Support ORC vectorized reader for nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$194(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        this.test("SPARK-37728: Reading nested columns with ORC vectorized reader should not cause ArrayIndexOutOfBoundsException", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$201(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        this.test("SPARK-36594: ORC vectorized reader should properly check maximal number of fields", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$209(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        this.test("Read/write all timestamp types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator45$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator45$1(OrcQuerySuite $outer) {
                }
            }
            IndexedSeq data = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable)i -> OrcQuerySuite.$anonfun$new$216(BoxesRunTime.unboxToInt((Object)i))).$colon$plus((Object)new Tuple2(null, null));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
            this.withOrcFile(data, (Function1<String, BoxedUnit>)(Function1 & Serializable)file -> {
                this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
                    public final class $typecreator44$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public $typecreator44$1(OrcQuerySuite $outer) {
                        }
                    }
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().read().orc(file), (Row[])$this.testImplicits().localSeqToDatasetHolder((Seq)data$9, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator44$1(null)))).toDF().collect());
                });
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator45$1(null)));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("SPARK-37463: read/write Timestamp ntz to Orc with different time zone", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                      |select\n                      | timestamp_ntz '2021-06-01 00:00:00' ts_ntz1,\n                      | timestamp_ntz '1883-11-16 00:00:00.0' as ts_ntz2,\n                      | timestamp_ntz '2021-03-14 02:15:00.0' as ts_ntz3\n                      |"));
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcQuerySuite.$anonfun$new$222(this, sqlText, dir);
                return BoxedUnit.UNIT;
            });
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
        this.ignore("SPARK-39387: BytesColumnVector should not throw RuntimeException due to overflow", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$228(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
        this.test("SPARK-39381: Make vectorized orc columar writer batch size configurable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 100})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)batchSize -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_WRITER_BATCH_SIZE().key()), (Object)Integer.toString(batchSize))}), (JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$235(this, dir);
            return BoxedUnit.UNIT;
        }))), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
        this.test("SPARK-39830: Reading ORC table that requires type promotion may throw AIOOBE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_WRITER_BATCH_SIZE().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orc.stripe.size"), (Object)"10240"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orc.rows.between.memory.checks"), (Object)"1")}), (JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$240(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        Statics.releaseFence();
    }
}

