/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ExplainSuiteHelper;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileBasedDataSourceTest;
import org.apache.spark.sql.execution.datasources.FileSourceAggregatePushDownSuite;
import org.apache.spark.sql.execution.datasources.FileSourceAggregatePushDownSuite$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005)4qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003'\u0001\u0011\u0005q\u0005C\u0003/\u0001\u0019Eq\u0006C\u0004<\u0001\t\u0007i\u0011C\u0018\t\u000bq\u0002A\u0011B\u001f\t\u000bY\u0003A\u0011B,\u0003A\u0019KG.Z*pkJ\u001cW-Q4he\u0016<\u0017\r^3QkNDGi\\<o'VLG/\u001a\u0006\u0003\u0011%\t1\u0002Z1uCN|WO]2fg*\u0011!bC\u0001\nKb,7-\u001e;j_:T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u000b\u001a;\r\u0002\"AF\f\u000e\u0003-I!\u0001G\u0006\u0003\u0013E+XM]=UKN$\bC\u0001\u000e\u001c\u001b\u00059\u0011B\u0001\u000f\b\u0005]1\u0015\u000e\\3CCN,G\rR1uCN{WO]2f)\u0016\u001cH\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!\u0017\u0005!A/Z:u\u0013\t\u0011sD\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0007C\u0001\f%\u0013\t)3B\u0001\nFqBd\u0017-\u001b8Tk&$X\rS3ma\u0016\u0014\u0018A\u0002\u0013j]&$H\u0005F\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0011)f.\u001b;\u0002\r\u0019|'/\\1u+\u0005\u0001\u0004CA\u00199\u001d\t\u0011d\u0007\u0005\u00024U5\tAG\u0003\u00026'\u00051AH]8pizJ!a\u000e\u0016\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003o)\nQ#Y4h!V\u001c\b\u000eR8x]\u0016s\u0017M\u00197fI.+\u00170A\u000euKN$\b+^:i\t><hNR8s\u00032dG)\u0019;b)f\u0004Xm\u001d\u000b\bQybe\n\u0015*U\u0011\u0015yD\u00011\u0001A\u0003%Ig\u000e];u%><8\u000fE\u0002B\r&s!A\u0011#\u000f\u0005M\u001a\u0015\"A\u0016\n\u0005\u0015S\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u00131aU3r\u0015\t)%\u0006\u0005\u0002\u0017\u0015&\u00111j\u0003\u0002\u0004%><\b\"B'\u0005\u0001\u0004\u0001\u0015aF3ya\u0016\u001cG/\u001a3NS:<\u0016\u000e\u001e5BY2$\u0016\u0010]3t\u0011\u0015yE\u00011\u0001A\u0003u)\u0007\u0010]3di\u0016$W*\u001b8XSRDw*\u001e;U'\u0006sGMQ5oCJL\b\"B)\u0005\u0001\u0004\u0001\u0015aF3ya\u0016\u001cG/\u001a3NCb<\u0016\u000e\u001e5BY2$\u0016\u0010]3t\u0011\u0015\u0019F\u00011\u0001A\u0003u)\u0007\u0010]3di\u0016$W*\u0019=XSRDw*\u001e;U'\u0006sGMQ5oCJL\b\"B+\u0005\u0001\u0004\u0001\u0015!D3ya\u0016\u001cG/\u001a3D_VtG/A\bdQ\u0016\u001c7\u000eU;tQ\u0016$\u0017J\u001c4p)\rA\u0003\f\u001b\u0005\u00063\u0016\u0001\rAW\u0001\u0003I\u001a\u0004\"aW3\u000f\u0005q#gBA/d\u001d\tq&M\u0004\u0002`C:\u00111\u0007Y\u0005\u0002%%\u0011\u0001#E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005\u0015[\u0011B\u00014h\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002F\u0017!)\u0011.\u0002a\u0001a\u0005!R\r\u001f9fGR,G\r\u00157b]\u001a\u0013\u0018mZ7f]R\u0004")
public interface FileSourceAggregatePushDownSuite
extends FileBasedDataSourceTest,
ExplainSuiteHelper {
    public String format();

    public String aggPushDownEnabledKey();

    private void testPushDownForAllDataTypes(Seq<Row> inputRows, Seq<Row> expectedMinWithAllTypes, Seq<Row> expectedMinWithOutTSAndBinary, Seq<Row> expectedMaxWithAllTypes, Seq<Row> expectedMaxWithOutTSAndBinary, Seq<Row> expectedCount) {
        StructType schema = new StructType((StructField[])((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("StringCol", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("BooleanCol", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("ByteCol", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("BinaryCol", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("ShortCol", (DataType)ShortType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("IntegerCol", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("LongCol", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("FloatCol", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("DoubleCol", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("DecimalCol", (DataType)new DecimalType(25, 5), true, StructField$.MODULE$.apply$default$4()), new StructField("DateCol", (DataType)DateType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("TimestampCol", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        SparkContext qual$1 = this.sparkContext();
        Seq<Row> x$1 = inputRows;
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
        this.withTempPath((Function1 & Serializable)file -> {
            FileSourceAggregatePushDownSuite.$anonfun$testPushDownForAllDataTypes$1(this, rdd, schema, expectedMinWithAllTypes, expectedMinWithOutTSAndBinary, expectedMaxWithAllTypes, expectedMaxWithOutTSAndBinary, expectedCount, file);
            return BoxedUnit.UNIT;
        });
    }

    private void checkPushedInfo(Dataset<Row> df, String expectedPlanFragment) {
        df.queryExecution().optimizedPlan().collect((PartialFunction)new Serializable(this, df, expectedPlanFragment){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSourceAggregatePushDownSuite $outer;
            private final Dataset df$3;
            private final String expectedPlanFragment$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2ScanRelation) {
                    this.$outer.checkKeywordsExistsInExplain(this.df$3, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.expectedPlanFragment$1}));
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof DataSourceV2ScanRelation;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.df$3 = df$3;
                this.expectedPlanFragment$1 = expectedPlanFragment$1;
            }
        });
    }

    public static /* synthetic */ Tuple1 $anonfun$$init$$2(int i) {
        return new Tuple1((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new .colon.colon((Object)("val_" + i), (List)Nil$.MODULE$)));
    }

    public static /* synthetic */ Tuple1 $anonfun$$init$$6(int i) {
        return new Tuple1((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new .colon.colon((Object)("val_" + i), (List)Nil$.MODULE$)));
    }

    public static /* synthetic */ Tuple1 $anonfun$$init$$11(int i) {
        return new Tuple1((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new .colon.colon((Object)("val_" + i), (List)Nil$.MODULE$)));
    }

    public static /* synthetic */ Tuple1 $anonfun$$init$$15(int i) {
        return new Tuple1((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new .colon.colon((Object)("val_" + i), (List)Nil$.MODULE$)));
    }

    public static /* synthetic */ void $anonfun$$init$$20(FileSourceAggregatePushDownSuite $this, File dir) {
        $this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset max = (Dataset)$this.sql().apply((Object)"SELECT Max(p) FROM tmp");
                $this.checkPushedInfo((Dataset<Row>)max, "PushedAggregation: []");
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> max, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            });
        });
    }

    public static /* synthetic */ void $anonfun$$init$$25(FileSourceAggregatePushDownSuite $this, File dir) {
        $this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"if(id % 2 = 0, null, id) AS n", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            .colon.colon enableVectorizedReader = new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$));
            enableVectorizedReader.foreach((Function1 & Serializable)testVectorizedReader -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)testVectorizedReader)}), (JFunction0.mcV.sp & Serializable)() -> {
                    Dataset count = (Dataset)$this.sql().apply((Object)"SELECT COUNT(p) FROM tmp");
                    $this.checkPushedInfo((Dataset<Row>)count, "PushedAggregation: [COUNT(p)]");
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> count, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})), (List)Nil$.MODULE$));
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    public static /* synthetic */ void $anonfun$$init$$51(FileSourceAggregatePushDownSuite $this, File dir) {
        $this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)enableVectorizedReader -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)enableVectorizedReader)}), (JFunction0.mcV.sp & Serializable)() -> {
                    Dataset max = (Dataset)$this.sql().apply((Object)"SELECT max(id), min(id), count(id) FROM tmp WHERE p = 0");
                    $this.checkPushedInfo((Dataset<Row>)max, "PushedAggregation: [MAX(id), MIN(id), COUNT(id)]");
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> max, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$));
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    public static /* synthetic */ void $anonfun$$init$$57(FileSourceAggregatePushDownSuite $this, File dir) {
        $this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as P"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            String query = "SELECT count(*), count(id), p, max(id), p, count(p), max(id),  min(id), p FROM tmp group by p";
            ObjectRef expected = ObjectRef.create((Object)((Row[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class))));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> {
                expected$1.elem = (Row[])((Dataset)$this.sql().apply((Object)query)).collect();
            });
            new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)enableVectorizedReader -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)enableVectorizedReader)}), (JFunction0.mcV.sp & Serializable)() -> {
                    Dataset df = (Dataset)$this.sql().apply((Object)query$2);
                    String expected_plan_fragment = "PushedAggregation: [COUNT(*), COUNT(id), MAX(id), COUNT(p), MIN(id)], PushedFilters: [], PushedGroupBy: [p]";
                    $this.checkPushedInfo((Dataset<Row>)df, expected_plan_fragment);
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Row[])expected$1.elem);
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    public static /* synthetic */ void $anonfun$$init$$64(FileSourceAggregatePushDownSuite $this, File dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator19$1(FileSourceAggregatePushDownSuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)8)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)9)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)8)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)8)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)-4), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)10))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator19$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value", "p1", "p2", "p3", "p4"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p2", "p1", "p4", "p3"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            String query = "SELECT count(*), count(value), max(value), min(value), p4, p2, p3, p1 FROM tmp GROUP BY p1, p2, p3, p4";
            ObjectRef expected = ObjectRef.create((Object)((Row[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class))));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> {
                expected$2.elem = (Row[])((Dataset)$this.sql().apply((Object)query)).collect();
            });
            new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)enableVectorizedReader -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)enableVectorizedReader)}), (JFunction0.mcV.sp & Serializable)() -> {
                    Dataset df = (Dataset)$this.sql().apply((Object)query$3);
                    String expected_plan_fragment = "PushedAggregation: [COUNT(*), COUNT(value), MAX(value), MIN(value)], PushedFilters: [], PushedGroupBy: [p1, p2, p3, p4]";
                    $this.checkPushedInfo((Dataset<Row>)df, expected_plan_fragment);
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, (Row[])expected$2.elem);
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    public static /* synthetic */ void $anonfun$testPushDownForAllDataTypes$1(FileSourceAggregatePushDownSuite $this, RDD rdd$1, StructType schema$1, Seq expectedMinWithAllTypes$1, Seq expectedMinWithOutTSAndBinary$1, Seq expectedMaxWithAllTypes$1, Seq expectedMaxWithOutTSAndBinary$1, Seq expectedCount$1, File file) {
        $this.spark().createDataFrame(rdd$1, schema$1).write().format($this.format()).save(file.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(file.getCanonicalPath()).createOrReplaceTempView("test");
            new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)enableVectorizedReader -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)enableVectorizedReader), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.MAX_METADATA_STRING_LENGTH().key()), (Object)"1000")}), (JFunction0.mcV.sp & Serializable)() -> {
                    Dataset testMinWithAllTypes = (Dataset)$this.sql().apply((Object)"SELECT min(StringCol), min(BooleanCol), min(ByteCol), min(BinaryCol), min(ShortCol), min(IntegerCol), min(LongCol), min(FloatCol), min(DoubleCol), min(DecimalCol), min(DateCol), min(TimestampCol) FROM test");
                    $this.checkPushedInfo((Dataset<Row>)testMinWithAllTypes, "PushedAggregation: []");
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> testMinWithAllTypes, (Seq<Row>)expectedMinWithAllTypes$1);
                    Dataset testMinWithOutTSAndBinary = (Dataset)$this.sql().apply((Object)"SELECT min(BooleanCol), min(ByteCol), min(ShortCol), min(IntegerCol), min(LongCol), min(FloatCol), min(DoubleCol), min(DateCol) FROM test");
                    String expected_plan_fragment = "PushedAggregation: [MIN(BooleanCol), MIN(ByteCol), MIN(ShortCol), MIN(IntegerCol), MIN(LongCol), MIN(FloatCol), MIN(DoubleCol), MIN(DateCol)]";
                    $this.checkPushedInfo((Dataset<Row>)testMinWithOutTSAndBinary, expected_plan_fragment);
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> testMinWithOutTSAndBinary, (Seq<Row>)expectedMinWithOutTSAndBinary$1);
                    Dataset testMaxWithAllTypes = (Dataset)$this.sql().apply((Object)"SELECT max(StringCol), max(BooleanCol), max(ByteCol), max(BinaryCol), max(ShortCol), max(IntegerCol), max(LongCol), max(FloatCol), max(DoubleCol), max(DecimalCol), max(DateCol), max(TimestampCol) FROM test");
                    $this.checkPushedInfo((Dataset<Row>)testMaxWithAllTypes, "PushedAggregation: []");
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> testMaxWithAllTypes, (Seq<Row>)expectedMaxWithAllTypes$1);
                    Dataset testMaxWithoutTSAndBinary = (Dataset)$this.sql().apply((Object)"SELECT max(BooleanCol), max(ByteCol), max(ShortCol), max(IntegerCol), max(LongCol), max(FloatCol), max(DoubleCol), max(DateCol) FROM test");
                    expected_plan_fragment = "PushedAggregation: [MAX(BooleanCol), MAX(ByteCol), MAX(ShortCol), MAX(IntegerCol), MAX(LongCol), MAX(FloatCol), MAX(DoubleCol), MAX(DateCol)]";
                    $this.checkPushedInfo((Dataset<Row>)testMaxWithoutTSAndBinary, expected_plan_fragment);
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> testMaxWithoutTSAndBinary, (Seq<Row>)expectedMaxWithOutTSAndBinary$1);
                    Dataset testCount = (Dataset)$this.sql().apply((Object)"SELECT count(StringCol), count(BooleanCol), count(ByteCol), count(BinaryCol), count(ShortCol), count(IntegerCol), count(LongCol), count(FloatCol), count(DoubleCol), count(DecimalCol), count(DateCol), count(TimestampCol) FROM test");
                    expected_plan_fragment = "PushedAggregation: [COUNT(StringCol), COUNT(BooleanCol), COUNT(ByteCol), COUNT(BinaryCol), COUNT(ShortCol), COUNT(IntegerCol), COUNT(LongCol), COUNT(FloatCol), COUNT(DoubleCol), COUNT(DecimalCol), COUNT(DateCol), COUNT(TimestampCol)]";
                    $this.checkPushedInfo((Dataset<Row>)testCount, expected_plan_fragment);
                    ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> testCount, (Seq<Row>)expectedCount$1);
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    private static StringToDate.1 StringToDate$2(String s) {
        public class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToDate$1 {
            private final String s;

            public Date date() {
                return Date.valueOf(this.s);
            }

            public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToDate$1(FileSourceAggregatePushDownSuite $outer, String s) {
                this.s = s;
            }
        }
        return new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToDate$1(null, s);
    }

    private static StringToTs.1 StringToTs$2(String s) {
        public class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToTs$1 {
            private final String s;

            public Timestamp ts() {
                return Timestamp.valueOf(this.s);
            }

            public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToTs$1(FileSourceAggregatePushDownSuite $outer, String s) {
                this.s = s;
            }
        }
        return new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$StringToTs$1(null, s);
    }

    public static /* synthetic */ Null$ $anonfun$$init$$83(int x$1) {
        return null;
    }

    public static /* synthetic */ Null$ $anonfun$$init$$84(int x$2) {
        return null;
    }

    public static /* synthetic */ void $anonfun$$init$$89(FileSourceAggregatePushDownSuite $this, File dir) {
        $this.spark().range(10L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).format($this.format()).save(dir.getCanonicalPath());
        $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tmp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().read().format($this.format()).load(dir.getCanonicalPath()).createOrReplaceTempView("tmp");
            Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT max(iD), min(Id) FROM tmp");
            $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: [MAX(id), MIN(id)]");
            ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
        });
    }

    public static void $init$(FileSourceAggregatePushDownSuite $this) {
        $this.test("nested column: Max(top level column) not push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> FileSourceAggregatePushDownSuite.$anonfun$$init$$2(BoxesRunTime.unboxToInt((Object)i)));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator1$1(FileSourceAggregatePushDownSuite $outer) {
                    }
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
                $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Dataset max = (Dataset)$this.sql().apply((Object)"SELECT Max(_1) FROM t");
                    $this.checkPushedInfo((Dataset<Row>)max, "PushedAggregation: []");
                }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator1$1(null)));
            });
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        $this.test("nested column: Count(top level column) push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> FileSourceAggregatePushDownSuite.$anonfun$$init$$6(BoxesRunTime.unboxToInt((Object)i)));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator2$1(FileSourceAggregatePushDownSuite $outer) {
                    }
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
                $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Dataset count = (Dataset)$this.sql().apply((Object)"SELECT Count(_1) FROM t");
                    $this.checkPushedInfo((Dataset<Row>)count, "PushedAggregation: [COUNT(_1)]");
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> count, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})), (List)Nil$.MODULE$));
                }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator2$1(null)));
            });
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.test("nested column: Max(nested sub-field) not push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> FileSourceAggregatePushDownSuite.$anonfun$$init$$11(BoxesRunTime.unboxToInt((Object)i)));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator3$1(FileSourceAggregatePushDownSuite $outer) {
                    }
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
                $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Dataset max = (Dataset)$this.sql().apply((Object)"SELECT Max(_1._2[0]) FROM t");
                    $this.checkPushedInfo((Dataset<Row>)max, "PushedAggregation: []");
                }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator3$1(null)));
            });
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        $this.test("nested column: Count(nested sub-field) not push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> FileSourceAggregatePushDownSuite.$anonfun$$init$$15(BoxesRunTime.unboxToInt((Object)i)));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator4$1(FileSourceAggregatePushDownSuite $outer) {
                    }
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
                $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Dataset count = (Dataset)$this.sql().apply((Object)"SELECT Count(_1._2[0]) FROM t");
                    $this.checkPushedInfo((Dataset<Row>)count, "PushedAggregation: []");
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> count, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})), (List)Nil$.MODULE$));
                }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator4$1(null)));
            });
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        $this.test("Max(partition column): not push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
            FileSourceAggregatePushDownSuite.$anonfun$$init$$20($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        $this.test("Count(partition column): push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
            FileSourceAggregatePushDownSuite.$anonfun$$init$$25($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        $this.test("filter alias over aggregate", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator5$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_1) + max(_1) as res FROM t having res > 1");
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: [MIN(_1), MAX(_1)]");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator5$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        $this.test("alias over aggregate", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator6$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_1) + 1 as minPlus1, min(_1) + 2 as minPlus2 FROM t");
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: [MIN(_1)]");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator6$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        $this.test("aggregate over alias push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator7$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator7$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset df = $this.spark().table("t");
                Dataset query = df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_1"}))).$((Seq)Nil$.MODULE$).as("col1")})).agg(functions$.MODULE$.min((Column)$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)), (Seq)Nil$.MODULE$);
                $this.checkPushedInfo((Dataset<Row>)query, "PushedAggregation: [MIN(_1)]");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> query, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-2)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator7$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        $this.test("query with group by not push down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator8$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator8$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)7)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_1) FROM t GROUP BY _3 ");
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: []");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator8$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        $this.test("aggregate with data filter cannot be pushed down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator9$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)7)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_3) FROM t WHERE _1 > 0");
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: []");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator9$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        $this.test("aggregate with partition filter can be pushed down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
            FileSourceAggregatePushDownSuite.$anonfun$$init$$51($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        $this.test("aggregate with partition group by can be pushed down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
            FileSourceAggregatePushDownSuite.$anonfun$$init$$57($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        $this.test("aggregate with multi partition group by columns can be pushed down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
            FileSourceAggregatePushDownSuite.$anonfun$$init$$64($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        $this.test("push down only if all the aggregates can be pushed down", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator20$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)7)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_1), sum(_3) FROM t");
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: []");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-2), BoxesRunTime.boxToInteger((int)41)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator20$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        $this.test("aggregate push down - MIN/MAX/COUNT", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator21$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)"SELECT min(_3), min(_3), max(_3), min(_1), max(_1), max(_1), count(*), count(_1), count(_2), count(_3) FROM t");
                String expected_plan_fragment = "PushedAggregation: [MIN(_3), MAX(_3), MIN(_1), MAX(_1), COUNT(*), COUNT(_1), COUNT(_2), COUNT(_3)]";
                $this.checkPushedInfo((Dataset<Row>)selectAgg, expected_plan_fragment);
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)-2), BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator21$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        $this.test("aggregate not push down - MIN/MAX/COUNT with CASE WHEN", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            public final class Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator22$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator22$1(FileSourceAggregatePushDownSuite $outer) {
                }
            }
            .colon.colon data = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-2), (Object)"abc", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"def", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ghi", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), null, (Object)BoxesRunTime.boxToInteger((int)19)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"mno", (Object)BoxesRunTime.boxToInteger((int)7)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), null, (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$))))));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileSourceAggregatePushDownSuite.class.getClassLoader());
            $this.withDataSourceTable(data, "t", $this.withDataSourceTable$default$3(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
                Dataset selectAgg = (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |SELECT\n            |  min(CASE WHEN _1 < 0 THEN 0 ELSE _1 END),\n            |  min(CASE WHEN _3 > 5 THEN 1 ELSE 0 END),\n            |  max(CASE WHEN _1 < 0 THEN 0 ELSE _1 END),\n            |  max(CASE WHEN NOT(_3 > 5) THEN 1 ELSE 0 END),\n            |  count(CASE WHEN _1 < 0 AND _2 IS NOT NULL THEN 0 ELSE _1 END),\n            |  count(CASE WHEN _3 != 5 OR _2 IS NULL THEN 1 ELSE 0 END)\n            |FROM t\n          ")));
                $this.checkPushedInfo((Dataset<Row>)selectAgg, "PushedAggregation: []");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> selectAgg, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$));
            }), ClassTag$.MODULE$.apply(Tuple3.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_FileSourceAggregatePushDownSuite$$typecreator22$1(null)));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        $this.test("aggregate push down - different data types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon rows = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a string", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)10)), "Spark SQL".getBytes(), BoxesRunTime.boxToShort((short)((short)12)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)0.15f), BoxesRunTime.boxToDouble((double)0.75), Decimal$.MODULE$.apply("12.345678"), FileSourceAggregatePushDownSuite.StringToDate$2("2021-01-01").date(), FileSourceAggregatePushDownSuite.StringToTs$2("2015-01-01 23:50:59.123").ts()})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"test string", BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToByte((byte)((byte)1)), "Parquet".getBytes(), BoxesRunTime.boxToShort((short)((short)2)), null, BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToFloat((float)0.25f), BoxesRunTime.boxToDouble((double)0.85), Decimal$.MODULE$.apply("1.2345678"), FileSourceAggregatePushDownSuite.StringToDate$2("2015-01-01").date(), FileSourceAggregatePushDownSuite.StringToTs$2("2021-01-01 23:50:59.123").ts()})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)10000)), "Spark ML".getBytes(), BoxesRunTime.boxToShort((short)((short)222)), BoxesRunTime.boxToInteger((int)113), BoxesRunTime.boxToLong((long)11111111L), BoxesRunTime.boxToFloat((float)0.25f), BoxesRunTime.boxToDouble((double)0.75), Decimal$.MODULE$.apply("12345.678"), FileSourceAggregatePushDownSuite.StringToDate$2("2004-06-19").date(), FileSourceAggregatePushDownSuite.StringToTs$2("1999-08-26 10:43:59.123").ts()})), (List)Nil$.MODULE$)));
            $this.testPushDownForAllDataTypes((Seq<Row>)rows, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a string", BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToByte((byte)((byte)1)), "Parquet".getBytes(), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToFloat((float)0.15f), BoxesRunTime.boxToDouble((double)0.75), BoxesRunTime.boxToDouble((double)1.23457), FileSourceAggregatePushDownSuite.StringToDate$2("2004-06-19").date(), FileSourceAggregatePushDownSuite.StringToTs$2("1999-08-26 10:43:59.123").ts()})), (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToFloat((float)0.15f), BoxesRunTime.boxToDouble((double)0.75), FileSourceAggregatePushDownSuite.StringToDate$2("2004-06-19").date()})), (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"test string", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)16)), "Spark SQL".getBytes(), BoxesRunTime.boxToShort((short)((short)222)), BoxesRunTime.boxToInteger((int)113), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)0.25f), BoxesRunTime.boxToDouble((double)0.85), BoxesRunTime.boxToDouble((double)12345.678), FileSourceAggregatePushDownSuite.StringToDate$2("2021-01-01").date(), FileSourceAggregatePushDownSuite.StringToTs$2("2021-01-01 23:50:59.123").ts()})), (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)16)), BoxesRunTime.boxToShort((short)((short)222)), BoxesRunTime.boxToInteger((int)113), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)0.25f), BoxesRunTime.boxToDouble((double)0.85), FileSourceAggregatePushDownSuite.StringToDate$2("2021-01-01").date()})), (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$));
            Row nullRow = Row$.MODULE$.fromSeq((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12).map((Function1 & Serializable)x$1 -> FileSourceAggregatePushDownSuite.$anonfun$$init$$83(BoxesRunTime.unboxToInt((Object)x$1))));
            Row nullRowWithOutTSAndBinary = Row$.MODULE$.fromSeq((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 8).map((Function1 & Serializable)x$2 -> FileSourceAggregatePushDownSuite.$anonfun$$init$$84(BoxesRunTime.unboxToInt((Object)x$2))));
            Row zeroCount = Row$.MODULE$.fromSeq((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12).map((Function1)(JFunction1.mcII.sp & Serializable)x$3 -> 0));
            $this.testPushDownForAllDataTypes((Seq<Row>)((Seq)package$.MODULE$.Seq().empty()), (Seq<Row>)new .colon.colon((Object)nullRow, (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)nullRowWithOutTSAndBinary, (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)nullRow, (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)nullRowWithOutTSAndBinary, (List)Nil$.MODULE$), (Seq<Row>)new .colon.colon((Object)zeroCount, (List)Nil$.MODULE$));
        }, new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        $this.test("column name case sensitivity", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)enableVectorizedReader -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.aggPushDownEnabledKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.vectorizedReaderEnabledKey()), (Object)enableVectorizedReader)}), (JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)dir -> {
                FileSourceAggregatePushDownSuite.$anonfun$$init$$89($this, dir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("FileSourceAggregatePushDownSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
    }
}

