/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.FakeFileSystemRequiringDSOption;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.scalactic.source.Position;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u001d4\u0001BB\u0004\u0011\u0002\u0007\u0005AC\u0017\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006\u001d\u00011\t\u0002\u000b\u0005\u0006[\u00011\tB\f\u0005\u0006u\u0001!\tb\u000f\u0005\u0006\u0017\u0002!\t\u0002\u0014\u0002\u001a\u0007>lWn\u001c8GS2,G)\u0019;b'>,(oY3Tk&$XM\u0003\u0002\t\u0013\u0005YA-\u0019;bg>,(oY3t\u0015\tQ1\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\ta\u0012%D\u0001\u001e\u0015\tqr$A\u0003qY\u0006t7O\u0003\u0002!\u0017\u0005A1-\u0019;bYf\u001cH/\u0003\u0002#;\tI1+\u0015'IK2\u0004XM]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0015\u0002\"A\u0006\u0014\n\u0005\u001d:\"\u0001B+oSR,\u0012!\u000b\t\u0003U-j\u0011aC\u0005\u0003Y-\u0011Ab\u00159be.\u001cVm]:j_:\f\u0001\u0003Z1uCN{WO]2f\r>\u0014X.\u0019;\u0016\u0003=\u0002\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a\u0018\u001b\u0005\u0019$B\u0001\u001b\u0014\u0003\u0019a$o\\8u}%\u0011agF\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027/\u0005a\u0011N\u001c9vi\u0012\u000bG/Y:fiV\tA\b\r\u0002>\u0005B\u0019!F\u0010!\n\u0005}Z!a\u0002#bi\u0006\u001cX\r\u001e\t\u0003\u0003\nc\u0001\u0001B\u0005D\t\u0005\u0005\t\u0011!B\u0001\t\n\u0019q\fJ\u0019\u0012\u0005\u0015C\u0005C\u0001\fG\u0013\t9uCA\u0004O_RD\u0017N\\4\u0011\u0005YI\u0015B\u0001&\u0018\u0005\r\te._\u0001\u0010o&$\bnQ8seV\u0004HOR5mKR\u0011Q%\u0014\u0005\u0006\u001d\u0016\u0001\raT\u0001\u0002MB!a\u0003\u0015*&\u0013\t\tvCA\u0005Gk:\u001cG/[8ocA\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0003S>T\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\n!a)\u001b7f%\rYVl\u0018\u0004\u00059\u0002\u0001!L\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002_\u00015\tq\u0001\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006Aa-\u001e8tk&$XM\u0003\u0002e#\u0005I1oY1mCR,7\u000f^\u0005\u0003M\u0006\u00141\"\u00118z\rVt7+^5uK\u0002")
public interface CommonFileDataSourceSuite
extends SQLHelper {
    public SparkSession spark();

    public String dataSourceFormat();

    public static /* synthetic */ Dataset inputDataset$(CommonFileDataSourceSuite $this) {
        return $this.inputDataset();
    }

    default public Dataset<?> inputDataset() {
        return this.spark().createDataset((Seq)new .colon.colon((Object)"abc", (List)Nil$.MODULE$), Encoders$.MODULE$.STRING());
    }

    public static /* synthetic */ void withCorruptFile$(CommonFileDataSourceSuite $this, Function1 f) {
        $this.withCorruptFile((Function1<File, BoxedUnit>)f);
    }

    default public void withCorruptFile(Function1<File, BoxedUnit> f) {
        File inputFile = File.createTempFile("input-", ".gz");
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteOutput);){
                gzip.write(new byte[]{1, 2, 3, 4});
            }
            byte[] bytes = byteOutput.toByteArray();
            try (FileOutputStream o = new FileOutputStream(inputFile);){
                o.write((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(bytes), bytes.length / 2));
            }
            f.apply((Object)inputFile);
        }
        finally {
            inputFile.delete();
        }
    }

    public static /* synthetic */ void $anonfun$$init$$5(CommonFileDataSourceSuite $this, scala.collection.immutable.Map conf$1, String p) {
        Dataset readback = $this.spark().read().options((Map)conf$1).format($this.dataSourceFormat()).load(p);
        readback.write().mode("overwrite").format("noop").save();
    }

    public static /* synthetic */ void $anonfun$$init$$4(CommonFileDataSourceSuite $this, boolean mergeSchema$1, File dir) {
        String path = dir.getAbsolutePath();
        scala.collection.immutable.Map conf = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds_option"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mergeSchema"), (Object)Boolean.toString(mergeSchema$1))}));
        $this.inputDataset().write().options((Map)conf).format($this.dataSourceFormat()).save(path);
        new .colon.colon((Object)path, (List)new .colon.colon((Object)("file:" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(path), "file:")), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)p -> {
            CommonFileDataSourceSuite.$anonfun$$init$$5($this, conf, p);
            return BoxedUnit.UNIT;
        });
    }

    public static void $init$(CommonFileDataSourceSuite $this) {
        ((AnyFunSuiteLike)$this).test("Propagate Hadoop configs from " + $this.dataSourceFormat() + " options to underlying file system", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl"), (Object)FakeFileSystemRequiringDSOption.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.file.impl.disable.cache"), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)mergeSchema -> {
            $this.withTempPath((Function1 & Serializable)dir -> {
                CommonFileDataSourceSuite.$anonfun$$init$$4($this, mergeSchema, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        })), new Position("CommonFileDataSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }
}

