/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001B\u0011#\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0011\u0019i\u0005\u0001)A\u0005\u000b\"9a\n\u0001b\u0001\n\u0013y\u0005BB+\u0001A\u0003%\u0001\u000bC\u0004W\u0001\t\u0007I\u0011B,\t\rm\u0003\u0001\u0015!\u0003Y\u0011\u001da\u0006A1A\u0005\nuCaa\u001a\u0001!\u0002\u0013q\u0006b\u00025\u0001\u0005\u0004%I!\u0018\u0005\u0007S\u0002\u0001\u000b\u0011\u00020\t\u000f)\u0004!\u0019!C\u0005W\"1q\u000e\u0001Q\u0001\n1Dq\u0001\u001d\u0001C\u0002\u0013%1\u000e\u0003\u0004r\u0001\u0001\u0006I\u0001\u001c\u0005\u0006e\u0002!\tf\u001d\u0005\u0006o\u0002!I\u0001\u001f\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u00020\u0001!I!!\r\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u00191\u00111\b\u0001\u0001\u0003{A\u0001\u0002S\r\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0007ie!\t!!\u0012\t\u0013\u00055\u0013D1A\u0005\n\u0005=\u0003\u0002CA<3\u0001\u0006I!!\u0015\t\u000f\u0005e\u0014\u0004\"\u0011\u0002|!9\u0011\u0011R\r\u0005\u0002\u0005-\u0005bBAI3\u0011\u0005\u00131\u0013\u0002 \u0005\u0006\u001c\u0018nY,sSR,G+Y:l'R\fGo\u001d+sC\u000e\\WM]*vSR,'BA\u0012%\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005\u00152\u0013!C3yK\u000e,H/[8o\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022e5\t\u0001&\u0003\u00024Q\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0012\u0002\u000fQ,W\u000e\u001d#jeV\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005\u0011\u0011n\u001c\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0003GS2,\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\u0017Q,W\u000e\u001d#jeB\u000bG\u000f[\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0003MNT!A\u0013\u0016\u0002\r!\fGm\\8q\u0013\tauI\u0001\u0003QCRD\u0017\u0001\u0004;f[B$\u0015N\u001d)bi\"\u0004\u0013\u0001B2p]\u001a,\u0012\u0001\u0015\t\u0003#Nk\u0011A\u0015\u0006\u0003\u001d&K!\u0001\u0016*\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0015\u0019wN\u001c4!\u0003\u001dawnY1mMN,\u0012\u0001\u0017\t\u0003\rfK!AW$\u0003\u0015\u0019KG.Z*zgR,W.\u0001\u0005m_\u000e\fGNZ:!\u0003\u0015!\u0017\r^12+\u0005q\u0006cA0cI6\t\u0001MC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0007MA\u0003BeJ\f\u0017\u0010\u0005\u0002`K&\u0011a\r\u0019\u0002\u0005\u0005f$X-\u0001\u0004eCR\f\u0017\u0007I\u0001\u0006I\u0006$\u0018MM\u0001\u0007I\u0006$\u0018M\r\u0011\u0002\t1,g.M\u000b\u0002YB\u0011q,\\\u0005\u0003]\u0002\u00141!\u00138u\u0003\u0015aWM\\\u0019!\u0003\u0011aWM\u001c\u001a\u0002\u000b1,gN\r\u0011\u0002\u0011\u00054G/\u001a:BY2$\u0012\u0001\u001e\t\u0003?VL!A\u001e1\u0003\tUs\u0017\u000e^\u0001\fCN\u001cXM\u001d;Ti\u0006$8\u000fF\u0003usz\f\t\u0001C\u0003{'\u0001\u000710A\u0004ue\u0006\u001c7.\u001a:\u0011\u0005]b\u0018BA?#\u0005i\u0011\u0015m]5d/JLG/\u001a+bg.\u001cF/\u0019;t)J\f7m[3s\u0011\u0015y8\u00031\u0001m\u0003\u00151\u0017\u000e\\3t\u0011\u0019\t\u0019a\u0005a\u0001Y\u0006)!-\u001f;fg\u0006Ya-\u001b8bYN#\u0018\r^;t)\u0011\tI!a\u0004\u0011\u0007]\nY!C\u0002\u0002\u000e\t\u00121CQ1tS\u000e<&/\u001b;f)\u0006\u001c8n\u0015;biNDQA\u001f\u000bA\u0002m\fQ\u0001^8vG\"$2\u0001^A\u000b\u0011\u0019\t9\"\u0006a\u0001\u000b\u0006!a-\u001b7f\u0003\u00159(/\u001b;f)\u0019\ti\"!\u000b\u0002,A!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$y\nA\u0001\\1oO&!\u0011qEA\u0011\u0005\u001dIe\u000e^3hKJDa!a\u0006\u0017\u0001\u0004)\u0005BBA\u0017-\u0001\u0007a,\u0001\u0003eCR\f\u0017AB<sSR,\u0017\u0007F\u0002u\u0003gAa!a\u0006\u0018\u0001\u0004)\u0015AB<sSR,'\u0007F\u0002u\u0003sAa!a\u0006\u0019\u0001\u0004)%\u0001\u0005$t/&$\bNR1lKb\u000bE\u000f\u001e:t'\rI\u0012q\b\t\u0004\r\u0006\u0005\u0013bAA\"\u000f\n\u0001b)\u001b7uKJ4\u0015\u000e\\3TsN$X-\u001c\u000b\u0005\u0003\u000f\nY\u0005E\u0002\u0002Jei\u0011\u0001\u0001\u0005\u0006\u0011n\u0001\r\u0001W\u0001\u0007q\u0006$HO]:\u0016\u0005\u0005E\u0003cBA*\u0003;\n\tGX\u0007\u0003\u0003+RA!a\u0016\u0002Z\u00059Q.\u001e;bE2,'bAA.A\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BA2\u0003crA!!\u001a\u0002nA\u0019\u0011q\r1\u000e\u0005\u0005%$bAA6]\u00051AH]8pizJ1!a\u001ca\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u000e1\u0002\u000fa\fG\u000f\u001e:tA\u0005A1/\u001a;Y\u0003R$(\u000fF\u0004u\u0003{\n\t)!\"\t\r\u0005}d\u00041\u0001F\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005\re\u00041\u0001\u0002b\u0005!a.Y7f\u0011\u0019\t9I\ba\u0001=\u0006)a/\u00197vK\u0006\u00191/\u001a;\u0015\u000bQ\fi)a$\t\u000f\u0005\ru\u00041\u0001\u0002b!9\u0011qQ\u0010A\u0002\u0005\u0005\u0014\u0001C4fib\u000bE\u000f\u001e:\u0015\u000by\u000b)*a&\t\r\u0005}\u0004\u00051\u0001F\u0011\u001d\t\u0019\t\ta\u0001\u0003C\u0002")
public class BasicWriteTaskStatsTrackerSuite
extends SparkFunSuite {
    private final File tempDir = Utils$.MODULE$.createTempDir();
    private final Path tempDirPath = new Path(this.tempDir().toURI());
    private final Configuration conf = new Configuration();
    private final FileSystem localfs = this.tempDirPath().getFileSystem(this.conf());
    private final byte[] data1 = "0123456789".getBytes(Charset.forName("US-ASCII"));
    private final byte[] data2 = "012".getBytes(Charset.forName("US-ASCII"));
    private final int len1 = this.data1().length;
    private final int len2 = this.data2().length;

    private File tempDir() {
        return this.tempDir;
    }

    private Path tempDirPath() {
        return this.tempDirPath;
    }

    private Configuration conf() {
        return this.conf;
    }

    private FileSystem localfs() {
        return this.localfs;
    }

    private byte[] data1() {
        return this.data1;
    }

    private byte[] data2() {
        return this.data2;
    }

    private int len1() {
        return this.len1;
    }

    private int len2() {
        return this.len2;
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.tempDir());
        }
        finally {
            super.afterAll();
        }
    }

    private void assertStats(BasicWriteTaskStatsTracker tracker, int files, int bytes) {
        BasicWriteTaskStats stats = this.finalStatus(tracker);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)files));
        int $org_scalatest_assert_macro_right = stats.numFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes));
        long $org_scalatest_assert_macro_right2 = stats.numBytes();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Wrong byte count of file size", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    private BasicWriteTaskStats finalStatus(BasicWriteTaskStatsTracker tracker) {
        return (BasicWriteTaskStats)tracker.getFinalStats(0L);
    }

    private void touch(Path file) {
        this.localfs().create(file, true).close();
    }

    private Integer write(Path file, byte[] data) {
        try (FSDataOutputStream stream = this.localfs().create(file, true);){
            stream.write(data);
        }
        return Predef$.MODULE$.int2Integer(data.length);
    }

    private void write1(Path file) {
        this.write(file, this.data1());
    }

    private void write2(Path file) {
        this.write(file, this.data2());
    }

    public BasicWriteTaskStatsTrackerSuite() {
        this.test("No files in run", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            this.assertStats(tracker, 0, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Missing File", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path missing = new Path(this.tempDirPath(), "missing");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(missing.toString());
            tracker.closeFile(missing.toString());
            this.assertStats(tracker, 0, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("Empty filename is forwarded", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile("");
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> tracker.closeFile(""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Null filename is only picked up in final status", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(null);
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> tracker.closeFile(null), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("0 byte file", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file0");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file.toString());
            this.touch(file);
            tracker.closeFile(file.toString());
            this.assertStats(tracker, 1, 0);
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("File with data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file-with-data");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file.toString());
            this.write1(file);
            tracker.closeFile(file.toString());
            this.assertStats(tracker, 1, this.len1());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("Open file", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            Path file = new Path(this.tempDirPath(), "file-open");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file.toString());
            tracker.closeFile(file.toString());
            try (FSDataOutputStream stream = this.localfs().create(file, true);){
                this.assertStats(tracker, 1, 0);
                stream.write(this.data1());
                stream.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1));
                int $org_scalatest_assert_macro_right = this.finalStatus(tracker).numFiles();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Wrong number of files", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            }
            return assertion;
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("Two files", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-2-1");
            Path file2 = new Path(this.tempDirPath(), "f-2-2");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.closeFile(file1.toString());
            tracker.newFile(file2.toString());
            this.write2(file2);
            tracker.closeFile(file2.toString());
            this.assertStats(tracker, 2, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("Three files, last one empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-3-1");
            Path file2 = new Path(this.tempDirPath(), "f-3-2");
            Path file3 = new Path(this.tempDirPath(), "f-3-3");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.closeFile(file1.toString());
            tracker.newFile(file2.toString());
            this.write2(file2);
            tracker.closeFile(file2.toString());
            tracker.newFile(file3.toString());
            this.touch(file3);
            tracker.closeFile(file3.toString());
            this.assertStats(tracker, 3, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Three files, one not found", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path file1 = new Path(this.tempDirPath(), "f-4-1");
            Path file2 = new Path(this.tempDirPath(), "f-4-2");
            Path file3 = new Path(this.tempDirPath(), "f-3-2");
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(file1.toString());
            this.write1(file1);
            tracker.closeFile(file1.toString());
            tracker.newFile(file2.toString());
            tracker.closeFile(file2.toString());
            tracker.newFile(file3.toString());
            this.write2(file3);
            tracker.closeFile(file3.toString());
            this.assertStats(tracker, 2, this.len1() + this.len2());
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("XAttr sourced length", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file");
            this.touch(file);
            FsWithFakeXAttrs xattrFS = new FsWithFakeXAttrs(this.localfs());
            long bigLong = 0x800000000L;
            xattrFS.set(BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), String.valueOf(BoxesRunTime.boxToLong((long)bigLong)));
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToLong((long)bigLong)));
            Option $org_scalatest_assert_macro_right = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Size not collected from XAttr entry", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("XAttr sourced length only used for 0-byte-files", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file");
            this.write2(file);
            FsWithFakeXAttrs xattrFS = new FsWithFakeXAttrs(this.localfs());
            long bigLong = 0x800000000L;
            xattrFS.set(BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), String.valueOf(BoxesRunTime.boxToLong((long)bigLong)));
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)this.len2())));
            Option $org_scalatest_assert_macro_right = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Size not collected from XAttr entry", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("Missing File with XAttr", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Path missing = new Path(this.tempDirPath(), "missing");
            FsWithFakeXAttrs xattrFS = new FsWithFakeXAttrs(this.localfs());
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            tracker.newFile(missing.toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(None$.MODULE$);
            Option $org_scalatest_assert_macro_right = tracker.getFileSize((FileSystem)xattrFS, missing);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("XAttr error recovery", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Path file = new Path(this.tempDirPath(), "file");
            this.touch(file);
            FsWithFakeXAttrs xattrFS = new FsWithFakeXAttrs(this.localfs());
            BasicWriteTaskStatsTracker tracker = new BasicWriteTaskStatsTracker(this.conf(), BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            Option $org_scalatest_assert_macro_right = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            xattrFS.set(BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), "Not-a-long");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            Option $org_scalatest_assert_macro_right2 = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            xattrFS.set(BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), "-1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            Option $org_scalatest_assert_macro_right3 = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            xattrFS.set(BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), "");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            Option $org_scalatest_assert_macro_right4 = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            xattrFS.setXAttr(file, BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR(), new byte[0]);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            Option $org_scalatest_assert_macro_right5 = tracker.getFileSize((FileSystem)xattrFS, file);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        }, new Position("BasicWriteTaskStatsTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    public class FsWithFakeXAttrs
    extends FilterFileSystem {
        private final Map<String, byte[]> xattrs;

        private Map<String, byte[]> xattrs() {
            return this.xattrs;
        }

        public void setXAttr(Path path, String name, byte[] value) {
            this.xattrs().put((Object)name, (Object)value);
        }

        public void set(String name, String value) {
            this.setXAttr(null, name, value.getBytes(StandardCharsets.UTF_8));
        }

        public byte[] getXAttr(Path path, String name) {
            this.getFileStatus(path);
            return (byte[])this.xattrs().getOrElse((Object)name, (Function0 & Serializable)() -> null);
        }

        public /* synthetic */ BasicWriteTaskStatsTrackerSuite org$apache$spark$sql$execution$datasources$BasicWriteTaskStatsTrackerSuite$FsWithFakeXAttrs$$$outer() {
            return BasicWriteTaskStatsTrackerSuite.this;
        }

        public FsWithFakeXAttrs(FileSystem fs) {
            if (BasicWriteTaskStatsTrackerSuite.this == null) {
                throw null;
            }
            super(fs);
            this.xattrs = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

