/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-2qa\u0001\u0003\u0011\u0002\u0007\u0005\u0011\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0004\u0006\u0001\t\u0007I\u0011\t\u0012\u0003-\u0011+7o\u0019:jE\u0016$\u0016M\u00197f'VLG/\u001a\"bg\u0016T!!\u0002\u0004\u0002\u000f\r|W.\\1oI*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\t\u0013\t)\u0002BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\u0014\t\u0012c5i\\7nC:$G+Z:u+RLGn]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168jiV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0001")
public interface DescribeTableSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$DescribeTableSuiteBase$_setter_$command_$eq(String var1);

    @Override
    public String command();

    public static /* synthetic */ void $anonfun$$init$$2(DescribeTableSuiteBase $this, String tbl) {
        String parsed = ((IterableOnceOps)CatalystSqlParser$.MODULE$.parseMultipartIdentifier(tbl + "_non_existence").map((Function1 & Serializable)part -> package$.MODULE$.quoteIdentifier(part))).mkString(".");
        AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("DESCRIBE TABLE " + tbl + "_non_existence")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        ((SparkFunSuite)$this).checkErrorTableNotFound((SparkThrowable)e, parsed, ((SparkFunSuite)$this).ExpectedContext().apply(tbl + "_non_existence", 15, 14 + (tbl + "_non_existence").length()));
    }

    public static /* synthetic */ void $anonfun$$init$$6(DescribeTableSuiteBase $this, String tbl) {
        $this.spark().sql("CREATE TABLE " + tbl + " (id bigint, data string) " + $this.defaultUsing());
        Dataset descriptionDf = $this.spark().sql("DESCRIBE TABLE " + tbl);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data", "string", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$9(DescribeTableSuiteBase $this, String tbl) {
        $this.spark().sql("CREATE TABLE " + tbl + " (id bigint, data string) " + $this.defaultUsing() + " PARTITIONED BY (id)");
        Dataset descriptionDf = $this.spark().sql("DESCRIBE TABLE " + tbl);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf.filter("col_name != 'Created Time'"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data", "string", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Partition Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# col_name", "data_type", "comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null})), (List)Nil$.MODULE$))))), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$12(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (c0 INT) " + $this.defaultUsing()));
        Dataset description = (Dataset)$this.sql().apply((Object)("DESCRIBE TABLE " + tbl));
        Dataset noCommentDataset = description.drop("comment");
        StructType expectedSchema = new StructType().add("col_name", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "name of the column").build()).add("data_type", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "data type of the column").build());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)noCommentDataset.schema());
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        Dataset isNullDataset = noCommentDataset.withColumn("is_null", noCommentDataset.apply("col_name").isNull());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)isNullDataset.schema());
        StructType $org_scalatest_assert_macro_right2 = expectedSchema.add("is_null", (DataType)BooleanType$.MODULE$, false);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    public static /* synthetic */ void $anonfun$$init$$14(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (c0 INT) " + $this.defaultUsing()));
        Dataset description = (Dataset)$this.sql().apply((Object)("DESCRIBE TABLE " + tbl + " c0"));
        Dataset noCommentDataset = description.drop("info_value");
        StructType expectedSchema = new StructType().add("info_name", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "name of the column info").build());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)noCommentDataset.schema());
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        Dataset isNullDataset = noCommentDataset.withColumn("is_null", noCommentDataset.apply("info_name").isNull());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)isNullDataset.schema());
        StructType $org_scalatest_assert_macro_right2 = expectedSchema.add("is_null", (DataType)BooleanType$.MODULE$, false);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }

    public static /* synthetic */ void $anonfun$$init$$16(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE " + tbl + "\n        |(key int COMMENT 'column_comment', col struct<x:int, y:string>)\n        |" + $this.defaultUsing())));
        Dataset descriptionDf = (Dataset)$this.sql().apply((Object)("DESC " + tbl + " key"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "key"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "column_comment"})), (List)Nil$.MODULE$))), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$19(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (key int COMMENT 'comment1') " + $this.defaultUsing()));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("DESC " + tbl + " " + tbl + ".key"))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "key"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "comment1"})), (List)Nil$.MODULE$))), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$21(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (`a.b` int, col struct<x:int, y:string>) " + $this.defaultUsing()));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("DESC " + tbl + " `a.b`"))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "a.b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$))), QueryTest$.MODULE$.checkAnswer$default$3());
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)("DESCRIBE " + tbl + " col"))), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "col"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "struct<x:int,y:string>"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$))), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$23(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (`a.b` int, col struct<x:int, y:string>) " + $this.defaultUsing()));
        String errMsg = ((AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("DESCRIBE TABLE " + tbl + " col.x")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175))).getMessage();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)errMsg);
        String $org_scalatest_assert_macro_right = "DESC TABLE COLUMN does not support nested column: col.x.";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
    }

    public static /* synthetic */ void $anonfun$$init$$26(DescribeTableSuiteBase $this, String tbl) {
        $this.sql().apply((Object)("CREATE TABLE " + tbl + " (col1 STRING COMMENT 'this is comment', col2 struct<x:int, y:int>) " + $this.defaultUsing() + " CLUSTER BY (col1, col2.x)"));
        Dataset descriptionDf = (Dataset)$this.sql().apply((Object)("DESC " + tbl));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col1", "string", "this is comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col2", "struct<x:int,y:int>", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Clustering Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# col_name", "data_type", "comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col1", "string", "this is comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col2.x", "int", null})), (List)Nil$.MODULE$)))))), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static void $init$(DescribeTableSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$DescribeTableSuiteBase$_setter_$command_$eq("DESCRIBE TABLE");
        $this.test("DESCRIBE TABLE in a catalog when table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "table", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$2($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        $this.test("DESCRIBE TABLE of a non-partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "table", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$6($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.test("DESCRIBE TABLE of a partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "table", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$9($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        $this.test("SPARK-34561: drop/add columns to a dataset of `DESCRIBE TABLE`", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "table", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$12($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        $this.test("SPARK-34576: drop/add columns to a dataset of `DESCRIBE COLUMN`", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "table", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$14($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        $this.test("describe a column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$16($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        $this.test("describe a column with fully qualified name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$19($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        $this.test("describe complex columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$21($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        $this.test("describe a nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$23($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        $this.test("describe a clustered table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withNamespaceAndTable("ns", "tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable)tbl -> {
            DescribeTableSuiteBase.$anonfun$$init$$26($this, tbl);
            return BoxedUnit.UNIT;
        }), new Position("DescribeTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

