/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000552A\u0001B\u0003\u0001)!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)!\u0006\u0001C\u0001W\t\u0011\"i\\8mK\u0006t')\u001b;TKR\u001cV/\u001b;f\u0015\t1q!A\u0006d_6\u0004(/Z:tS>t'B\u0001\u0005\n\u0003!\u0019w\u000e\\;n]\u0006\u0014(B\u0001\u0006\f\u0003%)\u00070Z2vi&|gN\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005)\u0011\u0001C:lK2,Go\u001c8\u0015\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#\u0001B+oSRDQA\n\u0002A\u0002\u001d\nQaY8v]R\u0004\"\u0001\t\u0015\n\u0005%\n#aA%oi\u0006)2o[3mKR|gNR8s\t\u0016\u001cw.\u001c9sKN\u001cHCA\u0010-\u0011\u001513\u00011\u0001(\u0001")
public class BooleanBitSetSuite
extends SparkFunSuite {
    public void skeleton(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)package$.MODULE$.Seq().fill(count, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Nil$.MODULE$));
        Seq values = (Seq)rows.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.getBoolean(0)));
        rows.foreach((Function1 & Serializable)x$2 -> {
            builder.appendFrom(x$2, 0);
            return BoxedUnit.UNIT;
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int extra = count % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
        int compressedSize = 8 + (count / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.assertResult(BoxesRunTime.boxToInteger((int)count), "Wrong element count", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        LongRef word = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable)i -> BooleanBitSetSuite.$anonfun$skeleton$4(this, word, buffer, values, BoxesRunTime.unboxToInt((Object)i)));
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (values.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            values.foreach((Function1 & Serializable)x$3 -> BooleanBitSetSuite.$anonfun$skeleton$5(this, decoder, mutableRow, BoxesRunTime.unboxToBoolean((Object)x$3)));
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public void skeletonForDecompress(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)package$.MODULE$.Seq().fill(count, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Nil$.MODULE$));
        Seq values = (Seq)rows.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.getBoolean(0)));
        rows.foreach((Function1 & Serializable)x$5 -> {
            builder.appendFrom(x$5, 0);
            return BoxedUnit.UNIT;
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        OnHeapColumnVector columnVector = new OnHeapColumnVector(values.length(), (DataType)BooleanType$.MODULE$);
        decoder.decompress((WritableColumnVector)columnVector, values.length());
        if (values.nonEmpty()) {
            ((IterableOnceOps)values.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    boolean b = tuple2._1$mcZ$sp();
                    int index = tuple2._2$mcI$sp();
                    if (true) {
                        boolean bl = b;
                        if (true) {
                            int n = index;
                            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)bl), "Wrong " + n + "-th decoded boolean value", BoxesRunTime.boxToBoolean((boolean)columnVector.getBoolean(n)), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public static final /* synthetic */ Assertion $anonfun$skeleton$4(BooleanBitSetSuite $this, LongRef word$1, ByteBuffer buffer$1, Seq values$1, int i) {
        int bit = i % BooleanBitSet$.MODULE$.BITS_PER_LONG();
        word$1.elem = bit == 0 ? buffer$1.getLong() : word$1.elem;
        return $this.assertResult(values$1.apply(i), "Wrong value in compressed buffer, index=" + i, BoxesRunTime.boxToBoolean(((word$1.elem & 1L << bit) != 0L ? 1 : 0) != 0), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }

    public static final /* synthetic */ Assertion $anonfun$skeleton$5(BooleanBitSetSuite $this, Decoder decoder$1, GenericInternalRow mutableRow$1, boolean x$3) {
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)x$3);
        decoder$1.next((InternalRow)mutableRow$1, 0);
        return $this.assertResult(bl, "Wrong decoded value", BoxesRunTime.boxToBoolean((boolean)mutableRow$1.getBoolean(0)), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    public static final /* synthetic */ Assertion $anonfun$new$14(OnHeapColumnVector columnVector$2, int rowNum) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(columnVector$2.isNullAt(rowNum), "columnVector.isNullAt(rowNum)", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }

    public BooleanBitSetSuite() {
        this.test(BooleanBitSet$.MODULE$ + ": empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton(0), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test(BooleanBitSet$.MODULE$ + ": less than 1 word", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test(BooleanBitSet$.MODULE$ + ": exactly 1 word", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG()), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test(BooleanBitSet$.MODULE$ + ": multiple whole words", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test(BooleanBitSet$.MODULE$ + ": multiple words and 1 more bit", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test(BooleanBitSet$.MODULE$ + ": empty for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress(0), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test(BooleanBitSet$.MODULE$ + ": less than 1 word for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test(BooleanBitSet$.MODULE$ + ": exactly 1 word for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG()), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test(BooleanBitSet$.MODULE$ + ": multiple whole words for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test(BooleanBitSet$.MODULE$ + ": multiple words and 1 more bit for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.skeletonForDecompress(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test(BooleanBitSet$.MODULE$ + ": Only nulls for decompression()", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
            int numRows = 10;
            Seq rows = (Seq)package$.MODULE$.Seq().fill(numRows, (Function0 & Serializable)() -> {
                GenericInternalRow row = new GenericInternalRow(1);
                row.setNullAt(0);
                return row;
            });
            rows.foreach((Function1 & Serializable)x$6 -> {
                builder.appendFrom(x$6, 0);
                return BoxedUnit.UNIT;
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
            OnHeapColumnVector columnVector = new OnHeapColumnVector(numRows, (DataType)BooleanType$.MODULE$);
            decoder.decompress((WritableColumnVector)columnVector, numRows);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRows).foreach((Function1 & Serializable)rowNum -> BooleanBitSetSuite.$anonfun$new$14(columnVector, BoxesRunTime.unboxToInt((Object)rowNum)));
        }, new Position("BooleanBitSetSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
    }
}

