/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.BooleanColumnStats;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarDataTypeUtils$;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DecimalColumnStats;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.IntervalColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t4A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u000b\u0001C\u0001/\")A\f\u0001C\u0001;\n\u00012i\u001c7v[:\u001cF/\u0019;t'VLG/\u001a\u0006\u0003\u000f!\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u0013)\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005a\u0011BA\f\r\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011AB\u0001\u0010i\u0016\u001cHoQ8mk6t7\u000b^1ugV\u0019ad\u0011\u001b\u0015\t})SH\u0014\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000fC\u0003'\u0005\u0001\u0007q%\u0001\td_2,XN\\*uCR\u001c8\t\\1tgB\u0019\u0001f\f\u001a\u000f\u0005%j\u0003C\u0001\u0016\"\u001b\u0005Y#B\u0001\u0017\u0013\u0003\u0019a$o\\8u}%\u0011a&I\u0001\u0007!J,G-\u001a4\n\u0005A\n$!B\"mCN\u001c(B\u0001\u0018\"!\t\u0019D\u0007\u0004\u0001\u0005\u000bU\u0012!\u0019\u0001\u001c\u0003\u0003U\u000b\"a\u000e\u001e\u0011\u0005\u0001B\u0014BA\u001d\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u001e\n\u0005q2!aC\"pYVlgn\u0015;biNDQA\u0010\u0002A\u0002}\n!bY8mk6tG+\u001f9f!\rY\u0002IQ\u0005\u0003\u0003\u001a\u0011\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0011\u0005M\u001aE!\u0002#\u0003\u0005\u0004)%!\u0001+\u0012\u0005]2\u0005CA$M\u001b\u0005A%BA%K\u0003\u0015!\u0018\u0010]3t\u0015\tY%\"\u0001\u0005dCR\fG._:u\u0013\ti\u0005J\u0001\tQQf\u001c\u0018nY1m\t\u0006$\u0018\rV=qK\")qJ\u0001a\u0001!\u0006\t\u0012N\\5uS\u0006d7\u000b^1uSN$\u0018nY:\u0011\u0007\u0001\n6+\u0003\u0002SC\t)\u0011I\u001d:bsB\u0011\u0001\u0005V\u0005\u0003+\u0006\u00121!\u00118z\u0003Y!Xm\u001d;EK\u000eLW.\u00197D_2,XN\\*uCR\u001cXc\u0001-[7R\u0011q$\u0017\u0005\u0006\u001f\u000e\u0001\r\u0001\u0015\u0003\u0006\t\u000e\u0011\r!\u0012\u0003\u0006k\r\u0011\rAN\u0001\u0018i\u0016\u001cH/\u00138uKJ4\u0018\r\\\"pYVlgn\u0015;biN,2A\u00181b)\tyr\fC\u0003P\t\u0001\u0007\u0001\u000bB\u0003E\t\t\u0007Q\tB\u00036\t\t\u0007a\u0007")
public class ColumnStatsSuite
extends SparkFunSuite {
    public <T extends PhysicalDataType, U extends ColumnStats> void testColumnStats(Class<U> columnStatsClass, NativeColumnType<T> columnType, Object[] initialStatistics) {
        String columnStatsName = columnStatsClass.getSimpleName();
        this.test(columnStatsName + ": empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object actual = tuple2._1();
                    Object expected = tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test(columnStatsName + ": non-empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$1 -> {
                columnStats.gatherStats(x$1, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((IterableOps)rows.take(10)).map((Function1 & Serializable)x$2 -> x$2.get(0, ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType())));
            Ordering ordering2 = PhysicalDataType$.MODULE$.ordering(ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType()));
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min(ordering2), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            this.assertResult(values.max(ordering2), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testColumnStats$8(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    public <T extends PhysicalDataType, U extends ColumnStats> void testDecimalColumnStats(Object[] initialStatistics) {
        String columnStatsName = DecimalColumnStats.class.getSimpleName();
        COMPACT_DECIMAL columnType = new COMPACT_DECIMAL(15, 10);
        this.test(columnStatsName + ": empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object actual = tuple2._1();
                    Object expected = tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test(columnStatsName + ": non-empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$3 -> {
                columnStats.gatherStats(x$3, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((IterableOps)rows.take(10)).map((Function1 & Serializable)x$4 -> x$4.get(0, ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType())));
            Ordering ordering2 = PhysicalDataType$.MODULE$.ordering(ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType()));
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min(ordering2), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            this.assertResult(values.max(ordering2), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testDecimalColumnStats$8(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }

    public <T extends PhysicalDataType, U extends ColumnStats> void testIntervalColumnStats(Object[] initialStatistics) {
        String columnStatsName = IntervalColumnStats.class.getSimpleName();
        CALENDAR_INTERVAL$ columnType = CALENDAR_INTERVAL$.MODULE$;
        this.test(columnStatsName + ": empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntervalColumnStats columnStats = new IntervalColumnStats();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()), (IterableOnce)Predef$.MODULE$.genericWrapArray((Object)initialStatistics))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object actual = tuple2._1();
                    Object expected = tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test(columnStatsName + ": non-empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IntervalColumnStats columnStats = new IntervalColumnStats();
            Seq rows = (Seq)((IterableOps)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Nil$.MODULE$))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)));
            rows.foreach((Function1 & Serializable)x$5 -> {
                columnStats.gatherStats(x$5, 0);
                return BoxedUnit.UNIT;
            });
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            return this.assertResult(stats[4], "Wrong size in bytes", ((IterableOnceOps)rows.map((Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testIntervalColumnStats$7(columnType, row)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    public static final /* synthetic */ int $anonfun$testColumnStats$8(NativeColumnType columnType$1, InternalRow row) {
        if (row.isNullAt(0)) {
            return 4;
        }
        return columnType$1.actualSize(row, 0);
    }

    public static final /* synthetic */ int $anonfun$testDecimalColumnStats$8(COMPACT_DECIMAL columnType$2, InternalRow row) {
        if (row.isNullAt(0)) {
            return 4;
        }
        return columnType$2.actualSize(row, 0);
    }

    public static final /* synthetic */ int $anonfun$testIntervalColumnStats$7(CALENDAR_INTERVAL$ columnType$3, InternalRow row) {
        if (row.isNullAt(0)) {
            return 4;
        }
        return columnType$3.actualSize(row, 0);
    }

    public ColumnStatsSuite() {
        this.testColumnStats((Class)BooleanColumnStats.class, (NativeColumnType)BOOLEAN$.MODULE$, new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)ByteColumnStats.class, (NativeColumnType)BYTE$.MODULE$, new Object[]{BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)ShortColumnStats.class, (NativeColumnType)SHORT$.MODULE$, new Object[]{BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)IntColumnStats.class, (NativeColumnType)INT$.MODULE$, new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)LongColumnStats.class, (NativeColumnType)LONG$.MODULE$, new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)FloatColumnStats.class, (NativeColumnType)FLOAT$.MODULE$, new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)-3.4028235E38f), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)DoubleColumnStats.class, (NativeColumnType)DOUBLE$.MODULE$, new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)-1.7976931348623157E308), BoxesRunTime.boxToInteger((int)0)});
        this.testColumnStats((Class)StringColumnStats.class, (NativeColumnType)STRING$.MODULE$, new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
        this.testDecimalColumnStats(new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
        this.testIntervalColumnStats(new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)});
    }
}

