/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CurrentUserContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.AlterTableTests;
import org.apache.spark.sql.connector.DataSourceV2SQLSuite;
import org.apache.spark.sql.connector.DataSourceV2SQLSuiteV1Filter$;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.ReserveSchemaNullabilityCatalog;
import org.apache.spark.sql.connector.catalog.BasicInMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryBaseTable$;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.SimpleScanSource;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005q4AAC\u0006\u0001-!)A\u0005\u0001C\u0001K!9q\u0005\u0001b\u0001\n#B\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00033\u0001\u0011\u00053\u0007C\u0003I\u0001\u0011%\u0011\nC\u0003\\\u0001\u0011%A\fC\u0003b\u0001\u0011%!\rC\u0003f\u0001\u0011%a\rC\u0004q\u0001E\u0005I\u0011B9\u00039\u0011\u000bG/Y*pkJ\u001cWM\u0016\u001aT#2\u001bV/\u001b;f-F2\u0015\u000e\u001c;fe*\u0011A\"D\u0001\nG>tg.Z2u_JT!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\f\u001c=A\u0011\u0001$G\u0007\u0002\u0017%\u0011!d\u0003\u0002\u0015\t\u0006$\u0018mU8ve\u000e,gKM*R\u0019N+\u0018\u000e^3\u0011\u0005aa\u0012BA\u000f\f\u0005=\tE\u000e^3s)\u0006\u0014G.\u001a+fgR\u001c\bCA\u0010#\u001b\u0005\u0001#BA\u0011\u000e\u0003\u0019)'O]8sg&\u00111\u0005\t\u0002\u0010#V,'/_#se>\u00148OQ1tK\u00061A(\u001b8jiz\"\u0012A\n\t\u00031\u0001\t1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u0006!2-\u0019;bY><\u0017I\u001c3OC6,7\u000f]1dK\u0002\n\u0001cZ3u)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0015\u0005QR\u0004CA\u001b9\u001b\u00051$BA\u001c\f\u0003\u001d\u0019\u0017\r^1m_\u001eL!!\u000f\u001c\u0003\u000bQ\u000b'\r\\3\t\u000bm\"\u0001\u0019\u0001\u001f\u0002\u0013Q\f'\r\\3OC6,\u0007CA\u001fG\u001d\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002B+\u00051AH]8pizR\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u000ba\u0001\u0015:fI\u00164\u0017B\u0001\u0019H\u0015\t)%)\u0001\nuKN$8\u000b[8x\u001d\u0006lWm\u001d9bG\u0016\u001cHc\u0001&O!B\u00111\nT\u0007\u0002\u0005&\u0011QJ\u0011\u0002\u0005+:LG\u000fC\u0003P\u000b\u0001\u0007A(A\u0004tc2$V\r\u001f;\t\u000bE+\u0001\u0019\u0001*\u0002\u0011\u0015D\b/Z2uK\u0012\u00042a\u0015-=\u001d\t!fK\u0004\u0002@+&\t1)\u0003\u0002X\u0005\u00069\u0001/Y2lC\u001e,\u0017BA-[\u0005\r\u0019V-\u001d\u0006\u0003/\n\u000bQc\u00195fG.t\u0015-\\3ta\u0006\u001cWmQ8n[\u0016tG\u000fF\u0002K;~CQA\u0018\u0004A\u0002q\n\u0011B\\1nKN\u0004\u0018mY3\t\u000b\u00014\u0001\u0019\u0001\u001f\u0002\u000f\r|W.\\3oi\u0006\t2\r[3dWR\u000b'\r\\3D_6lWM\u001c;\u0015\u0007)\u001bG\rC\u0003<\u000f\u0001\u0007A\bC\u0003a\u000f\u0001\u0007A(A\ruKN$hj\u001c;TkB\u0004xN\u001d;fIZ\u00134i\\7nC:$G\u0003\u0002&hS.DQ\u0001\u001b\u0005A\u0002q\n!b]9m\u0007>lW.\u00198e\u0011\u0015Q\u0007\u00021\u0001=\u0003%\u0019\u0018\u000f\u001c)be\u0006l7\u000fC\u0004m\u0011A\u0005\t\u0019A7\u0002!\u0015D\b/Z2uK\u0012\f%oZ;nK:$\bcA&oy%\u0011qN\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002GQ,7\u000f\u001e(piN+\b\u000f]8si\u0016$gKM\"p[6\fg\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\t!O\u000b\u0002ng.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003s\n\u000b!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DataSourceV2SQLSuiteV1Filter
extends DataSourceV2SQLSuite
implements AlterTableTests {
    private final String catalogAndNamespace;

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(org.apache.spark.sql.catalyst.expressions.Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (org.apache.spark.sql.catalyst.expressions.Expression)e);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$((QueryErrorsBase)this, (int)i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    @Override
    public Table getTableMetadata(String tableName) {
        Seq nameParts = this.spark().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        TableCatalog v2Catalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)nameParts.head())).asTableCatalog();
        String[] namespace = (String[])((IterableOnceOps)((IterableOps)nameParts.drop(1)).init()).toArray(ClassTag$.MODULE$.apply(String.class));
        return v2Catalog.loadTable(Identifier.of((String[])namespace, (String)((String)nameParts.last())));
    }

    private void testShowNamespaces(String sqlText, Seq<String> expected) {
        StructType schema = new StructType().add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = this.spark().sql(sqlText);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$3 -> (String)x$3.getAs(0), ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$));
        Seq $org_scalatest_assert_macro_right2 = (Seq)expected.sorted((Ordering)Ordering.String$.MODULE$);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
    }

    private void checkNamespaceComment(String namespace, String comment) {
        this.sql().apply((Object)("COMMENT ON NAMESPACE " + namespace + " IS " + Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable)x$7 -> "'" + x$7 + "'").getOrElse((Function0 & Serializable)() -> "NULL")));
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)("DESC NAMESPACE extended " + namespace))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).where("k='" + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString("comment")) + "'").head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2602));
    }

    private void checkTableComment(String tableName, String comment) {
        this.sql().apply((Object)("COMMENT ON TABLE " + tableName + " IS " + Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable)x$8 -> "'" + x$8 + "'").getOrElse((Function0 & Serializable)() -> "NULL")));
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)("DESC extended " + tableName))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v", "c"})).where("k='" + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString("comment")) + "'").head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2655));
    }

    private void testNotSupportedV2Command(String sqlCommand, String sqlParams, Option<String> expectedArgument) {
        this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)(sqlCommand + " " + sqlParams)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3496)), "NOT_SUPPORTED_COMMAND_FOR_V2_TABLE", "0A000", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), expectedArgument.getOrElse((Function0 & Serializable)() -> sqlCommand))})));
    }

    private Option<String> testNotSupportedV2Command$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$29(DataSourceV2SQLSuiteV1Filter $this, String action) {
        AnalysisException x$38 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)(action + " TABLE table_name (id int, value interval) USING " + $this.v2Format())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        String x$39 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$40 = Predef$.MODULE$.Map().empty();
        Option x$41 = $this.checkError$default$3();
        boolean x$42 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$43 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$38, "_LEGACY_ERROR_TEMP_1183", x$41, x$40, x$42, x$43);
        AnalysisException x$44 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)(action + " TABLE table_name (id array<interval>) USING " + $this.v2Format())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        String x$45 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$46 = Predef$.MODULE$.Map().empty();
        Option x$47 = $this.checkError$default$3();
        boolean x$48 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$49 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$44, "_LEGACY_ERROR_TEMP_1183", x$47, x$46, x$48, x$49);
    }

    public static final /* synthetic */ void $anonfun$new$34(DataSourceV2SQLSuiteV1Filter $this, String action) {
        AnalysisException x$50 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)(action + " TABLE table_name USING " + $this.v2Format() + " as select interval 1 day")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        String x$51 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$52 = Predef$.MODULE$.Map().empty();
        Option x$53 = $this.checkError$default$3();
        boolean x$54 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$55 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$50, "_LEGACY_ERROR_TEMP_1183", x$53, x$52, x$54, x$55);
        AnalysisException x$56 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)(action + " TABLE table_name USING " + $this.v2Format() + " as select array(interval 1 day)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        String x$57 = "_LEGACY_ERROR_TEMP_1183";
        scala.collection.immutable.Map x$58 = Predef$.MODULE$.Map().empty();
        Option x$59 = $this.checkError$default$3();
        boolean x$60 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$61 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$56, "_LEGACY_ERROR_TEMP_1183", x$59, x$58, x$60, x$61);
    }

    public static final /* synthetic */ void $anonfun$new$38(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT id, data FROM source");
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            SparkContext qual$11 = $this.spark().sparkContext();
            Seq x$62 = ((InMemoryTable)table).rows();
            int x$63 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize(x$62, x$63, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$12 = $this.spark();
                RDD x$64 = rdd;
                StructType x$65 = table.schema();
                boolean x$66 = qual$12.internalCreateDataFrame$default$3();
                return qual$12.internalCreateDataFrame(x$64, x$65, x$66);
            }, (Dataset<Row>)$this.spark().table("source"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$41(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            Dataset df = $this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT id, data FROM source");
            df.collect();
            df.take(5);
            df.tail(5);
            df.where("true").collect();
            df.where("true").take(5);
            df.where("true").tail(5);
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            SparkContext qual$13 = $this.spark().sparkContext();
            Seq x$67 = ((InMemoryTable)table).rows();
            int x$68 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize(x$67, x$68, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$14 = $this.spark();
                RDD x$69 = rdd;
                StructType x$70 = table.schema();
                boolean x$71 = qual$14.internalCreateDataFrame$default$3();
                return qual$14.internalCreateDataFrame(x$69, x$70, x$71);
            }, (Dataset<Row>)$this.spark().table("source"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$54(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Table replacedTable;
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT id, data FROM source");
            Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            $this.spark().sql("REPLACE TABLE " + identifier + " USING foo AS SELECT id FROM source");
            Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Table $org_scalatest_assert_macro_right = originalTable;
            Table table = $org_scalatest_assert_macro_left;
            Table table2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            String $org_scalatest_assert_macro_left2 = replacedTable.name();
            String $org_scalatest_assert_macro_right2 = identifier;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left4;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
            StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left5;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            SparkContext qual$15 = $this.spark().sparkContext();
            Seq x$72 = ((InMemoryTable)replacedTable).rows();
            int x$73 = qual$15.parallelize$default$2();
            RDD rdd = qual$15.parallelize(x$72, x$73, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$16 = $this.spark();
                RDD x$74 = rdd;
                StructType x$75 = replacedTable.schema();
                boolean x$76 = qual$16.internalCreateDataFrame$default$3();
                return qual$16.internalCreateDataFrame(x$74, x$75, x$76);
            }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Nil$.MODULE$));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$58(DataSourceV2SQLSuiteV1Filter $this, String cmd$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            Table replacedTable;
            TableCatalog catalog = (TableCatalog)tuple2._1();
            String identifier = (String)tuple2._2();
            $this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT id, data FROM source");
            Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Dataset df = $this.spark().sql(cmd$1 + " TABLE " + identifier + " USING foo AS SELECT id FROM source");
            df.collect();
            df.take(5);
            df.tail(5);
            df.where("true").collect();
            df.where("true").take(5);
            df.where("true").tail(5);
            Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Table $org_scalatest_assert_macro_right = originalTable;
            Table table = $org_scalatest_assert_macro_left;
            Table table2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            String $org_scalatest_assert_macro_left2 = replacedTable.name();
            String $org_scalatest_assert_macro_right2 = identifier;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left4;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
            StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
            StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left5;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
            SparkContext qual$17 = $this.spark().sparkContext();
            Seq x$77 = ((InMemoryTable)replacedTable).rows();
            int x$78 = qual$17.parallelize$default$2();
            RDD rdd = qual$17.parallelize(x$77, x$78, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$18 = $this.spark();
                RDD x$79 = rdd;
                StructType x$80 = replacedTable.schema();
                boolean x$81 = qual$18.internalCreateDataFrame$default$3();
                return qual$18.internalCreateDataFrame(x$79, x$80, x$81);
            }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Nil$.MODULE$));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$72(DataSourceV2SQLSuiteV1Filter $this, String catalog) {
        $this.spark().sql("CREATE TABLE " + catalog + ".created USING " + $this.v2Source() + " AS SELECT id, data FROM source");
        CannotReplaceMissingTableException x$82 = (CannotReplaceMissingTableException)$this.intercept((Function0 & Serializable)() -> $this.spark().sql("REPLACE TABLE " + catalog + ".replaced USING " + $this.v2Source() + " AS SELECT id, data FROM source"), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        String x$83 = "TABLE_OR_VIEW_NOT_FOUND";
        scala.collection.immutable.Map x$84 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`replaced`")}));
        Option x$85 = $this.checkError$default$3();
        boolean x$86 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$87 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$82, "TABLE_OR_VIEW_NOT_FOUND", x$85, x$84, x$86, x$87);
    }

    private final void insertNullValueAndCheck$1(String identifier$5, Table table$12) {
        this.sql().apply((Object)("INSERT INTO " + identifier$5 + " SELECT CAST(null AS INT)"));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = ((InMemoryTable)table$12).rows();
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd2 = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
            SparkSession qual$2 = this.spark();
            RDD x$3 = rdd2;
            StructType x$4 = table$12.schema();
            boolean x$5 = qual$2.internalCreateDataFrame$default$3();
            return qual$2.internalCreateDataFrame(x$3, x$4, x$5);
        }, (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$new$90(DataSourceV2SQLSuiteV1Filter $this, Tuple3 x0$5) {
        Tuple3 tuple3 = x0$5;
        if (tuple3 != null) {
            TableCatalog catalog = (TableCatalog)tuple3._1();
            String identifier = (String)tuple3._2();
            boolean nullable = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            $this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT 1 i");
            Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = identifier;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("i", "int", nullable);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            SparkContext qual$31 = $this.spark().sparkContext();
            Seq x$130 = ((InMemoryTable)table).rows();
            int x$131 = qual$31.parallelize$default$2();
            RDD rdd = qual$31.parallelize(x$130, x$131, ClassTag$.MODULE$.apply(InternalRow.class));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$32 = $this.spark();
                RDD x$132 = rdd;
                StructType x$133 = table.schema();
                boolean x$134 = qual$32.internalCreateDataFrame$default$3();
                return qual$32.internalCreateDataFrame(x$132, x$133, x$134);
            }, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            if (nullable) {
                $this.insertNullValueAndCheck$1(identifier, table);
                return;
            }
            SparkException x$135 = (SparkException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.insertNullValueAndCheck$1(identifier, table), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
            Object x$136 = null;
            scala.collection.immutable.Map x$137 = Predef$.MODULE$.Map().empty();
            Option x$138 = $this.checkError$default$3();
            boolean x$139 = $this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$140 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$135, null, x$138, x$137, x$139, x$140);
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$96(DataSourceV2SQLSuiteV1Filter $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE " + t + " USING foo AS SELECT id, data FROM source"));
            $this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT id FROM " + t));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + t)), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + view)), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Nil$.MODULE$));
            Dataset oldView = $this.spark().table(view);
            $this.sql().apply((Object)("REPLACE TABLE " + t + " (a bigint) USING foo"));
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData(oldView);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$102(DataSourceV2SQLSuiteV1Filter $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE " + t + " USING foo AS SELECT id, data FROM source"));
            $this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT id FROM " + t));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + t)), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + view)), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Nil$.MODULE$));
            $this.sql().apply((Object)("REPLACE TABLE " + t + " USING foo AS SELECT id FROM source"));
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData($this.spark().table(view));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$130(DataSourceV2SQLSuiteV1Filter $this, String t$9, File checkpointDir) {
        $this.sql().apply((Object)("CREATE TABLE " + t$9 + " (id bigint, data string) USING foo"));
        $this.sql().apply((Object)("INSERT INTO " + t$9 + " VALUES (1L, 'a')"));
        $this.sql().apply((Object)("CACHE TABLE " + t$9));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
        public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1(DataSourceV2SQLSuiteV1Filter $outer) {
            }
        }
        MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator49$1(null))), $this.sqlContext());
        Dataset df = inputData.toDF().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
        StreamingQuery query = df.writeStream().option("checkpointLocation", checkpointDir.getAbsolutePath()).toTable(t$9);
        .colon.colon newData = new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)Nil$.MODULE$);
        inputData.addData((IterableOnce)newData);
        query.processAllAvailable();
        query.stop();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("testcat.ns.t"), "DataSourceV2SQLSuiteV1Filter.this.spark.catalog.isCached(\"testcat.ns.t\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"}));
        Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("SELECT * FROM " + t$9)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    private final void check$1(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT testcat.ns1.ns2.tbl.id, testcat.ns1.ns2.tbl.point.x FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT ns1.ns2.tbl.id, ns1.ns2.tbl.point.x FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT ns2.tbl.id, ns2.tbl.point.x FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT tbl.id, tbl.point.x FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
    }

    public static final /* synthetic */ void $anonfun$new$156(DataSourceV2SQLSuiteV1Filter $this, boolean useV1Table) {
        String format;
        String string = format = useV1Table ? "json" : $this.v2Format();
        if (useV1Table) {
            $this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
        } else {
            $this.spark().conf().set(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key(), InMemoryTableSessionCatalog.class.getName());
        }
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t USING " + format + " AS SELECT 1 AS i"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select i from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$189(String x$1) {
        String string = x$1;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$192(DataSourceV2SQLSuiteV1Filter $this, String clause$1, String key$1, scala.collection.immutable.Map keyParameters$1, String action) {
        String sqlText = action + " TABLE testcat.reservedTest (key int) USING foo " + clause$1 + " ('" + key$1 + "'='bar')";
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1252)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key$1, (Function0 & Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), $this.ExpectedContext().apply(sqlText, 0, 58 + key$1.length() + clause$1.length() + action.length()));
    }

    public static final /* synthetic */ void $anonfun$new$191(DataSourceV2SQLSuiteV1Filter $this, String key$1, scala.collection.immutable.Map keyParameters$1, String clause) {
        new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$192($this, clause, key$1, keyParameters$1, action);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$190(DataSourceV2SQLSuiteV1Filter $this, scala.collection.immutable.Map keyParameters$1, String key) {
        new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)clause -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$191($this, key, keyParameters$1, clause);
            return BoxedUnit.UNIT;
        });
        String sql1 = "ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('" + key + "'='bar')";
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1269)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key, (Function0 & Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), $this.ExpectedContext().apply(sql1, 0, 60 + key.length()));
        String sql2 = "ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('" + key + "')";
        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1284)), "UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), keyParameters$1.getOrElse((Object)key, (Function0 & Serializable)() -> "please remove it from the TBLPROPERTIES list."))})), $this.ExpectedContext().apply(sql2, 0, 56 + key.length()));
    }

    public static final /* synthetic */ boolean $anonfun$new$200(String x$2) {
        String string = x$2;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$201(DataSourceV2SQLSuiteV1Filter $this, String key) {
        new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)clause -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)action -> {
                String originValue;
                $this.sql().apply((Object)(action + " TABLE testcat.reservedTest (key int) USING foo " + clause + " ('" + key$2 + "'='bar')"));
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left = originValue = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right = "bar";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
                $this.sql().apply((Object)("ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('" + key$2 + "'='newValue')"));
                String $org_scalatest_assert_macro_left2 = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right2 = originValue;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1309));
                $this.sql().apply((Object)("ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('" + key$2 + "')"));
                String $org_scalatest_assert_macro_left3 = (String)tableCatalog.loadTable(identifier).properties().get(key$2);
                String $org_scalatest_assert_macro_right3 = originValue;
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1312));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$222(DataSourceV2SQLSuiteV1Filter $this, String tblName$1, String tableDefinition$1, String statement) {
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName$1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String string = statement;
            String string2 = "REPLACE TABLE";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)("CREATE TABLE testcat." + tblName$1 + "(a INT) USING foo")) : BoxedUnit.UNIT;
            $this.sql().apply((Object)(statement + " testcat." + tableDefinition$1));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$1)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$207 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> {
                $this.sql().apply((Object)"USE dummy");
                return (Dataset)$this.sql().apply((Object)(statement + " dummy." + tableDefinition$1));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1484));
            String x$208 = "UNSUPPORTED_FEATURE.TABLE_OPERATION";
            scala.collection.immutable.Map x$209 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`dummy`.`my_tab`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"column default value")}));
            Option x$210 = $this.checkError$default$3();
            boolean x$211 = $this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$212 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$207, "UNSUPPORTED_FEATURE.TABLE_OPERATION", x$210, x$209, x$211, x$212);
        });
    }

    public static final /* synthetic */ void $anonfun$new$227(DataSourceV2SQLSuiteV1Filter $this, String tblName$2, String tableDefinition$2, String statement) {
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName$2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String string = statement;
            String string2 = "REPLACE TABLE";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)("CREATE TABLE testcat." + tblName$2 + "(a INT) USING foo")) : BoxedUnit.UNIT;
            $this.sql().apply((Object)(statement + " testcat." + tableDefinition$2 + " USING foo"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$2)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1511));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$213 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> {
                $this.sql().apply((Object)"USE dummy");
                return (Dataset)$this.sql().apply((Object)(statement + " dummy." + tableDefinition$2 + " USING foo"));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1516));
            String x$214 = "UNSUPPORTED_FEATURE.TABLE_OPERATION";
            scala.collection.immutable.Map x$215 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`dummy`.`my_tab`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"generated columns")}));
            Option x$216 = $this.checkError$default$3();
            boolean x$217 = $this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$218 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$213, "UNSUPPORTED_FEATURE.TABLE_OPERATION", x$216, x$215, x$217, x$218);
        });
    }

    private final void checkUnsupportedGenerationExpression$1(String expr, String expectedReason, String genColType, Option customTableDef, String tblName$4) {
        String tableDef = "CREATE TABLE testcat." + tblName$4 + "(a INT, b " + genColType + " GENERATED ALWAYS AS (" + expr + ")) USING foo";
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName$4}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply(customTableDef.getOrElse((Function0 & Serializable)() -> tableDef)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1566));
            String x$2 = "UNSUPPORTED_EXPRESSION_GENERATED_COLUMN";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressionStr"), (Object)expr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)expectedReason)}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "UNSUPPORTED_EXPRESSION_GENERATED_COLUMN", x$4, x$3, x$5, x$6);
        });
    }

    private static final String checkUnsupportedGenerationExpression$default$3$1() {
        return "INT";
    }

    private static final Option checkUnsupportedGenerationExpression$default$4$1() {
        return None$.MODULE$;
    }

    private final void testShowCurrentNamespace$1(String expectedCatalogName, String expectedNamespace) {
        StructType schema = new StructType().add("catalog", (DataType)StringType$.MODULE$, false).add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = (Dataset)this.sql().apply((Object)"SHOW CURRENT NAMESPACE");
        Row[] rows = (Row[])df.collect();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1754));
        Row[] $org_scalatest_assert_macro_left2 = rows;
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1755));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rows[0].getAs(0));
        String $org_scalatest_assert_macro_right3 = expectedCatalogName;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1756));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(rows[0].getAs(1));
        String $org_scalatest_assert_macro_right4 = expectedNamespace;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1757));
    }

    private final void checkPartitioning$1(TableCatalog cat, String partition) {
        String string = cat.name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] namespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{"default"}) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        Table table = cat.loadTable(Identifier.of((String[])namespace, (String)"tbl"));
        NamedReference[][] partitions = (NamedReference[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.partitioning()), (Function1 & Serializable)x$4 -> x$4.references(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(NamedReference.class)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partitions.length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1783));
        String[][] fieldNames = (String[][])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])partitions), (Function1 & Serializable)x$5 -> (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$5), (Function1 & Serializable)x$6 -> x$6.fieldNames(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(fieldNames);
        String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{partition})});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1785));
    }

    private final void checkFailure$1(String statement, String i) {
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)statement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1802));
            String x$2 = "_LEGACY_ERROR_TEMP_3060";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)i), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n                | |-- a: integer (nullable = true)\n                | |-- b: string (nullable = true)\n                |")))}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "_LEGACY_ERROR_TEMP_3060", x$4, x$3, x$5, x$6);
        });
    }

    public static final /* synthetic */ void $anonfun$new$269(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$237 = $this.analysisException("CREATE TABLE t (" + c0 + " INT, " + c1 + " INT) USING " + $this.v2Source());
                    String x$238 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$239 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$240 = $this.checkError$default$3();
                    boolean x$241 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$242 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$237, "COLUMN_ALREADY_EXISTS", x$240, x$239, x$241, x$242);
                    AnalysisException x$243 = $this.analysisException("CREATE TABLE testcat.t (" + c0 + " INT, " + c1 + " INT) USING " + $this.v2Source());
                    String x$244 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$245 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$246 = $this.checkError$default$3();
                    boolean x$247 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$248 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$243, "COLUMN_ALREADY_EXISTS", x$246, x$245, x$247, x$248);
                    AnalysisException x$249 = $this.analysisException("CREATE OR REPLACE TABLE t (" + c0 + " INT, " + c1 + " INT) USING " + $this.v2Source());
                    String x$250 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$251 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$252 = $this.checkError$default$3();
                    boolean x$253 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$254 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$249, "COLUMN_ALREADY_EXISTS", x$252, x$251, x$253, x$254);
                    AnalysisException x$255 = $this.analysisException("CREATE OR REPLACE TABLE testcat.t (" + c0 + " INT, " + c1 + " INT) USING " + $this.v2Source());
                    String x$256 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$257 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$258 = $this.checkError$default$3();
                    boolean x$259 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$260 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$255, "COLUMN_ALREADY_EXISTS", x$258, x$257, x$259, x$260);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$272(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$261 = $this.analysisException("CREATE TABLE t (d struct<" + c0 + ": INT, " + c1 + ": INT>) USING " + $this.v2Source());
                    String x$262 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$263 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("d." + c0.toLowerCase(Locale.ROOT)))}));
                    Option x$264 = $this.checkError$default$3();
                    boolean x$265 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$266 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$261, "COLUMN_ALREADY_EXISTS", x$264, x$263, x$265, x$266);
                    AnalysisException x$267 = $this.analysisException("CREATE TABLE testcat.t (d struct<" + c0 + ": INT, " + c1 + ": INT>) USING " + $this.v2Source());
                    String x$268 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$269 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("d." + c0.toLowerCase(Locale.ROOT)))}));
                    Option x$270 = $this.checkError$default$3();
                    boolean x$271 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$272 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$267, "COLUMN_ALREADY_EXISTS", x$270, x$269, x$271, x$272);
                    AnalysisException x$273 = $this.analysisException("CREATE OR REPLACE TABLE t (d struct<" + c0 + ": INT, " + c1 + ": INT>) USING " + $this.v2Source());
                    String x$274 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$275 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("d." + c0.toLowerCase(Locale.ROOT)))}));
                    Option x$276 = $this.checkError$default$3();
                    boolean x$277 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$278 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$273, "COLUMN_ALREADY_EXISTS", x$276, x$275, x$277, x$278);
                    AnalysisException x$279 = $this.analysisException("CREATE OR REPLACE TABLE testcat.t (d struct<" + c0 + ": INT, " + c1 + ": INT>) USING " + $this.v2Source());
                    String x$280 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$281 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("d." + c0.toLowerCase(Locale.ROOT)))}));
                    Option x$282 = $this.checkError$default$3();
                    boolean x$283 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$284 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$279, "COLUMN_ALREADY_EXISTS", x$282, x$281, x$283, x$284);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$279(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (JFunction0.mcV.sp & Serializable)() -> {
                    String dupCol = c1.toLowerCase(Locale.ROOT);
                    AnalysisException x$309 = $this.analysisException("CREATE TABLE t (" + c0 + " INT) USING " + $this.v2Source() + " PARTITIONED BY (" + c0 + ", " + c1 + ")");
                    String x$310 = "_LEGACY_ERROR_TEMP_3058";
                    scala.collection.immutable.Map x$311 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkType"), (Object)"in the partitioning"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateColumns"), (Object)dupCol)}));
                    Option x$312 = $this.checkError$default$3();
                    boolean x$313 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$314 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$309, "_LEGACY_ERROR_TEMP_3058", x$312, x$311, x$313, x$314);
                    AnalysisException x$315 = $this.analysisException("CREATE TABLE testcat.t (" + c0 + " INT) USING " + $this.v2Source() + " PARTITIONED BY (" + c0 + ", " + c1 + ")");
                    String x$316 = "_LEGACY_ERROR_TEMP_3058";
                    scala.collection.immutable.Map x$317 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkType"), (Object)"in the partitioning"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateColumns"), (Object)dupCol)}));
                    Option x$318 = $this.checkError$default$3();
                    boolean x$319 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$320 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$315, "_LEGACY_ERROR_TEMP_3058", x$318, x$317, x$319, x$320);
                    AnalysisException x$321 = $this.analysisException("CREATE OR REPLACE TABLE t (" + c0 + " INT) USING " + $this.v2Source() + " PARTITIONED BY (" + c0 + ", " + c1 + ")");
                    String x$322 = "_LEGACY_ERROR_TEMP_3058";
                    scala.collection.immutable.Map x$323 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkType"), (Object)"in the partitioning"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateColumns"), (Object)dupCol)}));
                    Option x$324 = $this.checkError$default$3();
                    boolean x$325 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$326 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$321, "_LEGACY_ERROR_TEMP_3058", x$324, x$323, x$325, x$326);
                    AnalysisException x$327 = $this.analysisException("CREATE OR REPLACE TABLE testcat.t (" + c0 + " INT) USING " + $this.v2Source() + " PARTITIONED BY (" + c0 + ", " + c1 + ")");
                    String x$328 = "_LEGACY_ERROR_TEMP_3058";
                    scala.collection.immutable.Map x$329 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkType"), (Object)"in the partitioning"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateColumns"), (Object)dupCol)}));
                    Option x$330 = $this.checkError$default$3();
                    boolean x$331 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$332 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$327, "_LEGACY_ERROR_TEMP_3058", x$330, x$329, x$331, x$332);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$282(DataSourceV2SQLSuiteV1Filter $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            boolean caseSensitive = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String c0 = (String)tuple22._1();
                String c1 = (String)tuple22._2();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$333 = $this.analysisException("CREATE TABLE t (" + c0 + " INT) USING " + $this.v2Source() + " CLUSTERED BY (" + c0 + ", " + c1 + ") INTO 2 BUCKETS");
                    String x$334 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$335 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$336 = $this.checkError$default$3();
                    boolean x$337 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$338 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$333, "COLUMN_ALREADY_EXISTS", x$336, x$335, x$337, x$338);
                    AnalysisException x$339 = $this.analysisException("CREATE TABLE testcat.t (" + c0 + " INT) USING " + $this.v2Source() + " CLUSTERED BY (" + c0 + ", " + c1 + ") INTO 2 BUCKETS");
                    String x$340 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$341 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$342 = $this.checkError$default$3();
                    boolean x$343 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$344 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$339, "COLUMN_ALREADY_EXISTS", x$342, x$341, x$343, x$344);
                    AnalysisException x$345 = $this.analysisException("CREATE OR REPLACE TABLE t (" + c0 + " INT) USING " + $this.v2Source() + " CLUSTERED BY (" + c0 + ", " + c1 + ") INTO 2 BUCKETS");
                    String x$346 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$347 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$348 = $this.checkError$default$3();
                    boolean x$349 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$350 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$345, "COLUMN_ALREADY_EXISTS", x$348, x$347, x$349, x$350);
                    AnalysisException x$351 = $this.analysisException("CREATE OR REPLACE TABLE testcat.t (" + c0 + " INT) USING " + $this.v2Source() + " CLUSTERED BY (" + c0 + ", " + c1 + ") INTO 2 BUCKETS");
                    String x$352 = "COLUMN_ALREADY_EXISTS";
                    scala.collection.immutable.Map x$353 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)("`" + c0.toLowerCase(Locale.ROOT) + "`"))}));
                    Option x$354 = $this.checkError$default$3();
                    boolean x$355 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$356 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$351, "COLUMN_ALREADY_EXISTS", x$354, x$353, x$355, x$356);
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isCached$1(String table) {
        return this.spark().table(table).queryExecution().withCachedData() instanceof InMemoryRelation;
    }

    private final void verify$1(String sql) {
        AnalysisException x$1 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2474));
        String x$2 = "REQUIRES_SINGLE_PART_NAMESPACE";
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionCatalog"), (Object)"spark_catalog"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)"")}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "REQUIRES_SINGLE_PART_NAMESPACE", x$4, x$3, x$5, x$6);
    }

    private final void assertWrongTableIdent$1() {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
            String t = "spark_catalog.t";
            this.verify$1("select * from " + t);
            this.verify$1("REFRESH TABLE " + t);
            this.verify$1("DESCRIBE " + t + " i");
            this.verify$1("DROP TABLE " + t);
            this.verify$1("DROP VIEW " + t);
            this.verify$1("ANALYZE TABLE " + t + " COMPUTE STATISTICS");
            this.verify$1("ANALYZE TABLE " + t + " COMPUTE STATISTICS FOR ALL COLUMNS");
            this.verify$1("MSCK REPAIR TABLE " + t);
            this.verify$1("LOAD DATA INPATH 'filepath' INTO TABLE " + t);
            this.verify$1("SHOW CREATE TABLE " + t);
            this.verify$1("SHOW CREATE TABLE " + t + " AS SERDE");
            this.verify$1("CACHE TABLE " + t);
            this.verify$1("UNCACHE TABLE " + t);
            this.verify$1("TRUNCATE TABLE " + t);
            this.verify$1("SHOW COLUMNS FROM " + t);
        });
    }

    private final void check$2(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT testcat.ns1.ns2.tbl.* FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT ns1.ns2.tbl.* FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT ns2.tbl.* FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT tbl.* FROM " + tbl)), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
    }

    private static final Timestamp testTimestamp$1(int daysOffset) {
        return Timestamp.valueOf(LocalDate.of(2020, 1, 1 + daysOffset).atStartOfDay());
    }

    private final void validateViewCommand$1(String sqlStatement) {
        AnalysisException e;
        AnalysisException x$1 = e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)sqlStatement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2745));
        String x$2 = "UNSUPPORTED_FEATURE.CATALOG_OPERATION";
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogName"), (Object)"`testcat`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"views")}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "UNSUPPORTED_FEATURE.CATALOG_OPERATION", x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ int $anonfun$new$408(BufferedRows x$9) {
        return x$9.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$409(BufferedRows x$10) {
        return x$10.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$410(BufferedRows x$11) {
        return x$11.partitionKey().getInt(0);
    }

    public static final /* synthetic */ int $anonfun$new$411(BufferedRows x$12) {
        return x$12.partitionKey().getInt(0);
    }

    public static final /* synthetic */ long $anonfun$new$414(BufferedRows x$13) {
        return x$13.sizeInBytes().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$415(BufferedRows x$14) {
        return x$14.numRows().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$416(BufferedRows x$15) {
        return x$15.filesCount().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$417(BufferedRows x$16) {
        return x$16.sizeInBytes().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$418(BufferedRows x$17) {
        return x$17.numRows().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$419(BufferedRows x$18) {
        return x$18.filesCount().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$420(BufferedRows x$19) {
        return x$19.sizeInBytes().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$421(BufferedRows x$20) {
        return x$20.numRows().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$422(BufferedRows x$21) {
        return x$21.filesCount().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$423(BufferedRows x$22) {
        return x$22.sizeInBytes().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$424(BufferedRows x$23) {
        return x$23.numRows().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$425(BufferedRows x$24) {
        return x$24.filesCount().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$426(BufferedRows x$25) {
        return x$25.sizeInBytes().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$427(BufferedRows x$26) {
        return x$26.numRows().getAsLong();
    }

    public static final /* synthetic */ long $anonfun$new$428(BufferedRows x$27) {
        return x$27.filesCount().getAsLong();
    }

    public static final /* synthetic */ boolean $anonfun$new$475(SparkPlan x$28) {
        return x$28 instanceof FilterExec;
    }

    public static final /* synthetic */ boolean $anonfun$new$479(SparkPlan x$29) {
        return x$29 instanceof FilterExec;
    }

    public DataSourceV2SQLSuiteV1Filter() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        AlterTableTests.$init$(this);
        this.catalogAndNamespace = "testcat.ns1.ns2.";
        this.test("CreateTable: use v2 plan because catalog is set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint NOT NULL, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            SparkContext qual$1 = this.spark().sparkContext();
            Seq x$1 = ((InMemoryTable)table).rows();
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$2 = this.spark();
                RDD x$3 = rdd;
                StructType x$4 = table.schema();
                boolean x$5 = qual$2.internalCreateDataFrame$default$3();
                return qual$2.internalCreateDataFrame(x$3, x$4, x$5);
            }, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("Describe column for v2 catalog", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string COMMENT 'hello') USING foo"));
                Dataset df1 = (Dataset)this.sql().apply((Object)("DESCRIBE " + t + " id"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df1.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
                .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df1.collect());
                .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                Dataset df2 = (Dataset)this.sql().apply((Object)("DESCRIBE " + t + " data"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df2.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
                .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(df2.collect());
                .colon.colon $org_scalatest_assert_macro_right4 = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "data"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "string"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "hello"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                this.checkError((SparkThrowable)this.analysisException("DESCRIBE " + t + " invalid_col"), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`invalid_col`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`id`, `data`")})), this.ExpectedContext().apply("DESCRIBE testcat.tbl invalid_col", 0, 31));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("Describe column for v2 catalog should work with qualified columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint) USING foo"));
                new .colon.colon((Object)"testcat.ns.tbl.id", (List)new .colon.colon((Object)"ns.tbl.id", (List)new .colon.colon((Object)"tbl.id", (List)new .colon.colon((Object)"id", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)col -> {
                    Dataset df = (Dataset)this.sql().apply((Object)("DESCRIBE " + t + " " + col));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
                    .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.collect());
                    .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("Describing nested column for v2 catalog is not supported", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (d struct<a: INT, b: INT>) USING foo"));
                AnalysisException x$6 = this.analysisException("describe " + t + " d.a");
                String x$7 = "_LEGACY_ERROR_TEMP_1060";
                scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"command"), (Object)"DESC TABLE COLUMN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)"d.a")}));
                Option x$9 = this.checkError$default$3();
                boolean x$10 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$11 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$6, "_LEGACY_ERROR_TEMP_1060", x$9, x$8, x$10, x$11);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("SPARK-33004: Describe column should resolve to a temporary view first", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2 as i");
            this.sql().apply((Object)"USE testcat.ns");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE t i"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "i"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$))));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("CreateTable: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE table_name (id bigint, data string) USING " + this.v2Source());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            SparkContext qual$3 = this.spark().sparkContext();
            Seq x$12 = ((InMemoryTable)table).rows();
            int x$13 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize(x$12, x$13, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$4 = this.spark();
                RDD x$14 = rdd;
                StructType x$15 = table.schema();
                boolean x$16 = qual$4.internalCreateDataFrame$default$3();
                return qual$4.internalCreateDataFrame(x$14, x$15, x$16);
            }, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("CreateTable: fail if table exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            TableAlreadyExistsException x$17 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string, id2 bigint) USING bar"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            String x$18 = "TABLE_OR_VIEW_ALREADY_EXISTS";
            scala.collection.immutable.Map x$19 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`table_name`")}));
            Option x$20 = this.checkError$default$3();
            boolean x$21 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$22 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$17, "TABLE_OR_VIEW_ALREADY_EXISTS", x$20, x$19, x$21, x$22);
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            Object $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left6), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            SparkContext qual$5 = this.spark().sparkContext();
            Seq x$23 = ((InMemoryTable)table).rows();
            int x$24 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize(x$23, x$24, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$6 = this.spark();
                RDD x$25 = rdd;
                StructType x$26 = table.schema();
                boolean x$27 = qual$6.internalCreateDataFrame$default$3();
                return qual$6.internalCreateDataFrame(x$25, x$26, x$27);
            }, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("CreateTable: if not exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING bar");
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            Object $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left6), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            SparkContext qual$7 = this.spark().sparkContext();
            Seq x$28 = ((InMemoryTable)table).rows();
            int x$29 = qual$7.parallelize$default$2();
            RDD rdd2 = qual$7.parallelize(x$28, x$29, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$8 = this.spark();
                RDD x$30 = rdd2;
                StructType x$31 = table.schema();
                boolean x$32 = qual$8.internalCreateDataFrame$default$3();
                return qual$8.internalCreateDataFrame(x$30, x$31, x$32);
            }, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("CreateTable: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            this.spark().sql("CREATE TABLE table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            SparkContext qual$9 = this.spark().sparkContext();
            Seq x$33 = ((InMemoryTable)table).rows();
            int x$34 = qual$9.parallelize$default$2();
            RDD rdd = qual$9.parallelize(x$33, x$34, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$10 = this.spark();
                RDD x$35 = rdd;
                StructType x$36 = table.schema();
                boolean x$37 = qual$10.internalCreateDataFrame$default$3();
                return qual$10.internalCreateDataFrame(x$35, x$36, x$37);
            }, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().empty()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("CreateTable: without USING clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT().key()), (Object)"false")}), (Function0 & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 (id int)");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            this.sql().apply((Object)"CREATE TABLE t2 (id int)");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("CreateTable/ReplaceTable: invalid schema if has interval type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$29(this, action);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        this.test("CTAS/RTAS: invalid schema if has interval type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)action -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$34(this, action);
            return BoxedUnit.UNIT;
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("CreateTableAsSelect: use v2 plan because catalog is set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$38(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("CreateTableAsSelect: do not double execute on collect(), take() and other queries", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$2 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$41(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("SPARK-36850: CreateTableAsSelect partitions can be specified using PARTITIONED BY and/or CLUSTERED BY", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String identifier = "testcat.table_name";
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"a1", (Object)"a2", (Object)"a3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"b1", (Object)"b2", (Object)"b3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c", (Object)"c1", (Object)"c2", (Object)"c3"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator1$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data1", "data2", "data3", "data4"}));
            df.createOrReplaceTempView("source_table");
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + identifier + " USING foo PARTITIONED BY (id) CLUSTERED BY (data1, data2, data3, data4) INTO 4 BUCKETS AS SELECT * FROM source_table");
                Dataset describe = this.spark().sql("DESCRIBE " + identifier);
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "bucket(4, data1, data2, data3, data4)";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("SPARK-36850: ReplaceTableAsSelect partitions can be specified using PARTITIONED BY and/or CLUSTERED BY", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String identifier = "testcat.table_name";
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"a1", (Object)"a2", (Object)"a3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"b1", (Object)"b2", (Object)"b3"), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c", (Object)"c1", (Object)"c2", (Object)"c3"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator2$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data1", "data2", "data3", "data4"}));
            df.createOrReplaceTempView("source_table");
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + identifier + " USING foo AS SELECT id FROM source");
                this.spark().sql("REPLACE TABLE " + identifier + " USING foo PARTITIONED BY (id) CLUSTERED BY (data1, data2) SORTED by (data3, data4) INTO 4 BUCKETS AS SELECT * FROM source_table");
                Dataset describe = this.spark().sql("DESCRIBE " + identifier);
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "sorted_bucket(data1, data2, 4, data3, data4)";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        this.test("SPARK-37545: CreateTableAsSelect should store location as qualified", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            new .colon.colon((Object)basicIdentifier, (List)new .colon.colon((Object)atomicIdentifier, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)identifier -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.spark().sql("CREATE TABLE " + identifier + " USING foo LOCATION '/tmp/foo' AS SELECT id FROM source");
                    String location = ((Row)$this.spark().sql("DESCRIBE EXTENDED " + identifier).filter("col_name = 'Location'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(location);
                    String $org_scalatest_assert_macro_right = "file:/tmp/foo";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.test("SPARK-37546: ReplaceTableAsSelect should store location as qualified", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            new .colon.colon((Object)basicIdentifier, (List)new .colon.colon((Object)atomicIdentifier, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)identifier -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.spark().sql("CREATE TABLE " + identifier + " USING foo LOCATION '/tmp/foo' AS SELECT id, data FROM source");
                    $this.spark().sql("REPLACE TABLE " + identifier + " USING foo LOCATION '/tmp/foo' AS SELECT id FROM source");
                    String location = ((Row)$this.spark().sql("DESCRIBE EXTENDED " + identifier).filter("col_name = 'Location'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(location);
                    String $org_scalatest_assert_macro_right = "file:/tmp/foo";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("ReplaceTableAsSelect: basic v2 implementation.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$3 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$54(this, x0$3);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        new .colon.colon((Object)"REPLACE", (List)new .colon.colon((Object)"CREATE OR REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cmd -> {
            this.test("ReplaceTableAsSelect: do not double execute " + cmd + " on collect()", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
                TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat_atomic")).asTableCatalog();
                String basicIdentifier = "testcat.table_name";
                String atomicIdentifier = "testcat_atomic.table_name";
                new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$4 -> {
                    DataSourceV2SQLSuiteV1Filter.$anonfun$new$58($this, cmd, x0$4);
                    return BoxedUnit.UNIT;
                });
            }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            return BoxedUnit.UNIT;
        });
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table if the write fails.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            this.intercept((Function0 & Serializable)() -> this.spark().sql("REPLACE TABLE testcat.table_name USING foo TBLPROPERTIES (`" + InMemoryBaseTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION() + "`=true) AS SELECT id FROM source"), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped as a result of the replace.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table permanently if the subsequent table creation fails.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            this.intercept((Function0 & Serializable)() -> this.spark().sql("REPLACE TABLE testcat.table_name USING foo TBLPROPERTIES (`" + InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY() + "`=true) AS SELECT id FROM source"), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped and failed to be created.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        this.test("ReplaceTableAsSelect: Atomic catalog does not drop the table when replace fails.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat_atomic.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            this.intercept((Function0 & Serializable)() -> this.spark().sql("REPLACE TABLE testcat_atomic.table_name USING foo TBLPROPERTIES (`" + InMemoryBaseTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION() + "=true) AS SELECT id FROM source"), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
            Table maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right = table;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
            this.intercept((Function0 & Serializable)() -> this.spark().sql("REPLACE TABLE testcat_atomic.table_name USING foo TBLPROPERTIES (`" + InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY() + "`=true) AS SELECT id FROM source"), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right2 = table;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        this.test("ReplaceTable: Erases the table contents and changes the metadata", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING " + this.v2Source() + " AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            return (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)"foo")}), (Function0 & Serializable)() -> {
                this.spark().sql("REPLACE TABLE testcat.table_name (id bigint NOT NULL DEFAULT 41 + 1) USING foo");
                Table replaced = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
                Seq $org_scalatest_assert_macro_left = ((InMemoryTable)replaced).rows();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Replaced table should have no rows after committing.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)replaced.columns().length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Replaced table should have new schema.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
                Column actual = (Column)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])replaced.columns()));
                Column expected = Column.create((String)"id", (DataType)LongType$.MODULE$, (boolean)false, null, (ColumnDefaultValue)new ColumnDefaultValue("41 + 1", (Literal)new LiteralValue((Object)BoxesRunTime.boxToLong((long)42L), (DataType)LongType$.MODULE$)), null);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(actual);
                Column $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Replaced table should have new schema with DEFAULT column metadata.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
        this.test("ReplaceTableAsSelect: CREATE OR REPLACE new table has same behavior as CTAS.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)catalogName -> {
            this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + catalogName + ".created USING " + this.v2Source() + "\n           |AS SELECT id, data FROM source\n         ")));
            this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE OR REPLACE TABLE " + catalogName + ".replaced USING " + this.v2Source() + "\n           |AS SELECT id, data FROM source\n         ")));
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)catalogName)).asTableCatalog();
            Table createdTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"created"));
            Table replacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"replaced"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((InMemoryTable)createdTable).rows());
            Seq $org_scalatest_assert_macro_right = ((InMemoryTable)replacedTable).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(createdTable.schema());
            StructType $org_scalatest_assert_macro_right2 = replacedTable.schema();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table does not exist.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)catalog -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$72(this, catalog);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table is dropped before commit.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat_atomic.created USING " + this.v2Source() + " AS SELECT id, data FROM source");
            CannotReplaceMissingTableException x$88 = (CannotReplaceMissingTableException)this.intercept((Function0 & Serializable)() -> this.spark().sql("REPLACE TABLE testcat_atomic.replaced USING " + this.v2Source() + " TBLPROPERTIES (`" + InMemoryTableCatalog$.MODULE$.SIMULATE_DROP_BEFORE_REPLACE_PROPERTY() + "`=true) AS SELECT id, data FROM source"), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            String x$89 = "TABLE_OR_VIEW_NOT_FOUND";
            scala.collection.immutable.Map x$90 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`replaced`")}));
            Option x$91 = this.checkError$default$3();
            boolean x$92 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$93 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$88, "TABLE_OR_VIEW_NOT_FOUND", x$91, x$90, x$92, x$93);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("CreateTableAsSelect: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE table_name USING " + this.v2Source() + " AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            SparkContext qual$19 = this.spark().sparkContext();
            Seq x$94 = ((InMemoryTable)table).rows();
            int x$95 = qual$19.parallelize$default$2();
            RDD rdd = qual$19.parallelize(x$94, x$95, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$20 = this.spark();
                RDD x$96 = rdd;
                StructType x$97 = table.schema();
                boolean x$98 = qual$20.internalCreateDataFrame$default$3();
                return qual$20.internalCreateDataFrame(x$96, x$97, x$98);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
        this.test("CreateTableAsSelect: fail if table exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
            SparkContext qual$21 = this.spark().sparkContext();
            Seq x$99 = ((InMemoryTable)table).rows();
            int x$100 = qual$21.parallelize$default$2();
            RDD rdd = qual$21.parallelize(x$99, x$100, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$22 = this.spark();
                RDD x$101 = rdd;
                StructType x$102 = table.schema();
                boolean x$103 = qual$22.internalCreateDataFrame$default$3();
                return qual$22.internalCreateDataFrame(x$101, x$102, x$103);
            }, (Dataset<Row>)this.spark().table("source"));
            TableAlreadyExistsException x$104 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name USING bar AS SELECT id, data, id as id2 FROM source2"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
            String x$105 = "TABLE_OR_VIEW_ALREADY_EXISTS";
            scala.collection.immutable.Map x$106 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`table_name`")}));
            Option x$107 = this.checkError$default$3();
            boolean x$108 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$109 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$104, "TABLE_OR_VIEW_ALREADY_EXISTS", x$107, x$106, x$108, x$109);
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            Object $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left6), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            SparkContext qual$23 = this.spark().sparkContext();
            Seq x$110 = ((InMemoryTable)table).rows();
            int x$111 = qual$23.parallelize$default$2();
            RDD rdd2 = qual$23.parallelize(x$110, x$111, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$24 = this.spark();
                RDD x$112 = rdd2;
                StructType x$113 = table.schema();
                boolean x$114 = qual$24.internalCreateDataFrame$default$3();
                return qual$24.internalCreateDataFrame(x$112, x$113, x$114);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
        this.test("CreateTableAsSelect: if not exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            SparkContext qual$25 = this.spark().sparkContext();
            Seq x$115 = ((InMemoryTable)table).rows();
            int x$116 = qual$25.parallelize$default$2();
            RDD rdd = qual$25.parallelize(x$115, x$116, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$26 = this.spark();
                RDD x$117 = rdd;
                StructType x$118 = table.schema();
                boolean x$119 = qual$26.internalCreateDataFrame$default$3();
                return qual$26.internalCreateDataFrame(x$117, x$118, x$119);
            }, (Dataset<Row>)this.spark().table("source"));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source2");
            SparkContext qual$27 = this.spark().sparkContext();
            Seq x$120 = ((InMemoryTable)table).rows();
            int x$121 = qual$27.parallelize$default$2();
            RDD rdd2 = qual$27.parallelize(x$120, x$121, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$28 = this.spark();
                RDD x$122 = rdd2;
                StructType x$123 = table.schema();
                boolean x$124 = qual$28.internalCreateDataFrame$default$3();
                return qual$28.internalCreateDataFrame(x$122, x$123, x$124);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        this.test("CreateTableAsSelect: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator3$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.spark().sql("CREATE TABLE table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            SparkContext qual$29 = this.sparkContext();
            Seq x$125 = ((InMemoryTable)table).rows();
            int x$126 = qual$29.parallelize$default$2();
            RDD rdd = qual$29.parallelize(x$125, x$126, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> {
                SparkSession qual$30 = this.spark();
                RDD x$127 = rdd;
                StructType x$128 = table.schema();
                boolean x$129 = qual$30.internalCreateDataFrame$default$3();
                return qual$30.internalCreateDataFrame(x$127, x$128, x$129);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        this.test("CreateTableAsSelect: v2 session catalog can load v1 source table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Table t;
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator4$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.sql().apply((Object)"CREATE TABLE table_name USING parquet AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"TABLE default.table_name"), (Dataset<Row>)this.spark().table("source"));
            Table $org_scalatest_assert_macro_left = t = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.connector.catalog.V1Table", $org_scalatest_assert_macro_left instanceof V1Table, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"V1 table wasn't returned as an unresolved table", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        this.test("CreateTableAsSelect: nullable schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.registerCatalog("testcat_nullability", ReserveSchemaNullabilityCatalog.class);
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            TableCatalog reserveNullabilityCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_nullability")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            String reserveNullabilityIdentifier = "testcat_nullability.table_name";
            new .colon.colon((Object)new Tuple3((Object)basicCatalog, (Object)basicIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)atomicCatalog, (Object)atomicIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)reserveNullabilityCatalog, (Object)reserveNullabilityIdentifier, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$5 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$90(this, x0$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        this.ignore("CreateTableAsSelect: without USING clause", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 AS SELECT 1 i");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
            this.sql().apply((Object)"CREATE TABLE t2 AS SELECT 1 i");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
        this.test("SPARK-34039: ReplaceTable (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)t -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$96(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
        this.test("SPARK-33492: ReplaceTableAsSelect (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)t -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$102(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
        this.test("SPARK-33492: AppendData should refresh cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator14$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator14$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator14$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().saveAsTable(t);
                this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT i FROM " + t));
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator24$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator24$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator24$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode(SaveMode.Append).saveAsTable(t);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
                Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
                Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        this.test("SPARK-33492: OverwriteByExpression should refresh cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " USING foo AS SELECT id, data FROM source"));
                this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT id FROM " + t));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Dataset<Row>)this.spark().table("source").select("id", (Seq)Nil$.MODULE$));
                this.sql().apply((Object)("INSERT OVERWRITE TABLE " + t + " VALUES (1, 'a')"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        this.test("SPARK-33492: OverwritePartitionsDynamic should refresh cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator34$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator34$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator34$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).saveAsTable(t);
                this.sql().apply((Object)("CACHE TABLE " + view + " AS SELECT i FROM " + t));
                Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator44$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator44$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator44$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).writeTo(t).overwritePartitions();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
                Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3));
                Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + view)), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
        this.test("SPARK-34947: micro batch streaming write should invalidate cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns.t";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)checkpointDir -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$130(this, t, checkpointDir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
        this.test("Relation: basic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT id, data FROM source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("TABLE " + t1)), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT * FROM " + t1)), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971));
        this.test("Relation: SparkSession.table()", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT id, data FROM source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(String.valueOf(t1)), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
        this.test("Relation: CTE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT id, data FROM source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |WITH cte AS (SELECT * FROM " + t1 + ")\n          |SELECT * FROM cte\n        "))), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
        this.test("Relation: view text", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String v1 = "view1";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT id, data FROM source"));
                this.sql().apply((Object)("CREATE VIEW " + v1 + " AS SELECT * from " + t1));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("TABLE " + v1)), (Dataset<Row>)this.spark().table("source"));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        this.test("Relation: join tables in 2 catalogs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.v2tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT id, data FROM source"));
                this.sql().apply((Object)("CREATE TABLE " + t2 + " USING foo AS SELECT id, data FROM source2"));
                Dataset df1 = this.spark().table("source");
                Dataset df2 = this.spark().table("source2");
                Dataset df_joined = df1.join(df2).where(df1.apply("id").$plus((Object)BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)df2.apply("id")));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT *\n          |FROM " + t1 + " t1, " + t2 + " t2\n          |WHERE t1.id + 1 = t2.id\n        "))), (Dataset<Row>)df_joined);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
        this.test("qualified column names for v2 tables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, point struct<x: bigint, y: bigint>) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES (1, (10, 20))"));
                this.check$1(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$1("tbl");
                this.checkError((SparkThrowable)this.analysisException("SELECT ns1.ns2.ns3.tbl.id from " + t), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`ns1`.`ns2`.`ns3`.`tbl`.`id`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`testcat`.`ns1`.`ns2`.`tbl`.`id`, `testcat`.`ns1`.`ns2`.`tbl`.`point`")})), this.ExpectedContext().apply("ns1.ns2.ns3.tbl.id", 7, 24));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
        this.test("qualified column names for v1 tables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)useV1Table -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$156(this, BoxesRunTime.unboxToBoolean((Object)useV1Table));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
        this.test("InsertInto: append - across catalog", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.db.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT * FROM source"));
                this.sql().apply((Object)("CREATE TABLE " + t2 + " (id bigint, data string) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + t2 + " SELECT * FROM " + t1));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(t2), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1091));
        this.test("insertInto: append by name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (id bigint, data string) USING " + this.v2Format()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator59$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator59$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator59$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                this.sql().apply((Object)("INSERT INTO " + t1 + "(id, data) VALUES(1L, 'a')"));
                this.sql().apply((Object)("INSERT INTO " + t1 + "(data, id) VALUES('b', 2L)"));
                this.sql().apply((Object)("INSERT INTO " + t1 + "(data, id) VALUES('c', 3)"));
                this.verifyTable(t1, (Dataset<Row>)df);
                AnalysisException x$141 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT INTO " + t1 + " VALUES(4)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1116));
                String x$142 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$143 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`")}));
                Option x$144 = this.checkError$default$3();
                boolean x$145 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$146 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$141, "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", x$144, x$143, x$145, x$146);
                AnalysisException x$147 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT INTO " + t1 + "(data, data) VALUES(5)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
                String x$148 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$149 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$150 = this.checkError$default$3();
                boolean x$151 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$152 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$147, "COLUMN_ALREADY_EXISTS", x$150, x$149, x$151, x$152);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
        this.test("insertInto: overwrite by name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (id bigint, data string) USING " + this.v2Format()));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(id, data) VALUES(1L, 'a')"));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator69$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator69$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator69$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, id) VALUES('b', 2L)"));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator79$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator79$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator79$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, id) VALUES('c', 3)"));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator89$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator89$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator89$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
                AnalysisException x$153 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT OVERWRITE " + t1 + " VALUES(4)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
                String x$154 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$155 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`")}));
                Option x$156 = this.checkError$default$3();
                boolean x$157 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$158 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$153, "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", x$156, x$155, x$157, x$158);
                AnalysisException x$159 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, data) VALUES(5)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1163));
                String x$160 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$161 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$162 = this.checkError$default$3();
                boolean x$163 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$164 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$159, "COLUMN_ALREADY_EXISTS", x$162, x$161, x$163, x$164);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136));
        this.dynamicOverwriteTest("insertInto: dynamic overwrite by name", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (id bigint, data string, data2 string) USING " + this.v2Format() + " PARTITIONED BY (id)"));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(id, data, data2) VALUES(1L, 'a', 'b')"));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator99$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator99$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator99$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, data2, id) VALUES('b', 'd', 2L)"));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator109$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator109$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a", (Object)"b"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"d"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator109$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, data2, id) VALUES('c', 'e', 1)"));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator119$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator119$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.verifyTable(t1, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"c", (Object)"e"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b", (Object)"d"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator119$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data", "data2"})));
                AnalysisException x$165 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT OVERWRITE " + t1 + " VALUES('a', 4)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
                String x$166 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                scala.collection.immutable.Map x$167 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`id`, `data`, `data2`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`, `col2`")}));
                Option x$168 = this.checkError$default$3();
                boolean x$169 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$170 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$165, "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", x$168, x$167, x$169, x$170);
                AnalysisException x$171 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("INSERT OVERWRITE " + t1 + "(data, data) VALUES(5)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1199));
                String x$172 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$173 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$174 = this.checkError$default$3();
                boolean x$175 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$176 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$171, "COLUMN_ALREADY_EXISTS", x$174, x$173, x$175, x$176);
            });
        });
        this.test("insertInto: static partition column name should not be used in the column list", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)("CREATE TABLE t(i STRING, c string) USING " + this.v2Format() + " PARTITIONED BY (c)"));
            AnalysisException x$177 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='1') (c) VALUES ('2')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1211));
            String x$178 = "STATIC_PARTITION_COLUMN_IN_INSERT_COLUMN_LIST";
            scala.collection.immutable.Map x$179 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"staticName"), (Object)"c")}));
            Option x$180 = this.checkError$default$3();
            boolean x$181 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$182 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$177, "STATIC_PARTITION_COLUMN_IN_INSERT_COLUMN_LIST", x$180, x$179, x$181, x$182);
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1207));
        this.test("ShowViews: using v1 catalog, db name with multipartIdentifier ('a.b') is not allowed.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$183 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM a.b"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1221));
            String x$184 = "_LEGACY_ERROR_TEMP_1126";
            scala.collection.immutable.Map x$185 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), (Object)"a.b")}));
            Option x$186 = this.checkError$default$3();
            boolean x$187 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$188 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$183, "_LEGACY_ERROR_TEMP_1126", x$186, x$185, x$187, x$188);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1219));
        this.test("ShowViews: using v2 catalog, command not supported.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$189 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM testcat"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
            String x$190 = "_LEGACY_ERROR_TEMP_1184";
            scala.collection.immutable.Map x$191 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugin"), (Object)"testcat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ability"), (Object)"views")}));
            Option x$192 = this.checkError$default$3();
            boolean x$193 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$194 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$189, "_LEGACY_ERROR_TEMP_1184", x$192, x$191, x$193, x$194);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
        this.test("create/replace/alter table - reserved properties", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.immutable.Map keyParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"please use the USING clause to specify it"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)"please use the LOCATION clause to specify it"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)"it will be set to the current user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"external"), (Object)"please use CREATE EXTERNAL TABLE")}));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> ((IterableOnceOps)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$189(x$1)))).foreach((Function1 & Serializable)key -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$190(this, keyParameters, key);
                return BoxedUnit.UNIT;
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> ((IterableOnceOps)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$200(x$2)))).foreach((Function1 & Serializable)key -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$201(this, key);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
        this.test("create/replace - path property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)conf -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)conf)}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)action -> {
                Bool bool;
                String location;
                String sql1 = action + " TABLE testcat.reservedTest USING foo LOCATION 'foo' OPTIONS ('path'='bar')";
                $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329)), "_LEGACY_ERROR_TEMP_0032", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathOne"), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathTwo"), (Object)"bar")})), $this.ExpectedContext().apply(sql1, 0, 74 + action.length()));
                String sql2 = action + " TABLE testcat.reservedTest USING foo OPTIONS ('path'='foo', 'PaTh'='bar')";
                $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342)), "_LEGACY_ERROR_TEMP_0032", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathOne"), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathTwo"), (Object)"bar")})), $this.ExpectedContext().apply(sql2, 0, 73 + action.length()));
                $this.sql().apply((Object)(action + " TABLE testcat.reservedTest USING foo LOCATION 'foo' TBLPROPERTIES ('path'='bar', 'Path'='noop')"));
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left = location = (String)tableCatalog.loadTable(identifier).properties().get("location");
                String $org_scalatest_assert_macro_right = "file:";
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = location;
                    String $org_scalatest_assert_macro_right2 = "foo";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "endsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.endsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1358));
                String $org_scalatest_assert_macro_left4 = (String)tableCatalog.loadTable(identifier).properties().get("path");
                String $org_scalatest_assert_macro_right4 = "bar";
                String string = $org_scalatest_assert_macro_left4;
                String string2 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1360));
                String $org_scalatest_assert_macro_left5 = (String)tableCatalog.loadTable(identifier).properties().get("Path");
                String $org_scalatest_assert_macro_right5 = "noop";
                String string3 = $org_scalatest_assert_macro_left5;
                String string4 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1362));
            })));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1321));
        this.test("Use: basic tests with USE statements", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"default"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1385));
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns1_1.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns2.ns2_2.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns3.ns3_3.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.testcat.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.testcat.ns1.ns1_1.table (id bigint) USING foo");
            this.sql().apply((Object)"USE testcat.ns1.ns1_1");
            String $org_scalatest_assert_macro_left3 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right3 = "testcat";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1396));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right4 = (String[])((Object[])new String[]{"ns1", "ns1_1"});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
            this.sql().apply((Object)"USE testcat2.ns2.ns2_2");
            String $org_scalatest_assert_macro_left5 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right5 = "testcat2";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1401));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right6 = (String[])((Object[])new String[]{"ns2", "ns2_2"});
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
            this.sql().apply((Object)"USE ns3.ns3_3");
            String $org_scalatest_assert_macro_left7 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right7 = "testcat2";
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1406));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right8 = (String[])((Object[])new String[]{"ns3", "ns3_3"});
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
            this.sql().apply((Object)"USE NAMESPACE testcat");
            String $org_scalatest_assert_macro_left9 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right9 = "testcat2";
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right10 = (String[])((Object[])new String[]{"testcat"});
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
            this.sql().apply((Object)"USE NAMESPACE testcat.ns1.ns1_1");
            String $org_scalatest_assert_macro_left11 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right11 = "testcat2";
            String string11 = $org_scalatest_assert_macro_left11;
            String string12 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1416));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right12 = (String[])((Object[])new String[]{"testcat", "ns1", "ns1_1"});
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left13 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right13 = "testcat";
            String string13 = $org_scalatest_assert_macro_left13;
            String string14 = $org_scalatest_assert_macro_right13;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1421));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(catalogManager.currentNamespace());
            Object[] $org_scalatest_assert_macro_right14 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1380));
        this.test("Use: set v2 catalog as a current catalog", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left2 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right2 = "testcat";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1430));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1425));
        this.test("Use: v2 session catalog is used and namespace does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            NoSuchDatabaseException exception;
            NoSuchDatabaseException x$195 = exception = (NoSuchDatabaseException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"USE ns1"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1434));
            String x$196 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$197 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`ns1`")}));
            Option x$198 = this.checkError$default$3();
            boolean x$199 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$200 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$195, "SCHEMA_NOT_FOUND", x$198, x$197, x$199, x$200);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1433));
        this.test("SPARK-31100: Use: v2 catalog that implements SupportsNamespaces is used and namespace not exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            NoSuchNamespaceException exception;
            NoSuchNamespaceException x$201 = exception = (NoSuchNamespaceException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"USE testcat.ns1.ns2"), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1445));
            String x$202 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$203 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`ns1`.`ns2`")}));
            Option x$204 = this.checkError$default$3();
            boolean x$205 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$206 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$201, "SCHEMA_NOT_FOUND", x$204, x$203, x$205, x$206);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1443));
        this.test("SPARK-31100: Use: v2 catalog that does not implement SupportsNameSpaces is used and namespace does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (Function0 & Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            this.sql().apply((Object)"USE dummy.ns1");
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = "dummy";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1461));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"ns1"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1462));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1454));
        this.test("SPARK-42684: Column default value only allowed with TableCatalogs that SUPPORT_COLUMN_DEFAULT_VALUE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = tblName + "(c1 INT, c2 INT DEFAULT 0)";
            new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)statement -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$222(this, tblName, tableDefinition, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1467));
        this.test("SPARK-41290: Generated columns only allowed with TableCatalogs that SUPPORTS_CREATE_TABLE_WITH_GENERATED_COLUMNS", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = tblName + "(eventDate DATE, eventYear INT GENERATED ALWAYS AS (year(eventDate)))";
            new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)statement -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$227(this, tblName, tableDefinition, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1499));
        this.test("SPARK-41290: Column cannot have both a generation expression and a default value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "my_tab";
            String tableDefinition = tblName + "(eventDate DATE, eventYear INT GENERATED ALWAYS AS (year(eventDate)) DEFAULT 0)";
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)"foo")}), (JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CREATE TABLE", (List)new .colon.colon((Object)"REPLACE TABLE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)statement -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String string = statement;
                    String string2 = "REPLACE TABLE";
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) ? $this.sql().apply((Object)("CREATE TABLE testcat." + tblName$3 + "(a INT) USING foo")) : BoxedUnit.UNIT;
                    AnalysisException x$219 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)(statement + " testcat." + tableDefinition$3 + " USING foo")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1541));
                    String x$220 = "GENERATED_COLUMN_WITH_DEFAULT_VALUE";
                    scala.collection.immutable.Map x$221 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"eventYear"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"genExpr"), (Object)"year(eventDate)")}));
                    Option x$222 = $this.checkError$default$3();
                    boolean x$223 = $this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$224 = $this.checkError$default$6();
                    $this.checkError((SparkThrowable)x$219, "GENERATED_COLUMN_WITH_DEFAULT_VALUE", x$222, x$221, x$223, x$224);
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1530));
        this.test("SPARK-41290: Generated column expression must be valid generation expression", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "my_tab";
            this.checkUnsupportedGenerationExpression$1("not_a_function(a)", "failed to resolve `not_a_function` to a built-in function", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.spark().udf().register("timesTwo", (Function1)(JFunction1.mcII.sp & Serializable)x -> x * 2, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
            this.checkUnsupportedGenerationExpression$1("timesTwo(a)", "failed to resolve `timesTwo` to a built-in function", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("b + 1", "generation expression cannot reference itself", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> this.checkUnsupportedGenerationExpression$1("B + 1", "generation expression cannot reference itself", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (B + 1)) USING foo")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1608)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`B`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`a`")})), this.ExpectedContext().apply("B", 0, 0))));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (B + 1), B INT) USING foo"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1623));
            }));
            String x$225 = "c + 1";
            String x$226 = "generation expression cannot reference another generated column";
            Some x$227 = new Some((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (c + 1), c INT GENERATED ALWAYS AS (a + 1)) USING foo"));
            String x$228 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
            this.checkUnsupportedGenerationExpression$1("c + 1", "generation expression cannot reference another generated column", x$228, (Option)x$227, tblName);
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (JFunction0.mcV.sp & Serializable)() -> {
                String x$229 = "C + 1";
                String x$230 = "generation expression cannot reference another generated column";
                Some x$231 = new Some((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (C + 1), c INT GENERATED ALWAYS AS (a + 1)) USING foo"));
                String x$232 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
                this.checkUnsupportedGenerationExpression$1("C + 1", "generation expression cannot reference another generated column", x$232, (Option)x$231, tblName);
                String x$233 = "c + 1";
                String x$234 = "generation expression cannot reference another generated column";
                Some x$235 = new Some((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (c + 1), C INT GENERATED ALWAYS AS (a + 1)) USING foo"));
                String x$236 = DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1();
                this.checkUnsupportedGenerationExpression$1("c + 1", "generation expression cannot reference another generated column", x$236, (Option)x$235, tblName);
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE testcat." + tblName + "(a INT, A INT GENERATED ALWAYS AS (a + 1), b INT GENERATED ALWAYS AS (a + 1)) USING foo"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1660));
            }));
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE TABLE testcat." + tblName + "(a INT, b INT GENERATED ALWAYS AS (c + 1)) USING foo")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1667)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`a`")})), this.ExpectedContext().apply("c", 0, 0)));
            this.checkUnsupportedGenerationExpression$1("rand()", "generation expression is not deterministic", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("a + 1", "generation expression data type int is incompatible with column data type boolean", "BOOLEAN", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE testcat." + tblName + "(a INT, b LONG GENERATED ALWAYS AS (a + 1)) USING foo"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1691));
            });
            this.checkUnsupportedGenerationExpression$1("(SELECT 1)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("(SELECT (SELECT 2) + 1)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.checkUnsupportedGenerationExpression$1("(SELECT 1) + a", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"other"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"create table other(x INT) using parquet");
                this.checkUnsupportedGenerationExpression$1("(select min(x) from other)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
            });
            this.checkUnsupportedGenerationExpression$1("(select min(x) from faketable)", "subquery expressions are not allowed for generated columns", DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$3$1(), DataSourceV2SQLSuiteV1Filter.checkUnsupportedGenerationExpression$default$4$1(), tblName);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1555));
        this.test("SPARK-44313: generation expression validation passes when there is a char/varchar column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "my_tab";
            new .colon.colon((Object)"name VARCHAR(64)", (List)new .colon.colon((Object)"name CHAR(64)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)charVarCharCol -> {
                this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat." + tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE testcat." + tblName$5 + "(\n             |  " + charVarCharCol + ",\n             |  tstamp TIMESTAMP,\n             |  tstamp_date DATE GENERATED ALWAYS AS (CAST(tstamp AS DATE))\n             |) USING foo\n             |")));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog().tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)tblName$5)), "org.apache.spark.sql.connector.catalog.CatalogV2Implicits.CatalogHelper(DataSourceV2SQLSuiteV1Filter.this.catalog(\"testcat\")).asTableCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), tblName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1733));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1720));
        this.test("SPARK-46972: asymmetrical replacement for char/varchar in V2SessionCatalog.createTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)("CREATE TABLE t(c char(1), v varchar(2)) USING " + this.v2Source())));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1738));
        this.test("ShowCurrentNamespace: basic tests", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.testShowCurrentNamespace$1("spark_catalog", "default");
            this.sql().apply((Object)"USE testcat");
            this.testShowCurrentNamespace$1("testcat", "");
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.testShowCurrentNamespace$1("testcat", "ns1.ns2");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1746));
        this.test("tableCreation: partition column case insensitive resolution", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog sessionCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            this.sql().apply((Object)("CREATE TABLE tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (A)"));
            this.checkPartitioning$1(sessionCatalog, "a");
            this.sql().apply((Object)("CREATE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (A)"));
            this.checkPartitioning$1(testCatalog, "a");
            this.sql().apply((Object)("CREATE OR REPLACE TABLE tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (B)"));
            this.checkPartitioning$1(sessionCatalog, "b");
            this.sql().apply((Object)("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (B)"));
            this.checkPartitioning$1(testCatalog, "b");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1771));
        this.test("tableCreation: partition column case sensitive resolution", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkFailure$1("CREATE TABLE tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (A)", "A");
            this.checkFailure$1("CREATE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (A)", "A");
            this.checkFailure$1("CREATE OR REPLACE TABLE tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (B)", "B");
            this.checkFailure$1("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " PARTITIONED BY (B)", "B");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1798));
        this.test("tableCreation: duplicate column names in the table definition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the table definition of";
            new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$6 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$269(this, x0$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1826));
        this.test("tableCreation: duplicate nested column names in the table definition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$7 -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$272(this, x0$7);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
        this.test("tableCreation: bucket column names not in table definition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$285 = this.analysisException("CREATE TABLE tbl (a int, b string) USING " + this.v2Source() + " CLUSTERED BY (c) INTO 4 BUCKETS");
            String x$286 = "_LEGACY_ERROR_TEMP_3060";
            scala.collection.immutable.Map x$287 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n            | |-- a: integer (nullable = true)\n            | |-- b: string (nullable = true)\n            |")))}));
            Option x$288 = this.checkError$default$3();
            boolean x$289 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$290 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$285, "_LEGACY_ERROR_TEMP_3060", x$288, x$287, x$289, x$290);
            AnalysisException x$291 = this.analysisException("CREATE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " CLUSTERED BY (c) INTO 4 BUCKETS");
            String x$292 = "_LEGACY_ERROR_TEMP_3060";
            scala.collection.immutable.Map x$293 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n            | |-- a: integer (nullable = true)\n            | |-- b: string (nullable = true)\n            |")))}));
            Option x$294 = this.checkError$default$3();
            boolean x$295 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$296 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$291, "_LEGACY_ERROR_TEMP_3060", x$294, x$293, x$295, x$296);
            AnalysisException x$297 = this.analysisException("CREATE OR REPLACE TABLE tbl (a int, b string) USING " + this.v2Source() + " CLUSTERED BY (c) INTO 4 BUCKETS");
            String x$298 = "_LEGACY_ERROR_TEMP_3060";
            scala.collection.immutable.Map x$299 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n            | |-- a: integer (nullable = true)\n            | |-- b: string (nullable = true)\n            |")))}));
            Option x$300 = this.checkError$default$3();
            boolean x$301 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$302 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$297, "_LEGACY_ERROR_TEMP_3060", x$300, x$299, x$301, x$302);
            AnalysisException x$303 = this.analysisException("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING " + this.v2Source() + " CLUSTERED BY (c) INTO 4 BUCKETS");
            String x$304 = "_LEGACY_ERROR_TEMP_3060";
            scala.collection.immutable.Map x$305 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n            | |-- a: integer (nullable = true)\n            | |-- b: string (nullable = true)\n            |")))}));
            Option x$306 = this.checkError$default$3();
            boolean x$307 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$308 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$303, "_LEGACY_ERROR_TEMP_3060", x$306, x$305, x$307, x$308);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1881));
        this.test("tableCreation: bucket column name containing dot", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            NamedReference[] references;
            Bool bool;
            Transform[] partitioning;
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE testcat.t (id int, `a.b` string) USING foo\n          |CLUSTERED BY (`a.b`) INTO 4 BUCKETS\n        ")));
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)"t"));
            Transform[] $org_scalatest_assert_macro_left = partitioning = table.partitioning();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                String $org_scalatest_assert_macro_left3 = ((Transform)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])partitioning))).name();
                String $org_scalatest_assert_macro_right2 = "bucket";
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1939));
            NamedReference[] $org_scalatest_assert_macro_left4 = references = ((Expression)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])partitioning))).references();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1941));
            Seq $org_scalatest_assert_macro_left5 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])references))).fieldNames()));
            .colon.colon $org_scalatest_assert_macro_right5 = new .colon.colon((Object)"a.b", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left5;
            .colon.colon colon2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1942));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1928));
        this.test("tableCreation: column repeated in partition columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$8 -> {
            DataSourceV2SQLSuiteV1Filter.$anonfun$new$279(this, x0$8);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1946));
        this.test("tableCreation: column repeated in bucket columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the bucket definition";
            new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$9 -> {
                DataSourceV2SQLSuiteV1Filter.$anonfun$new$282(this, x0$9);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1974));
        this.test("create table using - with sorted bucket", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String identifier = "testcat.table_name";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{identifier}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + identifier + " (a int, b string, c int, d int, e int, f int) USING " + this.v2Source() + " PARTITIONED BY (a, b) CLUSTERED BY (c, d) SORTED by (e, f) INTO 4 BUCKETS"));
                Dataset describe = this.spark().sql("DESCRIBE " + identifier);
                String part1 = ((Row)describe.filter("col_name = 'Part 0'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part1);
                String $org_scalatest_assert_macro_right = "a";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2016));
                String part2 = ((Row)describe.filter("col_name = 'Part 1'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part2);
                String $org_scalatest_assert_macro_right2 = "b";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2020));
                String part3 = ((Row)describe.filter("col_name = 'Part 2'").select("data_type", (Seq)Nil$.MODULE$).head()).getString(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(part3);
                String $org_scalatest_assert_macro_right3 = "sorted_bucket(c, d, 4, e, f)";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2024));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2007));
        this.test("REFRESH TABLE: v2 table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) USING foo"));
                InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2036));
                this.sql().apply((Object)("REFRESH TABLE " + t));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2038));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2028));
        this.test("SPARK-32990: REFRESH TABLE should resolve to a temporary view first", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2");
            this.sql().apply((Object)"USE testcat.ns");
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"t");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2052));
            this.sql().apply((Object)"REFRESH TABLE t");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2054));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2042));
        this.test("SPARK-33435, SPARK-34099: REFRESH TABLE should refresh all caches referencing the table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tblName + " (id bigint) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + tblName + " SELECT 0"));
                this.sql().apply((Object)("CACHE TABLE t AS SELECT id FROM " + tblName));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(tblName), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.sql().apply((Object)("INSERT INTO " + tblName + " SELECT 1"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2071));
                this.sql().apply((Object)("REFRESH TABLE " + tblName));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2073));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(tblName), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("t"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2059));
        this.test("SPARK-33653: REFRESH TABLE should recache the target table itself", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tblName + " (id bigint) USING foo"));
                Option $org_scalatest_assert_macro_left = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2086));
                this.sql().apply((Object)("REFRESH TABLE " + tblName));
                Option $org_scalatest_assert_macro_left2 = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2088));
                this.sql().apply((Object)("CACHE TABLE " + tblName));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2093));
                this.sql().apply((Object)("REFRESH TABLE " + tblName));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuiteV1Filter.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuiteV1Filter.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2095));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2080));
        this.test("REPLACE TABLE: v1 table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE OR REPLACE TABLE tbl (a int) USING " + SimpleScanSource.class.getName())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2100));
            this.checkError((SparkThrowable)e, "UNSUPPORTED_FEATURE.TABLE_OPERATION", "0A000", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"REPLACE TABLE")})));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2099));
        this.test("DeleteFrom: - delete with invalid predicate", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)"));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)"));
                AnalysisException x$357 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("DELETE FROM " + t + " WHERE id = 2 AND id = id")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2117));
                String x$358 = "_LEGACY_ERROR_TEMP_1110";
                scala.collection.immutable.Map x$359 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)"testcat.ns1.ns2.tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filters"), (Object)"[id = 2, id = id]")}));
                Option x$360 = this.checkError$default$3();
                boolean x$361 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$362 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$357, "_LEGACY_ERROR_TEMP_1110", x$360, x$359, x$361, x$362);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2124));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2111));
        this.test("UPDATE TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + t + " (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ")));
                this.checkError((SparkThrowable)this.analysisException("UPDATE dummy SET name='abc'"), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`dummy`")})), this.ExpectedContext().apply("dummy", 7, 11));
                this.checkError((SparkThrowable)this.analysisException("UPDATE " + t + " SET dummy='abc'"), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), this.ExpectedContext().apply("dummy='abc'", 31, 41));
                this.checkError((SparkThrowable)this.analysisException("UPDATE " + t + " SET name='abc' WHERE dummy=1"), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), this.ExpectedContext().apply("dummy", 48, 52));
                SparkUnsupportedOperationException x$363 = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("UPDATE " + t + " SET name='Robert', age=32 WHERE p=1")), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2174));
                String x$364 = "_LEGACY_ERROR_TEMP_2096";
                scala.collection.immutable.Map x$365 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ddl"), (Object)"UPDATE TABLE")}));
                Option x$366 = this.checkError$default$3();
                boolean x$367 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$368 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$363, "_LEGACY_ERROR_TEMP_2096", x$366, x$365, x$367, x$368);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2128));
        this.test("MERGE INTO TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String target = "testcat.ns1.ns2.target";
            String source = "testcat.ns1.ns2.source";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{target, source}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + target + " (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ")));
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + source + " (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ")));
                this.checkError((SparkThrowable)this.analysisException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |MERGE INTO testcat.ns1.ns2.dummy AS target\n             |USING testcat.ns1.ns2.source AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *\n           "))), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`ns1`.`ns2`.`dummy`")})), this.ExpectedContext().apply("testcat.ns1.ns2.dummy", 12, 32));
                this.checkError((SparkThrowable)this.analysisException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |MERGE INTO testcat.ns1.ns2.target AS target\n             |USING testcat.ns1.ns2.dummy AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *\n           "))), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`ns1`.`ns2`.`dummy`")})), this.ExpectedContext().apply("testcat.ns1.ns2.dummy", 51, 71));
                String sql1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n           |USING testcat.ns1.ns2.source AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.dummy = source.age\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *"));
                this.checkError((SparkThrowable)this.analysisException(sql1), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`target`.`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `id`, `name`, `p`")})), this.ExpectedContext().apply("target.dummy = source.age", 206, 230));
                this.checkError((SparkThrowable)this.analysisException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n             |USING testcat.ns1.ns2.source AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.age < 10) THEN DELETE\n             |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.age = source.dummy\n             |WHEN NOT MATCHED AND (target.col2='insert')\n             |THEN INSERT *"))), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`source`.`dummy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`age`, `age`, `id`, `id`, `name`, `name`, `p`, `p`")})), this.ExpectedContext().apply("source.dummy", 219, 230));
                SparkUnsupportedOperationException x$369 = (SparkUnsupportedOperationException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MERGE INTO testcat.ns1.ns2.target AS target\n               |USING testcat.ns1.ns2.source AS source\n               |ON target.id = source.id\n               |WHEN MATCHED AND (target.p < 0) THEN DELETE\n               |WHEN MATCHED AND (target.p > 0) THEN UPDATE SET *\n               |WHEN NOT MATCHED THEN INSERT *"))), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2274));
                String x$370 = "_LEGACY_ERROR_TEMP_2096";
                scala.collection.immutable.Map x$371 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ddl"), (Object)"MERGE INTO TABLE")}));
                Option x$372 = this.checkError$default$3();
                boolean x$373 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$374 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$369, "_LEGACY_ERROR_TEMP_2096", x$372, x$371, x$373, x$374);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2183));
        this.test("rename table by ALTER VIEW", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.new"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.old USING foo AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "old", BoxesRunTime.boxToBoolean((boolean)false)})), (List)Nil$.MODULE$));
            AnalysisException x$375 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns1.ns2.old RENAME TO ns1.new"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2293));
            String x$376 = "_LEGACY_ERROR_TEMP_1123";
            scala.collection.immutable.Map x$377 = Predef$.MODULE$.Map().empty();
            Option x$378 = this.checkError$default$3();
            boolean x$379 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$380 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$375, "_LEGACY_ERROR_TEMP_1123", x$378, x$377, x$379, x$380);
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2288));
        this.test("AlterTable: renaming views are not supported", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns.tbl RENAME TO ns.view"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2302));
            this.checkErrorTableNotFound((SparkThrowable)e, "`testcat`.`ns`.`tbl`", this.ExpectedContext().apply("testcat.ns.tbl", 11, 10 + "testcat.ns.tbl".length()));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2301));
        this.test("ANALYZE TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo");
                this.testNotSupportedV2Command("ANALYZE TABLE", t + " COMPUTE STATISTICS", this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("ANALYZE TABLE", t + " COMPUTE STATISTICS FOR ALL COLUMNS", this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2309));
        this.test("MSCK REPAIR TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo");
                this.testNotSupportedV2Command("MSCK REPAIR TABLE", t, this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2318));
        this.test("LOAD DATA INTO TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + t + " (id bigint, data string)\n           |USING foo\n           |PARTITIONED BY (id)\n         ")));
                this.testNotSupportedV2Command("LOAD DATA", "INPATH 'filepath' INTO TABLE " + t, this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", "LOCAL INPATH 'filepath' INTO TABLE " + t, this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", "LOCAL INPATH 'filepath' OVERWRITE INTO TABLE " + t, this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("LOAD DATA", "LOCAL INPATH 'filepath' OVERWRITE INTO TABLE " + t + " PARTITION(id=1)", this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2326));
        this.test("CACHE/UNCACHE TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo");
                this.sql().apply((Object)("CACHE TABLE " + t));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2353));
                this.sql().apply((Object)("UNCACHE TABLE " + t));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2356));
            });
            AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("UNCACHE TABLE " + t)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2360));
            this.checkErrorTableNotFound((SparkThrowable)e, "`testcat`.`ns1`.`ns2`.`tbl`", this.ExpectedContext().apply(t, 14, 13 + t.length()));
            return (Dataset)this.sql().apply((Object)("UNCACHE TABLE IF EXISTS " + t));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2344));
        this.test("SHOW COLUMNS", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo");
                this.testNotSupportedV2Command("SHOW COLUMNS", "FROM " + t, this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("SHOW COLUMNS", "IN " + t, this.testNotSupportedV2Command$default$3());
                this.testNotSupportedV2Command("SHOW COLUMNS", "FROM tbl IN testcat.ns1.ns2", this.testNotSupportedV2Command$default$3());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2370));
        this.test("ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo");
                this.testNotSupportedV2Command("ALTER TABLE", t + " SET SERDE 'test_serde'", (Option<String>)new Some((Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]"));
                this.testNotSupportedV2Command("ALTER TABLE", t + " SET SERDEPROPERTIES ('a' = 'b')", (Option<String>)new Some((Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2381));
        this.test("CREATE VIEW", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String v = "testcat.ns1.ns2.v";
            AnalysisException x$381 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE VIEW " + v + " AS SELECT 1")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2398));
            String x$382 = "_LEGACY_ERROR_TEMP_1184";
            scala.collection.immutable.Map x$383 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugin"), (Object)"testcat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ability"), (Object)"views")}));
            Option x$384 = this.checkError$default$3();
            boolean x$385 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$386 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$381, "_LEGACY_ERROR_TEMP_1184", x$384, x$383, x$385, x$386);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2395));
        this.test("global temp view should not be masked by v2 catalog", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Object object;
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            try {
                this.sql().apply((Object)"create global temp view v as select 1");
                this.sql().apply((Object)("alter view " + globalTempDB + ".v rename to v2"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(globalTempDB + ".v2"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                object = this.sql().apply((Object)("drop view " + globalTempDB + ".v2"));
            }
            finally {
                this.spark().sharedState().globalTempViewManager().clear();
            }
            return object;
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2405));
        this.test("SPARK-30104: global temp db is used as a table name under v2 catalog", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            String t = "testcat." + globalTempDB;
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string) USING foo"));
                this.sql().apply((Object)"USE testcat");
                this.sql().apply((Object)("DESCRIBE TABLE " + globalTempDB));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2419));
        this.test("SPARK-30104: v2 catalog named global_temp will be masked", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            AnalysisException x$387 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE TABLE " + globalTempDB + ".ns1.ns2.tbl (id bigint, data string) USING json")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2434));
            String x$388 = "REQUIRES_SINGLE_PART_NAMESPACE";
            scala.collection.immutable.Map x$389 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionCatalog"), (Object)"spark_catalog"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)"`global_temp`.`ns1`.`ns2`")}));
            Option x$390 = this.checkError$default$3();
            boolean x$391 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$392 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$387, "REQUIRES_SINGLE_PART_NAMESPACE", x$390, x$389, x$391, x$392);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2430));
        this.test("table name same as catalog can be used", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.testcat"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.testcat (id bigint, data string) USING foo");
            this.sql().apply((Object)"USE testcat");
            this.sql().apply((Object)"DESCRIBE TABLE testcat");
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2445));
        this.test("SPARK-30001: session catalog name can be specified in SQL statements", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"select * from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2454));
        this.test("SPARK-30885: v1 table name should be fully qualified", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertWrongTableIdent$1();
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.assertWrongTableIdent$1();
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2465));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE AS SELECT command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl USING json AS SELECT 1 AS i");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2508));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2504));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl (col string) USING json");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2516));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2512));
        this.test("SPARK-30094: current namespace is used during table resolution", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.default.t", "testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING parquet AS SELECT 1");
                this.sql().apply((Object)"CREATE TABLE testcat.ns.t USING parquet AS SELECT 2");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.sql().apply((Object)"USE testcat.ns");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2520));
        this.test("SPARK-30284: CREATE VIEW should track the current catalog and namespace", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String sessionCatalogName = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.sql().apply((Object)"CREATE TABLE t USING foo AS SELECT 1 col");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).createTempView("t");
                this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sessionCatalogName + ".default.v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$393 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("CREATE VIEW " + sessionCatalogName + ".default.v AS SELECT * FROM t")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2549));
                    String x$394 = "INVALID_TEMP_OBJ_REFERENCE";
                    scala.collection.immutable.Map x$395 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)"`spark_catalog`.`default`.`v`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)"`t`")}));
                    Option x$396 = this.checkError$default$3();
                    boolean x$397 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$398 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$393, "INVALID_TEMP_OBJ_REFERENCE", x$396, x$395, x$397, x$398);
                });
            });
            this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sessionCatalogName + ".default.v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE VIEW " + sessionCatalogName + ".default.v AS SELECT t1.col FROM t t1 JOIN ns1.ns2.t t2"));
                this.sql().apply((Object)("USE " + sessionCatalogName));
                this.spark().range(10L).createTempView("t");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("v"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2535));
        this.test("COMMENT ON NAMESPACE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.sql().apply((Object)"CREATE NAMESPACE ns");
            this.checkNamespaceComment("ns", "minor revision");
            this.checkNamespaceComment("ns", null);
            this.checkNamespaceComment("ns", "NULL");
            AnalysisException x$399 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2583));
            String x$400 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$401 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`abc`")}));
            Option x$402 = this.checkError$default$3();
            boolean x$403 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$404 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$399, "SCHEMA_NOT_FOUND", x$402, x$401, x$403, x$404);
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1");
            this.checkNamespaceComment("testcat.ns1", "minor revision");
            this.checkNamespaceComment("testcat.ns1", null);
            this.checkNamespaceComment("testcat.ns1", "NULL");
            AnalysisException x$405 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE testcat.abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2593));
            String x$406 = "SCHEMA_NOT_FOUND";
            scala.collection.immutable.Map x$407 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)"`abc`")}));
            Option x$408 = this.checkError$default$3();
            boolean x$409 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$410 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$405, "SCHEMA_NOT_FOUND", x$408, x$407, x$409, x$410);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2573));
        this.test("COMMENT ON TABLE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t(k int) USING json");
                this.checkTableComment("t", "minor revision");
                this.checkTableComment("t", null);
                this.checkTableComment("t", "NULL");
            });
            String sql1 = "COMMENT ON TABLE abc IS NULL";
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2619)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`abc`")})), this.ExpectedContext().apply("abc", 17, 19));
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.t(k int) USING foo");
                this.checkTableComment("testcat.ns1.ns2.t", "minor revision");
                this.checkTableComment("testcat.ns1.ns2.t", null);
                this.checkTableComment("testcat.ns1.ns2.t", "NULL");
            });
            String sql2 = "COMMENT ON TABLE testcat.abc IS NULL";
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2633)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`testcat`.`abc`")})), this.ExpectedContext().apply("testcat.abc", 17, 27));
            String globalTempDB = (String)this.spark().conf().get(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.registerCatalog(globalTempDB, InMemoryTableCatalog.class);
            this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"create global temp view v as select 1");
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON TABLE global_temp.v IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2643)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`global_temp`.`v`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"COMMENT ON TABLE")})), this.ExpectedContext().apply("global_temp.v", 17, 29));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2607));
        this.test("SPARK-31015: star expression should work for qualified column names for v2 tables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, name string) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES (1, 'hello')"));
                this.check$2(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$2("tbl");
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT ns1.ns2.ns3.tbl.* from " + t)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2681)), "CANNOT_RESOLVE_STAR_EXPAND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetString"), (Object)"`ns1`.`ns2`.`ns3`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columns"), (Object)"`id`, `name`")})), this.ExpectedContext().apply("ns1.ns2.ns3.tbl.*", 7, 23));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2660));
        this.test("SPARK-32168: INSERT OVERWRITE - hidden days partition - dynamic mode", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARTITION_OVERWRITE_MODE().key()), (Object)SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC().toString())}), (JFunction0.mcV.sp & Serializable)() -> {
            String t1 = this.catalogAndNamespace() + "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(3), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator120$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                df.createOrReplaceTempView("source_view");
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (ts timestamp, data string) USING " + this.v2Format() + " PARTITIONED BY (days(ts))"));
                this.sql().apply((Object)("INSERT INTO " + t1 + " VALUES (CAST(date_add('2020-01-01', 2) AS timestamp), 'dummy'), (CAST(date_add('2020-01-01', 4) AS timestamp), 'keep')"));
                this.sql().apply((Object)("INSERT OVERWRITE TABLE " + t1 + " SELECT ts, data FROM source_view"));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                Dataset expected = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(3), (Object)"c"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuiteV1Filter.testTimestamp$1(4), (Object)"keep"), (List)Nil$.MODULE$)))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator121$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                this.verifyTable(t1, (Dataset<Row>)expected);
            });
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2692));
        this.test("SPARK-33505: insert into partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE " + t + " (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)")));
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                InternalRow expectedPartitionIdent = InternalRow$.MODULE$.fromSeq((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2734));
                this.sql().apply((Object)("INSERT INTO " + t + " PARTITION(id = 1, city = 'NY') SELECT 'abc'"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2736));
                this.sql().apply((Object)("INSERT INTO " + t + " PARTITION(id = 1, city = 'NY') SELECT 'def'"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2739));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2724));
        this.test("View commands are not supported in v2 catalogs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.validateViewCommand$1("DROP VIEW testcat.v");
            this.validateViewCommand$1("ALTER VIEW testcat.v SET TBLPROPERTIES ('key' = 'val')");
            this.validateViewCommand$1("ALTER VIEW testcat.v UNSET TBLPROPERTIES ('key')");
            this.validateViewCommand$1("ALTER VIEW testcat.v AS SELECT 1");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2743));
        this.test("SPARK-33924: INSERT INTO .. PARTITION preserves the partition location", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE " + t + " (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)")));
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                String loc = "partition_location";
                this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (id = 1, city = 'NY') LOCATION '" + loc + "'"));
                InternalRow ident = InternalRow$.MODULE$.fromSeq((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right = loc;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2772));
                this.sql().apply((Object)("INSERT INTO " + t + " PARTITION(id = 1, city = 'NY') SELECT 'abc'"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right2 = loc;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2775));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2758));
        this.test("SPARK-34468: rename table in place when the destination name has single part", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = this.catalogAndNamespace() + "src_tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tbl + " (c0 INT) USING " + this.v2Format()));
                this.sql().apply((Object)("INSERT INTO " + tbl + " SELECT 0"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), (Seq<Row>)Nil$.MODULE$);
                this.sql().apply((Object)("ALTER TABLE " + tbl + " RENAME TO new_tbl"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "new_tbl", BoxesRunTime.boxToBoolean((boolean)false)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)("SELECT c0 FROM " + this.catalogAndNamespace() + "new_tbl")), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2779));
        this.test("SPARK-36481: Test for SET CATALOG statement", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2795));
            this.sql().apply((Object)"SET CATALOG testcat");
            String $org_scalatest_assert_macro_left2 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right2 = "testcat";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2798));
            this.sql().apply((Object)"SET CATALOG testcat2");
            String $org_scalatest_assert_macro_left3 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right3 = "testcat2";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2801));
            CatalogNotFoundException x$411 = (CatalogNotFoundException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SET CATALOG not_exist_catalog"), ClassTag$.MODULE$.apply(CatalogNotFoundException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2804));
            String x$412 = "CATALOG_NOT_FOUND";
            scala.collection.immutable.Map x$413 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogName"), (Object)"`not_exist_catalog`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.catalog.not_exist_catalog\"")}));
            Option x$414 = this.checkError$default$3();
            boolean x$415 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$416 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$411, "CATALOG_NOT_FOUND", x$414, x$413, x$415, x$416);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2793));
        this.test("SPARK-35973: ShowCatalogs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("catalog", (DataType)StringType$.MODULE$, false);
            Dataset df = (Dataset)this.sql().apply((Object)"SHOW CATALOGS");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = schema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2818));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"spark_catalog"}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2819));
            this.sql().apply((Object)"use testcat");
            this.sql().apply((Object)"use testpart");
            this.sql().apply((Object)"use testcat2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS")).collect());
            Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"spark_catalog"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testpart"}))});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2824));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS LIKE 'test*'")).collect());
            Row[] $org_scalatest_assert_macro_right4 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testpart"}))});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2827));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((Dataset)this.sql().apply((Object)"SHOW CATALOGS LIKE 'testcat*'")).collect());
            Row[] $org_scalatest_assert_macro_right5 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"testcat2"}))});
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2830));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2813));
        this.test("CREATE INDEX should fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint, data string COMMENT 'hello') USING foo"));
                String sql1 = "CREATE index i1 ON " + t + "(non_exist)";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2840)), "_LEGACY_ERROR_TEMP_1331", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"non_exist"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)"testcat.tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("root\n              | |-- id: long (nullable = true)\n              | |-- data: string (nullable = true)\n              |")))})), this.ExpectedContext().apply(sql1, 0, 40));
                String sql2 = "CREATE index i1 ON " + t + "(id)";
                AnalysisException x$417 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2859));
                String x$418 = "_LEGACY_ERROR_TEMP_1332";
                scala.collection.immutable.Map x$419 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errorMessage"), (Object)"CreateIndex is not supported in this table testcat.tbl.")}));
                Option x$420 = this.checkError$default$3();
                boolean x$421 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$422 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$417, "_LEGACY_ERROR_TEMP_1332", x$420, x$419, x$421, x$422);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2834));
        this.test("SPARK-37294: insert ANSI intervals into a table partitioned by the interval columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = "testpart.interval_table";
            new .colon.colon((Object)SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC(), (List)new .colon.colon((Object)SQLConf.PartitionOverwriteMode$.MODULE$.STATIC(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)mode -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARTITION_OVERWRITE_MODE().key()), (Object)mode.toString())}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE " + tbl$4 + " (i INT, part1 INTERVAL YEAR, part2 INTERVAL DAY) USING " + $this.v2Format() + "\n               |PARTITIONED BY (part1, part2)\n              ")));
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("ALTER TABLE " + tbl$4 + " ADD PARTITION (\n               |part1 = INTERVAL '2' YEAR,\n               |part2 = INTERVAL '3' DAY)")));
                    $this.sql().apply((Object)("INSERT OVERWRITE TABLE " + tbl$4 + " SELECT 1, INTERVAL '2' YEAR, INTERVAL '3' DAY"));
                    $this.sql().apply((Object)("INSERT INTO TABLE " + tbl$4 + " SELECT 4, INTERVAL '5' YEAR, INTERVAL '6' DAY"));
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |INSERT INTO " + tbl$4 + "\n               | PARTITION (part1 = INTERVAL '8' YEAR, part2 = INTERVAL '9' DAY)\n               |SELECT 7")));
                    $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(tbl$4), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Period.ofYears(2), Duration.ofDays(3L)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), Period.ofYears(5), Duration.ofDays(6L)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), Period.ofYears(8), Duration.ofDays(9L)})), (List)Nil$.MODULE$))));
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2868));
        this.test("Check HasPartitionKey from InMemoryPartitionTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testpart.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                int[] partKeys;
                this.sql().apply((Object)("CREATE TABLE " + t + " (id string) USING foo PARTITIONED BY (key int)"));
                InMemoryPartitionTable table = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"tbl"));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES ('a', 1), ('b', 2), ('c', 3)"));
                int[] $org_scalatest_assert_macro_left = partKeys = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$408(x$9)), (ClassTag)ClassTag$.MODULE$.Int());
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2911));
                Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.wrapIntArray(partKeys).toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                Set set = $org_scalatest_assert_macro_left2;
                Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2912));
                this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (key=3)"));
                int[] $org_scalatest_assert_macro_left3 = partKeys = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$409(x$10)), (ClassTag)ClassTag$.MODULE$.Int());
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2916));
                Set $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapIntArray(partKeys).toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
                Set set3 = $org_scalatest_assert_macro_left4;
                Set set4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2917));
                this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (key=4)"));
                int[] $org_scalatest_assert_macro_left5 = partKeys = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$410(x$11)), (ClassTag)ClassTag$.MODULE$.Int());
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2921));
                Set $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapIntArray(partKeys).toSet();
                Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4}));
                Set set5 = $org_scalatest_assert_macro_left6;
                Set set6 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2922));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES ('c', 3), ('e', 5)"));
                int[] $org_scalatest_assert_macro_left7 = partKeys = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)DataSourceV2SQLSuiteV1Filter.$anonfun$new$411(x$12)), (ClassTag)ClassTag$.MODULE$.Int());
                int $org_scalatest_assert_macro_right7 = 5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2926));
                Set $org_scalatest_assert_macro_left8 = Predef$.MODULE$.wrapIntArray(partKeys).toSet();
                Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
                Set set7 = $org_scalatest_assert_macro_left8;
                Set set8 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2927));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2901));
        this.test("Check HasPartitionStatistics from InMemoryPartitionTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "testpart.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t + " (id string) USING foo PARTITIONED BY (key int)"));
                InMemoryPartitionTable table = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"tbl"));
                long[] partSizes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$414(x$13)), (ClassTag)ClassTag$.MODULE$.Long());
                long[] partRowCounts = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$415(x$14)), (ClassTag)ClassTag$.MODULE$.Long());
                long[] partFiles = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$416(x$15)), (ClassTag)ClassTag$.MODULE$.Long());
                long[] $org_scalatest_assert_macro_left = partSizes;
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2942));
                long[] $org_scalatest_assert_macro_left2 = partRowCounts;
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2943));
                long[] $org_scalatest_assert_macro_left3 = partFiles;
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2944));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES ('a', 1), ('b', 2), ('c', 3)"));
                long[] $org_scalatest_assert_macro_left4 = partSizes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$417(x$16)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2948));
                Set $org_scalatest_assert_macro_left5 = Predef$.MODULE$.wrapLongArray(partSizes).toSet();
                Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100}));
                Set set = $org_scalatest_assert_macro_left5;
                Set set2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2949));
                long[] $org_scalatest_assert_macro_left6 = partRowCounts = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$418(x$17)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2951));
                Set $org_scalatest_assert_macro_left7 = Predef$.MODULE$.wrapLongArray(partRowCounts).toSet();
                Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1, 1}));
                Set set3 = $org_scalatest_assert_macro_left7;
                Set set4 = $org_scalatest_assert_macro_right7;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2952));
                long[] $org_scalatest_assert_macro_left8 = partFiles = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$419(x$18)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right8 = 3;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2954));
                Set $org_scalatest_assert_macro_left9 = Predef$.MODULE$.wrapLongArray(partFiles).toSet();
                Set $org_scalatest_assert_macro_right9 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100}));
                Set set5 = $org_scalatest_assert_macro_left9;
                Set set6 = $org_scalatest_assert_macro_right9;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2955));
                this.sql().apply((Object)("ALTER TABLE " + t + " DROP PARTITION (key=3)"));
                long[] $org_scalatest_assert_macro_left10 = partSizes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$420(x$19)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right10 = 2;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2959));
                Set $org_scalatest_assert_macro_left11 = Predef$.MODULE$.wrapLongArray(partSizes).toSet();
                Set $org_scalatest_assert_macro_right11 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100}));
                Set set7 = $org_scalatest_assert_macro_left11;
                Set set8 = $org_scalatest_assert_macro_right11;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2960));
                long[] $org_scalatest_assert_macro_left12 = partRowCounts = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$421(x$20)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right12 = 2;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left12, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2962));
                Set $org_scalatest_assert_macro_left13 = Predef$.MODULE$.wrapLongArray(partRowCounts).toSet();
                Set $org_scalatest_assert_macro_right13 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1}));
                Set set9 = $org_scalatest_assert_macro_left13;
                Set set10 = $org_scalatest_assert_macro_right13;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2963));
                long[] $org_scalatest_assert_macro_left14 = partFiles = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$422(x$21)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right14 = 2;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left14, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2965));
                Set $org_scalatest_assert_macro_left15 = Predef$.MODULE$.wrapLongArray(partFiles).toSet();
                Set $org_scalatest_assert_macro_right15 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100}));
                Set set11 = $org_scalatest_assert_macro_left15;
                Set set12 = $org_scalatest_assert_macro_right15;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right15, !(set11 != null ? !set11.equals(set12) : set12 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2966));
                this.sql().apply((Object)("ALTER TABLE " + t + " ADD PARTITION (key=4)"));
                long[] $org_scalatest_assert_macro_left16 = partSizes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$22 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$423(x$22)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right16 = 3;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left16, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2970));
                Set $org_scalatest_assert_macro_left17 = Predef$.MODULE$.wrapLongArray(partSizes).toSet();
                Set $org_scalatest_assert_macro_right17 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100}));
                Set set13 = $org_scalatest_assert_macro_left17;
                Set set14 = $org_scalatest_assert_macro_right17;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right17, !(set13 != null ? !set13.equals(set14) : set14 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2971));
                long[] $org_scalatest_assert_macro_left18 = partRowCounts = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$424(x$23)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right18 = 3;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left18, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left18.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right18), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2973));
                Set $org_scalatest_assert_macro_left19 = Predef$.MODULE$.wrapLongArray(partRowCounts).toSet();
                Set $org_scalatest_assert_macro_right19 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1, 0}));
                Set set15 = $org_scalatest_assert_macro_left19;
                Set set16 = $org_scalatest_assert_macro_right19;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "==", (Object)$org_scalatest_assert_macro_right19, !(set15 != null ? !set15.equals(set16) : set16 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2974));
                long[] $org_scalatest_assert_macro_left20 = partFiles = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$425(x$24)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right20 = 3;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left20, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left20.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right20), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2976));
                Set $org_scalatest_assert_macro_left21 = Predef$.MODULE$.wrapLongArray(partFiles).toSet();
                Set $org_scalatest_assert_macro_right21 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100}));
                Set set17 = $org_scalatest_assert_macro_left21;
                Set set18 = $org_scalatest_assert_macro_right21;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "==", (Object)$org_scalatest_assert_macro_right21, !(set17 != null ? !set17.equals(set18) : set18 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2977));
                this.sql().apply((Object)("INSERT INTO " + t + " VALUES ('c', 3), ('e', 5)"));
                long[] $org_scalatest_assert_macro_left22 = partSizes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$426(x$25)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right22 = 5;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left22, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left22.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right22), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2981));
                Set $org_scalatest_assert_macro_left23 = Predef$.MODULE$.wrapLongArray(partSizes).toSet();
                Set $org_scalatest_assert_macro_right23 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100, 100, 100}));
                Set set19 = $org_scalatest_assert_macro_left23;
                Set set20 = $org_scalatest_assert_macro_right23;
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "==", (Object)$org_scalatest_assert_macro_right23, !(set19 != null ? !set19.equals(set20) : set20 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2982));
                long[] $org_scalatest_assert_macro_left24 = partRowCounts = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$427(x$26)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right24 = 5;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left24, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left24.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right24), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2984));
                Set $org_scalatest_assert_macro_left25 = Predef$.MODULE$.wrapLongArray(partRowCounts).toSet();
                Set $org_scalatest_assert_macro_right25 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1, 0, 1, 1}));
                Set set21 = $org_scalatest_assert_macro_left25;
                Set set22 = $org_scalatest_assert_macro_right25;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "==", (Object)$org_scalatest_assert_macro_right25, !(set21 != null ? !set21.equals(set22) : set22 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2985));
                long[] $org_scalatest_assert_macro_left26 = partFiles = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.data()), (Function1 & Serializable)x$27 -> BoxesRunTime.boxToLong((long)DataSourceV2SQLSuiteV1Filter.$anonfun$new$428(x$27)), (ClassTag)ClassTag$.MODULE$.Long());
                int $org_scalatest_assert_macro_right26 = 5;
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left26, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left26.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2987));
                Set $org_scalatest_assert_macro_left27 = Predef$.MODULE$.wrapLongArray(partFiles).toSet();
                Set $org_scalatest_assert_macro_right27 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 100, 100, 100, 100}));
                Set set23 = $org_scalatest_assert_macro_left27;
                Set set24 = $org_scalatest_assert_macro_right27;
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "==", (Object)$org_scalatest_assert_macro_right27, !(set23 != null ? !set23.equals(set24) : set24 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2988));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2931));
        this.test("time travel", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"use testcat");
            String t1 = "testcat.tSnapshot123456789";
            String t2 = "testcat.t2345678910";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (id int) USING foo"));
                this.sql().apply((Object)("CREATE TABLE " + t2 + " (id int) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + t1 + " VALUES (1)"));
                this.sql().apply((Object)("INSERT INTO " + t1 + " VALUES (2)"));
                this.sql().apply((Object)("INSERT INTO " + t2 + " VALUES (3)"));
                this.sql().apply((Object)("INSERT INTO " + t2 + " VALUES (4)"));
                Row[] res1_sql = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t VERSION AS OF 'Snapshot123456789'")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(res1_sql);
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3008));
                Row[] res1_df = (Row[])this.spark().read().option("versionAsOf", "Snapshot123456789").table("t").collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(res1_df);
                Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3010));
                Row[] res2_sql = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t VERSION AS OF 2345678910")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(res2_sql);
                Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)}))});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3012));
                Row[] res2_df = (Row[])this.spark().read().option("versionAsOf", "2345678910").table("t").collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(res2_df);
                Row[] $org_scalatest_assert_macro_right4 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)}))});
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3014));
            });
            long ts1 = DateTimeUtils$.MODULE$.stringToTimestampAnsi(UTF8String.fromString((String)"2019-01-29 00:37:58"), DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()), DateTimeUtils$.MODULE$.stringToTimestampAnsi$default$3());
            long ts2 = DateTimeUtils$.MODULE$.stringToTimestampAnsi(UTF8String.fromString((String)"2021-01-29 00:00:00"), DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()), DateTimeUtils$.MODULE$.stringToTimestampAnsi$default$3());
            String ts1InSeconds = Long.toString(TimeUnit.MICROSECONDS.toSeconds(ts1));
            String ts2InSeconds = Long.toString(TimeUnit.MICROSECONDS.toSeconds(ts2));
            String t3 = "testcat.t" + ts1;
            String t4 = "testcat.t" + ts2;
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t3, t4}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t3 + " (id int) USING foo"));
                this.sql().apply((Object)("CREATE TABLE " + t4 + " (id int) USING foo"));
                this.sql().apply((Object)("INSERT INTO " + t3 + " VALUES (5)"));
                this.sql().apply((Object)("INSERT INTO " + t3 + " VALUES (6)"));
                this.sql().apply((Object)("INSERT INTO " + t4 + " VALUES (7)"));
                this.sql().apply((Object)("INSERT INTO " + t4 + " VALUES (8)"));
                Row[] res1_sql = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF '2019-01-29 00:37:58'")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(res1_sql);
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3038));
                Row[] res1_df = (Row[])this.spark().read().option("timestampAsOf", "2019-01-29 00:37:58").table("t").collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(res1_df);
                Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3040));
                Row[] res2_sql = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF '2021-01-29 00:00:00'")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(res2_sql);
                Row[] $org_scalatest_assert_macro_right3 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3042));
                Row[] res2_df = (Row[])this.spark().read().option("timestampAsOf", "2021-01-29 00:00:00").table("t").collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(res2_df);
                Row[] $org_scalatest_assert_macro_right4 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3044));
                Row[] res3 = (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF " + ts1InSeconds))).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(res3);
                Row[] $org_scalatest_assert_macro_right5 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3047));
                Row[] res4 = (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF " + ts2InSeconds))).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(res4);
                Row[] $org_scalatest_assert_macro_right6 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3049));
                Row[] res5 = (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t FOR SYSTEM_TIME AS OF " + ts1InSeconds))).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(res5);
                Row[] $org_scalatest_assert_macro_right7 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))});
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3051));
                Row[] res6 = (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t FOR SYSTEM_TIME AS OF " + ts2InSeconds))).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(res6);
                Row[] $org_scalatest_assert_macro_right8 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3053));
                Row[] res7 = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF make_date(2021, 1, 29)")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(res7);
                Row[] $org_scalatest_assert_macro_right9 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3055));
                Row[] res8 = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF to_timestamp('2021-01-29 00:00:00')")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(res8);
                Row[] $org_scalatest_assert_macro_right10 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3058));
                Row[] res9 = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF (SELECT make_date(2021, 1, 29))")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(res9);
                Row[] $org_scalatest_assert_macro_right11 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3061));
                Row[] res10 = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF (SELECT (SELECT make_date(2021, 1, 29)))")).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(res10);
                Row[] $org_scalatest_assert_macro_right12 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)}))});
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3065));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF current_date()"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3068)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`t`")})), this.ExpectedContext().apply("t", 14, 14));
                AnalysisException x$423 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF INTERVAL 1 DAY")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3081));
                String x$424 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT";
                scala.collection.immutable.Map x$425 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"INTERVAL '1' DAY\"")}));
                Option x$426 = this.checkError$default$3();
                boolean x$427 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$428 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$423, "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT", x$426, x$425, x$427, x$428);
                AnalysisException x$429 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF 'abc'")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3089));
                String x$430 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT";
                scala.collection.immutable.Map x$431 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"abc\"")}));
                Option x$432 = this.checkError$default$3();
                boolean x$433 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$434 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$429, "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.INPUT", x$432, x$431, x$433, x$434);
                AnalysisException x$435 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().option("timestampAsOf", "abc").table("t").collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3096));
                String x$436 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.OPTION";
                scala.collection.immutable.Map x$437 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"'abc'")}));
                Option x$438 = this.checkError$default$3();
                boolean x$439 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$440 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$435, "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.OPTION", x$438, x$437, x$439, x$440);
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])this.spark().read().option("timestampAsOf", "abc").option("versionAsOf", "1").table("t").collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3103)), "INVALID_TIME_TRAVEL_SPEC", this.checkError$default$3(), this.checkError$default$4(), this.checkError$default$5(), this.checkError$default$6());
                AnalysisException x$441 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF current_user()")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3113));
                String x$442 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.UNEVALUABLE";
                scala.collection.immutable.Map x$443 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"current_user()\"")}));
                Option x$444 = this.checkError$default$3();
                boolean x$445 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$446 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$441, "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.UNEVALUABLE", x$444, x$443, x$445, x$446);
                AnalysisException x$447 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF CAST(rand() AS STRING)")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3120));
                String x$448 = "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.NON_DETERMINISTIC";
                scala.collection.immutable.Map x$449 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"\"CAST(rand() AS STRING)\"")}));
                Option x$450 = this.checkError$default$3();
                boolean x$451 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$452 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$447, "INVALID_TIME_TRAVEL_TIMESTAMP_EXPR.NON_DETERMINISTIC", x$450, x$449, x$451, x$452);
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM t TIMESTAMP AS OF abs(true)")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3127)), "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"abs(true)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"first"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"true\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\")")})), this.ExpectedContext().apply("abs(true)", 32, 40));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM parquet.`/the/path` VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3145)), "UNSUPPORTED_FEATURE.TIME_TRAVEL", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationId"), (Object)"`parquet`.`/the/path`")})), this.checkError$default$5(), this.checkError$default$6());
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"WITH x AS (SELECT 1) SELECT * FROM x VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3153)), "UNSUPPORTED_FEATURE.TIME_TRAVEL", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationId"), (Object)"`x`")})), this.checkError$default$5(), this.checkError$default$6());
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_exist VERSION AS OF 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3161)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), this.ExpectedContext().apply("non_exist", 14, 22));
                String subquery1 = "SELECT 1 FROM non_exist";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (" + subquery1 + ")"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3173)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), this.ExpectedContext().apply("non_exist", 47, 55));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (SELECT (" + subquery1 + "))"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3184)), "TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)"`non_exist`")})), this.ExpectedContext().apply("non_exist", 55, 63));
                String subquery2 = "SELECT col";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (" + subquery2 + ")"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3196)), "UNRESOLVED_COLUMN.WITHOUT_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`col`")})), this.ExpectedContext().apply("col", 40, 42));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (SELECT (" + subquery2 + "))"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3206)), "UNRESOLVED_COLUMN.WITHOUT_SUGGESTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`col`")})), this.ExpectedContext().apply("col", 48, 50));
                String subquery3 = "SELECT 1, 2";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (" + subquery3 + ")"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3218)), "INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)"2")})), this.ExpectedContext().apply("(SELECT 1, 2)", 32, 44));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (SELECT (" + subquery3 + "))"))).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3229)), "INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)"2")})), this.ExpectedContext().apply("(SELECT 1, 2)", 40, 52));
                String subquery4 = "SELECT * FROM VALUES (1), (2)";
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (" + subquery4 + ")"))).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3242)), "SCALAR_SUBQUERY_TOO_MANY_ROWS", Predef$.MODULE$.Map().empty(), this.ExpectedContext().apply("(SELECT * FROM VALUES (1), (2))", 32, 62));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)("SELECT * FROM t TIMESTAMP AS OF (SELECT (" + subquery4 + "))"))).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3252)), "SCALAR_SUBQUERY_TOO_MANY_ROWS", Predef$.MODULE$.Map().empty(), this.ExpectedContext().apply("(SELECT * FROM VALUES (1), (2))", 40, 70));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2992));
        this.test("SPARK-37827: put build-in properties into V1Table.properties to adapt v2 command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + t + " (\n           |  a bigint,\n           |  b bigint\n           |)\n           |using parquet\n           |OPTIONS (\n           |  from = 0,\n           |  to = 1)\n           |COMMENT 'This is a comment'\n           |TBLPROPERTIES ('prop1' = '1', 'prop2' = '2')\n           |PARTITIONED BY (a)\n           |LOCATION '/tmp'\n        ")));
                Table table = CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)t));
                java.util.Map properties = table.properties();
                String $org_scalatest_assert_macro_left = (String)properties.get("provider");
                String $org_scalatest_assert_macro_right = "parquet";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3286));
                String $org_scalatest_assert_macro_left2 = (String)properties.get("comment");
                String $org_scalatest_assert_macro_right2 = "This is a comment";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3287));
                String $org_scalatest_assert_macro_left3 = (String)properties.get("location");
                String $org_scalatest_assert_macro_right3 = "file:///tmp";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3288));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(properties.containsKey("owner"), "properties.containsKey(\"owner\")", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3289));
                String $org_scalatest_assert_macro_left4 = (String)properties.get("external");
                String $org_scalatest_assert_macro_right4 = "true";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3290));
                String $org_scalatest_assert_macro_left5 = (String)properties.get("option.from");
                String $org_scalatest_assert_macro_right5 = "0";
                String string9 = $org_scalatest_assert_macro_left5;
                String string10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3291));
                String $org_scalatest_assert_macro_left6 = (String)properties.get("option.to");
                String $org_scalatest_assert_macro_right6 = "1";
                String string11 = $org_scalatest_assert_macro_left6;
                String string12 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3292));
                String $org_scalatest_assert_macro_left7 = (String)properties.get("prop1");
                String $org_scalatest_assert_macro_right7 = "1";
                String string13 = $org_scalatest_assert_macro_left7;
                String string14 = $org_scalatest_assert_macro_right7;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3293));
                String $org_scalatest_assert_macro_left8 = (String)properties.get("prop2");
                String $org_scalatest_assert_macro_right8 = "2";
                String string15 = $org_scalatest_assert_macro_left8;
                String string16 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3294));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3264));
        this.test("Overwrite: overwrite by expression: True", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator122$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"d"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"e"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"f"), (List)Nil$.MODULE$))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator123$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df2.createOrReplaceTempView("source2");
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo PARTITIONED BY (id)");
                this.spark().sql("INSERT INTO TABLE " + t + " SELECT * FROM source");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$))));
                this.spark().sql("INSERT INTO " + t + " REPLACE WHERE TRUE SELECT * FROM source2");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "d"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), "e"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "f"})), (List)Nil$.MODULE$))));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3298));
        this.test("Overwrite: overwrite by expression: id = 3", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator124$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"d"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"e"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"f"), (List)Nil$.MODULE$))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator125$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df2.createOrReplaceTempView("source2");
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo PARTITIONED BY (id)");
                this.spark().sql("INSERT INTO TABLE " + t + " SELECT * FROM source");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), "c"})), (List)Nil$.MODULE$))));
                this.spark().sql("INSERT INTO " + t + " REPLACE WHERE id = 3 SELECT * FROM source2");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(String.valueOf(t)), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), "d"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), "e"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), "f"})), (List)Nil$.MODULE$))))));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3321));
        this.test("SPARK-46144: Fail overwrite statement if the condition contains subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1(DataSourceV2SQLSuiteV1Filter $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator126$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            String t = "testcat.tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE TABLE " + t + " (id bigint, data string) USING foo PARTITIONED BY (id)");
                this.spark().sql("INSERT INTO TABLE " + t + " SELECT * FROM source");
                String invalidQuery = "INSERT INTO " + t + " REPLACE WHERE id = (select c2 from values(1) as t(c2)) SELECT * FROM source";
                AnalysisException exception = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().sql(invalidQuery), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3354));
                this.checkError((SparkThrowable)exception, "UNSUPPORTED_FEATURE.OVERWRITE_BY_SUBQUERY", "0A000", Predef$.MODULE$.Map().empty(), this.ExpectedContext().apply("id = (select c2 from values(1) as t(c2))", 38, 77));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3344));
        this.test("SPARK-41154: Incorrect relation caching for queries with time travel spec", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"use testcat");
            String t1 = "testcat.t1";
            String t2 = "testcat.t2";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + t1 + " USING foo AS SELECT 1 as c"));
                this.sql().apply((Object)("CREATE TABLE " + t2 + " USING foo AS SELECT 2 as c"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |SELECT * FROM t VERSION AS OF '1'\n              |UNION ALL\n              |SELECT * FROM t VERSION AS OF '2'\n              |")))).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3377));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3370));
        this.test("SPARK-41378: test column stats", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.test (id bigint NOT NULL, data string)");
            this.spark().sql("INSERT INTO testcat.test values (1, 'test1'), (2, null), (3, null), (4, null), (5, 'test5')");
            Dataset df = this.spark().sql("select * from testcat.test");
            .colon.colon expectedColumnStats = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 2)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(3)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 2)), (List)Nil$.MODULE$));
            return df.queryExecution().optimizedPlan().collect((PartialFunction)new Serializable(this, (Seq)expectedColumnStats, df){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DataSourceV2SQLSuiteV1Filter $outer;
                private final Seq expectedColumnStats$1;
                private final Dataset df$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1;
                        Statistics stats = dataSourceV2ScanRelation.stats();
                        BigInt $org_scalatest_assert_macro_left = stats.sizeInBytes();
                        int $org_scalatest_assert_macro_right = 200;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3399));
                        BigInt $org_scalatest_assert_macro_left2 = (BigInt)stats.rowCount().get();
                        int $org_scalatest_assert_macro_right2 = 5;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3400));
                        AttributeMap $org_scalatest_assert_macro_left3 = stats.attributeStats();
                        AttributeMap<ColumnStat> $org_scalatest_assert_macro_right3 = this.$outer.toAttributeMap((Seq<Tuple2<String, ColumnStat>>)this.expectedColumnStats$1, this.df$1.queryExecution().optimizedPlan());
                        AttributeMap attributeMap = $org_scalatest_assert_macro_left3;
                        AttributeMap<ColumnStat> attributeMap2 = $org_scalatest_assert_macro_right3;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(attributeMap != null ? !attributeMap.equals(attributeMap2) : attributeMap2 != null), Prettifier$.MODULE$.default());
                        return (B1)Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3401));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof DataSourceV2ScanRelation;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.expectedColumnStats$1 = expectedColumnStats$1;
                    this.df$1 = df$1;
                }
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3387));
        this.test("DESCRIBE TABLE EXTENDED of a V2 table with a default column value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)this.v2Source())}), (JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE t (id bigint default 42) USING " + this.v2Source());
            Dataset descriptionDf = this.spark().sql("DESCRIBE TABLE EXTENDED t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType())));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3411));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)descriptionDf.filter("!(col_name in ('Catalog', 'Created Time', 'Created By', 'Database', 'index', 'Location', 'Name', 'Owner', 'Provider', 'Table', 'Table Properties', 'Type', '_partition', ''))"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Detailed Table Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Column Default Values", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Metadata Columns", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", "42"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Statistics", "0 bytes, 0 rows", null})), (List)Nil$.MODULE$)))))), QueryTest$.MODULE$.checkAnswer$default$3());
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3406));
        this.test("SPARK-40045: Move the post-Scan Filters to the far right", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = this.catalogAndNamespace() + "table";
            this.withUserDefinedFunction((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"udfStrLen"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> expressionsAfter;
                Bool bool4;
                Bool bool5;
                Bool bool6;
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> expressionsBefore;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuiteV1Filter.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator127$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator127$1(DataSourceV2SQLSuiteV1Filter $outer) {
                    }
                }
                this.spark().udf().register("udfStrLen", (Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)str.length()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuiteV1Filter$$typecreator127$1(null)));
                this.sql().apply((Object)("CREATE TABLE " + t1 + " (id bigint, data string) USING " + this.v2Format()));
                this.sql().apply((Object)("INSERT INTO " + t1 + " VALUES (1, 'a'), (2, 'b'), (3, 'c')"));
                Dataset filterBefore = this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT id, data FROM " + t1 + "\n             |WHERE udfStrLen(data) = 1\n             |and id = 2\n             |")));
                org.apache.spark.sql.catalyst.expressions.Expression conditionBefore = ((FilterExec)Option$.MODULE$.option2Iterable(this.find(filterBefore.queryExecution().executedPlan(), (Function1<SparkPlan, Object>)(Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$475(x$28)))).head()).condition();
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> $org_scalatest_assert_macro_left = expressionsBefore = this.splitConjunctivePredicates(conditionBefore);
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(0)).toString().trim();
                    String $org_scalatest_assert_macro_right2 = "isnotnull(id";
                    bool6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "startsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.startsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool6 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool6;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    String $org_scalatest_assert_macro_left5 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(1)).toString().trim();
                    String $org_scalatest_assert_macro_right4 = "(id";
                    bool5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "startsWith", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.startsWith($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                } else {
                    bool5 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool5;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    String $org_scalatest_assert_macro_left7 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsBefore.apply(2)).toString().trim();
                    String $org_scalatest_assert_macro_right6 = "(udfStrLen(data";
                    bool4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "startsWith", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.startsWith($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                } else {
                    bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right7 = bool4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3454));
                Dataset filterAfter = this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT id, data FROM " + t1 + "\n             |WHERE id = 2\n             |and udfStrLen(data) = 1\n             |")));
                org.apache.spark.sql.catalyst.expressions.Expression conditionAfter = ((FilterExec)Option$.MODULE$.option2Iterable(this.find(filterAfter.queryExecution().executedPlan(), (Function1<SparkPlan, Object>)(Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuiteV1Filter.$anonfun$new$479(x$29)))).head()).condition();
                Seq<org.apache.spark.sql.catalyst.expressions.Expression> $org_scalatest_assert_macro_left8 = expressionsAfter = this.splitConjunctivePredicates(conditionAfter);
                int $org_scalatest_assert_macro_right8 = 3;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left9.value()) {
                    String $org_scalatest_assert_macro_left10 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(0)).toString().trim();
                    String $org_scalatest_assert_macro_right9 = "isnotnull(id";
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "startsWith", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.startsWith($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right10 = bool3;
                Bool $org_scalatest_assert_macro_left11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left11.value()) {
                    String $org_scalatest_assert_macro_left12 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(1)).toString().trim();
                    String $org_scalatest_assert_macro_right11 = "(id";
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "startsWith", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.startsWith($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right12 = bool2;
                Bool $org_scalatest_assert_macro_left13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "&&", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left11.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left13.value()) {
                    String $org_scalatest_assert_macro_left14 = ((org.apache.spark.sql.catalyst.expressions.Expression)expressionsAfter.apply(2)).toString().trim();
                    String $org_scalatest_assert_macro_right13 = "(udfStrLen(data";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "startsWith", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left14.startsWith($org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right14 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "&&", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left13.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3471));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3434));
        this.test("SPARK-45454: Set table owner to current_user if it is set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            String testOwner = "test_table_owner";
            try {
                CurrentUserContext$.MODULE$.CURRENT_USER().set(testOwner);
                this.spark().sql("CREATE TABLE testcat.table_name (id int) USING foo");
                Table table = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog().loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.properties().get("owner"));
                String $org_scalatest_assert_macro_right = testOwner;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3485));
            }
            finally {
                CurrentUserContext$.MODULE$.CURRENT_USER().remove();
            }
            return assertion;
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3479));
    }
}

