/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005)3qa\u0002\u0005\u0011\u0002\u0007\u00051\u0003C\u0003%\u0001\u0011\u0005Q\u0005C\u0003-\u0001\u0019EQ\u0006C\u0004B\u0001\t\u0007i\u0011\u0003\"\t\u000f\r\u0003!\u0019!D\t\u0005\")A\t\u0001C\u0005\u000b\")q\t\u0001C\u0005\u0011\ny\u0011\t\u001c;feR\u000b'\r\\3UKN$8O\u0003\u0002\n\u0015\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u00171\t1a]9m\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0005\u0001QAb\u0004\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0006\u0002\tQ,7\u000f^\u0005\u0003;i\u0011!c\u00155be\u0016$7\u000b]1sWN+7o]5p]B\u0011qDI\u0007\u0002A)\u0011\u0011EC\u0001\u0007KJ\u0014xN]:\n\u0005\r\u0002#aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0002\r\u0011Jg.\u001b;%)\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSR\f\u0001cZ3u)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0015\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\t\u0003\u001d\u0019\u0017\r^1m_\u001eL!a\r\u0019\u0003\u000bQ\u000b'\r\\3\t\u000bU\u0012\u0001\u0019\u0001\u001c\u0002\u0013Q\f'\r\\3OC6,\u0007CA\u001c?\u001d\tAD\b\u0005\u0002:Q5\t!H\u0003\u0002<%\u00051AH]8pizJ!!\u0010\u0015\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{!\n1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016,\u0012AN\u0001\tmJ2uN]7bi\u0006ia-\u001e7m)\u0006\u0014G.\u001a(b[\u0016$\"A\u000e$\t\u000bU*\u0001\u0019\u0001\u001c\u0002%A\u0014X\r]3oI\u000e\u000bG/\u00197pO:\u000bW.\u001a\u000b\u0003m%CQ!\u000e\u0004A\u0002Y\u0002")
public interface AlterTableTests
extends SharedSparkSession,
QueryErrorsBase {
    public Table getTableMetadata(String var1);

    public String catalogAndNamespace();

    public String v2Format();

    private String fullTableName(String tableName) {
        if (this.catalogAndNamespace().isEmpty()) {
            return "default." + tableName;
        }
        return this.catalogAndNamespace() + tableName;
    }

    private String prependCatalogName(String tableName) {
        if (this.catalogAndNamespace().isEmpty()) {
            return "spark_catalog." + tableName;
        }
        return tableName;
    }

    public static /* synthetic */ void $anonfun$$init$$52(AlterTableTests $this, String t$17, String field) {
        scala.collection.immutable.Map expectedParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"op"), (Object)"add"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)String.valueOf($this.toSQLId(field))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"struct"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"STRUCT<id: INT, point: STRUCT<x: DOUBLE, y: DOUBLE>,\n              |arr: ARRAY<STRUCT<x: DOUBLE, y: DOUBLE>>,\n              |mk: MAP<STRUCT<x: DOUBLE, y: DOUBLE>, STRING>,\n              |mv: MAP<STRING, STRUCT<x: DOUBLE, y: DOUBLE>>>\"")).replace("\n", " "))}));
        ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t$17 + " ADD COLUMNS " + field + " double")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466)), "FIELD_ALREADY_EXISTS", expectedParameters, ((SparkFunSuite)$this).ExpectedContext().apply("ALTER TABLE " + t$17 + " ADD COLUMNS " + field + " double", 0, 31 + t$17.length() + field.length()));
    }

    public static /* synthetic */ void $anonfun$$init$$64(AlterTableTests $this, String t$21, AnsiIntervalType x0$1) {
        AnsiIntervalType ansiIntervalType = x0$1;
        if (ansiIntervalType != null) {
            AnsiIntervalType ansiIntervalType2 = ansiIntervalType;
            ansiIntervalType2.typeName();
            String sqlText = "ALTER TABLE " + t$21 + " ALTER COLUMN id TYPE " + ansiIntervalType2.typeName();
            ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529)), "CANNOT_UPDATE_FIELD.INTERVAL_TYPE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)String.valueOf($this.toSQLId($this.prependCatalogName(t$21)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`id`")})), ((SparkFunSuite)$this).ExpectedContext().apply(sqlText, 0, 33 + ansiIntervalType2.typeName().length() + t$21.length()));
            return;
        }
        throw new MatchError((Object)ansiIntervalType);
    }

    public static /* synthetic */ void $anonfun$$init$$138(AlterTableTests $this, String t$50, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            String expectedName = (String)tuple2._2();
            if (tuple22 != null) {
                String field = (String)tuple22._1();
                String newName = (String)tuple22._2();
                String expectedStruct = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"\n            |STRUCT<id: INT, user_id: INT,\n            | point: STRUCT<x: DOUBLE, y: DOUBLE>,\n            | arr: ARRAY<STRUCT<x: DOUBLE, y: DOUBLE>>,\n            | mk: MAP<STRUCT<x: DOUBLE, y: DOUBLE>, STRING>,\n            | mv: MAP<STRING, STRUCT<x: DOUBLE, y: DOUBLE>>>\n            |\"")).replace("\n", "");
                String string = expectedName;
                String string2 = "user_id";
                int expectedStop = !(string != null ? !string.equals(string2) : string2 != null) ? 39 + t$50.length() : 31 + t$50.length() + expectedName.length();
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t$50 + " RENAME COLUMN " + field + " TO " + newName)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1116)), "FIELD_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"op"), (Object)"rename"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)String.valueOf($this.toSQLId(expectedName))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"struct"), (Object)expectedStruct)})), ((SparkFunSuite)$this).ExpectedContext().apply("ALTER TABLE " + t$50 + " RENAME COLUMN " + field + " TO " + newName, 0, expectedStop));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(AlterTableTests $this) {
        $this.test("AlterTable: table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t2 = $this.catalogAndNamespace() + "fake_table";
            String quoted = ((IterableOnceOps)UnresolvedAttribute$.MODULE$.parseAttributeName($this.catalogAndNamespace() + "table_name").map((Function1 & Serializable)part -> package$.MODULE$.quoteIdentifier(part))).mkString(".");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t2 + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + $this.catalogAndNamespace() + "table_name DROP COLUMN id")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
                ((SparkFunSuite)$this).checkErrorTableNotFound((SparkThrowable)exc, quoted, ((SparkFunSuite)$this).ExpectedContext().apply($this.catalogAndNamespace() + "table_name", 12, 11 + ($this.catalogAndNamespace() + "table_name").length()));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.test("AlterTable: change rejected by implementation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                SparkException exc = (SparkException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN id")), ClassTag$.MODULE$.apply(SparkException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Unsupported table change";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot drop all fields";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right3 = t;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        $this.test("AlterTable: add top-level column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN data string"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        $this.test("AlterTable: add column with NOT NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN data string NOT NULL"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        $this.test("AlterTable: add column with comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN data string COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        $this.test("AlterTable: add column with interval type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                ParseException e1 = (ParseException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN data interval")), ClassTag$.MODULE$.apply(ParseException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141)))));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Cannot use \"INTERVAL\" type in the table schema.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                ParseException e2 = (ParseException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.z interval")), ClassTag$.MODULE$.apply(ParseException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144)))));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Cannot use \"INTERVAL\" type in the table schema.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        $this.test("AlterTable: add column with position", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException e2;
                AnalysisException e1;
                $this.sql().apply((Object)("CREATE TABLE " + t + " (point struct<x: int>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN a string FIRST"));
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN b string AFTER point"));
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                AnalysisException x$1 = e1 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN c string AFTER non_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                String x$2 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"a, point, b")}));
                Option x$4 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$5 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$6 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$1, "FIELD_NOT_FOUND", x$4, x$3, x$5, x$6);
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.y int FIRST"));
                StructType $org_scalatest_assert_macro_left3 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left3;
                StructType structType6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.z int AFTER x"));
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)StringType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)StringType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left4;
                StructType structType8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
                AnalysisException x$7 = e2 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.x2 int AFTER non_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                String x$8 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`x2`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"y, x, z")}));
                Option x$10 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$11 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$12 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$7, "FIELD_NOT_FOUND", x$10, x$9, x$11, x$12);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        $this.test("SPARK-30814: add column with position referencing new columns being added", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException e;
                $this.sql().apply((Object)("CREATE TABLE " + t + " (a string, b int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS (x int AFTER a, y int AFTER x, z int AFTER y)"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(t).schema());
                StructType $org_scalatest_assert_macro_right = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS (point.z double AFTER x, point.zz double AFTER z)"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(t).schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)DoubleType$.MODULE$).add("z", (DataType)DoubleType$.MODULE$).add("zz", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
                AnalysisException x$13 = e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS (yy int AFTER xx, xx int)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                String x$14 = "FIELD_NOT_FOUND";
                scala.collection.immutable.Map x$15 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`yy`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"a, x, y, z, b, point")}));
                Option x$16 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$17 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$18 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$13, "FIELD_NOT_FOUND", x$16, x$15, x$17, x$18);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        $this.test("AlterTable: add multiple columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS data string COMMENT 'doc', ts timestamp"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("data", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)new .colon.colon((Object)new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        $this.test("AlterTable: add nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.z double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        $this.test("AlterTable: add nested column to map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<struct<x: double, y: double>, bigint>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN points.key.z double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        $this.test("AlterTable: add nested column to map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<string, struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN points.value.z double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        $this.test("AlterTable: add nested column to array element", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN points.element.z double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        $this.test("SPARK-39383 DEFAULT columns on V2 data sources with ALTER TABLE ADD/ALTER COLUMN", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)($this.v2Format() + ", "))}), (JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("create table " + t + " (a string) using " + $this.v2Format()));
                $this.sql().apply((Object)("alter table " + t + " add column (b int default 2 + 3)"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withCurrentDefaultValue("2 + 3").withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
                $this.sql().apply((Object)("alter table " + t + " alter column b set default 2 + 3"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(t).schema());
                StructType $org_scalatest_assert_macro_right3 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withCurrentDefaultValue("2 + 3").withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
                $this.sql().apply((Object)("alter table " + t + " alter column b drop default"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)$this.getTableMetadata(t).schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)StringType$.MODULE$).add(new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withExistenceDefaultValue("5"));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            });
        }), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        $this.test("SPARK-45075: ALTER COLUMN with invalid default value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS().key()), (Object)($this.v2Format() + ", "))}), (JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("create table t(i boolean) using " + $this.v2Format()));
            AnalysisException x$19 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t add column s bigint default badvalue"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            String x$20 = "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION";
            scala.collection.immutable.Map x$21 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)"ALTER TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`s`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"badvalue")}));
            Option x$22 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$23 = ((SparkFunSuite)$this).checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$19, "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION", x$22, x$21, x$23, x$24);
            $this.sql().apply((Object)"alter table t add column s bigint default 3L");
            AnalysisException x$25 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t alter column s set default badvalue"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            String x$26 = "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION";
            scala.collection.immutable.Map x$27 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)"ALTER TABLE ALTER COLUMN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`s`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"badvalue")}));
            Option x$28 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$29 = ((SparkFunSuite)$this).checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$25, "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION", x$28, x$27, x$29, x$30);
        })), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        $this.test("AlterTable: add complex column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN points array<struct<x: double, y: double>>"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        $this.test("AlterTable: add nested column with comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN points.element.z double COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("z", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        $this.test("AlterTable: add nested column parent must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMN point.z double")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
        $this.test("AlterTable: add column - new column should not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE " + t + " (\n           |id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING " + $this.v2Format())));
                new .colon.colon((Object)"id", (List)new .colon.colon((Object)"point.x", (List)new .colon.colon((Object)"arr.element.x", (List)new .colon.colon((Object)"mk.key.x", (List)new .colon.colon((Object)"mv.value.x", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)field -> {
                    AlterTableTests.$anonfun$$init$$52($this, t, field);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        $this.test("SPARK-36372: Adding duplicate columns should not be allowed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException x$31 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS (data string, data1 string, data string)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
                String x$32 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$33 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$34 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$35 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$36 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$31, "COLUMN_ALREADY_EXISTS", x$34, x$33, x$35, x$36);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        $this.test("SPARK-36372: Adding duplicate nested columns should not be allowed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                AnalysisException x$37 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ADD COLUMNS (point.z double, point.z double, point.xx double)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
                String x$38 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$39 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)$this.toSQLId("point.z"))}));
                Option x$40 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$41 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$42 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$37, "COLUMN_ALREADY_EXISTS", x$40, x$39, x$41, x$42);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        $this.test("AlterTable: update column type int -> long", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN id TYPE bigint"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        $this.test("AlterTable: update column type to interval", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                ((IterableOnceOps)DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().$plus$plus((IterableOnce)DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes())).foreach((Function1 & Serializable)x0$1 -> {
                    AlterTableTests.$anonfun$$init$$64($this, t, x0$1);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        $this.test("AlterTable: SET/DROP NOT NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id bigint NOT NULL) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN id SET NOT NULL"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)LongType$.MODULE$, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN id DROP NOT NULL"));
                Table table2 = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)table2.name());
                String $org_scalatest_assert_macro_right3 = t;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)table2.schema());
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
                AnalysisException e = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN id SET NOT NULL")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
                String $org_scalatest_assert_macro_left5 = e.message();
                String $org_scalatest_assert_macro_right5 = "Cannot change nullable column to non-nullable";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        $this.test("AlterTable: update nested type float -> double", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: float, y: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.x TYPE double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        $this.test("AlterTable: update column with struct type fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                String sqlText = "ALTER TABLE " + t + " ALTER COLUMN point TYPE struct<x: double, y: double, z: double>";
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591)), "CANNOT_UPDATE_FIELD.STRUCT_TYPE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)String.valueOf($this.toSQLId($this.prependCatalogName(t)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`point`")})), ((SparkFunSuite)$this).ExpectedContext().apply(sqlText, 0, 75 + t.length()));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        $this.test("AlterTable: update column with array type fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<int>) USING " + $this.v2Format()));
                String sqlText = "ALTER TABLE " + t + " ALTER COLUMN points TYPE array<long>";
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622)), "CANNOT_UPDATE_FIELD.ARRAY_TYPE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)String.valueOf($this.toSQLId($this.prependCatalogName(t)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`points`")})), ((SparkFunSuite)$this).ExpectedContext().apply(sqlText, 0, 48 + t.length()));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
        $this.test("AlterTable: update column array element type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<int>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.element TYPE long"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
        $this.test("AlterTable: update column with map type fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, m map<string, int>) USING " + $this.v2Format()));
                String sqlText = "ALTER TABLE " + t + " ALTER COLUMN m TYPE map<string, long>";
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666)), "CANNOT_UPDATE_FIELD.MAP_TYPE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)String.valueOf($this.toSQLId($this.prependCatalogName(t)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`m`")})), ((SparkFunSuite)$this).ExpectedContext().apply(sqlText, 0, 49 + t.length()));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        $this.test("AlterTable: update column map value type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, m map<string, int>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN m.value TYPE long"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("m", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        $this.test("AlterTable: update nested type in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<struct<x: float, y: double>, bigint>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.key.x TYPE double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        $this.test("AlterTable: update nested type in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<string, struct<x: float, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.value.x TYPE double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
        $this.test("AlterTable: update nested type in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: float, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.element.x TYPE double"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739));
        $this.test("AlterTable: update column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN data TYPE string")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        $this.test("AlterTable: nested update column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.x TYPE double")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        $this.test("AlterTable: update column type must be compatible", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                String sql1 = "ALTER TABLE " + t + " ALTER COLUMN id TYPE boolean";
                ((SparkFunSuite)$this).checkErrorMatchPVals((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788)), "NOT_SUPPORTED_CHANGE_COLUMN", (Option)None$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newName"), (Object)"`id`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originName"), (Object)"`id`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)".*table_name.*")})), ((SparkFunSuite)$this).ExpectedContext().apply(sql1, 0, sql1.length() - 1));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        $this.test("AlterTable: update column comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN id COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
        $this.test("AlterTable: update column position", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (a int, b int, point struct<x: int, y: int, z: int>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN b FIRST"));
                StructType $org_scalatest_assert_macro_left = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("b", (DataType)IntegerType$.MODULE$).add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN b AFTER point"));
                StructType $org_scalatest_assert_macro_left2 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
                AnalysisException e1 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN b AFTER non_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
                String $org_scalatest_assert_macro_left3 = e1.getMessage();
                String $org_scalatest_assert_macro_right3 = "Missing field non_exist";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.y FIRST"));
                StructType $org_scalatest_assert_macro_left4 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right4 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("y", (DataType)IntegerType$.MODULE$).add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType5 = $org_scalatest_assert_macro_left4;
                StructType structType6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType5 != null ? !structType5.equals(structType6) : structType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.y AFTER z"));
                StructType $org_scalatest_assert_macro_left5 = $this.getTableMetadata(t).schema();
                StructType $org_scalatest_assert_macro_right5 = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("point", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("z", (DataType)IntegerType$.MODULE$).add("y", (DataType)IntegerType$.MODULE$)).add("b", (DataType)IntegerType$.MODULE$);
                StructType structType7 = $org_scalatest_assert_macro_left5;
                StructType structType8 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(structType7 != null ? !structType7.equals(structType8) : structType8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
                AnalysisException e2 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.y AFTER non_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
                String $org_scalatest_assert_macro_left6 = e2.getMessage();
                String $org_scalatest_assert_macro_right6 = "Missing field point.non_exist";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
                ((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN a.y AFTER x")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
        $this.test("AlterTable: update nested column comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.y COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
        $this.test("AlterTable: update nested column comment in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<struct<x: double, y: double>, bigint>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.key.y COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
        $this.test("AlterTable: update nested column comment in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<string, struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.value.y COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
        $this.test("AlterTable: update nested column comment in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN points.element.y COMMENT 'doc'"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("doc"), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
        $this.test("AlterTable: comment update column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN data COMMENT 'doc'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945));
        $this.test("AlterTable: nested comment update column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " ALTER COLUMN point.x COMMENT 'doc'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 958));
        $this.test("AlterTable: rename column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN id TO user_id"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("user_id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971));
        $this.test("AlterTable: rename nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN point.y TO t"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 992));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
        $this.test("AlterTable: rename nested column in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point map<struct<x: double, y: double>, bigint>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN point.key.y TO t"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1011));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        $this.test("AlterTable: rename nested column in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<string, struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN points.value.y TO t"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
        $this.test("AlterTable: rename nested column in array element", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN points.element.y TO t"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1045));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("t", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1046));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
        $this.test("AlterTable: rename column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN data TO some_string")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1054));
        $this.test("AlterTable: nested rename column must exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " RENAME COLUMN point.x TO z")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
        $this.test("AlterTable: rename column - new name should not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE " + t + " (\n           |id int,\n           |user_id int,\n           |point struct<x: double, y: double>,\n           |arr array<struct<x: double, y: double>>,\n           |mk map<struct<x: double, y: double>, string>,\n           |mv map<string, struct<x: double, y: double>>\n           |)\n           |USING " + $this.v2Format())));
                new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"user_id")), (Object)"user_id"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point.x"), (Object)"y")), (Object)"point.y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arr.element.x"), (Object)"y")), (Object)"arr.element.y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mk.key.x"), (Object)"y")), (Object)"mk.key.y"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mv.value.x"), (Object)"y")), (Object)"mv.value.y"), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$2 -> {
                    AlterTableTests.$anonfun$$init$$138($this, t, x0$2);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1080));
        $this.test("AlterTable: drop column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, data string) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN data"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1141));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1133));
        $this.test("AlterTable: drop nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point struct<x: double, y: double, t: double>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN point.t"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1155));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1156));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1146));
        $this.test("AlterTable: drop nested column in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, point map<struct<x: double, y: double>, bigint>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN point.key.y"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("point", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (DataType)LongType$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1174));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1164));
        $this.test("AlterTable: drop nested column in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points map<string, struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN points.value.y"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1190));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1181));
        $this.test("AlterTable: drop nested column in array element", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN points.element.y"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1206));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1207));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1198));
        $this.test("AlterTable: drop column must exist if required", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN data")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1219));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1223));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN IF EXISTS data"));
                Table table = $this.getTableMetadata(t);
                StructType $org_scalatest_assert_macro_left2 = table.schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                StructType structType = $org_scalatest_assert_macro_left2;
                StructType structType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1214));
        $this.test("AlterTable: nested drop column must exist if required", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                AnalysisException exc = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN point.x")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "Missing field point.x";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1241));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMN IF EXISTS point.x"));
                Table table = $this.getTableMetadata(t);
                StructType $org_scalatest_assert_macro_left2 = table.schema();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("id", (DataType)IntegerType$.MODULE$);
                StructType structType = $org_scalatest_assert_macro_left2;
                StructType structType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1246));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1232));
        $this.test("AlterTable: drop mixed existing/non-existing columns using IF EXISTS", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int, name string, points array<struct<x: double, y: double>>) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " DROP COLUMNS IF EXISTS names, name, points.element.z, id, points.element.x"));
                Table table = $this.getTableMetadata(t);
                StructType $org_scalatest_assert_macro_left = table.schema();
                StructType $org_scalatest_assert_macro_right = new StructType().add("points", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1250));
        $this.test("AlterTable: set table property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " SET TBLPROPERTIES ('test'='34')"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1265));
        $this.test("AlterTable: remove table property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (id int) USING " + $this.v2Format() + " TBLPROPERTIES('test' = '34')"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1286));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.properties());
                java.util.Map $org_scalatest_assert_macro_right2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)"34")})))).asJava();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1287));
                $this.sql().apply((Object)("ALTER TABLE " + t + " UNSET TBLPROPERTIES ('test')"));
                Table updated = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = ((TripleEquals)$this).convertToEqualizer((Object)updated.name());
                String $org_scalatest_assert_macro_right3 = t;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)updated.properties());
                java.util.Map $org_scalatest_assert_macro_right4 = CollectionConverters$.MODULE$.MapHasAsJava((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)$this.v2Format())})))).asJava();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
        $this.test("AlterTable: replace columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (col1 int, col2 int COMMENT 'c2') USING " + $this.v2Format()));
                $this.sql().apply((Object)("ALTER TABLE " + t + " REPLACE COLUMNS (col2 string, col3 int COMMENT 'c3')"));
                Table table = $this.getTableMetadata(t);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)table.name());
                String $org_scalatest_assert_macro_right = t;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)table.schema());
                StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("col3", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("c3"), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1299));
        $this.test("SPARK-36449: Replacing columns with duplicate name should not be allowed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = $this.fullTableName("table_name");
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE " + t + " (data string) USING " + $this.v2Format()));
                AnalysisException x$43 = (AnalysisException)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)("ALTER TABLE " + t + " REPLACE COLUMNS (data string, data1 string, data string)")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1319));
                String x$44 = "COLUMN_ALREADY_EXISTS";
                scala.collection.immutable.Map x$45 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`data`")}));
                Option x$46 = ((SparkFunSuite)$this).checkError$default$3();
                boolean x$47 = ((SparkFunSuite)$this).checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$48 = ((SparkFunSuite)$this).checkError$default$6();
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$43, "COLUMN_ALREADY_EXISTS", x$46, x$45, x$47, x$48);
            });
        }, new Position("AlterTableTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1314));
    }
}

