/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.artifact.RecordedStubClassLoader;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.StubClassLoader;
import org.apache.spark.util.StubClassLoader$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00053A!\u0003\u0006\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\rE\u0002\u0001\u0015!\u0003,\u0011\u001d\u0011\u0004A1A\u0005\n)Baa\r\u0001!\u0002\u0013Y\u0003\"\u0002\u001b\u0001\t\u0013)$\u0001F*uk\n\u001cE.Y:t\u0019>\fG-\u001a:Tk&$XM\u0003\u0002\f\u0019\u0005A\u0011M\u001d;jM\u0006\u001cGO\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u001d%\u0011\u0011D\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005Q\u0011!C;eM:{\u0017IS1s+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\rqW\r\u001e\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#EA\u0002V%2\u000b!\"\u001e3g\u001d>\f%*\u0019:!\u00035\u0019G.Y:t\tVlW._+eMV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/I\u0005!A.\u00198h\u0013\t\u0001TF\u0001\u0004TiJLgnZ\u0001\u000fG2\f7o\u001d#v[6LX\u000b\u001a4!\u0003\u0019\u0019G.Y:t\u0003\u000691\r\\1tg\u0006\u0003\u0013\u0001\u00047pC\u0012$U/\\7z+\u00124GC\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0011)f.\u001b;\t\u000buB\u0001\u0019\u0001 \u0002%M,7o]5p]\u000ec\u0017m]:M_\u0006$WM\u001d\t\u0003Y}J!\u0001Q\u0017\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d")
public class StubClassLoaderSuite
extends SparkFunSuite {
    private final URL udfNoAJar = new File("src/test/resources/artifact-tests/udf_noA.jar").toURI().toURL();
    private final String classDummyUdf;
    private final String classA;

    private URL udfNoAJar() {
        return this.udfNoAJar;
    }

    private String classDummyUdf() {
        return this.classDummyUdf;
    }

    private String classA() {
        return this.classA;
    }

    private void loadDummyUdf(ClassLoader sessionClassLoader) {
        Class<?> cls = Class.forName(this.classDummyUdf(), false, sessionClassLoader);
        cls.getDeclaredMethod("dummy", new Class[0]);
        Class.forName(this.classA(), false, sessionClassLoader);
    }

    public static final /* synthetic */ boolean $anonfun$new$2(String x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(String x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(String x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$12(String x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$14(String x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$17(String x$6) {
        return true;
    }

    public StubClassLoaderSuite() {
        this.classDummyUdf = "org.apache.spark.sql.connect.client.StubClassDummyUdf";
        this.classA = "org.apache.spark.sql.connect.client.A";
        this.test("find class with stub class", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RecordedStubClassLoader cl = new RecordedStubClassLoader(this.getClass().getClassLoader(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$2(x$1)));
            Class<?> cls = cl.findClass("my.name.HelloWorld");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cls.getName());
            String $org_scalatest_assert_macro_right = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(cl.lastStubbed());
            String $org_scalatest_assert_macro_right2 = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("class for name with stub class", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            RecordedStubClassLoader cl = new RecordedStubClassLoader(this.getClass().getClassLoader(), (Function1<String, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$4(x$2)));
            Class<?> cls = Class.forName("my.name.HelloWorld", false, (ClassLoader)((Object)cl));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cls.getName());
            String $org_scalatest_assert_macro_right = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(cl.lastStubbed());
            String $org_scalatest_assert_macro_right2 = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("filter class to stub", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            List list = Nil$.MODULE$.$colon$colon((Object)"my.name");
            StubClassLoader cl = StubClassLoader$.MODULE$.apply(this.getClass().getClassLoader(), (Seq)list);
            Class cls = cl.findClass("my.name.HelloWorld");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cls.getName());
            String $org_scalatest_assert_macro_right = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            return (ClassNotFoundException)this.intercept((Function0 & Serializable)() -> cl.findClass("name.my.GoodDay"), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("call stub class default constructor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            RecordedStubClassLoader cl = new RecordedStubClassLoader(this.getClass().getClassLoader(), (Function1<String, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$8(x$3)));
            Class<?> cls = Class.forName("my.name.HelloWorld", false, (ClassLoader)((Object)cl));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cl.lastStubbed());
            String $org_scalatest_assert_macro_right = "my.name.HelloWorld";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            InvocationTargetException error = (InvocationTargetException)this.intercept((Function0 & Serializable)() -> cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), ClassTag$.MODULE$.apply(InvocationTargetException.class), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Throwable $org_scalatest_assert_macro_left2 = error.getCause();
            Object $org_scalatest_assert_macro_right2 = null;
            Throwable throwable = $org_scalatest_assert_macro_left2;
            Object var11_9 = null;
            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, throwable == null ? var11_9 != null : !throwable.equals(var11_9), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left3.value()) {
                String $org_scalatest_assert_macro_left4 = error.getCause().getMessage();
                String $org_scalatest_assert_macro_right3 = "Fail to initiate the class my.name.HelloWorld because it is stubbed";
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right4 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)error, Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("stub missing class", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClassLoader sysClassLoader = this.getClass().getClassLoader();
            RecordedStubClassLoader stubClassLoader = new RecordedStubClassLoader(null, (Function1<String, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$12(x$4)));
            ChildFirstURLClassLoader sessionClassLoader = new ChildFirstURLClassLoader((URL[])((Object[])new URL[]{this.udfNoAJar()}), (ClassLoader)((Object)stubClassLoader), sysClassLoader);
            this.loadDummyUdf((ClassLoader)sessionClassLoader);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stubClassLoader.lastStubbed());
            String $org_scalatest_assert_macro_right = this.classA();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("unload stub class", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ClassLoader sysClassLoader = this.getClass().getClassLoader();
            RecordedStubClassLoader stubClassLoader = new RecordedStubClassLoader(null, (Function1<String, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$14(x$5)));
            ChildFirstURLClassLoader cl1 = new ChildFirstURLClassLoader((URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class)), (ClassLoader)((Object)stubClassLoader), sysClassLoader);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.loadDummyUdf((ClassLoader)cl1), ClassTag$.MODULE$.apply(Exception.class), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stubClassLoader.lastStubbed());
            String $org_scalatest_assert_macro_right = this.classDummyUdf();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            ChildFirstURLClassLoader cl2 = new ChildFirstURLClassLoader((URL[])((Object[])new URL[]{this.udfNoAJar()}), (ClassLoader)((Object)stubClassLoader), sysClassLoader);
            this.loadDummyUdf((ClassLoader)cl2);
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("throw no such method if trying to access methods on stub class", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ClassLoader sysClassLoader = this.getClass().getClassLoader();
            RecordedStubClassLoader stubClassLoader = new RecordedStubClassLoader(null, (Function1<String, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StubClassLoaderSuite.$anonfun$new$17(x$6)));
            ChildFirstURLClassLoader sessionClassLoader = new ChildFirstURLClassLoader((URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class)), (ClassLoader)((Object)stubClassLoader), sysClassLoader);
            String $org_scalatest_assert_macro_left = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.loadDummyUdf((ClassLoader)sessionClassLoader), ClassTag$.MODULE$.apply(NoSuchMethodException.class), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119))).getMessage();
            String $org_scalatest_assert_macro_right = this.classDummyUdf();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(stubClassLoader.lastStubbed());
            String $org_scalatest_assert_macro_right2 = this.classDummyUdf();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("StubClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }
}

