/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005e4qAC\u0006\u0011\u0002\u0007\u0005A\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003(\u0001\u0019\u0005\u0001\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u0003D\u0001\u0011\u0005A\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003R\u0001\u0011\u0005Q\u000bC\u0003\\\u0001\u0011%A\fC\u0003b\u0001\u0011%!\rC\u0003u\u0001\u0011%QO\u0001\u000bDQ\u0006\u0014h+\u0019:dQ\u0006\u0014H+Z:u'VLG/\u001a\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005Y\u0011B\u0001\r\f\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0017\u0005!A/Z:u\u0013\tq2D\u0001\u0007T#2#Vm\u001d;Vi&d7/\u0001\u0004%S:LG\u000f\n\u000b\u0002CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t!QK\\5u\u0003\u00191wN]7biV\t\u0011\u0006\u0005\u0002+c9\u00111f\f\t\u0003Y\rj\u0011!\f\u0006\u0003]M\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019$\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u001a\u0013\u0001D2iK\u000e\\7i\u001c7UsB,GcA\u00117}!)qg\u0001a\u0001q\u0005\ta\r\u0005\u0002:y5\t!H\u0003\u0002<\u0017\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0003@\u0007\u0001\u0007\u0001)\u0001\u0002eiB\u0011\u0011(Q\u0005\u0003\u0005j\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0011G\",7m\u001b)mC&t'+Z:vYR$B!I#O\u001f\")a\t\u0002a\u0001\u000f\u0006\u0011AM\u001a\t\u0003\u0011.s!AF%\n\u0005)[\u0011a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005)[\u0001\"B \u0005\u0001\u0004I\u0003\"\u0002)\u0005\u0001\u0004I\u0013!C5og\u0016\u0014HOV1m\u0003a\t7o]3si2+gn\u001a;i\u0007\",7m\u001b$bS2,(/\u001a\u000b\u0003CMCQ\u0001V\u0003A\u0002%\nQ!];fef$\"!\t,\t\u000b]3\u0001\u0019\u0001-\u0002\t\u0019,hn\u0019\t\u0004Ee\u000b\u0013B\u0001.$\u0005%1UO\\2uS>t\u0007'\u0001\buKN$H+\u00192mK^\u0013\u0018\u000e^3\u0015\u0005\u0005j\u0006\"B\u001c\b\u0001\u0004q\u0006\u0003\u0002\u0012`S\u0005J!\u0001Y\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\u0004;fgR\u001cuN\u001c3ji&|gn\u001d\u000b\u0004C\r$\u0007\"\u0002$\t\u0001\u00049\u0005\"B3\t\u0001\u00041\u0017AC2p]\u0012LG/[8ogB\u0019qm\u001b8\u000f\u0005!TgB\u0001\u0017j\u0013\u0005!\u0013B\u0001&$\u0013\taWNA\u0002TKFT!AS\u0012\u0011\t\tz\u0017&]\u0005\u0003a\u000e\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012s\u0013\t\u00198EA\u0004C_>dW-\u00198\u0002%Q,7\u000f\u001e(vY2\u001cuN\u001c3ji&|gn\u001d\u000b\u0004CY<\b\"\u0002$\n\u0001\u00049\u0005\"B3\n\u0001\u0004A\bcA4lS\u0001")
public interface CharVarcharTestSuite
extends SQLTestUtils {
    public String format();

    public static /* synthetic */ void checkColType$(CharVarcharTestSuite $this, StructField f, DataType dt) {
        $this.checkColType(f, dt);
    }

    default public void checkColType(StructField f, DataType dt) {
        DataType $org_scalatest_assert_macro_left = f.dataType();
        DataType $org_scalatest_assert_macro_right = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dt);
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        Option $org_scalatest_assert_macro_left2 = CharVarcharUtils$.MODULE$.getRawType(f.metadata());
        Some $org_scalatest_assert_macro_right2 = new Some((Object)dt);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public static /* synthetic */ void checkPlainResult$(CharVarcharTestSuite $this, Dataset df, String dt, String insertVal) {
        $this.checkPlainResult((Dataset<Row>)df, dt, insertVal);
    }

    default public void checkPlainResult(Dataset<Row> df, String dt, String insertVal) {
        DataType dataType = CatalystSqlParser$.MODULE$.parseDataType(dt);
        this.checkColType(df.schema().apply(1), dataType);
        DataType dataType2 = dataType;
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            int len = charType.length();
            String fixLenStr = insertVal != null ? StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len)), len, (Object)" ").mkString() : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", fixLenStr})));
            return;
        }
        if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            int len = varcharType.length();
            String varLenStrWithUpperBound = insertVal != null ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(insertVal), len) : null;
            ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", varLenStrWithUpperBound})));
            return;
        }
        throw new MatchError((Object)dataType2);
    }

    public static /* synthetic */ void assertLengthCheckFailure$(CharVarcharTestSuite $this, String query) {
        $this.assertLengthCheckFailure(query);
    }

    default public void assertLengthCheckFailure(String query) {
        this.assertLengthCheckFailure((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)query));
    }

    public static /* synthetic */ void assertLengthCheckFailure$(CharVarcharTestSuite $this, Function0 func) {
        $this.assertLengthCheckFailure((Function0<BoxedUnit>)func);
    }

    default public void assertLengthCheckFailure(Function0<BoxedUnit> func) {
        SparkRuntimeException x$1 = (SparkRuntimeException)((Assertions)this).intercept(func, ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        String x$2 = "EXCEED_LIMIT_LENGTH";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)"5")}));
        Option x$4 = ((SparkFunSuite)this).checkError$default$3();
        boolean x$5 = ((SparkFunSuite)this).checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = ((SparkFunSuite)this).checkError$default$6();
        ((SparkFunSuite)this).checkError((SparkThrowable)x$1, "EXCEED_LIMIT_LENGTH", x$4, x$3, x$5, x$6);
    }

    private void testTableWrite(Function1<String, BoxedUnit> f) {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"char"));
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)"varchar"));
    }

    private void testConditions(Dataset<Row> df, Seq<Tuple2<String, Object>> conditions) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.selectExpr((Seq)conditions.map((Function1 & Serializable)x$1 -> (String)x$1._1())), Row$.MODULE$.fromSeq((Seq)conditions.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._2$mcZ$sp()))));
    }

    private void testNullConditions(Dataset<Row> df, Seq<String> conditions) {
        conditions.foreach((Function1 & Serializable)cond -> {
            CharVarcharTestSuite.$anonfun$testNullConditions$1(this, df, cond);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ String $anonfun$$init$$4(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$5(CharVarcharTestSuite $this, String typ$1, String v) {
        $this.sql().apply((Object)("INSERT OVERWRITE t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ$1, v);
    }

    public static /* synthetic */ String $anonfun$$init$$8(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$9(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)("INSERT OVERWRITE t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
    }

    public static /* synthetic */ String $anonfun$$init$$11(int n) {
        return "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
    }

    public static /* synthetic */ void $anonfun$$init$$12(CharVarcharTestSuite $this, String v) {
        $this.sql().apply((Object)("INSERT INTO t VALUES ('1', '" + v + "')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        $this.sql().apply((Object)("INSERT INTO t PARTITION (c ='" + v + "') VALUES ('1')"));
        $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "CHAR(5)", v);
        $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c='a')");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
    }

    public static /* synthetic */ void $anonfun$$init$$77(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c " + typeName + "(5)) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES ('123456')");
    }

    public static /* synthetic */ void $anonfun$$init$$80(CharVarcharTestSuite $this, String tableName$1, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE " + tableName$1 + "(i INT, c " + typeName + "(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
        $this.sql().apply((Object)("INSERT INTO " + tableName$1 + " VALUES (1, null)"));
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(tableName$1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})));
        $this.assertLengthCheckFailure("INSERT INTO " + tableName$1 + " VALUES (1, '123456')");
    }

    public static /* synthetic */ void $anonfun$$init$$83(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c STRUCT<c: " + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(null)");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        $this.assertLengthCheckFailure("INSERT INTO t SELECT struct('123456')");
    }

    public static /* synthetic */ void $anonfun$$init$$86(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<" + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (array('a', '123456'))");
    }

    public static /* synthetic */ void $anonfun$$init$$89(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<" + typeName + "(5), STRING>) USING " + $this.format()));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (map('123456', 'a'))");
    }

    public static /* synthetic */ void $anonfun$$init$$91(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<STRING, " + typeName + "(5)>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (map('a', null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (map('a', '123456'))");
    }

    public static /* synthetic */ void $anonfun$$init$$94(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c MAP<" + typeName + "(5), " + typeName + "(5)>) USING " + $this.format()));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (map('123456', 'a'))");
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (map('a', '123456'))");
    }

    public static /* synthetic */ void $anonfun$$init$$96(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c STRUCT<c: ARRAY<" + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t SELECT struct(array(null))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        $this.assertLengthCheckFailure("INSERT INTO t SELECT struct(array('123456'))");
    }

    public static /* synthetic */ void $anonfun$$init$$99(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<STRUCT<c: " + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (array(struct('123456')))");
    }

    public static /* synthetic */ void $anonfun$$init$$102(CharVarcharTestSuite $this, String typeName) {
        $this.sql().apply((Object)("CREATE TABLE t(c ARRAY<ARRAY<" + typeName + "(5)>>) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES (array(array(null)))");
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        $this.assertLengthCheckFailure("INSERT INTO t VALUES (array(array('123456')))");
    }

    public static /* synthetic */ void $anonfun$testNullConditions$1(CharVarcharTestSuite $this, Dataset df$3, String cond) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df$3.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{cond})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
    }

    public static /* synthetic */ void $anonfun$$init$$115(CharVarcharTestSuite $this, Seq conditions$2) {
        $this.sql().apply((Object)("CREATE TABLE t(c CHAR(2)) USING " + $this.format()));
        $this.sql().apply((Object)"INSERT INTO t VALUES ('a')");
        $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions$2);
    }

    public static /* synthetic */ void $anonfun$$init$$116(CharVarcharTestSuite $this, Seq conditions$2) {
        $this.sql().apply((Object)("CREATE TABLE t(i INT, c CHAR(2)) USING " + $this.format() + " PARTITIONED BY (c)"));
        $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a')");
        $this.testNullConditions((Dataset<Row>)$this.spark().table("t"), (Seq<String>)conditions$2);
    }

    public static /* synthetic */ void $anonfun$$init$$119(CharVarcharTestSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String con = (String)tuple2._1();
            boolean res = tuple2._2$mcZ$sp();
            Dataset df = $this.spark().table("t");
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Assertions)$this).withClue((Object)con, (Function0)(JFunction0.mcV.sp & Serializable)() -> ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df.where(con), (Dataset<Row>)df.where(Boolean.toString(res))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$$init$$153(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT v FROM t1\n             |WHERE 'a' IN (SELECT v FROM t2 WHERE " + predicate + ")\n           "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c"})));
    }

    public static /* synthetic */ void $anonfun$$init$$157(CharVarcharTestSuite $this, String predicate) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT c0 FROM t t1\n             |WHERE (\n             |  SELECT count(*) AS c\n             |  FROM t\n             |  WHERE c0 = t1.c0 AND " + predicate + "\n             |) > 0\n         "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
    }

    public static void $init$(CharVarcharTestSuite $this) {
        $this.test("apply char padding/trimming and varchar trimming: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format()));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$4(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$5($this, typ, v);
                    return BoxedUnit.UNIT;
                });
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        $this.test("char type values should be padded or trimmed: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$8(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$9($this, v);
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)n -> CharVarcharTestSuite.$anonfun$$init$$11(BoxesRunTime.unboxToInt((Object)n))).foreach((Function1 & Serializable)v -> {
                    CharVarcharTestSuite.$anonfun$$init$$12($this, v);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        $this.test("char type values should not be padded when charVarcharAsString is true", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(a STRING, b CHAR(5), c CHAR(5)) USING " + $this.format() + " partitioned by (c)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('abc', 'abc', 'abc')");
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT b FROM t WHERE b in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c='abc'"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT c FROM t WHERE c in ('abc')"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc"})));
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        $this.test("varchar type values length check and trim: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)n -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c VARCHAR(5)) USING " + $this.format() + " PARTITIONED BY (c)"));
            String v = "a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n);
            $this.sql().apply((Object)("INSERT INTO t VALUES ('1', '" + v + "')"));
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)("ALTER TABLE t DROP PARTITION(c='" + v + "')"));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            $this.sql().apply((Object)("INSERT INTO t PARTITION (c='" + v + "') VALUES ('1')"));
            $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), "VARCHAR(5)", v);
            $this.sql().apply((Object)("ALTER TABLE t DROP PARTITION(c='" + v + "')"));
            ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
        })), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        $this.test("oversize char/varchar values for alter table partition operations", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format() + " PARTITIONED BY (c)"));
                new .colon.colon((Object)"ADD", (List)new .colon.colon((Object)"DROP", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)op -> {
                    $this.assertLengthCheckFailure("ALTER TABLE t " + op + " PARTITION(c='abcdef')");
                    return BoxedUnit.UNIT;
                });
                $this.assertLengthCheckFailure("ALTER TABLE t PARTITION (c='abcdef') RENAME TO PARTITION (c='2')");
                $this.assertLengthCheckFailure("ALTER TABLE t PARTITION (c='1') RENAME TO PARTITION (c='abcdef')");
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        $this.test("SPARK-34233: char/varchar with null value for partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"CHAR(5)", (List)new .colon.colon((Object)"VARCHAR(5)", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t(i STRING, c " + typ + ") USING " + $this.format() + " PARTITIONED BY (c)"));
                $this.sql().apply((Object)"INSERT INTO t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
                $this.checkPlainResult((Dataset<Row>)$this.spark().table("t"), typ, null);
                $this.sql().apply((Object)"ALTER TABLE t DROP PARTITION(c=null)");
                ((QueryTest)((Object)((Object)$this))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)Nil$.MODULE$);
            });
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        $this.test("char type values should be padded: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c STRUCT<c: CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct('a'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        $this.test("char type values should be padded: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        $this.test("char type values should be padded: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<CHAR(5), STRING>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (Object)"ab")}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)StringType$.MODULE$));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        $this.test("char type values should be padded: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<STRING, CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new CharType(5)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', map('a', null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null)}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        $this.test("char type values should be padded: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c MAP<CHAR(5), CHAR(10)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', map('a', 'ab'))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 8)))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)MapType$.MODULE$.apply((DataType)new CharType(5), (DataType)new CharType(10)));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        $this.test("char type values should be padded: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c STRUCT<c: ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', struct(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$))}))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)new StructType().add("c", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', struct(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))}))})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        $this.test("char type values should be padded: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<STRUCT<c: CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(struct('a'), struct('ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)})), (List)Nil$.MODULE$))})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", (DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(struct(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        $this.test("char type values should be padded: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i STRING, c ARRAY<ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1', array(array('a', 'ab')))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)new .colon.colon((Object)("a" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4)), (List)new .colon.colon((Object)("ab" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)})));
            $this.checkColType($this.spark().table("t").schema().apply(1), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new CharType(5))));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', null)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(null))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))})));
            $this.sql().apply((Object)"INSERT OVERWRITE t VALUES ('1', array(array(null)))");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))), (List)Nil$.MODULE$)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        $this.test("length check for input string values: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$77($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        $this.test("length check for input string values: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            if (!$this.conf().contains(SQLConf$.MODULE$.DEFAULT_CATALOG().key())) {
                String tableName = "t";
                $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
                    CharVarcharTestSuite.$anonfun$$init$$80($this, tableName, typeName);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        $this.test("length check for input string values: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$83($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        $this.test("length check for input string values: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$86($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        $this.test("length check for input string values: nested in map key", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$89($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        $this.test("length check for input string values: nested in map value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$91($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        $this.test("length check for input string values: nested in both map key and value", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$94($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        $this.test("length check for input string values: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$96($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        $this.test("length check for input string values: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$99($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        $this.test("length check for input string values: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.testTableWrite((Function1<String, BoxedUnit>)(Function1 & Serializable)typeName -> {
            CharVarcharTestSuite.$anonfun$$init$$102($this, typeName);
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        $this.test("length check for input string values: with trailing spaces", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('12 ', '12 ')");
            $this.sql().apply((Object)"INSERT INTO t VALUES ('1234  ', '1234  ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"12" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3), "12 "})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234 "})), (List)Nil$.MODULE$)));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        $this.test("length check for input string values: with implicit cast", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(5), c2 VARCHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1234, 1234)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1234 ", "1234"})));
            $this.assertLengthCheckFailure("INSERT INTO t VALUES (123456, 1)");
            $this.assertLengthCheckFailure("INSERT INTO t VALUES (1, 123456)");
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        $this.test("char type comparison: top-level columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 CHAR(2), c2 CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        $this.test("char type comparison: partitioned columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i INT, c1 CHAR(2), c2 CHAR(5)) USING " + $this.format() + " PARTITIONED BY (c1, c2)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 <=> null", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        $this.test("SPARK-34233: char type comparison with null values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon conditions = new .colon.colon((Object)"c = null", (List)new .colon.colon((Object)"c IN ('e', null)", (List)new .colon.colon((Object)"c IN (null)", (List)Nil$.MODULE$)));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> CharVarcharTestSuite.$anonfun$$init$$115($this, (Seq)conditions)));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> CharVarcharTestSuite.$anonfun$$init$$116($this, (Seq)conditions)));
        }, new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        $this.test("char type comparison: partition pruning", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(i INT, c1 CHAR(2), c2 VARCHAR(5)) USING " + $this.format() + " PARTITIONED BY (c1, c2)"));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'a', 'a')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c1 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"'a' = c1", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c1 > 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c1 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 = 'a  '", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)"c2 = 'a'", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)"c2 IN ('a', 'b')", (Object)BoxesRunTime.boxToBoolean((boolean)true))})).foreach((Function1 & Serializable)x0$1 -> {
                CharVarcharTestSuite.$anonfun$$init$$119($this, x0$1);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        $this.test("char type comparison: join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t1(c CHAR(2)) USING " + $this.format()));
            $this.sql().apply((Object)("CREATE TABLE t2(c CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('a')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT t1.c FROM t1 JOIN t2 ON t1.c = t2.c"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        $this.test("char type comparison: nested in struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 STRUCT<c: CHAR(2)>, c2 STRUCT<c: CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct('a'), struct('a'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        $this.test("char type comparison: nested in array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<CHAR(2)>, c2 ARRAY<CHAR(5)>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array('a', 'b'), array('a', 'b'))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        $this.test("char type comparison: nested in struct of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 STRUCT<a: ARRAY<CHAR(2)>>, c2 STRUCT<a: ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (struct(array('a', 'b')), struct(array('a', 'b')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        $this.test("char type comparison: nested in array of struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<STRUCT<c: CHAR(2)>>, c2 ARRAY<STRUCT<c: CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(struct('a')), array(struct('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        $this.test("char type comparison: nested in array of array", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c1 ARRAY<ARRAY<CHAR(2)>>, c2 ARRAY<ARRAY<CHAR(5)>>) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (array(array('a')), array(array('a')))");
            $this.testConditions((Dataset<Row>)$this.spark().table("t"), (Seq<Tuple2<String, Object>>)new .colon.colon((Object)new Tuple2((Object)"c1 = c2", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 < c2", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"c1 IN (c2)", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        $this.test("SPARK-33892: DESCRIBE TABLE w/ char/varchar", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), c CHAR(5)) USING " + $this.format()));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> ((Dataset)$this.sql().apply((Object)"desc t")).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("data_type like '%char%'"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"char(5)"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"varchar(3)"})), (List)Nil$.MODULE$)));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        $this.test("SPARK-34003: fix char/varchar fails w/ both group by and order by ", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), i INT) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT v, sum(i) FROM t GROUP BY v ORDER BY v"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        $this.test("SPARK-34003: fix char/varchar fails w/ order by functions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3), i INT) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c', 1)");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT substr(v, 1, 2), sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT sum(i) FROM t GROUP BY v ORDER BY substr(v, 1, 2)"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        $this.test("SPARK-34114: varchar type will strip tailing spaces to certain length at write time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c      ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c  "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        $this.test("SPARK-34114: varchar type will remain the value length with spaces at read time", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(v VARCHAR(3)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES ('c ')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c "})));
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - join keys", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t1(v VARCHAR(3), c CHAR(5)) USING " + $this.format()));
            $this.sql().apply((Object)("CREATE TABLE t2(v VARCHAR(5), c CHAR(8)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t1 VALUES ('c', 'b')");
            $this.sql().apply((Object)"INSERT INTO t2 VALUES ('a', 'b')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1.c = t2.c", "t2.c = t1.c", "t1.c = 'b'", "'b' = t1.c", "t1.c = 'b    '", "'b    ' = t1.c", "t1.c = 'b      '", "'b      ' = t1.c"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$153($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        $this.test("SPARK-34833: right-padding applied correctly for correlated subqueries - other preds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t(c0 INT, c1 CHAR(5), c2 CHAR(7)) USING " + $this.format()));
            $this.sql().apply((Object)"INSERT INTO t VALUES (1, 'abc', 'abc')");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1 = 'abc'", "'abc' = c1", "c1 = 'abc  '", "'abc  ' = c1", "c1 = 'abc    '", "'abc    ' = c1", "c1 = c2", "c2 = c1", "c1 IN ('xxx', 'abc', 'xxxxx')", "c1 IN ('xxx', 'abc  ', 'xxxxx')", "c1 IN ('xxx', 'abc    ', 'xxxxx')", "c1 IN (c2)", "c2 IN (c1)"})).foreach((Function1 & Serializable)predicate -> {
                CharVarcharTestSuite.$anonfun$$init$$157($this, predicate);
                return BoxedUnit.UNIT;
            });
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
        $this.test("SPARK-35359: create table and insert data over length values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"char", (List)new .colon.colon((Object)"varchar", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)typ -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key(), (Object)"true")}), (JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE t (col " + typ + "(2)) using " + $this.format()));
                $this.sql().apply((Object)"INSERT INTO t SELECT 'aaa'");
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"aaa"})));
            }));
            return BoxedUnit.UNIT;
        }), new Position("CharVarcharTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
    }
}

