/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005uv!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007\u000f\u0006\u0001\u000b\u0011B \t\u000b!\u000bA\u0011A%\t\u000bM\fA\u0011\u0001;\t\u000f\u0005\r\u0011\u0001\"\u0001\u0002\u0006!9\u0011QC\u0001\u0005\u0002\u0005]a!B\u0017\u001f\u0001\u0005u\u0001BCA\u0016\u0013\t\u0005\t\u0015!\u0003\u0002.!Aa*\u0003B\u0001B\u0003%1\f\u0003\u0006\u00026%\u0011\t\u0011)A\u0005\u0003oA\u0011\"a\u0011\n\u0005\u0003\u0005\u000b\u0011B(\t\u0015\u0005\u0015\u0013B!A!\u0002\u0013\t9\u0005\u0003\u0004<\u0013\u0011\u0005\u0011Q\n\u0005\tG&\u0011\r\u0011\"\u0003\u0002\\!9\u0011QL\u0005!\u0002\u0013!\u0007\"CA0\u0013\t\u0007I\u0011BA1\u0011\u001d\t\u0019'\u0003Q\u0001\nUD\u0011\"!\u001a\n\u0005\u0004%I!!\u0019\t\u000f\u0005\u001d\u0014\u0002)A\u0005k\"I\u0011\u0011N\u0005C\u0002\u0013%\u00111\u000e\u0005\t\u0003sJ\u0001\u0015!\u0003\u0002n!I\u00111P\u0005C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u000bK\u0001\u0015!\u0003\u0002\u0000!9\u0011qQ\u0005\u0005\n\u0005%\u0005bBAI\u0013\u0011\u0005\u00131\u0013\u0005\b\u0003sKA\u0011IA^\u000391\u0015\u000e\\3TiJ,\u0017-\\*j].T!a\b\u0011\u0002\u0013M$(/Z1nS:<'BA\u0011#\u0003%)\u00070Z2vi&|gN\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002-\u00035\taD\u0001\bGS2,7\u000b\u001e:fC6\u001c\u0016N\\6\u0014\u0007\u0005yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003mej\u0011a\u000e\u0006\u0003q\u0011\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003u]\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002W\u0005YQ.\u001a;bI\u0006$\u0018\rR5s+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u00195,G/\u00193bi\u0006$\u0015N\u001d\u0011\u0002\u0017!\f7/T3uC\u0012\fG/\u0019\u000b\u0005\u00156\u0013G\u000e\u0005\u00021\u0017&\u0011A*\r\u0002\b\u0005>|G.Z1o\u0011\u0015qU\u00011\u0001P\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0007AC6L\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AKK\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!aV\u0019\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\u0004'\u0016\f(BA,2!\ta\u0006M\u0004\u0002^=B\u0011!+M\u0005\u0003?F\na\u0001\u0015:fI\u00164\u0017B\u0001$b\u0015\ty\u0016\u0007C\u0003d\u000b\u0001\u0007A-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t\r|gN\u001a\u0006\u0003S\u001a\na\u0001[1e_>\u0004\u0018BA6g\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q.\u0002a\u0001]\u000691/\u001d7D_:4\u0007CA8r\u001b\u0005\u0001(B\u0001\u001d#\u0013\t\u0011\bOA\u0004T#2\u001buN\u001c4\u0002%\u001d,G/T3uC\u0012\fG/\u0019'pOB\u000bG\u000f\u001b\u000b\u0006kn|\u0018\u0011\u0001\t\u0003mfl\u0011a\u001e\u0006\u0003q\"\f!AZ:\n\u0005i<(\u0001\u0002)bi\"DQ\u0001\u001f\u0004A\u0002q\u0004\"A^?\n\u0005y<(A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")aJ\u0002a\u0001k\")QN\u0002a\u0001]\u0006A2\r[3dW\u0016\u001b8-\u00199fI6+G/\u00193bi\u0006\u0004\u0016\r\u001e5\u0015\u0011\u0005\u001d\u0011QBA\b\u0003'\u00012\u0001MA\u0005\u0013\r\tY!\r\u0002\u0005+:LG\u000fC\u0003y\u000f\u0001\u0007A\u0010\u0003\u0004\u0002\u0012\u001d\u0001\r!^\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\u0006[\u001e\u0001\rA\\\u0001\u001cC:\u001cWm\u001d;pe&\u001bX*\u001a;bI\u0006$\u0018\rR5sK\u000e$xN]=\u0015\u000b)\u000bI\"a\u0007\t\u000b9C\u0001\u0019A;\t\u000b\rD\u0001\u0019\u00013\u0014\r%\ty\"!\n6!\r\u0001\u0015\u0011E\u0005\u0004\u0003G\t%AB(cU\u0016\u001cG\u000fE\u0002-\u0003OI1!!\u000b\u001f\u0005\u0011\u0019\u0016N\\6\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005=\u0012\u0011G\u0007\u0002E%\u0019\u00111\u0007\u0012\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015\u0019LG.\u001a$pe6\fG\u000f\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004I\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0002B\u0005m\"A\u0003$jY\u00164uN]7bi\u0006!\u0002/\u0019:uSRLwN\\\"pYVlgNT1nKN\fqa\u001c9uS>t7\u000fE\u0003]\u0003\u0013Z6,C\u0002\u0002L\u0005\u00141!T1q)1\ty%!\u0015\u0002T\u0005U\u0013qKA-!\ta\u0013\u0002C\u0004\u0002,=\u0001\r!!\f\t\u000b9{\u0001\u0019A.\t\u000f\u0005Ur\u00021\u0001\u00028!1\u00111I\bA\u0002=Cq!!\u0012\u0010\u0001\u0004\t9%F\u0001e\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\u0002\u0011\t\f7/\u001a)bi\",\u0012!^\u0001\nE\u0006\u001cX\rU1uQ\u0002\nq\u0001\\8h!\u0006$\b.\u0001\u0005m_\u001e\u0004\u0016\r\u001e5!\u0003%\u0011X\r^3oi&|g.\u0006\u0002\u0002nA)\u0001'a\u001c\u0002t%\u0019\u0011\u0011O\u0019\u0003\r=\u0003H/[8o!\r\u0001\u0014QO\u0005\u0004\u0003o\n$\u0001\u0002'p]\u001e\f!B]3uK:$\u0018n\u001c8!\u0003\u001d1\u0017\u000e\\3M_\u001e,\"!a \u0011\u00071\n\t)C\u0002\u0002\u0004z\u0011\u0011CR5mKN#(/Z1n'&t7\u000eT8h\u0003!1\u0017\u000e\\3M_\u001e\u0004\u0013!\u00072bg&\u001cwK]5uK*{'m\u0015;biN$&/Y2lKJ,\"!a#\u0011\t\u0005e\u0012QR\u0005\u0005\u0003\u001f\u000bYDA\rCCNL7m\u0016:ji\u0016TuNY*uCR\u001cHK]1dW\u0016\u0014\u0018\u0001C1eI\n\u000bGo\u00195\u0015\r\u0005\u001d\u0011QSAM\u0011\u001d\t9j\u0007a\u0001\u0003g\nqAY1uG\"LE\rC\u0004\u0002\u001cn\u0001\r!!(\u0002\t\u0011\fG/\u0019\t\u0005\u0003?\u000b\u0019L\u0004\u0003\u0002\"\u0006Ef\u0002BAR\u0003_sA!!*\u0002.:!\u0011qUAV\u001d\r\u0011\u0016\u0011V\u0005\u0002S%\u0011q\u0005K\u0005\u0003K\u0019J!a\t\u0013\n\u0005]\u0013\u0013\u0002BA[\u0003o\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005]\u0013\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003m\u0003")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final Map<String, String> options;
    private final Configuration hadoopConf;
    private final Path basePath;
    private final Path logPath;
    private final Option<Object> retention;
    private final FileStreamSinkLog fileLog;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration hadoopConf) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, hadoopConf);
    }

    public static void checkEscapedMetadataPath(FileSystem fs, Path metadataPath, SQLConf sqlConf) {
        FileStreamSink$.MODULE$.checkEscapedMetadataPath(fs, metadataPath, sqlConf);
    }

    public static Path getMetadataLogPath(FileSystem fs, Path path, SQLConf sqlConf) {
        return FileStreamSink$.MODULE$.getMetadataLogPath(fs, path, sqlConf);
    }

    public static boolean hasMetadata(Seq<String> path, Configuration hadoopConf, SQLConf sqlConf) {
        return FileStreamSink$.MODULE$.hasMetadata(path, hadoopConf, sqlConf);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private Option<Object> retention() {
        return this.retention;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
        } else {
            FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), Long.toString(batchId), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
            FileCommitProtocol fileCommitProtocol = committer;
            if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
                ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
                manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable)col -> {
                Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
                return (Attribute)data.logicalPlan().output().find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$4(nameEquality, col, f))).getOrElse((Function0 & Serializable)() -> {
                    throw QueryExecutionErrors$.MODULE$.partitionColumnNotFoundInSchemaError(col, data.schema());
                });
            });
            QueryExecution qe = data.queryExecution();
            FileFormatWriter$.MODULE$.write(this.sparkSession, qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (Map<Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{this.basicWriteJobStatsTracker()}))), this.options, FileFormatWriter$.MODULE$.write$default$11());
        }
    }

    public String toString() {
        return new StringBuilder(10).append("FileSink[").append(this.path).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$4(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Sink.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.basePath = new Path(path);
        this.logPath = FileStreamSink$.MODULE$.getMetadataLogPath(this.basePath().getFileSystem(this.hadoopConf()), this.basePath(), sparkSession.sessionState().conf());
        this.retention = options.get((Object)"retention").map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeStringAsMs(str)));
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toString(), this.retention());
    }
}

