/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"Ia\r\u0001a\u0001\u0002\u0003\u0006Ka\u0017\u0005\nO\u0002\u0001\r\u00111A\u0005\n!D\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011B7\t\u0013=\u0004\u0001\u0019!A!B\u0013I\u0007\"\u00029\u0001\t\u0013\t\b\"\u0002:\u0001\t\u0003\u001axa\u0002?\u0014\u0003\u0003E\t! \u0004\b%M\t\t\u0011#\u0001\u007f\u0011\u0019\u0011v\u0002\"\u0001\u0002\u0006!I\u0011qA\b\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0002\u001a'&tw\r\\3ESJ,7\r^8ss\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0015+\u0005YA-\u0019;bg>,(oY3t\u0015\t1r#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001$G\u0001\u0004gFd'B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\t\t\u0003E\rj\u0011aE\u0005\u0003IM\u0011ACR5mK\u001a{'/\\1u\t\u0006$\u0018m\u0016:ji\u0016\u0014\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"AI\u0014\n\u0005!\u001a\"aE,sSR,'j\u001c2EKN\u001c'/\u001b9uS>t\u0017A\u0005;bg.\fE\u000f^3naR\u001cuN\u001c;fqR\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u00135\f\u0007O]3ek\u000e,'BA\u0018\u001c\u0003\u0019A\u0017\rZ8pa&\u0011\u0011\u0007\f\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH/A\u0005d_6l\u0017\u000e\u001e;feB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0003S>T!\u0001O\r\u0002\u0011%tG/\u001a:oC2L!AO\u001b\u0003%\u0019KG.Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0001\u000eGV\u001cHo\\7NKR\u0014\u0018nY:\u0011\tu2\u0015\n\u0014\b\u0003}\u0011\u0003\"a\u0010\"\u000e\u0003\u0001S!!Q\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0004\u001b\u0006\u0004(BA#C!\ti$*\u0003\u0002L\u0011\n11\u000b\u001e:j]\u001e\u0004\"!\u0014)\u000e\u00039S!aT\u000b\u0002\r5,GO]5d\u0013\t\tfJA\u0005T#2kU\r\u001e:jG\u00061A(\u001b8jiz\"R\u0001V+W/b\u0003\"A\t\u0001\t\u000b\u0015*\u0001\u0019\u0001\u0014\t\u000b%*\u0001\u0019\u0001\u0016\t\u000bI*\u0001\u0019A\u001a\t\u000fm*\u0001\u0013!a\u0001y\u0005Ya-\u001b7f\u0007>,h\u000e^3s+\u0005Y\u0006C\u0001/^\u001b\u0005\u0011\u0015B\u00010C\u0005\rIe\u000e^\u0001\u0010M&dWmQ8v]R,'o\u0018\u0013fcR\u0011\u0011\r\u001a\t\u00039\nL!a\u0019\"\u0003\tUs\u0017\u000e\u001e\u0005\bK\u001e\t\t\u00111\u0001\\\u0003\rAH%M\u0001\rM&dWmQ8v]R,'\u000fI\u0001\u000ee\u0016\u001cwN\u001d3t\u0013:4\u0015\u000e\\3\u0016\u0003%\u0004\"\u0001\u00186\n\u0005-\u0014%\u0001\u0002'p]\u001e\f\u0011C]3d_J$7/\u00138GS2,w\fJ3r)\t\tg\u000eC\u0004f\u0015\u0005\u0005\t\u0019A5\u0002\u001dI,7m\u001c:eg&sg)\u001b7fA\u0005ya.Z<PkR\u0004X\u000f^,sSR,'\u000fF\u0001b\u0003\u00159(/\u001b;f)\t\tG\u000fC\u0003v\u001b\u0001\u0007a/\u0001\u0004sK\u000e|'\u000f\u001a\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s^\t\u0001bY1uC2L8\u000f^\u0005\u0003wb\u00141\"\u00138uKJt\u0017\r\u001c*po\u0006I2+\u001b8hY\u0016$\u0015N]3di>\u0014\u0018\u0010R1uC^\u0013\u0018\u000e^3s!\t\u0011sb\u0005\u0002\u0010\u007fB\u0019A,!\u0001\n\u0007\u0005\r!I\u0001\u0004B]f\u0014VM\u001a\u000b\u0002{\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a\u0003+\u0007q\nia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tIBQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SingleDirectoryDataWriter
extends FileFormatDataWriter {
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private int fileCounter;
    private long recordsInFile;

    public static Map<String, SQLMetric> $lessinit$greater$default$4() {
        return SingleDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4();
    }

    private int fileCounter() {
        return this.fileCounter;
    }

    private void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private long recordsInFile() {
        return this.recordsInFile;
    }

    private void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    private void newOutputWriter() {
        this.recordsInFile_$eq(0L);
        this.releaseResources();
        String ext = this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext);
        int arg$macro$1 = this.fileCounter();
        String currentPath = this.committer.newTaskTempFile(this.taskAttemptContext, (Option)None$.MODULE$, new StringBuilder(0).append(StringOps$.MODULE$.format$extension("-c%03d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}))).append(ext).toString());
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & Serializable)x$8 -> {
            x$8.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void write(InternalRow record) {
        if (this.description.maxRecordsPerFile() > 0L && this.recordsInFile() >= this.description.maxRecordsPerFile()) {
            this.fileCounter_$eq(this.fileCounter() + 1);
            Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
            this.newOutputWriter();
        }
        this.currentWriter().write(record);
        this.statsTrackers().foreach((Function1 & Serializable)x$9 -> {
            x$9.newRow(this.currentWriter().path(), record);
            return BoxedUnit.UNIT;
        });
        this.recordsInFile_$eq(this.recordsInFile() + 1L);
    }

    public SingleDirectoryDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer, customMetrics);
        this.newOutputWriter();
    }
}

