/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.LocalSparkSession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.execution.streaming.continuous.CommitPartitionEpoch;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.EpochCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.continuous.GetCurrentEpoch$;
import org.apache.spark.sql.execution.streaming.continuous.ReportPartitionOffset;
import org.apache.spark.sql.execution.streaming.continuous.SetReaderPartitions;
import org.apache.spark.sql.execution.streaming.continuous.SetWriterPartitions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.TestSparkSession;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u000e\u001c\u0001!BQa\u0010\u0001\u0005\u0002\u0001C\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002#\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0013a\u0005\"C+\u0001\u0001\u0004\u0005\t\u0015)\u0003F\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005b\u0001\u0001\u0007\t\u0019!C\u0005E\"IA\r\u0001a\u0001\u0002\u0003\u0006K\u0001\u0017\u0005\nK\u0002\u0001\r\u00111A\u0005\n\u0019D\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\t\u0013I\u0004\u0001\u0019!A!B\u00139\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0003u\u0011%Q\b\u00011AA\u0002\u0013%1\u0010C\u0005~\u0001\u0001\u0007\t\u0011)Q\u0005k\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\u0004\u0001\u0001\u0006I!!\u0001\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u000e\u0001\t\u0013\tY\u0001C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA2\u0001\u0011%\u0011Q\r\u0002\u0016\u000bB|7\r[\"p_J$\u0017N\\1u_J\u001cV/\u001b;f\u0015\taR$\u0001\u0006d_:$\u0018N\\;pkNT!AH\u0010\u0002\u0013M$(/Z1nS:<'B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011#\u0002\u0001*[EJ\u0004C\u0001\u0016,\u001b\u0005\t\u0013B\u0001\u0017\"\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0012\u0019>\u001c\u0017\r\\*qCJ\\7+Z:tS>t\u0007C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u001diwnY6ji>T!AN\u0013\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0013\tA4G\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000f\u0005\u0002;{5\t1H\u0003\u0002=K\u0005I1oY1mCR,7\u000f^\u0005\u0003}m\u0012!CQ3g_J,\u0017I\u001c3BMR,'/R1dQ\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011aG\u0001\u0011KB|7\r[\"p_J$\u0017N\\1u_J,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0006\n1A\u001d9d\u0013\tQuI\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002)\u0015\u0004xn\u00195D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\ti5\u000b\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0003V]&$\bb\u0002+\u0004\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014!E3q_\u000eD7i\\8sI&t\u0017\r^8sA\u0005aqO]5uKN+\b\u000f]8siV\t\u0001\f\u0005\u0002Z?6\t!L\u0003\u0002\u001f7*\u0011A,X\u0001\u0006oJLG/\u001a\u0006\u0003=~\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005\u0001T&AD*ue\u0016\fW.\u001b8h/JLG/Z\u0001\u0011oJLG/Z*vaB|'\u000f^0%KF$\"!T2\t\u000fQ3\u0011\u0011!a\u00011\u0006iqO]5uKN+\b\u000f]8si\u0002\nQ!];fef,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u00039)T!AH6\u000b\u00051|\u0012!C3yK\u000e,H/[8o\u0013\tq\u0017NA\nD_:$\u0018N\\;pkN,\u00050Z2vi&|g.A\u0005rk\u0016\u0014\u0018p\u0018\u0013fcR\u0011Q*\u001d\u0005\b)&\t\t\u00111\u0001h\u0003\u0019\tX/\u001a:zA\u0005iqN\u001d3feZ+'/\u001b4jKJ,\u0012!\u001e\t\u0003mbl\u0011a\u001e\u0006\u0003i\u0015J!!_<\u0003\u000f%swJ\u001d3fe\u0006\trN\u001d3feZ+'/\u001b4jKJ|F%Z9\u0015\u00055c\bb\u0002+\r\u0003\u0003\u0005\r!^\u0001\u000f_J$WM\u001d,fe&4\u0017.\u001a:!\u0003U)\u0007o\\2i\u0005\u0006\u001c7\u000e\\8h#V,W/Z*ju\u0016,\"!!\u0001\u0011\u00079\u000b\u0019!C\u0002\u0002\u0006=\u00131!\u00138u\u0003Y)\u0007o\\2i\u0005\u0006\u001c7\u000e\\8h#V,W/Z*ju\u0016\u0004\u0013A\u00032fM>\u0014X-R1dQR\tQ*A\ntKR<&/\u001b;feB\u000b'\u000f^5uS>t7\u000fF\u0002N\u0003#Aq!a\u0005\u0012\u0001\u0004\t\t!A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u0014g\u0016$(+Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004\u001b\u0006e\u0001bBA\n%\u0001\u0007\u0011\u0011A\u0001\u0015G>lW.\u001b;QCJ$\u0018\u000e^5p]\u0016\u0003xn\u00195\u0015\u000b5\u000by\"a\t\t\u000f\u0005\u00052\u00031\u0001\u0002\u0002\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\t)c\u0005a\u0001\u0003O\tQ!\u001a9pG\"\u00042ATA\u0015\u0013\r\tYc\u0014\u0002\u0005\u0019>tw-A\u000bsKB|'\u000f\u001e)beRLG/[8o\u001f\u001a47/\u001a;\u0015\u000b5\u000b\t$a\r\t\u000f\u0005\u0005B\u00031\u0001\u0002\u0002!9\u0011Q\u0005\u000bA\u0002\u0005\u001d\u0012aE7bW\u0016\u001c\u0016P\\2ie>tw.^:DC2d\u0017\u0001\u0004<fe&4\u0017pQ8n[&$HcA'\u0002<!9\u0011Q\u0005\fA\u0002\u0005\u001d\u0012!\u0005<fe&4\u0017PT8D_6l\u0017\u000e\u001e$peR\u0019Q*!\u0011\t\u000f\u0005\u0015r\u00031\u0001\u0002(\u00051b/\u001a:jMf\u001cu.\\7jiNLen\u0014:eKJ|e\rF\u0002N\u0003\u000fBq!!\u0013\u0019\u0001\u0004\tY%\u0001\u0004fa>\u001c\u0007n\u001d\t\u0007\u0003\u001b\ni&a\n\u000f\t\u0005=\u0013\u0011\f\b\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0016bAA.\u001f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u00121aU3r\u0015\r\tYfT\u0001\u001bm\u0016\u0014\u0018NZ=Ti>\u0004\b/\u001a3XSRDW\t_2faRLwN\u001c\u000b\u0004\u001b\u0006\u001d\u0004bBA53\u0001\u0007\u00111N\u0001\u0004[N<\u0007\u0003BA7\u0003krA!a\u001c\u0002rA\u0019\u0011\u0011K(\n\u0007\u0005Mt*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003gz\u0005")
public class EpochCoordinatorSuite
extends SparkFunSuite
implements LocalSparkSession,
MockitoSugar {
    private RpcEndpointRef epochCoordinator;
    private StreamingWrite writeSupport;
    private ContinuousExecution query;
    private InOrder orderVerifier;
    private final int epochBacklogQueueSize;
    private transient SparkSession spark;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$LocalSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void beforeAll() {
        LocalSparkSession.beforeAll$(this);
    }

    @Override
    public void afterEach() {
        LocalSparkSession.afterEach$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private RpcEndpointRef epochCoordinator() {
        return this.epochCoordinator;
    }

    private void epochCoordinator_$eq(RpcEndpointRef x$1) {
        this.epochCoordinator = x$1;
    }

    private StreamingWrite writeSupport() {
        return this.writeSupport;
    }

    private void writeSupport_$eq(StreamingWrite x$1) {
        this.writeSupport = x$1;
    }

    private ContinuousExecution query() {
        return this.query;
    }

    private void query_$eq(ContinuousExecution x$1) {
        this.query = x$1;
    }

    private InOrder orderVerifier() {
        return this.orderVerifier;
    }

    private void orderVerifier_$eq(InOrder x$1) {
        this.orderVerifier = x$1;
    }

    private int epochBacklogQueueSize() {
        return this.epochBacklogQueueSize;
    }

    public void beforeEach() {
        ContinuousStream stream = (ContinuousStream)this.mock(ClassTag$.MODULE$.apply(ContinuousStream.class));
        this.writeSupport_$eq((StreamingWrite)this.mock(ClassTag$.MODULE$.apply(StreamingWrite.class)));
        this.query_$eq((ContinuousExecution)this.mock(ClassTag$.MODULE$.apply(ContinuousExecution.class)));
        this.orderVerifier_$eq(Mockito.inOrder((Object[])new Object[]{this.writeSupport(), this.query()}));
        this.spark_$eq(new TestSparkSession(new SparkContext("local[2]", "test-sql-context", new SparkConf().set("spark.sql.testkey", "true").set(SQLConf$.MODULE$.CONTINUOUS_STREAMING_EPOCH_BACKLOG_QUEUE_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.epochBacklogQueueSize())))));
        this.epochCoordinator_$eq(EpochCoordinatorRef$.MODULE$.create(this.writeSupport(), stream, this.query(), "test", 1L, this.spark(), SparkEnv$.MODULE$.get()));
    }

    private void setWriterPartitions(int numPartitions) {
        this.epochCoordinator().askSync((Object)new SetWriterPartitions(numPartitions), (ClassTag)ClassTag$.MODULE$.Unit());
    }

    private void setReaderPartitions(int numPartitions) {
        this.epochCoordinator().askSync((Object)new SetReaderPartitions(numPartitions), (ClassTag)ClassTag$.MODULE$.Unit());
    }

    private void commitPartitionEpoch(int partitionId, long epoch) {
        WriterCommitMessage dummyMessage = (WriterCommitMessage)this.mock(ClassTag$.MODULE$.apply(WriterCommitMessage.class));
        this.epochCoordinator().send((Object)new CommitPartitionEpoch(partitionId, epoch, dummyMessage));
    }

    private void reportPartitionOffset(int partitionId, long epoch) {
        PartitionOffset dummyOffset = (PartitionOffset)this.mock(ClassTag$.MODULE$.apply(PartitionOffset.class));
        this.epochCoordinator().send((Object)new ReportPartitionOffset(partitionId, epoch, dummyOffset));
    }

    private void makeSynchronousCall() {
        this.epochCoordinator().askSync((Object)GetCurrentEpoch$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long());
    }

    private void verifyCommit(long epoch) {
        ((StreamingWrite)this.orderVerifier().verify((Object)this.writeSupport())).commit(ArgumentMatchers.eq((long)epoch), (WriterCommitMessage[])ArgumentMatchers.any());
        ((ContinuousExecution)this.orderVerifier().verify((Object)this.query())).commit(epoch);
    }

    private void verifyNoCommitFor(long epoch) {
        ((StreamingWrite)Mockito.verify((Object)this.writeSupport(), (VerificationMode)Mockito.never())).commit(ArgumentMatchers.eq((long)epoch), (WriterCommitMessage[])ArgumentMatchers.any());
        ((ContinuousExecution)Mockito.verify((Object)this.query(), (VerificationMode)Mockito.never())).commit(epoch);
    }

    private void verifyCommitsInOrderOf(Seq<Object> epochs) {
        epochs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)epoch -> this.verifyCommit(epoch));
    }

    private void verifyStoppedWithException(String msg) {
        Option throwable;
        ArgumentCaptor exceptionCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((ContinuousExecution)Mockito.verify((Object)this.query(), (VerificationMode)Mockito.atLeastOnce())).stopInNewThread((Throwable)exceptionCaptor.capture());
        Option $org_scalatest_assert_macro_left = throwable = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(exceptionCaptor.getAllValues()).asScala()).find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EpochCoordinatorSuite.$anonfun$verifyStoppedWithException$1(this, msg, x$5)));
        Object $org_scalatest_assert_macro_right = null;
        Option option = $org_scalatest_assert_macro_left;
        Object var7_6 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, option == null ? var7_6 != null : !option.equals(var7_6), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Stream stopped with an exception but expected message is missing", Prettifier$.MODULE$.default(), new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
    }

    public static final /* synthetic */ boolean $anonfun$verifyStoppedWithException$1(EpochCoordinatorSuite $this, String msg$1, Throwable x$5) {
        return $this.convertToEqualizer(x$5.getMessage()).$eq$eq$eq((Object)msg$1, Equality$.MODULE$.default());
    }

    public EpochCoordinatorSuite() {
        LocalSparkSession.$init$(this);
        MockitoSugar.$init$((MockitoSugar)this);
        this.epochBacklogQueueSize = 10;
        this.test("single epoch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(3);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.commitPartitionEpoch(1, 1L);
            this.commitPartitionEpoch(2, 1L);
            this.reportPartitionOffset(0, 1L);
            this.reportPartitionOffset(1, 1L);
            this.makeSynchronousCall();
            this.verifyCommit(1L);
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("single epoch, all but one writer partition has committed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(3);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.commitPartitionEpoch(1, 1L);
            this.reportPartitionOffset(0, 1L);
            this.reportPartitionOffset(1, 1L);
            this.makeSynchronousCall();
            this.verifyNoCommitFor(1L);
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("single epoch, all but one reader partition has reported an offset", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(3);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.commitPartitionEpoch(1, 1L);
            this.commitPartitionEpoch(2, 1L);
            this.reportPartitionOffset(0, 1L);
            this.makeSynchronousCall();
            this.verifyNoCommitFor(1L);
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("consequent epochs, messages for epoch (k + 1) arrive after messages for epoch k", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(2);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.commitPartitionEpoch(1, 1L);
            this.reportPartitionOffset(0, 1L);
            this.reportPartitionOffset(1, 1L);
            this.commitPartitionEpoch(0, 2L);
            this.commitPartitionEpoch(1, 2L);
            this.reportPartitionOffset(0, 2L);
            this.reportPartitionOffset(1, 2L);
            this.makeSynchronousCall();
            this.verifyCommitsInOrderOf((Seq<Object>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L}))));
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("consequent epochs, a message for epoch k arrives after messages for epoch (k + 1)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(2);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.commitPartitionEpoch(1, 1L);
            this.reportPartitionOffset(0, 1L);
            this.commitPartitionEpoch(0, 2L);
            this.commitPartitionEpoch(1, 2L);
            this.reportPartitionOffset(0, 2L);
            this.reportPartitionOffset(1, 2L);
            this.reportPartitionOffset(1, 1L);
            this.makeSynchronousCall();
            this.verifyCommitsInOrderOf((Seq<Object>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L}))));
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("several epochs, messages arrive in order 1 -> 3 -> 4 -> 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(1);
            this.setReaderPartitions(1);
            this.commitPartitionEpoch(0, 1L);
            this.reportPartitionOffset(0, 1L);
            this.commitPartitionEpoch(0, 3L);
            this.reportPartitionOffset(0, 3L);
            this.commitPartitionEpoch(0, 4L);
            this.reportPartitionOffset(0, 4L);
            this.commitPartitionEpoch(0, 2L);
            this.reportPartitionOffset(0, 2L);
            this.makeSynchronousCall();
            this.verifyCommitsInOrderOf((Seq<Object>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L, 4L}))));
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("several epochs, messages arrive in order 1 -> 3 -> 5 -> 4 -> 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(1);
            this.setReaderPartitions(1);
            this.commitPartitionEpoch(0, 1L);
            this.reportPartitionOffset(0, 1L);
            this.commitPartitionEpoch(0, 3L);
            this.reportPartitionOffset(0, 3L);
            this.commitPartitionEpoch(0, 5L);
            this.reportPartitionOffset(0, 5L);
            this.commitPartitionEpoch(0, 4L);
            this.reportPartitionOffset(0, 4L);
            this.commitPartitionEpoch(0, 2L);
            this.reportPartitionOffset(0, 2L);
            this.makeSynchronousCall();
            this.verifyCommitsInOrderOf((Seq<Object>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L, 4L, 5L}))));
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("several epochs, max epoch backlog reached by partitionOffsets", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(1);
            this.setReaderPartitions(1);
            this.reportPartitionOffset(0, 1L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), this.epochBacklogQueueSize() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.reportPartitionOffset(0, i));
            this.makeSynchronousCall();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.epochBacklogQueueSize() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.verifyNoCommitFor(i));
            this.verifyStoppedWithException("Size of the partition offset queue has exceeded its maximum");
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("several epochs, max epoch backlog reached by partitionCommits", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(1);
            this.setReaderPartitions(1);
            this.commitPartitionEpoch(0, 1L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), this.epochBacklogQueueSize() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.commitPartitionEpoch(0, i));
            this.makeSynchronousCall();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.epochBacklogQueueSize() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.verifyNoCommitFor(i));
            this.verifyStoppedWithException("Size of the partition commit queue has exceeded its maximum");
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("several epochs, max epoch backlog reached by epochsWaitingToBeCommitted", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.setWriterPartitions(2);
            this.setReaderPartitions(2);
            this.commitPartitionEpoch(0, 1L);
            this.reportPartitionOffset(0, 1L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), this.epochBacklogQueueSize() + 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                this.commitPartitionEpoch(0, i);
                this.reportPartitionOffset(0, i);
                this.commitPartitionEpoch(1, i);
                this.reportPartitionOffset(1, i);
            });
            this.makeSynchronousCall();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.epochBacklogQueueSize() + 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.verifyNoCommitFor(i));
            this.verifyStoppedWithException("Size of the epoch queue has exceeded its maximum");
        }, new Position("EpochCoordinatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
    }
}

